; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below.
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1

;==========================================================================
;R}h֘At@C
;==========================================================================

;-------------------------------------------------------------------------------
[Command]
name = "AIflag1"
command = ~D,DB,B,D,DF,FD,D,DB,B,D,DF,F,D,DF,F,x+y,D,DF,F,D,DF,F,x+y
time = 1

[Command]
name = "AIflag2"
command = ~D,DF,F,D,DF,F,x+y
time = 1

[Command]
name = "AIflag3"
command = ~D,DB,B,D,DF,F,a+b
time = 1

[Command]
name = "AIflag4"
command = ~D,DB,B,D,DF,F,x+y
time = 1

[Command]
name = "AIflag5"
command = ~D,DB,B,D,DB,B,a+b
time = 1

[Command]
name = "AIflag6"
command = ~D,DB,B,D,DB,B,x+y
time = 1

[Command]
name = "AIflag7"
command = ~D,DF,F,D,DF,FD,DF,F,D,DF,F,a+b
time = 1

[Command]
name = "AIflag8"
command = ~D,DF,F,D,DF,FD,DF,F,D,DF,F,x+y
time = 1

[Command]
name = "AIflag9"
command = ~D,DB,B,D,DF,FD,DF,F,D,DF,F,a+b
time = 1

[Command]
name = "AIflag10"
command = ~D,DB,B,D,DF,FD,D,DB,B,D,DF,F,D,DF,F,x+y
time = 1

[Command]
name = "AIflag11"
command = ~D,DB,B,D,DB,D,DB,B,D,BD,DF,F,D,DF,F,a+b
time = 1

[Command]
name = "AIflag12"
command = ~D,DB,B,D,DB,D,DB,B,D,BD,DF,F,D,DF,F,x+y
time = 1

[Command]
name = "AIflag13"
command = ~D,DB,B,D,DB,B,D,D,DF,FD,DF,F,D,DF,F,a+b
time = 1

[Command]
name = "AIflag14"
command = ~D,DB,B,D,DF,FD,DF,D,DB,B,D,F,D,DF,F,x+y
time = 1

[Command]
name = "AIflag15"
command = ~D,DB,B,D,DB,BD,DF,F,D,D,DB,B,D,DF,F,a+b
time = 1

[Command]
name = "AIflag16"
command = ~D,DB,B,D,DB,BD,DF,F,D,DF,F,D,D,DB,DF,F,x+y
time = 1

[Command]
name = "AIflag17"
command = ~D,DB,B,D,DF,FD,D,DB,B,D,D,DB,B,D,DF,FD,DF,F,D,DF,F,x+y
time = 1

[Command]
name = "AIflag18"
command = ~D,DB,B,D,DB,D,D,DB,B,D,DF,FD,DB,B,D,BD,DF,F,D,DF,F,a+b
time = 1

[Command]
name = "AIflag19"
command = ~D,DB,B,D,DB,B,D,DF,FD,D,DB,D,DB,B,D,BD,DF,F,D,DF,F,x+y
time = 1

[Command]
name = "AIflag20"
command = ~D,DB,B,D,DB,B,D,D,DF,FD,DF,F,D,DF,F,D,DB,B,D,DF,FD,a+b
time = 1

[Command]
name = "AIflag21"
command = ~D,DB,B,D,DF,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,x+y
time = 1

[Command]
name = "AIflag22"
command = ~D,DB,B,D,DF,FD,D,DB,B,D,DB,BD,DF,F,D,D,DB,B,D,DF,F,a+b
time = 1

[Command]
name = "AIflag23"
command = ~D,DB,B,D,DB,BD,DF,D,DB,B,D,DF,FD,F,D,B,D,D,DB,B,D,DF,FD,DF,F,D,DF,F,D,D,DB,DF,F,x+y
time = 1

[Command]
name = "AIflag24"
command = ~D,DB,B,D,DF,FD,B,D,D,DB,B,D,DF,FD,DF,F,D,D,DB,B,D,D,DB,B,D,DF,FD,DF,F,D,DF,F,x+y
time = 1

[Command]
name = "AIflag25"
command = ~D,DB,B,D,DB,D,B,D,D,DB,B,D,DF,FD,DF,F,D,D,DB,B,D,DF,FD,DB,B,D,BD,DF,F,D,DF,F,a+b
time = 1

[Command]
name = "AIflag26"
command = ~D,DB,B,D,DB,B,D,DF,FD,D,DB,D,DB,B,D,BD,DF,F,D,DF,F,B,D,D,DB,B,D,DF,FD,DF,F,D,x+y
time = 1

[Command]
name = "AIflag27"
command = ~D,DB,B,D,B,D,D,DB,B,D,DF,FD,DF,F,D,DB,B,D,D,DF,FD,DF,F,D,DF,F,D,DB,B,D,DF,FD,a+b
time = 1

[Command]
name = "AIflag28"
command = ~D,DB,B,D,DF,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,B,D,D,DB,B,D,DF,FD,DF,F,D,x+y
time = 1

[Command]
name = "AIflag29"
command = ~D,DB,B,D,DF,FD,D,DB,B,D,DB,BD,DF,F,D,B,D,D,DB,B,D,DF,FD,DF,F,D,D,DB,B,D,DF,F,a+b
time = 1

[Command]
name = "AIflag30"
command = ~D,DB,B,D,B,D,D,DB,B,D,DF,FD,DF,F,D,DB,BD,DF,D,DB,B,D,DF,FD,F,D,DF,F,D,D,DB,DF,F,x+y
time = 1

[Command]
name = "AIflag31"
command = ~D,DB,B,D,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,DF,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,x+y
time = 1

[Command]
name = "AIflag32"
command = ~D,DB,B,D,DF,FD,D,DB,B,D,DB,BD,DF,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,F,D,D,DB,B,D,DF,F,a+b
time = 1

[Command]
name = "AIflag33"
command = ~D,DB,B,D,DB,BD,DF,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,D,DB,B,D,DF,FD,F,D,B,D,D,DB,B,D,DF,FD,DF,F,D,DF,F,D,D,DB,DF,F,x+y
time = 1

[Command]
name = "AIflag34"
command = ~D,DB,B,D,DF,FD,B,D,D,DB,B,D,DF,FD,DF,F,D,D,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,DB,B,D,D,DB,B,D,DF,FD,DF,F,D,DF,F,x+y
time = 1

[Command]
name = "AIflag35"
command = ~D,DB,B,D,DB,D,B,D,D,DB,B,D,DF,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,FD,DF,F,D,D,DB,B,D,DF,FD,DB,B,D,BD,DF,F,D,DF,F,a+b
time = 1

[Command]
name = "AIflag36"
command = ~D,DB,B,D,DB,B,D,DF,FD,D,DB,D,DB,B,D,BD,DF,F,D,DF,F,B,D,D,DB,B,D,DF,FD,DF,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,F,D,x+y
time = 1

[Command]
name = "AIflag37"
command = ~D,DB,B,D,B,D,D,DB,B,D,DF,FD,DF,F,D,DB,B,D,D,DF,FD,DF,F,D,DF,F,D,DB,B,D,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,DF,FD,a+b
time = 1

[Command]
name = "AIflag38"
command = ~D,DB,B,D,DF,FD,DF,D,DB,B,D,F,D,DB,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,B,D,DF,FD,D,DF,F,B,D,D,DB,B,D,DF,FD,DF,F,D,x+y
time = 1

[Command]
name = "AIflag39"
command = ~D,DB,B,D,DF,FD,D,DB,B,D,DB,BD,DF,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,F,D,B,D,D,DB,B,D,DF,FD,DF,F,D,D,DB,B,D,DF,F,a+b
time = 1

[Command]
name = "AIflag40"
command = ~D,DB,B,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,D,B,D,D,DB,B,D,DF,FD,DF,F,D,DB,BD,DF,D,DB,B,D,DF,FD,F,D,DF,F,D,D,DB,DF,F,x+y
time = 1

[Command]
name = "AIflag41"
command = ~D,DB,B,D,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,DF,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,D,DB,B,D,DF,FD,D,DF,F,DF,FD,D,DF,F,x+y
time = 1

[Command]
name = "AIflag42"
command = ~D,DB,B,D,DF,FD,D,DB,B,D,DB,BD,DF,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,F,D,D,DB,D,DB,B,D,DF,FD,D,DF,F,DF,B,D,DF,F,a+b
time = 1

[Command]
name = "AIflag43"
command = ~D,DB,B,D,DB,BD,DF,FD,DF,D,DB,B,D,F,D,DB,B,D,DB,B,D,DF,FD,D,DF,F,DF,D,DF,FD,D,DF,F,D,DB,B,D,DF,FD,F,D,B,D,D,DB,B,D,DF,FD,DF,F,D,DF,F,D,D,DB,DF,F,x+y
time = 1

[Command]
name = "AIflag44"
command = ~D,DB,D,DB,B,D,DF,FD,D,DF,F,DF,B,D,DF,FD,B,D,D,DB,B,D,DF,FD,DF,F,D,D,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,DB,B,D,D,DB,B,D,DF,FD,DF,F,D,DF,F,x+y
time = 1

[Command]
name = "AIflag45"
command = ~D,DB,B,D,DB,D,DB,B,D,DF,FD,D,DF,F,DF,D,B,D,D,DB,B,D,DF,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,FD,DF,F,D,D,DB,B,D,DF,FD,DB,B,D,BD,DF,F,D,DF,F,a+b
time = 1

[Command]
name = "AIflag46"
command = ~D,DB,B,D,DB,B,D,DF,FD,D,DB,D,DB,B,D,BD,DF,D,DB,B,D,DF,FD,D,DF,F,DF,F,D,DF,F,B,D,D,DB,B,D,DF,FD,DF,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,F,D,x+y
time = 1

[Command]
name = "AIflag47"
command = ~D,DB,B,D,B,D,D,DB,B,D,DF,D,DB,B,D,DF,FD,D,DF,F,DF,FD,DF,F,D,DB,B,D,D,DF,FD,DF,F,D,DF,F,D,DB,B,D,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,DF,FD,a+b
time = 1

[Command]
name = "AIflag48"
command = ~D,DB,B,D,DF,FD,DF,D,DB,B,D,F,D,DB,FD,DF,D,DB,B,D,F,D,DB,B,D,D,DB,B,D,DF,FD,D,DF,F,DF,DF,FD,D,DF,F,B,D,DF,FD,D,DF,F,B,D,D,DB,B,D,DF,FD,DF,F,D,x+y
time = 1

[Command]
name = "AIflag49"
command = ~D,DB,B,D,DF,FD,D,D,DB,B,D,DF,FD,D,DF,F,DF,DB,B,D,DB,BD,DF,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,F,D,B,D,D,DB,B,D,DF,FD,DF,F,D,D,DB,B,D,DF,F,a+b
time = 1

[Command]
name = "AIflag50"
command = ~D,DB,B,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,D,B,D,D,D,DB,B,D,DF,FD,D,DF,F,DF,DB,B,D,DF,FD,DF,F,D,DB,BD,DF,D,DB,B,D,DF,FD,F,D,DF,F,D,D,DB,DF,F,x+y
time = 1

[Command]
name = "AIflag51"
command = ~D,DB,B,D,FD,DF,D,DB,B,D,F,D,DF,FD,D,DF,F,DF,FD,DF,D,DB,B,D,DF,FD,D,DF,F,DF,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,D,DB,B,D,DF,FD,D,DF,F,DF,FD,D,DF,F,x+y
time = 1

[Command]
name = "AIflag52"
command = ~D,DB,B,D,DF,FD,D,DB,B,D,DB,BD,DF,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,D,DF,FD,D,DF,F,DF,FD,DF,F,F,D,D,DB,D,DB,B,D,DF,FD,D,DF,F,DF,B,D,DF,F,a+b
time = 1

[Command]
name = "AIflag53"
command = ~D,DB,B,D,DB,BD,DF,FD,DF,D,DB,B,D,F,D,DB,B,D,DB,B,D,DF,FD,D,DF,F,DF,FD,DF,D,DF,FD,D,DF,F,DF,D,DF,FD,D,DF,F,D,DB,B,D,DF,FD,F,D,B,D,D,DB,B,D,DF,FD,DF,F,D,DF,F,D,D,DB,DF,F,x+y
time = 1

[Command]
name = "AIflag54"
command = ~D,DB,D,DF,FD,D,DF,F,DF,FD,DF,D,DB,B,D,DF,FD,D,DF,F,DF,B,D,DF,FD,B,D,D,DB,B,D,DF,FD,DF,F,D,D,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,DB,B,D,D,DB,B,D,DF,FD,DF,F,D,DF,F,x+y
time = 1

[Command]
name = "AIflag55"
command = ~D,D,DF,FD,D,DF,F,DF,FD,DF,DB,B,D,DB,D,DB,B,D,DF,FD,D,DF,F,DF,D,B,D,D,DB,B,D,DF,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,FD,DF,F,D,D,DB,B,D,DF,FD,DB,B,D,BD,DF,F,D,DF,F,a+b
time = 1

[Command]
name = "AIflag56"
command = ~D,DB,B,D,DB,B,D,DF,FD,D,DB,D,DB,B,D,BD,DF,D,DB,B,D,DF,FD,D,DF,F,DF,F,D,DF,F,B,D,D,DB,B,D,DF,FD,DF,FD,DF,D,DF,FD,D,DF,F,DF,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,F,D,x+y
time = 1

[Command]
name = "AIflag57"
command = ~D,DB,B,D,B,D,D,DB,B,D,DF,D,DB,B,D,DF,FD,D,DF,F,DF,FD,DF,F,D,DB,B,D,D,DF,FD,DF,F,D,DF,F,D,DB,B,D,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,DF,FD,D,DF,FD,D,DF,F,DF,FD,DF,a+b
time = 1

[Command]
name = "AIflag58"
command = ~D,DB,D,DF,FD,D,DF,F,DF,FD,DF,B,D,DF,FD,DF,D,DB,B,D,F,D,DB,FD,DF,D,DB,B,D,F,D,DB,B,D,D,DB,B,D,DF,FD,D,DF,F,DF,DF,FD,D,DF,F,B,D,DF,FD,D,DF,F,B,D,D,DB,B,D,DF,FD,DF,F,D,x+y
time = 1

[Command]
name = "AIflag59"
command = ~D,DB,B,D,DF,D,DF,FD,D,DF,F,DF,FD,DF,FD,D,D,DB,B,D,DF,FD,D,DF,F,DF,DB,B,D,DB,BD,DF,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,F,D,B,D,D,DB,B,D,DF,FD,DF,F,D,D,DB,B,D,DF,F,a+b
time = 1

[Command]
name = "AIflag60"
command = ~D,DB,B,FD,DF,D,DB,B,D,F,D,DB,B,D,DF,FD,D,DF,F,D,B,D,D,DF,FD,D,DF,F,DF,FD,DF,D,D,DB,B,D,DF,FD,D,DF,F,DF,DB,B,D,DF,FD,DF,F,D,DB,BD,DF,D,DB,B,D,DF,FD,F,D,DF,F,D,D,DB,DF,F,x+y
time = 1


;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF";Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB";Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = a+b
time = 1

[Command]
name = "ab"
command = a+b
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "fwd_a"
command = /F,a
time = 1

[Command]
name = "fwd_b"
command = /F,b
time = 1

[Command]
name = "fwd_c"
command = /F,c
time = 1

[Command]
name = "fwd_x"
command = /F,x
time = 1

[Command]
name = "fwd_y"
command = /F,y
time = 1


[Command]
name = "downfwd_a"
command = /DF,a
time = 1

[Command]
name = "downfwd_b"
command = /DF,b
time = 1

[Command]
name = "back_x"
command = /B,x
time = 1

[Command]
name = "back_a"
command = /B,a
time = 1

[Command]
name = "back_b"
command = /B,b
time = 1

[Command]
name = "back_c"
command = /B,c
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "down_z"
command = /$D,z
time = 1

[Command]
name = "fwd_ab"
command = /F, a+b
time = 1

[Command]
name = "back_ab"
command = /B, a+b
time = 1

;-| U{^ςȂ |-----------------------------------------------

[Command]
name = "hold_med"
command = /b
time = 1

[Command]
name = "hold_med"
command = /a
time = 1

[Command]
name = "hold_med"
command = /a+b
time = 1

[Command]
name = "hold_med"
command = /c
time = 1

[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_x"
command = /y
time = 1


;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "s"
command = s
time = 1


[Command]
name = "u"
command = $U
time = 1
[Command]
name = "uu"
command = /$U
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup";Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1


[Command]
name = "f_a"
command = F, a
time = 15

[Command]
name = "f_b"
command = F, b
time = 15

[Command]
name = "f_c"
command = F, c
time = 15
;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't removethe following line. It's required by the CMD standard.
[Statedef -1]
;-------------------------------------------------------------------------------
[State -1]
type = ChangeState
value = 180
triggerall = !(palno=12||var(36))
triggerall = !ishelper
triggerall = alive
triggerall = !(stateno = 170||anim = 170)
triggerall = !(stateno = 180||stateno = 181||anim=181)
triggerall = roundstate = 4
trigger1 = win
ignorehitpause = 1

[State -1]
type = ChangeState
value = 170
triggerall = !(palno=12||var(36))
triggerall = !ishelper
triggerall = alive
triggerall = !(stateno = 170||anim=170)
triggerall = roundstate = 4
trigger1 = !win
ignorehitpause = 1

[State ]
type = ChangeState
triggerall = (palno=12||var(36))
trigger1 = !ishelper
value = 5151
ignorehitpause = 1

[State ]
type = ChangeState
triggerall = !(palno=12||var(36))
triggerall = !ishelper
trigger1 = !alive
trigger2 = loseko
value = 51505
ignorehitpause = 1
