; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
;

;-| AI |--------------------------------------------------------

[Command]
name = "AI0"
command = a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a
time = 0
[Command]
name = "AI1"
command = b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b
time = 0
[Command]
name = "AI2"
command = c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c
time = 0
[Command]
name = "AI3"
command = x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
time = 0
[Command]
name = "AI4"
command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y
time = 0
[Command]
name = "AI5"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI6"
command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
time = 0
[Command]
name = "AI7"
command = F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F
time = 0
[Command]
name = "AI8"
command = D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D
time = 0
[Command]
name = "AI9"
command = B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B
time = 0
[Command]
name = "AI10"
command = U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U
time = 0
[Command]
name = "AI11"
command = a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a
time = 0
[Command]
name = "AI12"
command = c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c
time = 0
[Command]
name = "AI13"
command = x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
time = 0
[Command]
name = "AI14"
command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y
time = 0
[Command]
name = "AI15"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI16"
command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
time = 0
[Command]
name = "AI17"
command = a,B,c,x,y,z,s,B,D,F,U,a,b,c,x,y,z,s,s
time = 0
[Command]
name = "AI18"
command = a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a
time = 0
[Command]
name = "AI19"
command = b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b
time = 0
[Command]
name = "AI20"
command = c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c
time = 0
[Command]
name = "AI21"
command = x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
time = 0
[Command]
name = "AI22"
command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y
time = 0
[Command]
name = "AI23"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI24"
command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
time = 0
[Command]
name = "AI25"
command = F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F
time = 0
[Command]
name = "AI26"
command = D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D
time = 0
[Command]
name = "AI27"
command = B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B
time = 0
[Command]
name = "AI28"
command = U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U
time = 0
[Command]
name = "AI29"
command = a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a
time = 0
[Command]
name = "AI30"
command = c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c
time = 0
[Command]
name = "AI31"
command = x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
time = 0
[Command]
name = "AI32"
command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y
time = 0
[Command]
name = "AI33"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI34"
command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
time = 0
[Command]
name = "AI35"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI36"
command = z,z,z,z,z,z,a,a,a,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI37"
command = z,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,z,z,z
time = 0
[Command]
name = "AI38"
command = z,z,z,z,z,a,a,a,z,z,z,z,z,a,a,a,z,z,z
time = 0
[Command]
name = "AI39"
command = z,z,z,z,z,a,a,a,z,z,z,z,z,z,a,a,z,z,z
time = 0
[Command]
name = "AI40"
command = z,z,z,z,a,a,a,z,z,z,z,a,z,z,a,a,z,z,z
time = 0
[Command]
name = "AI41"
command = z,z,z,a,z,z,z,z,z,z,z,z,z,a,a,z,z,z,z
time = 0
[Command]
name = "AI42"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI43"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,a,a,z
time = 0
[Command]
name = "AI44"
command = z,z,a,a,a,a,z,z,z,z,z,z,z,z,z,a,a,a,z
time = 0
[Command]
name = "AI45"
command = z,z,z,z,z,z,a,a,z,z,z,z,z,a,a,a,a,z,z
time = 0
[Command]
name = "AI46"
command = z,z,z,z,z,z,z,z,a,a,a,a,a,a,z,z,z,z,z
time = 0
[Command]
name = "AI47"
command = z,z,z,a,a,a,a,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI48"
command = z,z,z,z,z,a,a,a,z,z,z,a,a,a,z,z,a,z,a
time = 0
[Command]
name = "AI49"
command = z,z,z,z,a,a,a,z,z,z,z,z,a,a,a,z,z,z,z
time = 0
[Command]
name = "AI50"
command = z,z,z,a,a,z,z,z,z,z,z,z,z,z,a,a,z,z,z
time = 0


;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.

;------------------------------------------------------
[Command]
name = "doll"
command = ~D, F, D, F, b
time = 35

[Command]
name = "ranbu2"
command = ~F, B, D, F, a
time = 35

[Command]
name = "nio"
command = ~F, B, D, F, b
time = 35

[Command]
name = "ranbu"
command = ~F, D, B, F, x
time = 35

[Command]
name = "makyou"
command = ~F, D, B, F, a
time = 35

|------------------------------------------------------
[Command]
name = "hao"
command = ~F, B, D, F, x
time = 25

[Command]
name = "bball"
command = ~D, B, D, F, b
time = 25

[Command]
name = "zan"
command = ~D, F, D, B, x
time = 25

[Command]
name = "gekihou"
command = ~F, D, DF, b
time = 15

[Command]
name = "retsu"
command = ~F, D, DF, a
time = 15

[Command]
name = "ko"
command = ~D, DF, F, x
time = 15

[Command]
name = "mega"
command = ~D, DF, F, a
time = 15

[Command]
name = "hiki"
command = ~F, D, B, x
time = 15

[Command]
name = "ball"
command = ~D, DB, B, x
time = 15

[Command]
name = "hikyaku"
command = ~D, DB, B, a
time = 15

[Command]
name = "senbei"
command = ~30$DB, F, x
time = 15

[Command]
name = "bakurai"
command = ~30$DB, F, b
time = 15


;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

[Command]
name = "DD"     ;Required (do not remove)
command = D, D
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

[Command]
name = "xa"
command = x+a
time = 1

[Command]
name = "yb"
command = y+b
time = 1

[Command]
name = "xy"
command = x+y
time = 1

[Command]
name = "ab"
command = a+b
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

[Command]
name = "hold_x";Required (do not remove)
command = /$x
time = 1

[Command]
name = "hold_y";Required (do not remove)
command = /$y
time = 1

[Command]
name = "hold_a";Required (do not remove)
command = /$a
time = 1

[Command]
name = "hold_b";Required (do not remove)
command = /$b
time = 1

[command]
name="fwd"
command=F
time=1
[command]
name="back"
command=B
time=1
[command]
name="up"
command=U
time=1
[command]
name="down"
command=D
time=1

[Statedef 10000]
anim=10000;Ȃɂ\Ȃ҂łǓȂĂSRȂ
ctrl=0

[State 10000,ԈႢŖ{̂痧ֈڍs]
type=selfstate
trigger1=!ishelper
value=0

[State 10000,vC[]
type=varset
trigger1=command="up"&&root,command="up"
trigger2=command="down"&&root,command="down"
trigger3=command="back"&&root,command="back"
trigger4=command="fwd"&&root,command="fwd"
trigger5=command="a"&&root,command="a"
trigger6=command="b"&&root,command="b"
trigger7=command="c"&&root,command="c"
trigger8=command="x"&&root,command="x"
trigger9=command="y"&&root,command="y"
trigger10=command="z"&&root,command="z"
trigger11=command="start"&&root,command="start"
var(59)=-1

[State 10000,]
Type = DestroySelf
triggerAll = isHelper
trigger1 = root,var(59)||var(59)=-1
trigger2=command="up"&&root,command="up"
trigger3=command="down"&&root,command="down"
trigger4=command="back"&&root,command="back"
trigger5=command="fwd"&&root,command="fwd"
trigger6=command="a"&&root,command="a"
trigger7=command="b"&&root,command="b"
trigger8=command="c"&&root,command="c"
trigger9=command="x"&&root,command="x"
trigger10=command="y"&&root,command="y"
trigger11=command="z"&&root,command="z"
trigger12=command="start"&&root,command="start"

[State 10000,׸ON]
type=varset
triggerall=var(59)!=-1
trigger1=root,command="up"
trigger2=root,command="down"
trigger3=root,command="back"
trigger4=root,command="fwd"
trigger5=root,command="a"
trigger6=root,command="b"
trigger7=root,command="c"
trigger8=root,command="x"
trigger9=root,command="y"
trigger10=root,command="z"
trigger11=root,command="start"
var(59)=1


;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

[State -1, AINpwp[]
type=helper
trigger1 = !NumHelper(10000)
trigger1 = roundstate=2
trigger1 = alive
trigger1 = var(59)=0
trigger1 = (PrevStateNo=[190,194]) || PrevStateNo = 5900
trigger1 = ctrl&&stateno=0
helpertype=normal
name = "AI"
stateno = 10000
ID = 10000
pos = 9999,9999
keyctrl = 1
pausemovetime = 2147483647
supermovetime = 2147483647
persistent = 0

;Ô߁tĂ
[State -1, ֌WXe[gɍsȂ悤]
type = changestate
trigger1 = ishelper(10000)
trigger1 = stateno != 10000
value = 10000
;===========================================================================
;AItO
;---------------------------------------------------------------------------

[State -1, AI]
type = VarSet
triggerall = !var(59) 
triggerall = RoundState = [1,2]
trigger1 = Command = "AI0"
trigger2 = Command = "AI1"
trigger3 = Command = "AI2"
trigger4 = Command = "AI3"
trigger5 = Command = "AI4"
trigger6 = Command = "AI5"
trigger7 = Command = "AI6"
trigger8 = Command = "AI7"
trigger9 = Command = "AI8"
trigger10 = Command = "AI9"
trigger11 = Command = "AI10"
trigger12 = Command = "AI11"
trigger13 = Command = "AI12"
trigger14 = Command = "AI13"
trigger15 = Command = "AI14"
trigger16 = Command = "AI15"
trigger17 = Command = "AI16"
trigger18 = Command = "AI17"
trigger19 = Command = "AI18"
trigger20 = Command = "AI19"
trigger21 = Command = "AI20"
trigger22 = Command = "AI21"
trigger23 = Command = "AI22"
trigger24 = Command = "AI23"
trigger25 = Command = "AI24"
trigger26 = Command = "AI25"
trigger27 = Command = "AI26"
trigger28 = Command = "AI27"
trigger29 = Command = "AI28"
trigger30 = Command = "AI29"
trigger31 = Command = "AI30"
trigger32 = Command = "AI31"
trigger33 = Command = "AI32"
trigger34 = Command = "AI33"
trigger35 = Command = "AI34"
trigger36 = Command = "AI35"
trigger37 = Command = "AI36"
trigger38 = Command = "AI37"
trigger39 = Command = "AI38"
trigger40 = Command = "AI39"
trigger41 = Command = "AI40"
trigger42 = Command = "AI41"
trigger43 = Command = "AI42"
trigger44 = Command = "AI43"
trigger45 = Command = "AI44"
trigger46 = Command = "AI45"
trigger47 = Command = "AI46"
trigger48 = Command = "AI47"
trigger49 = Command = "AI48"
trigger50 = Command = "AI49"
trigger51 = Command = "AI50"
trigger52 = NumHelper(10000)
trigger52 = Helper(10000),var(59)
;trigger53 = !ishelper
var(59) = 6 ;AIxݒ1~6

[State -1, R{ϐ];Zbg
Type = VarSet
triggerall = var(59)
triggerall = var(58)
trigger1 = RoundState = 4
trigger2 = stateno = 5120 || movetype = H
trigger3 = EnemyNear(var(50)),StateNo = 5120
trigger4 = stateno = 211 || stateno = 241
var(58) = 0
IgnoreHitPause = 1

[State -1, R{ϐ];
Type = VarSet
triggerall = var(59)
triggerall = RoundState = 2
trigger1 = stateno = 401
trigger1 = movehit
var(58) = 1
IgnoreHitPause = 1

[State -1, R{ϐ];
Type = VarSet
triggerall = var(59)
triggerall = RoundState = 2
trigger1 = EnemyNear(var(50)),StateNo = 1039
trigger1 = EnemyNear(var(50)),MoveType = H
var(58) = 2
IgnoreHitPause = 1

[State -1, qɒe];
Type = VarSet
triggerall = var(59)
triggerall = RoundState = 2
trigger1 = stateno = 1001
var(56) = 1
IgnoreHitPause = 1

[State -1, qɒe];
Type = VarSet
triggerall = var(59)
triggerall = RoundState = 2
trigger1 = stateno = 1003
var(56) = 2
IgnoreHitPause = 1

[State -1, qɒe];
Type = VarSet
triggerall = var(59)
triggerall = RoundState = 2
trigger1 = stateno = 1004
var(56) = 3
IgnoreHitPause = 1

[State -1, qɒe];
Type = VarSet
triggerall = var(59)
triggerall = RoundState = 2
trigger1 = stateno = 1007
var(56) = 4
IgnoreHitPause = 1

[State -1, Vnw];
Type = VarSet
triggerall = var(59)
triggerall = RoundState = 2
trigger1 = stateno = 1080
var(55) = 1
IgnoreHitPause = 1

[State -1, Vnw];
Type = VarAdd
triggerall = var(59)
triggerall = RoundState = 2
trigger1 = var(55) < 300
var(55) = 1
IgnoreHitPause = 1

[State -1, ^bOp];
Type = VarSet
triggerall = var(59)
triggerall = RoundState = 2
trigger1 = NumEnemy = 1
trigger2 = NumEnemy = 2
trigger2 = EnemyNear(0),life > 0
var(50) = 0
IgnoreHitPause = 1

[State -1, ^bOp];
Type = VarSet
triggerall = var(59)
triggerall = RoundState = 2
trigger1 = NumEnemy = 2
trigger1 = EnemyNear(0),life <= 0
var(50) = 1
IgnoreHitPause = 1

;========AI=========================================================

;===========================================================================
;؂ւ
;---------------------------------------------------------------------------
;
;---------------------------------------------------------------------------
;r
;[State -1, Kung Fu Throw]
type = ChangeState
value = 800
triggerall = var(59) = 6
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = ctrl
triggerall = Anim != 900 || Anim != 901
trigger1 = p2bodydist X < 5
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
trigger1 = random <= var(59)*70
trigger1 = P2BodyDist X = [-5,4]
trigger1 = EnemyNear(var(50)),Statetype != A
trigger1 = EnemyNear(var(50)),Statetype != L
trigger1 = EnemyNear(var(50)),MoveType != H
trigger1 = BackEdgeBodyDist >= 40

;r
;[State -1, Kung Fu Throw]
type = ChangeState
value = 801
triggerall = var(59) = 6
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = ctrl
triggerall = Anim != 900 || Anim != 901
trigger1 = p2bodydist X < 5
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
trigger1 = random <= var(59)*70
trigger1 = P2BodyDist X = [-5,4]
trigger1 = EnemyNear(var(50)),Statetype != A
trigger1 = EnemyNear(var(50)),Statetype != L
trigger1 = EnemyNear(var(50)),MoveType != H
trigger1 = BackEdgeBodyDist < 40

;r
;[State -1, Kung Fu Throw]
type = ChangeState
value = 800
triggerall = var(59) = [1,5]
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = ctrl
triggerall = Anim != 900 || Anim != 901
triggerall = PrevStateNo != [800,801]
triggerall = (EnemyNear(var(50)),statetype != A) && (EnemyNear(var(50)),statetype != L)
triggerall = (EnemyNear(var(50)),statetype = S) || (EnemyNear(var(50)),statetype = C) 
triggerall = p2bodydist X < 3
trigger1 = EnemyNear(var(50)),MoveType != H
trigger1 = BackEdgeBodyDist >= 40
trigger1 = random <= var(59)*50
trigger1 = (EnemyNear(var(50)),StateNo=[120,159])
trigger2 = random <= var(59)*30
trigger2 = EnemyNear(var(50)),MoveType != H

;r 
;[State -1, Kung Fu Throw]
type = ChangeState
value = 801
triggerall = var(59) = [1,5]
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = ctrl
triggerall = Anim != 900 || Anim != 901
triggerall = PrevStateNo != [800,801]
triggerall = (EnemyNear(var(50)),statetype != A) && (EnemyNear(var(50)),statetype != L)
triggerall = (EnemyNear(var(50)),statetype = S) || (EnemyNear(var(50)),statetype = C) 
triggerall = p2bodydist X < 3
trigger1 = EnemyNear(var(50)),MoveType != H
trigger1 = BackEdgeBodyDist < 40
trigger1 = random <= var(59)*50
trigger1 = (EnemyNear(var(50)),StateNo=[120,159])
trigger2 = random <= var(59)*30
trigger2 = EnemyNear(var(50)),MoveType != H
;---------------------------------------------------------------------------
;Δѓ
;---------------------------------------------------------------------------
;q@w ѓp
[State -1]
type = ChangeState
value = 1020
triggerall = var(59) = [1,5]
triggerall = var(59) > 2
triggerall = RoundState = 2
triggerall = statetype != A
trigger1 = ctrl
trigger1 = EnemyNear(var(50)),HitDefAttr = SCA,AP || EnemyNear(var(50)),Movetype  = A
trigger1 = Enemy,NumHelper > 0 || Enemy,NumProj > 0
trigger1 = InGuardDist
trigger1 = p2bodydist X >= 100
trigger1 = random <= var(59)*50
trigger1 = EnemyNear(var(50)),StateType != A

;q@Ԋw
[State -1]
type = ChangeState
value = 1025
triggerall = var(59) = [1,5]
triggerall = var(59) > 2
triggerall = RoundState = 2
triggerall = statetype != A
trigger1 = ctrl
trigger1 = EnemyNear(var(50)),HitDefAttr = SCA,AP || EnemyNear(var(50)),Movetype  = A
trigger1 = Enemy,NumHelper > 0 || Enemy,NumProj > 0
trigger1 = InGuardDist
trigger1 = p2bodydist X >= 150
trigger1 = random <= var(59)*100
trigger1 = EnemyNear(var(50)),StateType != A
trigger2 = (P2BodyDist X = [30,60]) && (p2bodydist Y = [-80,-30])
trigger2 = EnemyNear(var(50)),StateType = A
trigger2 = ctrl && random <= var(59)*120
;---------------------------------------------------------------------------
;GړZ
;---------------------------------------------------------------------------
; ً}O
[State -1]
type = ChangeState
value = 510
triggerall = var(59) = 6
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = (ctrl || stateno = 100)
trigger1 = EnemyNear(var(50)),AnimTime <= -22
trigger1 = EnemyNear(var(50)),Movetype = A
trigger1 = P2BodyDist X = [-5,60]
trigger1 = random<=var(59)*100
trigger1 = facing != EnemyNear(var(50)),facing
trigger2 = p2statetype = L
trigger2 = p2bodydist X = [-5,50]
trigger2 = BackEdgeBodyDist < 40
trigger2 = random<=var(59)*100
trigger3 = EnemyNear(var(50)),Movetype = A
trigger3 = p2bodydist X = [-5,20]
trigger3 = BackEdgeBodyDist < 40
trigger3 = random<=var(59)*50

; ً}O
[State -1]
type = ChangeState
value = 510
triggerall = var(59) = [1,5]
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = (ctrl || stateno = 100)
trigger1 = random <= var(59)*50
trigger1 = p2statetype != L
trigger1 = P2BodyDist X = [80,100]
trigger2 = p2statetype = L || EnemyNear(var(50)),MoveType = A
trigger2 = p2bodydist X = [-5,50]
trigger2 = BackEdgeBodyDist < 40

; ً}
[State -1]
type = ChangeState
value = 511
triggerall = var(59) = [1,5]
triggerall = var(59) > 2
triggerall = RoundState = 2
triggerall = statetype != A && (ctrl || stateno = 100)
trigger1 = var(59) > 3
trigger1 = random <= var(59)*140
trigger1 = p2statetype = L || EnemyNear(var(50)),MoveType = A
trigger1 = p2bodydist X = [-5,50]
trigger1 = BackEdgeBodyDist > 40
trigger2 = var(59) = 3
trigger2 = random <= var(59)*60
trigger2 = p2statetype = L || EnemyNear(var(50)),MoveType = A
trigger2 = p2bodydist X = [-5,50]
trigger2 = BackEdgeBodyDist > 40
;---------------------------------------------------------------------------
;΋
;---------------------------------------------------------------------------
;
[State -1, Run Back]
type = ChangeState
value = 110
triggerall = var(59) = 6
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = Anim != 900 || Anim != 901
trigger1 = ctrl
trigger1 = stateno != 110
trigger1 = P2bodydist X = [-30,60]
trigger1 = P2bodydist Y = [-90,-15]
trigger1 = random<=var(59)*100
trigger1 = EnemyNear(var(50)),StateType = A
trigger1 = EnemyNear(var(50)),MoveType = A

;ߋp`
[State -1, Stand Strong Punch]
type = ChangeState
value = 211
triggerall = var(59) = [1,5]
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = p2bodydist X < 20
triggerall = Anim != 900 || Anim != 901
trigger1 = ctrl
trigger1 = (P2BodyDist X = [-5,30]) && (p2bodydist Y = [-80,-30])
trigger1 = EnemyNear(var(50)),StateType = A
trigger1 = random <= var(59)*140

;u{[r
[State -1, ]
type = ChangeState
value = 1300
triggerall = var(59) = [1,5]
triggerall = RoundState = 2
triggerall = statetype != A
trigger1 = (PrevStateNo = [5110,5270]) || (PrevStateNo = 702)
trigger1 = ctrl && random <= var(59)*150
trigger1 = p2bodydist X = [-5,30]

;===========================================================================
;K[h
;---------------------------------------------------------------------------
[State -1,K[h]
Type = ChangeState
Value = 120
triggerall = var(59) && RoundState = 2
triggerAll = StateNo!=[120,155]
triggerAll = StateType != A && p2statetype != L
triggerAll = Ctrl || (stateno = 100)
triggerAll = inguarddist
trigger1 = Random<=var(59)*120
trigger2 = P2BodyDist X>90||EnemyNear(var(50)),Time>50
trigger2 = Random<=var(59)*200
trigger3 = P2BodyDist X = [-5,90]
trigger3 = PrevStateNo = [5000,5270]
trigger3 = random <= var(59)*200

;===========================================================================
;R{
;---------------------------------------------------------------------------
;--------------------------
;KEZ
;--------------------------
;q嗐
[State -1]
type = ChangeState
value = 1050
triggerall = var(59) = 6
triggerall = RoundState = 2
triggerall = power >= 2000
triggerall = statetype != A
triggerall = var(12)
triggerall = EnemyNear(var(50)),Life >= 250
trigger1 = stateno = 241
trigger1 = movehit
trigger1 = AnimElem = 8, > 0
trigger1 = random <= var(59)*160
trigger1 = FrontEdgeBodyDist >= 55
trigger2 = stateno = 210
trigger2 = movehit
trigger2 = random <= var(59)*160
trigger2 = FrontEdgeBodyDist >= 55

;mE
[State -1]
type = ChangeState
value = 1200
triggerall = var(59) = 6
triggerall = RoundState = 2
triggerall = power >= 1000
triggerall = statetype != A
trigger1 = stateno = 241
trigger1 = moveguarded
trigger1 = AnimElem = 8, > 0
trigger1 = random <= var(59)*120

;q
[State -1]
type = ChangeState
value = 1040
triggerall = var(59) = 6
triggerall = RoundState = 2
triggerall = power >= 1000
triggerall = statetype != A
triggerall = var(12)
trigger1 = stateno = 241
trigger1 = movehit
trigger1 = AnimElem = 8, > 0
trigger1 = random <= var(59)*140
trigger1 = FrontEdgeBodyDist >= 55
trigger2 = stateno = 210
trigger2 = movehit
trigger2 = random <= var(59)*140
trigger2 = FrontEdgeBodyDist >= 55

;q嗐
[State -1]
type = ChangeState
value = 1050
triggerall = var(59) = 5
triggerall = RoundState = 2
triggerall = power >= 2000
triggerall = statetype != A
trigger1 = movehit
trigger1 = stateno = 210
trigger1 = var(12)

;q
[State -1]
type = ChangeState
value = 1040
triggerall = var(59) = [1,5]
triggerall = var(59) > 2
triggerall = RoundState = 2
triggerall = power >= 1000
triggerall = statetype != A
trigger1 = movehit
trigger1 = stateno = 210
trigger1 = var(12)
trigger1 = random <= var(59)*100

;--------------------------
;KEZ
;--------------------------
;q
[State -1]
type = ChangeState
value = 1030
triggerall = var(59) = 6
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = !inguarddist
triggerall = !var(12)
trigger1 = stateno = 241
trigger1 = movehit
trigger1 = AnimElem = 8, > 0
trigger1 = random <= var(59)*110 || (power >= 1000 && random <= var(59)*150)
trigger2 = stateno = 210
trigger2 = movehit
trigger2 = random <= var(59)*110 || (power >= 1000 && random <= var(59)*150)
trigger2 = EnemyNear(var(50)),StateType != A

;C
[State -1]
type = ChangeState
value = 1004
triggerall = var(59) = 6
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
triggerall = var(12)
triggerall = EnemyNear(var(50)),StateType != A
triggerall = FrontEdgeBodyDist < 55
trigger1 = stateno = 241
trigger1 = movehit
trigger1 = AnimElem = 8, > 0
trigger1 = random <= var(59)*150
trigger2 = stateno = 210
trigger2 = movehit
trigger2 = random <= var(59)*150

;eęጝ
[State -1]
type = ChangeState
value = 1001
triggerall = var(59) = 6
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
trigger1 = stateno = 241
trigger1 = moveguarded
trigger1 = AnimElem = 8, > 0
trigger1 = random <= var(59)*70
trigger2 = stateno = 210
trigger2 = movehit
trigger2 = random <= var(59)*110
trigger3 = stateno = 210
trigger3 = movehit
trigger3 = random <= var(59)*150
trigger3 = EnemyNear(var(50)),StateType = A

;ubc{[
[State -1]
type = ChangeState
value = 1007
triggerall = var(59) = 6
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
trigger1 = stateno = 241
trigger1 = moveguarded || (movehit && var(12))
trigger1 = AnimElem = 8, > 0
trigger1 = random <= var(59)*100

;q
[State -1]
type = ChangeState
value = 1030
triggerall = var(59) = [1,5]
triggerall = var(59) > 3
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = !inguarddist
triggerall = !var(12)
trigger1 = movehit
trigger1 = (stateno = 210) || (stateno = 231)
trigger1 = random <= var(59)*170
trigger1 = p2statetype != A
trigger2 = ctrl
trigger2 = random <= var(59)*60
trigger2 = P2BodyDist X = [80,100]
trigger2 = p2statetype != A && p2statetype != L

;eęጝ
[State -1]
type = ChangeState
value = 1001
triggerall = var(59) = [1,5]
triggerall = var(59) > 3
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
triggerall = PrevStateNo != 1001
trigger1 = ctrl
trigger1 = random <= var(59)*30
trigger1 = P2BodyDist X >= 160
trigger2 = var(12)
trigger2 = movehit
trigger2 = stateno = 210
trigger2 = random <= var(59)*100
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = random <= var(59)*100
trigger3 = EnemyNear(var(50)),StateType = A
trigger3 = p2bodydist X <= 100

;KX}bV
[State -1]
type = ChangeState
value = 1002
triggerall = var(59) = [1,5]
triggerall = var(59) > 3
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
triggerall = PrevStateNo != 1002
triggerall = EnemyNear(var(50)),StateType != A
trigger1 = ctrl
trigger1 = random <= var(59)*40
trigger1 = P2BodyDist X >= 150
trigger1 = p2statetype != A
trigger2 = !var(12)
trigger2 = movehit
trigger2 = stateno = 210
trigger2 = random <= var(59)*100
trigger3 = movehit
trigger3 = stateno = 231
trigger3 = random <= var(59)*100

;ubc{[
[State -1]
type = ChangeState
value = 1007
triggerall = var(59) = [1,5]
triggerall = var(59)
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
trigger1 = movehit
trigger1 = stateno = 210
trigger1 = random <= var(59)*100
trigger2 = movehit
trigger2 = stateno = 210
trigger2 = random <= var(59)*100
trigger2 = EnemyNear(var(50)),StateType = A
trigger2 = p2bodydist X > 100

;--------------------------
;ʏZ
;--------------------------
;ߋLbN
[State -1, Standing Strong Kick]
type = ChangeState
value = 241
triggerall = var(59) = 6
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = p2bodydist X < 20
triggerall = Anim != 900 || Anim != 901
trigger1 = ctrl
trigger1 = var(58) = 1

;ߋp`
[State -1, Stand Strong Punch]
type = ChangeState
value = 211
triggerall = var(59) = 6
triggerall = var(58) = 2
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = p2bodydist X < 20
triggerall = Anim != 900 || Anim != 901
trigger1 = ctrl || stateno = 100
trigger1 = random <= var(59)*80
trigger1 = P2BodyDist X = [-5,19]
trigger1 = P2BodyDist Y = [-50,0]
trigger1 = EnemyNear(var(50)),StateType != L

;p`
[State -1, Stand Strong Punch]
type = ChangeState
value = 210
triggerall = var(59) = 6
triggerall = var(58) != 2
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = p2bodydist X >= 20
trigger1 = ctrl
trigger1 = random <= var(59)*80
trigger1 = P2BodyDist X = [20,80]
trigger1 = P2BodyDist Y = [-50,0]
trigger1 = EnemyNear(var(50)),StateType != L
trigger2 = stateno = 100
trigger2 = random <= var(59)*80
trigger2 = P2BodyDist X = [20,60]
trigger2 = P2BodyDist Y = [-50,0]
trigger2 = EnemyNear(var(50)),StateType != L

;Crouching Light Punch
;Ⴊݎp`
[State -1, Crouching Light Punch]
type = ChangeState
value = 401
triggerall = var(59) = 6
triggerall = var(58) != 2
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = p2bodydist X < 20
triggerall = Anim != 900 || Anim != 901
trigger1 = ctrl || stateno = 100
trigger1 = random <= var(59)*80
trigger1 = P2BodyDist X = [-5,4]
trigger1 = EnemyNear(var(50)),StateType != A
trigger1 = EnemyNear(var(50)),StateType != L

;ߋLbN
[State -1, Standing Strong Kick]
type = ChangeState
value = 241
triggerall = var(59) = 6
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = p2bodydist X < 20
triggerall = Anim != 900 || Anim != 901
trigger1 = ctrl || stateno = 100
trigger1 = random <= var(59)*80
trigger1 = P2BodyDist X = [-5,19]
trigger1 = EnemyNear(var(50)),StateType != A
trigger1 = EnemyNear(var(50)),StateType != L

;ߋp`
[State -1, Stand Light Punch]
type = ChangeState
value = 201
triggerall = var(59) = [1,5]
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = p2bodydist X < 20
triggerall = Anim != 900 || Anim != 901
triggerall = ctrl || stateno = 100 
trigger1 = random <= var(59)*140
trigger1 = p2statetype != L
trigger1 = EnemyNear(var(50)),StateType != A
trigger1 = P2BodyDist X = [-5,20]

;ߋLbN
[State -1, Stand Light Kick]
type = ChangeState
value = 231
triggerall = var(59) = [1,5]
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = p2bodydist X < 20
triggerall = Anim != 900 || Anim != 901
triggerall = ctrl
trigger1 = random <= var(59)*140
trigger1 = PrevStateNo = 201
trigger1 = P2BodyDist X = [-5,20]

;p`
[State -1, Stand Strong Punch]
type = ChangeState
value = 210
triggerall = var(59) = [1,5]
triggerall = RoundState = 2
triggerall = p2bodydist X >= 20
triggerall = statetype != A
triggerall = !inguarddist
triggerall = ctrl || stateno = 100 
triggerall = P2BodyDist Y = [-80,0]
trigger1 = !var(12)
trigger1 = random <= var(59)*140
trigger1 = P2BodyDist X = [20,75]
trigger1 = PrevStateNo != 220
trigger1 = p2statetype != L
trigger2 = random <= var(59)*140
trigger2 = PrevStateNo = 231 || PrevStateNo = 201
trigger2 = P2BodyDist X = [20,70]
trigger3 = stateno != 100
trigger3 = PrevStateNo = 1031
trigger3 = random <= var(59)*100
trigger3 = EnemyNear(var(50)),MoveType = H
trigger3 = PrevStateNo != 220

;===========================================================================
;nړ
;---------------------------------------------------------------------------
;Run Fwd
;_bV
[State -1, Run Fwd]
type = ChangeState
value = 100
ctrl = 0
triggerall = var(59)
triggerall = RoundState = 2
triggerall = (stateno != 100) && (stateno != 101) && (stateno != 10)
triggerall = statetype != A
triggerall = Anim != 900 || Anim != 901
triggerall = ctrl
trigger1 = P2BodyDist X > 100
trigger1 = p2statetype != L
trigger1 = random <= var(59)*70
trigger2 = numhelper(1009)
trigger2 = random <= var(59)*70 || (var(59) = 6 && random <= var(59)*120)
trigger2 = p2statetype != A
trigger3 = var(59) != 6
trigger3 = var(12)
trigger3 = p2statetype != A && p2statetype != L
trigger3 = EnemyNear(var(50)),MoveType = H
trigger4 = var(59) = 6
trigger4 = var(58) = 2
trigger5 = var(59) = 6
trigger5 = numhelper(1009)
trigger5 = helper(1009),movehit

;Run Back
;ރ_bV
[State -1, Run Back]
type = ChangeState
value = 105
triggerall = var(59)
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = Anim != 900 || Anim != 901
trigger1 = ctrl
trigger1 = random <= var(59)*40
trigger1 = p2bodydist X > 50
trigger1 = BackEdgeBodyDist > 40
trigger1 = EnemyNear(var(50)),MoveType != H
trigger2 = ctrl
trigger2 = var(59) = 6
trigger2 = random <= var(59)*40
trigger2 = P2BodyDist X = [-5,50]
trigger2 = BackEdgeBodyDist > 40
trigger2 = EnemyNear(var(50)),StateType = L

;r
[State -1]
type = ChangeState
value = 1100
triggerall = var(59) = 6
triggerall = RoundState = 2
triggerall = statetype != A
trigger1 = numhelper(1101) = 0
trigger1 = numhelper(1009) = 0
trigger1 = ctrl || stateno = 100
trigger1 = random <= var(59)*50
trigger1 = P2BodyDist X >= 140
trigger1 = EnemyNear(var(50)),StateType != A

;---------------------
;
;---------------------
;mE
[State -1]
type = ChangeState
value = 1200
triggerall = var(59) = 6
triggerall = RoundState = 2
triggerall = power >= 1000
triggerall = statetype != A
trigger1 = ctrl || stateno = 100
trigger1 = P2BodyDist X = [60,120]
trigger1 = EnemyNear(var(50)),StateType = L
trigger1 = random <= var(59)*100

;Vnw
[State -1]
type = ChangeState
value = 1080
triggerall = var(59) = 6
triggerall = var(55) > 200
triggerall = RoundState = 2
triggerall = numhelper(1080) = 0
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
triggerall = power >= 2000
triggerall = statetype != A
trigger1 = ctrl
trigger1 = random <= var(59)*90
trigger1 = P2BodyDist X >= 140

;r[{[
[State -1]
type = ChangeState
value = 1003
triggerall = var(59) = 6
triggerall = var(56) != 2
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
triggerall = ctrl
trigger1 = random <= var(59)*70
trigger1 = P2BodyDist X >= 150
trigger1 = EnemyNear(var(50)),StateType != A

;C
[State -1]
type = ChangeState
value = 1004
triggerall = var(59) = 6
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
trigger1 = ctrl
trigger1 = var(56) != 3
trigger1 = random <= var(59)*70
trigger1 = P2BodyDist X >= 150
trigger1 = EnemyNear(var(50)),StateType != A
trigger2 = ctrl || stateno = 100
trigger2 = random <= var(59)*90
trigger2 = P2BodyDist X >= 100
trigger2 = EnemyNear(var(50)),StateType = L

;ubc{[
[State -1]
type = ChangeState
value = 1007
triggerall = var(59) = 6
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
trigger1 = ctrl
trigger1 = var(56) != 4
trigger1 = random <= var(59)*80
trigger1 = P2BodyDist X >= 140
trigger1 = EnemyNear(var(50)),StateType != A
trigger1 = EnemyNear(var(50)),StateType != L
trigger2 = ctrl || stateno = 100
trigger2 = !var(58)
trigger2 = P2BodyDist X = [50,100]
trigger2 = EnemyNear(var(50)),StateNo = [120,155]
trigger2 = EnemyNear(var(50)),StateType != A
trigger2 = random <= var(59)*120

;eęጝ
[State -1]
type = ChangeState
value = 1001
triggerall = var(59) = 6
triggerall = var(56) != 1
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
trigger1 = ctrl
trigger1 = random <= var(59)*80
trigger1 = P2BodyDist X >= 140
trigger1 = EnemyNear(var(50)),StateType != L

;mE
[State -1]
type = ChangeState
value = 1200
triggerall = var(59) = [1,5]
triggerall = var(59) > 2
triggerall = RoundState = 2
triggerall = power >= 1000
triggerall = statetype != A
triggerall = PrevStateNo != 1200
trigger1 = ctrl
trigger1 = p2bodydist X >= 80
trigger1 = EnemyNear(var(50)),StateType = A 
trigger1 = EnemyNear(var(50)),StateType != L
trigger1 = random <= var(59)*100
trigger1 = EnemyNear(var(50)),Vel X >= 0
trigger1 = P2BodyDist X = [50,150]

;Vnw
[State -1]
type = ChangeState
value = 1080
triggerall = var(59) = [1,5]
triggerall = var(59) > 3
triggerall = RoundState = 2
triggerall = numhelper(1080) = 0
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
triggerall = power >= 2000
triggerall = statetype != A
trigger1 = ctrl
trigger1 = random <= var(59)*100
trigger1 = P2BodyDist X >= 140

;
[State -1]
type = ChangeState
value = 1000
triggerall = var(59) = [1,3]
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
triggerall = stateno != 100
triggerall = PrevStateNo != 1000
triggerall = ctrl
trigger1 = random <= var(59)*50
trigger1 = P2BodyDist X >= 175
trigger1 = p2statetype != A

;aSh
[State -1]
type = ChangeState
value = 1005
triggerall = var(59) = [1,5]
triggerall = var(59) > 3
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
triggerall = PrevStateNo != 1005
triggerall = ctrl
trigger1 = random <= var(59)*80
trigger1 = P2BodyDist X >= 140
trigger1 = p2statetype != A

;r[{[
[State -1]
type = ChangeState
value = 1003
triggerall = var(59) = [1,5]
triggerall = var(59)
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
triggerall = PrevStateNo != 1003
triggerall = ctrl
trigger1 = random <= var(59)*80
trigger1 = P2BodyDist X >= 150
trigger1 = p2statetype != A

;C
[State -1]
type = ChangeState
value = 1004
triggerall = var(59) = [1,5]
triggerall = var(59) > 3
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
triggerall = PrevStateNo != 1004
triggerall = ctrl
trigger1 = random <= var(59)*100
trigger1 = P2BodyDist X >= 150
trigger1 = p2statetype != A

;ZxC藠
[State -1]
type = ChangeState
value = 1006
triggerall = var(59) = [1,3]
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
triggerall = PrevStateNo != 1006
triggerall = ctrl
trigger1 = random <= var(59)*100
trigger1 = P2BodyDist X >= 150
trigger1 = p2statetype != A

;r
[State -1]
type = ChangeState
value = 1100
triggerall = var(59) = [1,5]
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = numhelper(1009) = 0
triggerall = PrevStateNo != [1100,1111]
trigger1 = ctrl
trigger1 = p2statetype = L
trigger1 = random <= var(59)*50
trigger2 = ctrl
trigger2 = P2BodyDist X >= 150
trigger2 = random <= var(59)*70
trigger2 = EnemyNear(var(50)),MoveType != H

;Crouching Strong Punch
;Ⴊ݋p`
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = var(59) = [1,5]
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = !inguarddist
triggerall = ctrl
trigger1 = P2BodyDist X = [20,60]
trigger1 = random <= var(59)*100
trigger1 = EnemyNear(var(50)),MoveType != H

;Crouching Strong Kick
;Ⴊ݋LbN
[State -1, Crouching Strong Kick]
type = ChangeState
value = 440
triggerall = var(59) = [1,5]
triggerall = RoundState = 2
triggerall = statetype != A
triggerall = ctrl
trigger1 = P2BodyDist X = [-5,50]
trigger1 = random <= var(59)*100
trigger1 = EnemyNear(var(50)),MoveType != H

;===========================================================================
;󒆈ړ
;---------------------------------------------------------------------------
[State -1,ެ]
Type     = ChangeState
Value    = 40
triggerall = var(59) && RoundState = 2
triggerall = StateType != A
triggerall = EnemyNear(var(50)),MoveType != H
triggerall = !inguarddist
trigger1 = stateno = 100
trigger1 = numhelper(1009) = 0
trigger1 = EnemyNear(var(50)),StateType != L
trigger1 = random <= var(59)*80
trigger1 = p2bodydist X = [130,160]
trigger2 = Ctrl || stateno = 100
trigger2 = EnemyNear(var(50)),HitDefAttr=SCA,AT
trigger2 = random <= var(59)*160
trigger2 = EnemyNear(var(50)),Time>=30||(!Time&&var(59)>3) || var(59)>4
trigger2 = EnemyNear(var(50)),Time>=50 || (PrevStateNo=[5000,5270]) || (PrevStateNo=[120,159])

;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = var(59) = 6
triggerall = RoundState = 2
triggerall = statetype = A
triggerall = ctrl
trigger1 = (p2bodydist X = [-5,60])
trigger1 = p2statetype = A
trigger1 = random <= var(59)*100
trigger1 = EnemyNear(var(50)),StateType != L

;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = var(59) && RoundState = 2
triggerall = statetype = A
triggerall = vel Y >= 0
triggerall = ctrl
trigger1 = (p2bodydist X = [-5,60])
trigger1 = (p2bodydist Y = [45,65])
trigger1 = random <= var(59)*160
trigger1 = EnemyNear(var(50)),StateType != L
trigger2 = (p2bodydist X = [-5,60])
trigger2 = p2statetype = A
trigger2 = random <= var(59)*160
trigger2 = EnemyNear(var(50)),StateType != L


;========܂AI=========================================================
;===========================================================================
;---------------------------------------------------------------------------
;kCO~
[State -1, Light Kung Fu Palm]
type = ChangeState
value = 704
triggerall = !var(59)
triggerall = command = "doll"
trigger1 = statetype != A
trigger1 = ctrl
triggerall = Anim != 900 || Anim != 901
trigger2 = movehit
trigger2 = stateno = 200
trigger3 = movehit
trigger3 = stateno = 210
trigger4 = movehit
trigger4 = stateno = 231
trigger5 = movehit
trigger5 = stateno = 211
trigger6 = movecontact
trigger6 = stateno = 241


;-----------------------------------------------------------
;q嗐
[State -1]
type = ChangeState
value = 1050
triggerall = !var(59)
triggerall = command = "ranbu2"
triggerall = power >= 2000
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger3 = movehit
trigger3 = stateno = 210
trigger4 = movehit
trigger4 = stateno = 231
trigger5 = movehit
trigger5 = stateno = 211
trigger6 = movecontact
trigger6 = stateno = 241
trigger7 = stateno = 704 && time >= 30

;-----------------------------------------------------------
;mE
[State -1]
type = ChangeState
value = 1200
triggerall = !var(59)
triggerall = command = "nio"
triggerall = power >= 1000
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger3 = movehit
trigger3 = stateno = 210
trigger4 = movehit
trigger4 = stateno = 231
trigger5 = movehit
trigger5 = stateno = 211
trigger6 = movecontact
trigger6 = stateno = 241
trigger7 = stateno = 704 && time >= 30

;-----------------------------------------------------------
;q
[State -1]
type = ChangeState
value = 1040
triggerall = !var(59)
triggerall = command = "ranbu"
triggerall = power >= 1000
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger3 = movehit
trigger3 = stateno = 210
trigger4 = movehit
trigger4 = stateno = 231
trigger5 = movehit
trigger5 = stateno = 211
trigger6 = movecontact
trigger6 = stateno = 241
trigger7 = stateno = 704 && time >= 30

;-----------------------------------------------------------
;Vnw
[State -1]
type = ChangeState
value = 1080
triggerall = !var(59)
triggerall = numhelper(1080) = 0
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
triggerall = command = "makyou"
triggerall = power >= 2000
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger3 = movehit
trigger3 = stateno = 210
trigger4 = movehit
trigger4 = stateno = 231
trigger5 = movehit
trigger5 = stateno = 211
trigger6 = movecontact
trigger6 = stateno = 241
trigger7 = stateno = 704 && time >= 30


;---------------------------------------------------------------------------
;qɒe
;eęጝ
[State -1]
type = ChangeState
value = 1001
triggerall = !var(59)
triggerall = command = "hao"
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger3 = movehit
trigger3 = stateno = 210
trigger4 = movehit
trigger4 = stateno = 231
trigger5 = movehit
trigger5 = stateno = 211
trigger6 = movecontact
trigger6 = stateno = 241
trigger7 = stateno = 704 && time >= 30

;r[{[
[State -1]
type = ChangeState
value = 1003
triggerall = !var(59)
triggerall = command = "bball"
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger3 = movehit
trigger3 = stateno = 210
trigger4 = movehit
trigger4 = stateno = 231
trigger5 = movehit
trigger5 = stateno = 211
trigger6 = movecontact
trigger6 = stateno = 241
trigger7 = stateno = 704 && time >= 30

;aSh
[State -1]
type = ChangeState
value = 1005
triggerall = !var(59)
triggerall = command = "zan"
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger3 = movehit
trigger3 = stateno = 210
trigger4 = movehit
trigger4 = stateno = 231
trigger5 = movehit
trigger5 = stateno = 211
trigger6 = movecontact
trigger6 = stateno = 241
trigger7 = stateno = 704 && time >= 30

;q C
[State -1]
type = ChangeState
value = 1060
triggerall = !var(59)
triggerall = command = "gekihou"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger3 = movehit
trigger3 = stateno = 210
trigger4 = movehit
trigger4 = stateno = 231
trigger5 = movehit
trigger5 = stateno = 211
trigger6 = movecontact
trigger6 = stateno = 241
trigger7 = stateno = 704 && time >= 30

;u{[r
[State -1, ]
type = ChangeState
value = 1300
triggerall = !var(59)
triggerall = command = "retsu"
trigger1 = statetype != A
trigger1 = ctrl
triggerall = Anim != 900 || Anim != 901
trigger2 = movehit
trigger2 = stateno = 200
trigger3 = movehit
trigger3 = stateno = 210
trigger4 = movehit
trigger4 = stateno = 231
trigger5 = movehit
trigger5 = stateno = 211
trigger6 = movecontact
trigger6 = stateno = 241

;
[State -1]
type = ChangeState
value = 1000
triggerall = !var(59)
triggerall = command = "ko"
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger3 = movehit
trigger3 = stateno = 210
trigger4 = movehit
trigger4 = stateno = 231
trigger5 = movehit
trigger5 = stateno = 211
trigger6 = movecontact
trigger6 = stateno = 241
trigger7 = stateno = 704 && time >= 30

;KX}bV
[State -1]
type = ChangeState
value = 1002
triggerall = !var(59)
triggerall = command = "mega"
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger3 = movehit
trigger3 = stateno = 210
trigger4 = movehit
trigger4 = stateno = 231
trigger5 = movehit
trigger5 = stateno = 211
trigger6 = movecontact
trigger6 = stateno = 241
trigger7 = stateno = 704 && time >= 30

;q
[State -1]
type = ChangeState
value = 1030
triggerall = !var(59)
triggerall = command = "hiki"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger3 = movehit
trigger3 = stateno = 210
trigger4 = movehit
trigger4 = stateno = 231
trigger5 = movehit
trigger5 = stateno = 211
trigger6 = movecontact
trigger6 = stateno = 241
trigger7 = stateno = 704 && time >= 30

;ubc{[
[State -1]
type = ChangeState
value = 1007
triggerall = !var(59)
triggerall = command = "ball"
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger3 = movehit
trigger3 = stateno = 210
trigger4 = movehit
trigger4 = stateno = 231
trigger5 = movehit
trigger5 = stateno = 211
trigger6 = movecontact
trigger6 = stateno = 241
trigger7 = stateno = 704 && time >= 30

;r
[State -1]
type = ChangeState
value = 1100
triggerall = !var(59)
triggerall = command = "hikyaku"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger3 = movehit
trigger3 = stateno = 210
trigger4 = movehit
trigger4 = stateno = 231
trigger5 = movehit
trigger5 = stateno = 211
trigger6 = movecontact
trigger6 = stateno = 241
trigger7 = stateno = 704 && time >= 30

;ZxC藠
[State -1]
type = ChangeState
value = 1006
triggerall = !var(59)
triggerall = command = "senbei"
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger3 = movehit
trigger3 = stateno = 210
trigger4 = movehit
trigger4 = stateno = 231
trigger5 = movehit
trigger5 = stateno = 211
trigger6 = movecontact
trigger6 = stateno = 241
trigger7 = stateno = 704 && time >= 30

;C
[State -1]
type = ChangeState
value = 1004
triggerall = !var(59)
triggerall = command = "bakurai"
triggerall = statetype != A
triggerall = numproj = 0
triggerall = numhelper(1004) = 0
triggerall = numhelper(1005) = 0
triggerall = numhelper(1009) = 0
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger3 = movehit
trigger3 = stateno = 210
trigger4 = movehit
trigger4 = stateno = 231
trigger5 = movehit
trigger5 = stateno = 211
trigger6 = movecontact
trigger6 = stateno = 241
trigger7 = stateno = 704 && time >= 30


;===========================================================================
;---------------------------------------------------------------------------
;Run Fwd
;_bV
[State -1, Run Fwd]
type = ChangeState
value = 100
triggerall = !var(59)
triggerall = command = "FF"
triggerall = Anim != 900 || Anim != 901
trigger1 = statetype = S
trigger1 = ctrl

trigger2 = stateno = 704 && time >= 30

;---------------------------------------------------------------------------
;Run Back
;ރ_bV
[State -1, Run Back]
type = ChangeState
value = 105
triggerall = !var(59)
triggerall = command = "BB"
triggerall = Anim != 900 || Anim != 901
trigger1 = statetype = S
trigger1 = ctrl

trigger2 = stateno = 704 && time >= 30

;---------------------------------------------------------------------------
;
[State -1, Run Back]
type = ChangeState
value = 110
triggerall = !var(59)
triggerall = command = "DD"
triggerall = Anim != 900 || Anim != 901
trigger1 = statetype != A
trigger1 = ctrl

trigger2 = stateno = 704 && time >= 30

;--------------------------------------------------------
;q@w
[State -1]
type = ChangeState
value = 1020
triggerall = !var(59)
triggerall = command = "xy"
triggerall = command = "holdfwd"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger3 = movehit
trigger3 = stateno = 210
trigger4 = movehit
trigger4 = stateno = 231
trigger5 = movehit
trigger5 = stateno = 211
trigger6 = movecontact
trigger6 = stateno = 241
trigger7 = stateno = 704 && time >= 30

;--------------------------------------------------------
;q@Ԋw
[State -1]
type = ChangeState
value = 1025
triggerall = !var(59)
triggerall = command = "ab"
triggerall = command = "holdfwd"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger3 = movehit
trigger3 = stateno = 210
trigger4 = movehit
trigger4 = stateno = 231
trigger5 = movehit
trigger5 = stateno = 211
trigger6 = movecontact
trigger6 = stateno = 241
trigger7 = stateno = 704 && time >= 30

;---------------------------------------------------------------------------
;r
[State -1, Kung Fu Throw]
type = ChangeState
value = 800
triggerall = !var(59)
triggerall = command = "y"
triggerall = statetype = S
triggerall = ctrl
triggerall = Anim != 900 || Anim != 901
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X < 3
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
trigger2 = command = "holdback"
trigger2 = p2bodydist X < 5
trigger2 = (p2statetype = S) || (p2statetype = C)
trigger2 = p2movetype != H

;r
[State -1, Kung Fu Throw]
type = ChangeState
value = 801
triggerall = !var(59)
triggerall = command = "b"
triggerall = statetype = S
triggerall = ctrl
triggerall = Anim != 900 || Anim != 901
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X < 3
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
trigger2 = command = "holdback"
trigger2 = p2bodydist X < 5
trigger2 = (p2statetype = S) || (p2statetype = C)
trigger2 = p2movetype != H


;===========================================================================
;---------------------------------------------------------------------------
;p`
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = !var(59)
triggerall = command = "x"
triggerall = command != "holddown"
triggerall = p2bodydist X >= 20
triggerall = Anim != 900 || Anim != 901
trigger1 = statetype = S
trigger1 = ctrl


;ߋp`
[State -1, Stand Light Punch]
type = ChangeState
value = 201
triggerall = !var(59)
triggerall = command = "x"
triggerall = command != "holddown"
triggerall = p2bodydist X < 20
triggerall = Anim != 900 || Anim != 901
trigger1 = statetype = S
trigger1 = ctrl


;---------------------------------------------------------------------------
;p`
[State -1, Stand Strong Punch]
type = ChangeState
value = 210
triggerall = !var(59)
triggerall = command = "y"
triggerall = command != "holddown"
triggerall = p2bodydist X >= 20
trigger1 = statetype = S
trigger1 = ctrl

;ߋp`
[State -1, Stand Strong Punch]
type = ChangeState
value = 211
triggerall = !var(59)
triggerall = command = "y"
triggerall = command != "holddown"
triggerall = p2bodydist X < 20
triggerall = Anim != 900 || Anim != 901
trigger1 = statetype = S
trigger1 = ctrl


;---------------------------------------------------------------------------
;LbN
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = !var(59)
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = p2bodydist X >= 20
triggerall = Anim != 900 || Anim != 901
trigger1 = statetype = S
trigger1 = ctrl


;ߋLbN
[State -1, Stand Light Kick]
type = ChangeState
value = 231
triggerall = !var(59)
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = p2bodydist X < 20
triggerall = Anim != 900 || Anim != 901
trigger1 = statetype = S
trigger1 = ctrl


;---------------------------------------------------------------------------
;LbN
[State -1, Standing Strong Kick]
type = ChangeState
value = 240
triggerall = !var(59)
triggerall = command = "b"
triggerall = command != "holddown"
triggerall = p2bodydist X >= 20
triggerall = Anim != 900 || Anim != 901
trigger1 = statetype = S
trigger1 = ctrl


;ߋLbN
[State -1, Standing Strong Kick]
type = ChangeState
value = 241
triggerall = !var(59)
triggerall = command = "b"
triggerall = command != "holddown"
triggerall = p2bodydist X < 20
triggerall = Anim != 900 || Anim != 901
trigger1 = statetype = S
trigger1 = ctrl


; ً}O
[State -1]
type = ChangeState
value = 510
triggerall = !var(59)
triggerall = (command = "z" || command = "xa") && command != "holdback"
trigger1 = statetype != A && (ctrl || stateno = 100)

; ً}
[State -1]
type = ChangeState
value = 511
triggerall = !var(59)
triggerall = (command = "z" || command = "xa") && command = "holdback"
trigger1 = statetype != A && (ctrl || stateno = 100)

;---------------------------------------------------------------------------
;Taunt2
[State -1, Taunt]
type = ChangeState
value = 196
triggerall = !var(59)
triggerall = command = "start" && (command = "holdfwd" || command = "holdback")
triggerall = Anim != 900 || Anim != 901
trigger1 = statetype != A
trigger1 = ctrl


;Taunt1
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = !var(59)
triggerall = command = "start"
triggerall = Anim != 900 || Anim != 901
trigger1 = statetype != A
trigger1 = ctrl



;---------------------------------------------------------------------------
;Crouching Light Punch
;Ⴊݎp`
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = !var(59)
triggerall = command = "x"
triggerall = command = "holddown"
triggerall = p2bodydist X >= 20
triggerall = Anim != 900 || Anim != 901
trigger1 = statetype = C
trigger1 = ctrl


;Crouching Light Punch
;Ⴊݎp`
[State -1, Crouching Light Punch]
type = ChangeState
value = 401
triggerall = !var(59)
triggerall = command = "x"
triggerall = command = "holddown"
triggerall = p2bodydist X < 20
triggerall = Anim != 900 || Anim != 901
trigger1 = statetype = C
trigger1 = ctrl


;---------------------------------------------------------------------------
;Crouching Strong Punch
;Ⴊ݋p`
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = !var(59)
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Light Kick
;ႪݎLbN
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = !var(59)
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Strong Kick
;Ⴊ݋LbN
[State -1, Crouching Strong Kick]
type = ChangeState
value = 440
triggerall = !var(59)
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
;Jump Light Punch
;󒆎p`
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = !var(59)
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = !var(59)
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = !var(59)
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Jump Strong Kick
;󒆋LbN
[State -1, Jump Strong Kick]
type = ChangeState
value = 640
triggerall = !var(59)
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl


