; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below. 
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1



[Command]
name = "AI1"
command = U, D, U, D, U, D, U, D
time = 1
[Command]
name = "AI2"
command = U, D, U, D, U, D, U ,D,U
time = 1
[Command]
name = "AI3"
command = U, D, U, D, U, D, U ,D ,U ,D
time = 1
[Command]
name = "AI4"
command = U, D, U, D, U, D, U, D ,b
time = 1
[Command]
name = "AI5"
command = U, D, D, D, U, D, U, D, U
time = 1
[Command]
name = "AI6"
command = U, U, U, D, U, D, U ,D ,U ,D
time = 1
[Command]
name = "AI7"
command = U, D, U, D, U, D, U, D ,x
time = 1
[Command]
name = "AI8"
command = U, D, U, D, U, D, U ,D,U ,y
time = 1
[Command]
name = "AI9"
command = U, D, U, D, U, D, U ,D ,U ,D ,z
time = 1
[Command]
name = "AI10"
command = U, D, U, D, U, D, U, D ,U ,D ,a
time = 1
[Command]
name = "AI11"
command = U, D, U, D, U, D, U ,D,U,D,U,b
time = 1
[Command]
name = "AI12"
command = U, D, U, D, U, D, U ,D ,U ,D,c
time = 1
[Command]
name = "AI13"
command = U, D, U, D, U, D, U, D ,U ,D ,F
time = 1
[Command]
name = "AI14"
command = U, D, U, D, U, D, U ,D,U,D,U,B
time = 1
[Command]
name = "AI15"
command = U, D, U, D, U, D, U ,D ,U ,D,D,D
time = 1
[Command]
name = "AI16"
command = U, F, U, D, U, D, U ,D ,U ,D ,z
time = 1
[Command]
name = "AI17"
command = U, F, U, D, U, D, U, D ,U ,D ,a
time = 1
[Command]
name = "AI18"
command = U, F, U, D, U, D, U ,D,U,D,U,b
time = 1
[Command]
name = "AI19"
command = U, F, U, D, U, D, U ,U ,U ,D ,z
time = 1
[Command]
name = "AI20"
command = U, F, U, D, U, D, U, B ,U ,D ,a
time = 1
[Command]
name = "AI21"
command = U, F, U, D, B, D, U ,D,U,D,U,b
time = 1
[Command]
name = "AI22"
command = U, F, U, D, U, D, U ,U ,U ,D ,z,b
time = 1
[Command]
name = "AI23"
command = U, F, U, D, U, D, U, B ,U ,D ,a,c
time = 1
[Command]
name = "AI24"
command = U, F, U, D, B, D, U ,D,U,D,U,b,a
time = 1
[Command]
name = "AI25"
command = U, F, U, D, U, D, U ,U ,U ,D ,z,b,U
time = 1
[Command]
name = "AI26"
command = U, F, U, D, U, D, U, B ,U ,D ,a,c,D
time = 1
[Command]
name = "AI27"
command = U, F, U, D, B, D, U ,D,U,D,U,b,a,F
time = 1
[Command]
name = "AI28"
command = U, F, U, D, B, D, U ,D,U,D,U,b,a,a,a
time = 1
[Command]
name = "AI29"
command = U, F, U, D, U, D, U ,U ,U ,D ,z,b,U,a,b
time = 1
[Command]
name = "AI30"
command = U, F, U, D, U, D, U, B ,U ,D ,a,c,D,a,c
time = 1
[Command]
name = "AI31"
command = U, F, U, D, B, D, U ,D,U,D,U,b,a,F,a,c
time = 1



;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.
;
[Command]
name = "Kamehameha"
command = ~D, y
time = 10

[Command]
name = "celljunior"
command = ~D, z
time = 10

[Command]
name = "QCB_xy"
command = ~B, y
time = 10

;-| Special Motions |------------------------------------------------------
[Command]
name = "upper_x"
command = ~F, D, DF, x
time = 1

[Command]
name = "upper_y"
command = ~F, D, DF, y
time = 1

[Command]
name = "upper_xy"
command = ~F, D, DF, x+y
time = 1

[Command]
name = "QCF_x"
command = ~D, DF, F, x
time = 1

[Command]
name = "QCF_y"
command = ~D, DF, F, y
time = 1

[Command]
name = "QCF_xy"
command = ~D, DF, F, x+y
time = 1

[Command]
name = "hadouken"
command = ~F, x
time = 10

[Command]
name = "QCB_y"
command = ~F, y
time = 10

[Command]
name = "FF_ab"
command = F, F, a+b
time = 1

[Command]
name = "FF_a"
command = F, F, a
time = 1

[Command]
name = "FF_b"
command = F, F, b
time = 1

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "hold_a"
command = /$a
time = 1

[Command]
name = "hold_b"
command = /$b
time = 1

[Command]
name = "hold_c"
command = /$c
time = 1

[Command]
name = "hold_x"
command = /$x
time = 1

[Command]
name = "hold_y"
command = /$y
time = 1

[Command]
name = "hold_z"
command = /$z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

[Command]
name = "holddownfwd";Required (do not remove)
command = /$DF
time = 1

[Command]
name = "longjump"
command = ~D, $U
time = 11

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]
[State -1,2]
type = Varset
triggerall = var(51) != 1
trigger1 = command = "AI1"
trigger2 = command = "AI2"
trigger3 = command = "AI3"
trigger4 = command = "AI4"
trigger5 = command = "AI5"
trigger6 = command = "AI6"
trigger7 = command = "AI7"
trigger8 = command = "AI8"
trigger9 = command = "AI9"
trigger10 = command = "AI10"
trigger11 = command = "AI11"
trigger12 = command = "AI12"
trigger13 = command = "AI13"
trigger14 = command = "AI14"
trigger15 = command = "AI15"
trigger16 = command = "AI16"
trigger17 = command = "AI17"
trigger18 = command = "AI18"
trigger19 = command = "AI19"
trigger20 = command = "AI20"
trigger21 = command = "AI21"
trigger22 = command = "AI22"
trigger23 = command = "AI23"
trigger24 = command = "AI24"
trigger25 = command = "AI25"
trigger26 = command = "AI26"
trigger27 = command = "AI27"
trigger28 = command = "AI28"
trigger29 = command = "AI29"
trigger30 = command = "AI30"
trigger31 = command = "AI31"
v = 51
value = 1

[state -1, AI]
type = ChangeState
value = Ifelse(EnemyNear,StateType = C,131,130)
triggerall = Var(51) = 1
triggerall = Random <= ifelse (StateType = A, 100, 500) && Ctrl
trigger1 = StateType != A && (Enemy, HitDefAttr = SCA, AA, SA ,HA ,AP, SP, HP)
trigger1 = MoveType = I && ((EnemyNear, MoveType = A  && P2BodyDist X <= 50) || (Enemy, NumProj >= 1)) && Ctrl

[State -1 , AI]
type = ChangeState
triggerall = var(51) = 1
triggerall = p2statetype != A
triggerall = var(10) = 0
triggerall = power >= 2000
triggerall = P2Life > 0
trigger1 = stateno = 250
trigger1 = movehit
trigger1 = time >= 10
trigger2 = stateno = 450
trigger2 = movehit
value = 3100

[State -1 , AI]
type = ChangeState
triggerall = var(51) = 1
triggerall = StateType != A
triggerall = p2movetype = A
triggerall = p2statetype != A
triggerall = var(10) = 0
triggerall = power >= 1567
triggerall = life > 500
triggerall = random <= 333
triggerall = P2Life > 0
triggerall = ctrl = 1
trigger1 = stateno != 191
trigger1 = p2bodydist X > 180
value = 2300

[State -1 , AI]
type = ChangeState
triggerall = var(51) = 1
triggerall = StateType != A
triggerall = p2movetype != A
triggerall = var(10) != 0
triggerall = random <= 333
triggerall = P2Life > 0
triggerall = ctrl = 1
triggerall = stateno != 191
triggerall = power >= 2000
trigger1 = p2bodydist X = [120,165]
trigger2 = p2bodydist X > 210
value = 2000

[State -1 , AI]
type = ChangeState
triggerall = var(51) = 1
triggerall = StateType != A
triggerall = random <= 333
triggerall = P2Life > 0
triggerall = ctrl = 1
triggerall = stateno != 191
trigger1 = p2statetype = L
trigger1 = p2bodydist X > 1
trigger2 = p2movetype != A
trigger2 = p2bodydist X > 100
trigger2 = power < 1000
trigger2 = life > 300
trigger3 = p2movetype != A
trigger3 = p2bodydist X > 175
trigger3 = power < 1500
trigger3 = life > 500
value = 1900

[State -1 , AI]
type = ChangeState
triggerall = var(51) = 1
triggerall = StateType != A
triggerall = random <= 333
triggerall = P2Life > 0
triggerall = ctrl = 1
triggerall = stateno != 191
trigger1 = p2bodydist X < 20
trigger1 = p2statetype = L
trigger2 = p2bodydist X = [43,54]
trigger2 = p2movetype = A
value = 105

[State -1 , AI]
type = ChangeState
triggerall = var(51) = 1
triggerall = StateType != A
triggerall = random <= 333
triggerall = p2movetype = A
triggerall = P2Life > 0
triggerall = ctrl = 1
trigger1 = stateno = 1900
value = 1901

[State -1 , AI]
type = ChangeState
triggerall = var(51) = 1
triggerall = StateType != A
triggerall = power >= 1234
triggerall = random <= (life+power)/2
triggerall = numproj = 0 || numproj = 1 && var(10) != 0
triggerall = P2Life > 0
triggerall = ctrl = 1
triggerall = stateno != 191
trigger1 = p2bodydist X = [111,123]
trigger2 = p2bodydist X = [134,156]
trigger3 = p2bodydist X = [167,189]
value = 1200

[State -1 , AI]
type = ChangeState
triggerall = var(51) = 1
triggerall = StateType != A
triggerall = p2movetype != H
triggerall = p2statetype = S
triggerall = random <= 333
triggerall = P2Life > 0
triggerall = ctrl = 1
triggerall = power >= 120
trigger1 = stateno != 191
trigger1 = p2bodydist X <= 10
value = 1210

[State -1 , AI]
type = ChangeState
triggerall = var(51) = 1
triggerall = StateType != A
triggerall = random <= 333
triggerall = P2Life > 0
triggerall = ctrl = 1
trigger1 = p2statetype = A
trigger1 = p2movetype != H
trigger1 = stateno != 191
trigger1 = p2bodydist X > 1
value = 40

[State -1 , AI]
type = ChangeState
triggerall = var(51) = 1
triggerall = StateType != A
triggerall = P2Life > 0
trigger1 = stateno = 252
trigger1 = movehit
value = 40

[State -1 , AI]
type = ChangeState
triggerall = var(51) = 1
triggerall = StateType != A
triggerall = p2movetype != A
triggerall = p2statetype = S
triggerall = random <= 333
triggerall = P2Life > 0
triggerall = ctrl = 1
trigger1 = stateno != 191
trigger1 = p2bodydist X = [25,55]
value = 200

[State -1 , AI]
type = ChangeState
triggerall = var(51) = 1
triggerall = StateType != A
triggerall = p2movetype != H
triggerall = p2statetype != A
triggerall = random <= 333
triggerall = P2Life > 0
triggerall = ctrl = 1
trigger1 = stateno != 191
trigger1 = p2bodydist X <= 40
value = 410

[State -1 , AI]
type = ChangeState
triggerall = var(51) = 1
triggerall = StateType != A
triggerall = p2statetype != A
triggerall = random <= 333
triggerall = P2Life > 0
triggerall = ctrl = 1
trigger1 = stateno != 191
trigger1 = p2bodydist X = [35,60]
value = 400


[State -1 , AI]
type = ChangeState
triggerall = var(51) = 1
triggerall = StateType != A
triggerall = p2moveType != A
triggerall = random <= 333
triggerall = P2Life > 0
triggerall = ctrl = 1
triggerall = stateno != 191
trigger1 = p2bodydist X = [101,150]
trigger2 = p2bodydist X > 190
value = 100


;===========================================================================
;---------------------------------------------------------------------------
; X[p[S[XgJ~J[A^bN
[State -1,]
type = ChangeState
value = 3100
triggerall = var(59) <= 0
triggerall = command = "celljunior"
triggerall = power >= 2000
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = stateno = 52 || stateno = 101
trigger2 = animelem = 1, >= 1
trigger3 = stateno = 200 && MoveContact
trigger4 = stateno = 211 && MoveContact
trigger5 = stateno = 271 && movecontact
trigger6 = stateno = 250 && movecontact
trigger7 = stateno = 210 && movecontact
trigger8 = stateno = 220 && movecontact
trigger9 = stateno = 260 && movecontact && AnimElem = 9, >= 1 && AnimElem = 10, <= 1
trigger10 = stateno = 270 && movecontact
trigger11 = (stateno = 400 || stateno = 450) && (movecontact)
trigger12 = stateno = 410 && movecontact && AnimElem = 4, >= 1 && AnimElem = 6, <= 1

;---------------------------------------------------------------------------
;Sɓ{r[
[State -1, Triple Kung Fu Palm]
type = ChangeState
value = 2300
triggerall = command = "Kamehameha"
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [3000,3050)
trigger2 = movecontact

;---------------------------------------------------------------------------
;Sɓ{r[()
[State -1,]
type = ChangeState
value = 2350
triggerall = command = "Kamehameha"
triggerall = power >= 1000
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 && movecontact
trigger3 = stateno = 610 && movecontact
trigger4 = stateno = 620 && movecontact
trigger5 = stateno = 630 && movecontact
trigger6 = stateno = 635 && movecontact
trigger7 = stateno = 640 && movecontact
trigger8 = stateno = 650 && movecontact

;---------------------------------------------------------------------------
; X[p[KEZtR[X
[State -1, Fast Kung Fu Blow]
type = ChangeState
value = 2000
triggerall = command = "QCB_xy"
triggerall = power >= 2000
trigger1 = var(1) ;Use combo condition (above)

;===========================================================================
;This is not a move, but it sets up var(1) to be 1 if conditions are right
;for a combo into a special move (used below).
;Since a lot of special moves rely on the same conditions, this reduces
;redundant logic.
[State -1, Combo condition Reset]
type = VarSet
trigger1 = 1
var(1) = 0

[State -1, Combo condition Check]
type = VarSet
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = [200,299]) || (stateno = [400,499])
trigger2 = stateno != 440 ;Except for sweep kick
trigger2 = movecontact
var(1) = 1



;---------------------------------------------------------------------------
; C͗
[State -1]
type = ChangeState
value = 1900
triggerall = statetype = S
triggerall = Power < 3000
triggerall = ctrl = 1
trigger1 = command = "hold_b" && command = "hold_y"
trigger2 = command = "hold_c"

;---------------------------------------------------------------------------
; ߂͂ߔgij
[State -1]
type = ChangeState
value = 1200
triggerall = command = "hadouken"
triggerall = power >= 100
triggerall = numproj = 0 || numproj = 1 && var(10) != 0
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = stateno = 52 || stateno = 100
trigger2 = animelem = 1, >= 1
trigger3 = stateno = 200 && movecontact = 1
trigger4 = stateno = 201 && movecontact = 1
trigger5 = stateno = 202 && movecontact = 1
trigger6 = stateno = 203 && movecontact = 1
trigger7 = stateno = 204 && movecontact = 1
trigger8 = stateno = 251 && movecontact = 1
trigger9 = stateno = 253 && movecontact = 1
trigger10 = stateno = 250 && movecontact = 1
trigger11 = stateno = 252 && movecontact = 1
trigger12 = stateno = 400 && movecontact = 1
trigger13 = stateno = 410 && movecontact = 1
trigger14 = stateno = 420 && movecontact = 1
trigger15 = stateno = 450 && movecontact = 1
trigger16 = stateno = 500 && movecontact = 1

;---------------------------------------------------------------------------
; 󒆂߂͂ߔgij
[State -1,]
type = ChangeState
value = 1400
triggerall = command = "hadouken"
triggerall = power >= 100
triggerall = numproj = 0 || numproj = 1 && var(10) != 0
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 && movecontact
trigger3 = stateno = 610 && movecontact
trigger4 = stateno = 620 && movecontact
trigger5 = stateno = 630 && movecontact
trigger6 = stateno = 635 && movecontact
trigger7 = stateno = 640 && movecontact
trigger8 = stateno = 650 && movecontact

;---------------------------------------------------------------------------
;MNeBJh[ic
[State -1, Strong Kung Fu Blow]
type = ChangeState
value = 1210
triggerall = command = "QCB_y"
triggerall = power >= 120
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
; ړ ()
[State -1]
type = ChangeState
value = 360
triggerall = var(22) = 0
triggerall = command = "recovery" ^^ command = "z"
triggerall = command = "holdback"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 100
trigger3 = stateno = 101
trigger4 = stateno = 102

;---------------------------------------------------------------------------
; ړ (O)
[State -1]
type = ChangeState
value = 361
triggerall = var(22) = 0
triggerall = command = "recovery" ^^ command = "z"
trigger1 = statetype = S
trigger1 = ctrl

;===========================================================================
;---------------------------------------------------------------------------
;Run Fwd
;_bV
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Run Back
;ރ_bV
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;󒆃_bV
[State -1, Run Fwd]
type = ChangeState
value = 110
triggerall = var(22) = 0
trigger1 = command = "FF"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
; 󒆃obN_bV
[State -1, Run Back]
type = ChangeState
value = 112
triggerall = var(22) = 0
triggerall = vel x <= 0;-1 
trigger1 = command = "BB"
trigger1 = statetype = A
trigger1 = ctrl


;===========================================================================
;---------------------------------------------------------------------------
;Stand Light Punch
;p`
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time > 6

;---------------------------------------------------------------------------
;Stand Strong Punch
;p`
[State -1, Stand Strong Punch]
type = ChangeState
value = 210
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6

;---------------------------------------------------------------------------
;Stand Light Kick
;LbN
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 7
trigger3 = (stateno = 230) && time > 9

;---------------------------------------------------------------------------
;Standing Strong Kick
;LbN
[State -1, Standing Strong Kick]
type = ChangeState
value = 240
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6

;---------------------------------------------------------------------------
;Taunt
;
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Light Punch
;Ⴊݎp`
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Strong Punch
;Ⴊ݋p`
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Crouching Light Kick
;ႪݎLbN
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Crouching Strong Kick
;Ⴊ݋LbN
[State -1, Crouching Strong Kick]
type = ChangeState
value = 440
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Jump Light Punch
;󒆎p`
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = statetime >= 7
trigger3 = stateno = 1350 ;Air blocking

;---------------------------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact
trigger3 = stateno = 1350 ;Air blocking

;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 1350 ;Air blocking

;---------------------------------------------------------------------------
;Jump Strong Kick
;󒆋LbN
[State -1, Jump Strong Kick]
type = ChangeState
value = 640
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact
trigger3 = stateno = 1350 ;Air blocking
