; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below. 
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10

[Command]
name = "AI_01"
Command = a, a, a, a, a, a
time = 0

[Command]
name = "AI_02"
Command = b, b, b, b, b, b
time = 0

[Command]
name = "AI_03"
Command = c, c, c, c, c, c
time = 0

[Command]
name = "AI_04"
Command = x, x, x, x, x, x
time = 0

[Command]
name = "AI_05"
Command = y, y, y, y, y, y
time = 0

[Command]
name = "AI_06"
Command = z, z, z, z, z, z
time = 0

[Command]
name = "AI_07"
Command = a, a, a, a, a, a, b
time = 0

[Command]
name = "AI_08"
Command = a, a, a, a, a, a, c
time = 0

[Command]
name = "AI_09"
Command = a, a, a, a, a, a, x
time = 0

[Command]
name = "AI_10"
Command = a, a, a, a, a, a, y
time = 0

[Command]
name = "AI_11"
Command = a, a, a, a, a, a, z
time = 0

[Command]
name = "AI_12"
Command = b, b, b, b, b, b, a
time = 0

[Command]
name = "AI_13"
Command = b, b, b, b, b, b, c
time = 0

[Command]
name = "AI_14"
Command = b, b, b, b, b, b, x
time = 0

[Command]
name = "AI_15"
Command = b, b, b, b, b, b, y
time = 0

[Command]
name = "AI_16"
Command = b, b, b, b, b, b, z
time = 0

[Command]
name = "AI_17"
Command = c, c, c, c, c, c, a
time = 0

[Command]
name = "AI_18"
Command = c, c, c, c, c, c, b
time = 0

[Command]
name = "AI_19"
Command = c, c, c, c, c, c, x
time = 0

[Command]
name = "AI_20"
Command = c, c, c, c, c, c, y
time = 0

[Command]
name = "AI_21"
Command = c, c, c, c, c, c, z
time = 0

[Command]
name = "AI_22"
Command = x, x, x, x, x, x, a
time = 0

[Command]
name = "AI_23"
command = x, x, x, x, x, x, b
time = 0

[Command]
name = "AI_24"
command = x, x, x, x, x, x, c
time = 0

[Command]
name = "AI_25"
command = x, x, x, x, x, x, y
time = 0

[Command]
name = "AI_26"
command = x, x, x, x, x, x, z
time = 0

[Command]
name = "AI_27"
command = y, y, y, y, y, y, a
time = 0

[Command]
name = "AI_28"
command = y, y, y, y, y, y, b
time = 0

[Command]
name = "AI_29"
command = y, y, y, y, y, y, c
time = 0

[Command]
name = "AI_30"
command = y, y, y, y, y, y, x
time = 0

[Command]
name = "AI_31"
command = y, y, y, y, y, y, z
time = 0

[Command]
name = "AI_32"
command = z, z, z, z, z, z, a
time = 0

[Command]
name = "AI_33"
command = z, z, z, z, z, z, b
time = 0

[Command]
name = "AI_34"
command = z, z, z, z, z, z, c
time = 0

[Command]
name = "AI_35"
command = z, z, z, z, z, z, x
time = 0

[Command]
name = "AI_36"
command = z, z, z, z, z, z, y
time = 0

[Command]
name = "AI_37"
command = F, F, F, F, F, F
time = 0

[Command]
name = "AI_38"
command = B, B, B, B, B, B
time = 0

[Command]
name = "AI_39"
command = U, U, U, U, U, U
time = 0

[Command]
name = "AI_40"
command = D, D, D, D, D, D
time = 0

[Command]
name = "AI_41"
command = F, F, F, F, F, F, B
time = 0

[Command]
name = "AI_42"
command = F, F, F, F, F, F, U
time = 0

[Command]
name = "AI_43"
command = F, F, F, F, F, F, D
time = 0

[Command]
name = "AI_44"
command = B, B, B, B, B, B, F
time = 0

[Command]
name = "AI_45"
command = B, B, B, B, B, B, U
time = 0

[Command]
name = "AI_46"
command = B, B, B, B, B, B, D
time = 0

[Command]
name = "AI_47"
command = U, U, U, U, U, U, F
time = 0

[Command]
name = "AI_48"
command = U, U, U, U, U, U, B
time = 0

[Command]
name = "AI_49"
command = U, U, U, U, U, U, D
time = 0

[Command]
name = "AI_50"
command = D, D, D, D, D, D, F
time = 0

;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 30

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1


;-| Super Motions |--------------------------------------------------------


;Cyber Ex Rushing Strike
[Command]
name = "Rushing Strike"
command = ~D, DF, F, D, DF, F, y



;-| Special Motions |------------------------------------------------------



;Violence Wind
[Command]
name = "QCF_x"
command = ~B, DB, D, DF, F, x


;Risky Nail
[Command]
name = "QCB_x"
command = ~F, D, DF, x

;Satellite Force
[Command]
name = "QCF_y"
command = ~D, DB, B, x


;Violent Jet
[Command]
name = "QCB_y"
command = ~B, DB, D, DF, F, y

;Satellite Force Long
[Command]
name = "QCF_z"
command = ~D, DB, B, y


;
[Command]
name = "QCB_z"
command = ~D, DB, B, z


;
[Command]
name = "QCF_a"
command = ~D, DF, F, a




; Dash Drill, 300
[Command]
name = "FFx"
command = F, F, x

;Dash Punch, 310
[Command]
name = "FFy"
command = F, F, y


[Command]
name = "Oiuchi"
command = $U,a


[Command]
name = "Giga Crush"
command = x+y


;[Command]
;name = "Recharge Power"
;command = y+z


[Command]
name = "Special Reversal"
command = /B,c


;[Command]
;name = "Super Jump"
;command = D,$U



;----|Throw Motions|---------------------------------------


;Grab to Punch
[Command]
name = "Stand Throw"  ;while standing
command = ~B,x

;Grab to Punch
[Command]
name = "Stand Throw"  ;while standing
command = ~F,x

;Toss
[Command]
name = "Toss"
command = ~F,y

;Toss
[Command]
name = "Toss"
command = ~B,y


;Fatality Dunk
[Command]
name = "Fatality Dunk"
command = ~D,D,y




;----|Basic Motions|---------------------------------------


;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1


;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

;---|Hold Buttons|------------------------

[Command]
name = "holdx"
command = /x
time = 1


[Command]
name = "holdy"
command = /y
time = 1

[Command]
name = "holdz"
command = /z
time = 1

[Command]
name = "holda"
command = /a
time = 1

[Command]
name = "holdb"
command = /b
time = 1

[Command]
name = "holdc"
command = /c
time = 1

[Command]
name = "holds"
command = /s
time = 1

;---|Relase Buttons|------------------------


;---|Press then Release no other key in between|------------------


;--------------

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]


;===========================================================================
;This is not a move, but it sets up var(3) to be 1 if conditions are right
;for a combo into a special move (used below).
;Since a lot of special moves rely on the same conditions, this reduces
;redundant logic.
[State -1, Combo condition Reset]
type = VarSet
trigger1 = 1
var(17) = 0

[State -1, Move Cancel condition Reset]
type = VarSet
trigger1 = 1
var(51) = 0


[State -1, Move Miss Reset]
type = VarSet
trigger1 = 1
var(9) = 0


;---------------------------------------------------------------------------

[State -1,Rushing Strike]
type = ChangeState
value = 3000
triggerall = var(59) = 0
triggerall = command = "Rushing Strike"
triggerall = power >= 1000
triggerall = statetype != A
trigger1 = ctrl
trigger2 = var(51)
trigger3 = stateno = 200 && time >= 8 || stateno = 210 && time >= 7 || stateno = 300 && time >= 8
trigger4 = stateno = 310 && time >= 10
trigger5 = stateno = 140 || stateno = 141 ||  stateno = 150 || stateno = 151 
trigger6 = stateno = 100 || stateno = 105

;---------------------------------------------------------------------------
[State -1, Punch 1]
type = ChangeState
value = 1000
triggerall = var(59) = 0
triggerall = var(57) != 4
trigger1 = command = "x"
trigger1 = Stateno = 200
trigger1 = MoveContact
;trigger1 = Time >= 10

;------------------------------------------------------------------------------
[State -1, Punch 2]
type = ChangeState
value = 1001
triggerall = var(59) = 0
triggerall = var(57) != 4
trigger1 = command = "y"
trigger1 = Stateno = 1000
trigger1 = MoveContact
trigger2 = command = "y"
trigger2 = Stateno = 200
trigger2 = MoveContact
;trigger1 = Time >= 8




;---------------------------------------------------------------------------
[State -1, Giga Crush]
type = ChangeState
value = 1230
triggerall = var(59) = 0
triggerall = command = "Giga Crush"
triggerall = power >= 1000
triggerall = statetype != A
trigger1 = ctrl
trigger2 = var(51) = 1

;---------------------------------------------------------------------------
[State -1, Violence Wind]
type = ChangeState
value = 1240
triggerall = var(59) = 0
triggerall = command = "QCF_x"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = var(51) = 1
trigger3 = stateno = 200 && time >= 8 || stateno = 210 && time >= 7 || stateno = 300 && time >= 8
trigger4 = stateno = 310 && time >= 10 || stateno = 400 && time >= 5 || stateno = 1001 && time >= 7

;---------------------------------------------------------------------------
[State -1, Risky Nail]
type = ChangeState
value = 1250
triggerall = var(59) = 0
triggerall = command = "QCB_x"
triggerall = statetype != A
triggerall = var(57) != 4
trigger1 = ctrl
trigger2 = var(51) = 1
trigger3 = stateno = 200 && time >= 8 || stateno = 210 && time >= 7 || stateno = 300 && time >= 8
trigger4 = stateno = 310 && time >= 10


;---------------------------------------------------------------------------
[State -1, Satellite Force]
type = ChangeState
value = 1260
triggerall = var(59) = 0
triggerall = command = "QCF_y"
triggerall = statetype != A
triggerall = var(57) != 4
trigger1 = ctrl
trigger2 = var(51) = 1
trigger3 = stateno = 200 && time >= 8 || stateno = 210 && time >= 7 || stateno = 300 && time >= 8
trigger4 = stateno = 310 && time >= 10


;---------------------------------------------------------------------------
[State -1, Satellite Force Long]
type = ChangeState
value = 1280
triggerall = var(59) = 0
triggerall = command = "QCF_z"
triggerall = statetype != A
triggerall = var(57) != 4
trigger1 = ctrl
trigger2 = var(51) = 1
trigger3 = stateno = 200 && time >= 8 || stateno = 210 && time >= 7 || stateno = 300 && time >= 8
trigger4 = stateno = 310 && time >= 10

;---------------------------------------------------------------------------
[State -1, Violent Jet]
type = ChangeState
value = 1270
triggerall = var(59) = 0
triggerall = command = "QCB_y"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = var(51) = 1
trigger3 = stateno = 200 && time >= 8 || stateno = 210 && time >= 7 || stateno = 300 && time >= 8
trigger4 = stateno = 310 && time >= 10


;---------------------------

[State -1, Fire Laser Cannon]
type = ChangeState
value = 2300
triggerall = var(59) = 0
trigger1 = command = "a"
trigger1 = ctrl
trigger1 = statetype = S
trigger1 = NumHelper(2300) = 0
trigger1 = fvar(23) = 0

[State -1, Fire Laser Cannon]
type = ChangeState
value = 2301
triggerall = var(59) = 0
trigger1 = command = "a"
trigger1 = ctrl
trigger1 = statetype = C
trigger1 = NumHelper(2300) = 0
trigger1 = fvar(23) = 0


[State -1, Fire Laser Cannon]
type = ChangeState
value = 2302
triggerall = var(59) = 0
trigger1 = command = "a"
trigger1 = ctrl
trigger1 = statetype = A
trigger1 = NumHelper(2300) = 0
trigger1 = fvar(23) = 0

;===========================================================================
;---------------------------------------------------------------------------


[State -1,Release b]
type = VarSet
trigger1 = command = "holdb"
triggerall = Stateno = 100 ||  Stateno = 105 || Stateno = 50 || Stateno = 54
var(55) = 0

[State -1,Release b]
type = VarSet
trigger1 = command != "holdb"
triggerall = Stateno != 100 ||  Stateno != 105 || Stateno != 50 || Stateno != 54
var(55) = 55

;u[Xg
[State -1, Run Fwd]
type = ChangeState
value = 100
triggerall = Var(59) = 0
triggerall = var(55) = 55
triggerall = Stateno != [100,151]
triggerall = statetype = S
triggerall = command != "holddown"
triggerall = command != "holdup"
triggerall = ctrl
trigger1 = command = "FF"
trigger2 = command != "holdback"
trigger2 = command = "holdb"

;---------------------------------------------------------------------------
;obNu[Xg
[State -1, Run Back]
type = ChangeState
value = 105
triggerall = Var(59) = 0
triggerall = var(55) = 55
triggerall = Stateno != 105
triggerall = statetype = S
triggerall = command != "holddown"
triggerall = command != "holdup"
triggerall = ctrl||(Stateno = 151 && time >= 8)
trigger1 = command = "BB"
trigger2 = command = "holdback"
trigger2 = command = "holdb"
trigger3 = command = "BB"|| command = "holdback" && command = "holdb"


;---------------------------------------------------------------------------

[State -1, Air Boost]
type = ChangeState
value = 54
triggerall = var(54) < 2
triggerall = Stateno = 54
triggerall = statetype = A
triggerall = ctrl
trigger1 = command = "b"

[State -1]
type = varadd
trigger1 = stateno = 54
trigger1 = Time = 1
var(54) = 1



;---------------------------------------------------------------------------

[State -1,Grab to Punch]
type = ChangeState
value = 800
triggerall = var(59) = 0
triggerall = command = "Stand Throw"
triggerall = ctrl
triggerall = p2stateno!=[150,155]
triggerall = P2BodyDist Y <= 0
triggerall = p2BodyDist X <=7
triggerall = var(57) != 4
trigger1 = stateno != 100
trigger1 = statetype = S
trigger1 = var(18) != 2
;---------------------------------------------------------------------------

[State -1, Toss]
type = ChangeState
value = 830
triggerall = var(59) = 0
triggerall = command = "Toss"
triggerall = ctrl
triggerall = p2stateno!=[150,155]
triggerall = P2BodyDist Y <= 0
triggerall = p2BodyDist X <=7
triggerall = var(57) != 4
trigger1 = stateno != 100
trigger1 = statetype = S
trigger1 = var(18) != 2

;---------------------------------------------------------------------------
[State -1, Fatality Dunk]
type = ChangeState
value = 860
triggerall = var(59) = 0
triggerall = command = "Fatality Dunk"
triggerall = ctrl
triggerall = p2stateno!=[150,155]
triggerall = P2BodyDist Y <= 0
triggerall = p2BodyDist X <=7
triggerall = var(57) != 4
trigger1 = stateno != 100
trigger1 = statetype = S
trigger1 = var(18) != 2



;---------------------------------------------------------------------------
[State -1]
type = ChangeState
value = 860
triggerall = var(59) = 0
triggerall = command = "Fatality Dunk"
triggerall = ctrl
triggerall = p2stateno!=[150,155]
triggerall = p2BodyDist X <= 15
triggerall = var(54) != 0
triggerall = var(57) != 4
trigger1 = stateno != 100
trigger1 = statetype = A
trigger1 = var(18) != 2


;===========================================================================
;---------------------------------------------------------------------------

[State -1, Standing Punch]
type = ChangeState
value = 200
triggerall = var(59) = 0
triggerall = command = "x"
triggerall = stateno != 100
triggerall = ctrl
triggerall = var(57) != 4
trigger1 = statetype = S

;---------------------------------------------------------------------------
[State -1, One Arm Attack]
type = null;ChangeState
value = 207
triggerall = var(59) = 0
triggerall = command = "x"
triggerall = stateno != 100
triggerall = var(57) = 4
triggerall = ctrl
trigger1 = statetype = S

;---------------------------------------------------------------------------
[State -1, Hard Punch]
type = ChangeState
value = 210
triggerall = var(59) = 0
triggerall = command = "y"
triggerall = command != "holdfwd"
triggerall = var(57) != 4
triggerall = stateno != 100
triggerall = ctrl
trigger1 = statetype = S

;---------------------------------------------------------------------------
[State -1,  Dash Drill]
type = ChangeState
value = 300
triggerall = var(59) = 0
triggerall = ctrl
triggerall = statetype = S
trigger1 = command = "FFx"
trigger2 = command = "x"
trigger2 = stateno = 100

;---------------------------------------------------------------------------
[State -1, Dash Punch]
type = ChangeState
value = 310
triggerall = var(59) = 0
triggerall = ctrl
triggerall = statetype = S
triggerall = var(57) != 4
trigger1 = command = "FFy"
trigger2 = command = "y"
trigger2 = stateno = 100
;---------------------------------------------------------------------------
[State -1, Taunt]
type = null;ChangeState
value = 195
triggerall = var(59) = 0
triggerall = command = "start"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------

[State -1, Crouch Punch]
type = ChangeState
value = 400
triggerall = var(59) = 0
triggerall = command = "x"
triggerall = ctrl
trigger1 = statetype = C

;---------------------------------------------------------------------------
[State -1, Crouch Slash]
type = ChangeState
value = 430
triggerall = var(59) = 0
triggerall = command = "y"
triggerall = ctrl
trigger1 = statetype = C


;---------------------------------------------------------------------------
[State -1, Air Kick]
type = ChangeState
value = 630
triggerall = var(59) = 0
triggerall = command = "x"
triggerall = ctrl
trigger1 = statetype = A


;---------------------------------------------------------------------------
[State -1, Drill Spin]
type = ChangeState
value = 640
triggerall = var(59) = 0
triggerall = command = "y"
triggerall = command != "holddown"
triggerall = ctrl
trigger1 = statetype = A


;---------------------------------------------------------------------------
[State -1, Drill Knee]
type = ChangeState
value = 650
triggerall = var(59) = 0
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = ctrl
trigger1 = statetype = A



;---------------------------------------------------------------------------
[State -1, Slide foward]
type = ChangeState
value = 700
triggerall = var(59) = 0
triggerall = stateno = 5120
trigger1 = command = "holdfwd"
trigger1 = Time = 1

;---------------------------------------------------------------------------
[State -1, Slide Backward]
type = ChangeState
value = 701
triggerall = var(59) = 0
triggerall = stateno = 5120
trigger1 = command = "holdback"
trigger1 = Time = 1


;---------------------------------------------------------------------------
[State -1, Oiuchi]
type = null;ChangeState
value = 704
triggerall = var(59) = 0
triggerall = p2stateno = 5110
triggerall = command = "Oiuchi"
trigger1 = ctrl 
trigger1 = StateType = S





;---------------------------------------------------------------------------
[State -1, Recharge Power]
type = ChangeState
value = 1220
triggerall = var(59) = 0
triggerall = command = "holdx"
triggerall = command = "holdy"
triggerall = power < 1000
trigger1 = ctrl 
trigger1 = stateno != 1220
trigger1 = StateType = S
trigger2 = stateno = 200 && time >= 8 || stateno = 210 && time >= 7
trigger3 = stateno = 300 && time >= 12|| stateno = 310 && time >= 12
trigger4 = stateno = 1000 && time >= 7
