; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
;


;Combo's
;-------------
;x,x,b
;x,x,z
;x,a,y,b
;-------------
;Air Combo's
;x,x,b
;a,a,c

;var(9)

;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.
;

[Command]
name = "laser"
command = ~D, DB, B, z
time = 20

;-| Special Motions |------------------------------------------------------

[Command]
name = "Devitalization_a"
command = ~F,DF, D, DB,B,a
time = 20

[Command]
name = "Devitalization_b"
command = ~F,DF, D, DB,B,b
time = 20

[Command]
name = "Devitalization_c"
command = ~F,DF, D, DB,B,c
time = 20

[Command]
name = "rebagatya"
command = ~F,B,F,B,F
time = 35

[Command]
name = "QCF_a"
command = ~D, DF, F, a
time = 15

[Command]
name = "QCF_b"
command = ~D, DF, F, b
time = 15

[Command]
name = "QCF_c"
command = ~D, DF, F, c
time = 15

[Command]
name = "QCF_x"
command = ~D, DF, F, x
time = 15

[Command]
name = "QCF_y"
command = ~D, DF, F, y
time = 15

[Command]
name = "QCF_z"
command = ~D, DF, F, z
time = 15

[Command]
name = "QCF_xy"
command = ~D, DF, F, x+y


[Command]
name = "QCF_2k"
command = ~D, DF, F, a+b

[Command]
name = "QCF_2k"
command = ~D, DF, F, a+c

[Command]
name = "QCF_2k"
command = ~D, DF, F, b+c

[Command]
name = "QCF_2p"
command = ~D, DF, F, x+y

[Command]
name = "QCF_2p"
command = ~D, DF, F, x+z

[Command]
name = "QCF_2p"
command = ~D, DF, F, y+z


[Command]
name = "QCB_2p"
command = ~D, DB, B, x+y




[Command]
name = "qcb_2k"
command = ~D, DB, B, a+b

[Command]
name = "qcb_2k"
command = ~D, DB, B, a+c

[Command]
name = "qcb_2k"
command = ~D, DB, B, b+c

[Command]
name = "FF_ab"
command = F, F, a+b

[Command]
name = "FF_a"
command = F, F, a

[Command]
name = "FF_b"
command = F, F, b

[Command]
name = "F+c"
command = /$DF,c


;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10



;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1


;-| Dir + Button |---------------------------------------------------------
[Command]
name = "FWD_y"
command = /$F,y
time = 1

[Command]
name = "FWD_b"
command = /$F,b
time = 1

[Command]
name = "FWD_z"
command = /$F,z
time = 1

[Command]
name = "FWD_c"
command = /$F,c
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1


[Command]
name = "counter"
command = ~B, DB, D, y

[Command]
name = "counter"
command = ~B, DB, D, z

[Command]
name = "counter"
command = ~B, DB, D, b

[Command]
name = "counter"
command = ~B, DB, D, c




;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

[Command]
name = "airfollow"
command = U

[Command]
name = "airfollow"
command = UF

[Command]
name = "airfollow" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "DU"
command = D, U
time = 15

[Command]
name = "DU"
command = D, UB
time = 15

[Command]
name = "DU"
command = D, UF
time = 15

[command]
name="fwd"
command=F
time=1
[command]
name="back"
command=B
time=1
[command]
name="up"
command=U
time=1
[command]
name="down"
command=D
time=1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

[Command]
name = "holdup+z" ;Required (do not remove)
command = /$U+z
time = 1



[Command]
name = "holda";Required (do not remove)
command = /$a
time = 1

[Command]
name = "holdb";Required (do not remove)
command = /$b
time = 1

[Command]
name = "holdc" ;Required (do not remove)
command = /$c
time = 1

[Command]
name = "holdx";Required (do not remove)
command = /$x
time = 1

[Command]
name = "holdy" ;Required (do not remove)
command = /$y
time = 1

[Command]
name = "holdz" ;Required (do not remove)
command = /$z
time = 1

;---AI Command-----------------------------

[Command]
name = "CPU1"
command = D, D, U, U, D, U
time = 1

[Command]
name = "CPU2"
command = D, F, D, F, F, D, F
time = 1

[Command]
name = "CPU3"
command = B, D, F, B, B, D
time = 1

[Command]
name = "CPU4"
command = D, D, U, U, D, U, F, U
time = 1

[Command]
name = "CPU5"
command = D, F, D, F, F, D, F, U, U
time = 1

[Command]
name = "CPU6"
command = B, D, F, B, B, D, U
time = 1

[Command]
name = "CPU7"
command = B, F, B, F, F, D, F, U, U, U
time = 1

[Command]
name = "CPU8"
command = B, F, F, B, F, D, U, U
time = 1

[Command]
name = "CPU9"
command = D, F, D, F, F, D, F, U, U, F, U, U, B
time = 1

[Command]
name = "CPU10"
command = B, D, F, B, B, B, B
time = 1

[Command]
name = "CPU11"
command = D, F, D, F, F, D, F, U, U, B, B, U, F
time = 1

[Command]
name = "CPU12"
command = B, D, D, B, B, D, U, U, U, F
time = 1

[Command]
name = "CPU13"
command = D, F, D, F, F, D, F, U, B, B, B, U
time = 1

[Command]
name = "CPU14"
command = B, D, F, B, B, D, F, U, B, F, U
time = 1

[Command]
name = "CPU15"
command = D, U, D, F, F, D, B, U, B, U
time = 1

[Command]
name = "CPU16"
command = B, U, F, U, B, U, F, U, B, F, U
time = 1

[Command]
name = "AICombo"
command = F, D, D, D, B, B
time = 1

[Command]
name = "AICombo2"
command = F, D, D, D, B, B, F
time = 1

[Command]
name = "AICombo3"
command = F, F, D, F, B, B
time = 1

[Command]
name = "AICombo4"
command = F, D, F, D, B, B, F, U
time = 1

[Command]
name = "AICombo5"
command = F, D, D, D, B, B, U, F, U, B
time = 1

[Command]
name = "AICombo6"
command = F, D, B, D, B, B, F, B
time = 1

[Command]
name = "AICombo7"
command = U, D, U, D, B, B, U, F, U, B
time = 1

[Command]
name = "AICombo8"
command = U, D, B, D, B, B, F, B
time = 1

[Command]
name = "AICombo9"
command = U, D, U, D, B, B, U, F, U, B, U
time = 1

[Command]
name = "AICombo10"
command = U, D, B, D, B, B, F, B, D, U, D, F
time = 1

[Command]
name = "Hyper1"
command = F, F, D, D, F, B
time = 1

[Command]
name = "Hyper2"
command = F, B, F, D, F, F, F, B
time = 1

[Command]
name = "Hyper3"
command = F, B, F, D, F, F, F, B, F, B
time = 1

[Command]
name = "Hyper4"
command = F, B, F, D, F, F, F, B
time = 1

[Command]
name = "Hyper5"
command = F, B, F, D, F, F, F, B, F, B, D, F, D
time = 1

[Command]
name = "Hyper6"
command = F, B, F, D, F, F, F, B, D, D
time = 1

[Command]
name = "Hyper7"
command = F, B, F, D, F, F, F, B, F, B, F
time = 1

[Command]
name = "Hyper8"
command = F, B, F, F, D, F, B, B, D, D, U
time = 1

[Command]
name = "Hyper9"
command = F, B, U, D, F, F, F, B, F, U, F, U
time = 1

[Command]
name = "Hyper10"
command = U, B, U, D, F, F, F, B, F, U, F, U
time = 1

[Command]
name = "Hyper11"
command = F, B, U, D, F, F, F, B, F, U, F, U, U, U
time = 1

[Command]
name = "Hyper12"
command = U, B, U, D, F, F, F, B, F, U, F, U, B
time = 1

[Command]
name = "AI22"
command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y
time = 0
[Command]
name = "AI23"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI24"
command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
time = 0
[Command]
name = "AI25"
command = F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F
time = 0
[Command]
name = "AI26"
command = D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D
time = 0
[Command]
name = "AI27"
command = B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B
time = 0
[Command]
name = "AI28"
command = U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U
time = 0
[Command]
name = "AI29"
command = a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a
time = 0
[Command]
name = "AI30"
command = c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c
time = 0
[Command]
name="a2"
command=a
time=1
[Command]
name="b2"
command=b
time=1
[Command]
name="c2"
command=c
time=1
[Command]
name="x2"
command=x
time=1
[Command]
name="y2"
command=y
time=1
[Command]
name="z2"
command=z
time=1
[Command]
name="start2"
command=s
time=1
[command]
name="fwd2"
command=F
time=1
[command]
name="back2"
command=B
time=1
[command]
name="up2"
command=U
time=1
[command]
name="down2"
command=D
time=1


;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
;---------------------------------------------------------------------------

;===========================================================================
;---------------------------------------------------------------------------



;---------蓮----------------------------------------------------


;----s--------------------------------------------------------

;Super Jump
[State -1, Super Jump]
type = ChangeState
value = 41
triggerall = !var(59)
triggerall = (Statetype != A) && (ctrl)
trigger1 = (command = "DU") && (var(20) = 0) 
;trigger2 = movehit > 10 &&  (command = "airfollow")
;trigger2 = stateno = 240 


;Dash Backward
[State -1, Dash Backward]
type = ChangeState
value = 3200
triggerall = !var(59)
triggerall = (Statetype != A) && (ctrl)
trigger1 = (command = "BB") 

;Dash Backward Air
[State -1, Dash Backward Air]
type = ChangeState
value = 652
triggerall = !var(59)
triggerall = (Statetype = A) && (ctrl)
TriggerAll= var(19)  = 0
trigger1 = (command = "BB") 

;Ground Counter
[State -1, GroundCounter]
type = ChangeState
value = 900
triggerall = !var(59)
triggerall = (command = "counter")
triggerall = stateno = 150 || stateno = 151
trigger1 = (Statetype != A) && (power >= 1000)

;Air Counter
[State -1, AirCounter]
type = ChangeState
value = 901
triggerall = !var(59)
triggerall = (command = "counter")
triggerall = stateno = 154
trigger1 = (Statetype = A) && (power >= 1000)


;Guard Push (Standing)-AhoVOK[h
[State -1, Guard Push]
type = ChangeState
value = 7000
triggerall = !var(59)
triggerall = command = "recovery"
triggerall = statetype = S
trigger1 = stateno = 150 || stateno = 151

;Guard Push (Crouching)-Ⴊ݃AhoVOK[h
[State -1,C- Guard Push]
type = ChangeState
value = 7005
triggerall = !var(59)
triggerall = command = "holddown"
triggerall = command = "recovery"
triggerall = statetype = C
trigger1 = stateno = 152 || stateno = 153

;Guard Push (Air)-󒆃AhoVOK[h
[State -1, Guard Push]
type = ChangeState
value = 7006
triggerall = !var(59)
triggerall = command = "recovery"
triggerall = statetype = A
trigger1 = stateno = 154 || stateno = 155

;Dash Forward
[State -1, Dash Forward]
type = ChangeState
value = 100
triggerall = !var(59)
triggerall = (Statetype != A) 
triggerall = (ctrl) 
triggerall = EnemyNear,Alive 
triggerall =  (stateno != 100) && (stateno != 101)
trigger1 = (command = "FF") 


;Air Dash Forward
[State -1, Dash Forward Air]
type = ChangeState
value = 651
triggerall = !var(59)
triggerall = (Statetype = A) && (ctrl)
TriggerAll= var(19)  = 0
trigger1 = (command = "FF") 



;----nCp[R{--------------------------------------------------------

[State -1, Chaos Demention Activate]
type = ChangeState
value = 4603
triggerall = !var(59)
triggerall = (Statetype = S) 
triggerall =  (power >= 3000) 
triggerall =  (ctrl) && var(25) = 0
trigger1 = (command = "QCF_2p") 

;---------------------------------------------------------

[State -1, Chaos Demension Grab Standing];Ȃ
type = ChangeState
value = 4600
triggerall = !var(59)
triggerall =  (command = "z") || (command = "c")  
triggerall =  (P2BodyDist X = [0, 75]) 
triggerall =  (command != "holddown")
triggerall = (var(25) = 1)
triggerall = movecontact
trigger1 = (stateno = 200) && time > 5
trigger2 = (stateno = 230) && time > 6
trigger3 = (stateno = 210) && time > 8
trigger4 = (stateno = 220) && animelemtime(7) > 0
trigger5 = (stateno = 250) && time > 8
trigger6 = (stateno = 400) || (stateno = 430) || (stateno = 410) || (stateno = 440)
trigger6 = ( time > 5)
trigger7 = (stateno = 420) || (stateno = 450)
trigger7 = ( time > 8)

;Chaos Demension Grab
[State -1, Chaos Demension Grab Standing]
type = ChangeState
value = 4600
triggerall = !var(59)
triggerall = (Statetype = S) 
triggerall =  (ctrl)  
triggerall =  (P2BodyDist X = [0, 75]) 
triggerall =  (command != "holddown")
triggerall = (var(25) = 1)
trigger1 = (command = "z") 
trigger2 = (command = "c") 

;---------------------------------------------------------
;Chaos Demension Grab
[State -1, Chaos Demension Grab Air];-Ȃ
type = ChangeState
value = 4602
triggerall = !var(59)
triggerall = (Statetype = A) 
triggerall =  (P2BodyDist X = [0, 75]) 
triggerall = (var(25) = 1) 
triggerall = (command = "FWD_z") || (command = "FWD_c")
triggerall = movecontact
trigger1 = (stateno = 600)
trigger2 = (stateno = 630)
trigger3 = (stateno = 610)
trigger4 = (stateno = 640)

[State -1, Chaos Demension Grab Air]
type = ChangeState
value = 4602
triggerall = !var(59)
triggerall = (Statetype = A) 
triggerall =  (ctrl)  
triggerall =  (P2BodyDist X = [0, 75]) 
triggerall = (var(25) = 1) 
trigger1 = (command = "FWD_z")
trigger2 = (command = "FWD_c")

;---------------------------------------------------------

;Chaos Demension Grab
[State -1, Chaos Demension Grab Crouch kick]
type = ChangeState
value = 4601
triggerall = !var(59)
triggerall =  (P2BodyDist X = [0, 80]) 
triggerall = (command = "holddown") && (var(25) = 1) 
triggerall = (command = "c")  || (command = "z") 
triggerall = movecontact
trigger1 = (stateno = 200) && time > 5
trigger2 = (stateno = 230) && time > 6
trigger3 = (stateno = 210) && time > 8
trigger4 = (stateno = 220) && animelemtime(7) > 0
trigger5 = (stateno = 250) && time > 8
trigger6 = (stateno = 400) || (stateno = 430) || (stateno = 410) || (stateno = 440)
trigger6 = ( time > 5)
trigger7 = (stateno = 420) || (stateno = 450)
trigger7 = ( time > 8)

;Chaos Demension Grab
[State -1, Chaos Demension Grab Crouch kick]
type = ChangeState
value = 4601
triggerall = !var(59)
triggerall = (Statetype = C) && (ctrl)  && (P2BodyDist X = [0, 80]) 
triggerall = (command = "holddown") && (var(25) = 1) 
trigger1 = (command = "c")  || (command = "z") 

;---------------------------------------------------------
[State -1, laser] ;r|-Ȃ
type = ChangeState
value = 9180
triggerall = !var(59)
triggerall =(power >= 2000)
triggerall = (command = "laser") 
triggerall = StateType = A
trigger1 = movecontact
trigger1 = stateno = 620 
trigger2 = prevstateno = 620 
trigger2 = stateno = 50 

[State -1, laser] ;r|
type = ChangeState
value = 9180
triggerall = !var(59)
triggerall = ctrl  && (power >= 2000)
trigger1 = StateType = A &&  (command = "laser") 
trigger2 = StateType = S &&  (command = "laser")

;---------------------------------------------------------

;Seperation Attack
[State -1, Mystic Smash Hyper] ;nCp[~XeBbNX}bV-Ȃ
type = ChangeState
value = 3000
triggerall = !var(59)
triggerall = statetype != A && (power >= 1000) 
triggerall = (command = "QCF_2k")
triggerall = movecontact
trigger1 = (stateno = 200) && time > 5
trigger2 = (stateno = 230) && time > 6
trigger3 = (stateno = 210) && time > 8
trigger4 = (stateno = 220) && animelemtime(7) > 0
trigger5 = (stateno = 250) && time > 8
trigger6 = (stateno = 400) || (stateno = 430) || (stateno = 410) || (stateno = 440)
trigger6 = ( time > 5)
trigger7 = (stateno = 420) || (stateno = 450)
trigger7 = ( time > 8)

[State -1, Mystic Smash Hyper]
type = ChangeState
value = 3000
triggerall = !var(59)
triggerall = statetype != A && (power >= 1000) 
triggerall = (command = "QCF_2k")
trigger1 = (ctrl)

;---------------------------------------------------------

;Clone Call
[State -1, Clone Call Hyper]
type = ChangeState
value = 3401
triggerall = !var(59)
triggerall = statetype != A && (ctrl)
trigger1 = (command = "qcb_2k") && (power >= 1000) 


;Hovering Clone Call
[State -1, Hovering Clone Call]
type = ChangeState
value = 3415
triggerall = !var(59)
triggerall = (power >= 1000) && Statetype = A
trigger1 = (command = "QCB_2p") && ctrl
trigger2 = (command = "QCB_2p") && stateno = 50

;----KEZ--------------------------------------------------------

;-------------------------------------------------------
;Devitalization,fBoC^[[V
[State -1, Devitalization];-Ȃ
type = ChangeState
value = 3600
triggerall = !var(59)
triggerall = (Statetype != A)
triggerall = (command =  "Devitalization_a") || (command = "Devitalization_b") || (command = "Devitalization_c")
triggerall = movecontact
trigger1 = (stateno = 200) && time > 5
trigger2 = (stateno = 230) && time > 6
trigger3 = (stateno = 400) || (stateno = 430)
trigger3 = ( time > 5)

[State -1, Devitalization]
type = ChangeState
value = 3600
triggerall = !var(59)
triggerall = (Statetype != A) && (ctrl)
trigger1 =  (command =  "Devitalization_a") || (command = "Devitalization_b") || (command = "Devitalization_c")

;---------------------------------------------------------
;Roll attack Ground
[State -1, Roll Attack Ground];-Ȃ
type = ChangeState
value = 1003
triggerall = !var(59)
triggerall = (Statetype != A)
triggerall = (command = "QCF_c") 
triggerall = movecontact
trigger1 = (stateno = 200) && time > 5
trigger2 = (stateno = 230) && time > 6
trigger3 = (stateno = 210) && time > 8
trigger4 = (stateno = 220) && animelemtime(7) > 0
trigger5 = (stateno = 250) && time > 8
trigger6 = (stateno = 400) || (stateno = 430) || (stateno = 410) || (stateno = 440)
trigger6 = ( time > 5)
trigger7 = (stateno = 420) || (stateno = 450)
trigger7 = ( time > 8)

;Roll attack Ground
[State -1, Roll Attack Ground]
type = ChangeState
value = 1003
triggerall = !var(59)
triggerall = (Statetype != A) && (ctrl)
trigger1 = (command = "QCF_c") 

;-------------------------------------------------------
;Roll attack air
[State -1, Roll Attack Air]
type = ChangeState
value = 1004
triggerall = !var(59)
triggerall = (Statetype = A) && (ctrl)
trigger1 = (command = "QCF_a")
trigger2 = (command = "QCF_b")
trigger3 = (command = "QCF_c")


;-------------------------------------------------------
;Roll attack arch
[State -1, Roll Attack Arch];-Ȃ
type = ChangeState
value = 1006
triggerall = !var(59)
triggerall = (Statetype != A)
triggerall = (command = "QCF_a") || (command = "QCF_b")
triggerall = movecontact
trigger1 = (stateno = 200) && time > 5
trigger2 = (stateno = 230) && time > 6
trigger3 = (stateno = 210) && time > 8
trigger4 = (stateno = 220) && animelemtime(7) > 0
trigger5 = (stateno = 250) && time > 8
trigger6 = (stateno = 400) || (stateno = 430) || (stateno = 410) || (stateno = 440)
trigger6 = ( time > 5)
trigger7 = (stateno = 420) || (stateno = 450)
trigger7 = ( time > 8)

[State -1, Roll Attack Arch]
type = ChangeState
value = 1006
triggerall = !var(59)
triggerall = (Statetype != A) && (ctrl)
trigger1 = (command = "QCF_a") || (command = "QCF_b")


;-------------------------------------------------------
;Eye Projectile
[State -1, Mystic Stare];-Ȃ
type = ChangeState
value = 1000
triggerall = !var(59)
triggerall = (Statetype != A)
triggerall = numhelper(9920) = 0 && numhelper(9923) = 0 && numhelper(9925) = 0
triggerall = NumHelper(1001) = 0
triggerall = movecontact
triggerall = (command = "QCF_x") || (command = "QCF_y") || (command = "QCF_z")
trigger1 = (stateno = 200) && time > 5
trigger2 = (stateno = 230) && time > 6
trigger3 = (stateno = 210) && time > 8
trigger4 = (stateno = 220) && animelemtime(7) > 0
trigger5 = (stateno = 250) && time > 8
trigger6 = (stateno = 400) || (stateno = 430) || (stateno = 410) || (stateno = 440)
trigger6 = ( time > 5)
trigger7 = (stateno = 420) || (stateno = 450)
trigger7 = ( time > 8)

[State -1, Mystic Stare]
type = ChangeState
value = 1000
triggerall = !var(59)
triggerall = (Statetype != A) && (ctrl)
triggerall = numhelper(9920) = 0 && numhelper(9923) = 0 && numhelper(9925) = 0
triggerall = NumHelper(1001) = 0
trigger1 = (command = "QCF_x") || (command = "QCF_y") || (command = "QCF_z")

;--------------------------------------------------------
;Eye Projectile-Air
[State -1, Mystic Stare]
type = ChangeState
value = 1010
triggerall = !var(59)
triggerall = (Statetype = A) && (ctrl)
triggerall = numhelper(9920) = 0 && numhelper(9923) = 0 && numhelper(9925) = 0
triggerall = numhelper(9911) = 0 && numhelper(9912) = 0 && numhelper(9913) = 0
triggerall = NumHelper(1001) = 0
trigger1 = (command = "QCF_x")
trigger2 = (command = "QCF_y")
trigger3 = (command = "QCF_z")

;-------------------------------------------------------
;Air Rock-Ȃ
[State -1, AirRock]
type = ChangeState
value = 1005
triggerall = !var(59)
triggerall = (statetype = A)
triggerall = (command = "down_c")  
triggerall = movecontact
trigger1 = stateno = 600 
trigger2 = stateno = 610 
trigger3 = stateno = 630 
trigger4 = stateno = 640 

[State -1, AirRock]
type = ChangeState
value = 1005
triggerall = !var(59)
triggerall = (statetype = A) && (ctrl)
trigger1 = (command = "down_c") 

;------------------------------------------------------------

;Energy Drain
[State -1, Energy Drain];-Ȃ
type = ChangeState
value = 4015
triggerall = !var(59)
triggerall = (statetype = A)
triggerall = (command = "FWD_b")  
triggerall = movehit
triggerall = (P2BodyDist X = [0, 40]) && (P2BodyDist y = [-40, 30])
triggerall = EnemyNear,StateNo != [150,155]
trigger1 = stateno = 600 
trigger2 = stateno = 610 
trigger3 = stateno = 630 
trigger4 = stateno = 640

[State -1, Energy Drain]
type = ChangeState
value = 4015
triggerall = !var(59)
triggerall = p2statetype != L  && (ctrl)
triggerall = (command = "FWD_b")  && command != "holddown"
triggerall = EnemyNear,StateNo != [150,155]
trigger1 =  (P2BodyDist X = [0, 20]) && (P2BodyDist y = [-20, 20])
trigger2 =  (P2BodyDist X = [0, 30]) && (P2BodyDist y = [-30, 30])
Trigger2 = var(30) >= 1

;------------------------------------------------------------
;Throw
[State -1, Throw]
type = ChangeState
value = 3002
triggerall = !var(59)
triggerall = (Statetype = S) && p2statetype != L && (ctrl) && command != "holddown"
triggerall = p2statetype !=  A
triggerall = EnemyNear,StateNo != [150,155]
trigger1 = (command = "FWD_y") && (P2BodyDist X = [0, 20])  


;------------------------------------------------------------
[State -1, Taunt];
type = ChangeState
value = 938
triggerall = !var(59)
trigger1 = command = "start"  && ctrl 
trigger1 = statetype != A





;----ʏZ------------------------------------------------------

;Standing Medium Kick
;LbNAႪ݂Ȃ
[State -1, Standing Medium Kick]
type = ChangeState
value = 240
triggerall = !var(59)
triggerall = (statetype != A)
triggerall = (statetype = C) 
triggerall = command = "F+c"
trigger1 = movecontact
trigger1= (stateno = 400) || (stateno = 430) || (stateno = 410) || (stateno = 440)
trigger1 = (time > 5)
trigger2 =  (ctrl);Po

;------------------------------------------------------------
;Crouching Light Punch
;Ⴊݎp`,Ȃ
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = !var(59)
triggerall = command = "x"   || command = "holdx"
triggerall = command = "holddown"
triggerall = (statetype = C)
triggerall = movecontact
trigger1 = (stateno = 430)
trigger1 = ( time > 4)

;Crouching Light Punch
;Ⴊݎp`
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = !var(59)
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = (statetype = C) && (ctrl) 


;------------------------------------------------------------
;Crouching Medium Punch
;Ⴊݒp`-Ȃp
[State -1, Crouching Medium Punch]
type = ChangeState
value = 410
triggerall = !var(59)
triggerall = command = "y" || command = "holdy"
triggerall = command = "holddown"
triggerall = (statetype = C)
triggerall = movecontact
trigger1 = (stateno = 400) || (stateno = 430)
trigger1 = (time > 5)

;Ⴊݒp`
[State -1, Crouching Medium Punch]
type = ChangeState
value = 410
triggerall = !var(59)
triggerall = command = "y" && (statetype = C)
triggerall = command = "holddown"
trigger1 = (statetype = C) && (ctrl) 

;------------------------------------------------------------
;Ⴊ݋p`,Ȃ
[State -1, Crouching Strong Punch]
type = ChangeState
value = 420
triggerall = !var(59)
triggerall = var(25) = 0
triggerall = command = "z"    || command = "holdz"
triggerall = command = "holddown" && (statetype = C)
triggerall = movecontact
trigger1 = (stateno = 400) || (stateno = 430) || (stateno = 410) || (stateno = 440)
trigger1 = ( time > 5)

;Ⴊ݋p`
[State -1, Crouching Strong Punch]
type = ChangeState
value = 420
triggerall = !var(59)
triggerall = var(25) = 0
triggerall = command = "z"
triggerall = command = "holddown" && (statetype = C)
trigger1 = (statetype = C) && (ctrl)


;------------------------------------------------------------
;Crouching Light Kick
;ႪݎLbN-Ȃp
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = !var(59)
triggerall = command = "a"  || command = "holda"
triggerall = command = "holddown"
triggerall = movecontact
trigger1 = (stateno = 400)
trigger1 = ( time > 4)

;ႪݎLbN
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = !var(59)
triggerall = command = "a"  && (statetype = C)
triggerall = command = "holddown" && stateno != 430
trigger1 =  (ctrl)
trigger2 = (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;------------------------------------------------------------
;Crouching Strong Kick
;ႪݒLbN
[State -1, Crouching medium Kick]
type = ChangeState
value = 440
triggerall = !var(59)
triggerall = command = "b"  || command = "holdb"
triggerall = command = "holddown" && (Statetype != A)
triggerall = movecontact
trigger1= (stateno = 400) || (stateno = 430)
trigger2 = stateno = 200 || stateno = 230 || stateno = 210

;Crouching Strong Kick
;ႪݒLbN
[State -1, Crouching medium Kick]
type = ChangeState
value = 440
triggerall = !var(59)
triggerall = command = "b"
triggerall = command = "holddown" && (statetype = C)
trigger1 = (ctrl) 

;------------------------------------------------------------
;Ⴊ݋LbN,Ȃ
[State -1, Crouching Strong Kick]
type = ChangeState
value = 450
triggerall = !var(59)
triggerall = var(25) = 0
triggerall = command = "c"  || command = "holdc"
triggerall = command = "holddown"  && (statetype = C)
triggerall = command != "holdfwd"
triggerall = movecontact
trigger1 = (stateno = 400) || (stateno = 430) || (stateno = 410) || (stateno = 440)
trigger1 = ( time > 5)


;Ⴊ݋LbN
[State -1, Crouching Strong Kick]
type = ChangeState
value = 450
triggerall = !var(59)
triggerall = var(25) = 0
triggerall = command = "c"
triggerall = command = "holddown"  && (statetype = C)
trigger1 = (statetype = C) && (ctrl)


;--------------------------------------------------------------

;Stand Light Punch
;p`
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = !var(59)
triggerall =  (statetype = S)
trigger1 = (statetype = S) && (ctrl) 
trigger1 = command = "x" && command != "holddown"
trigger2 = var(35) = 1
trigger2 = movecontact

;------------------------------------------------------------
;Stand Medium Punch
;p`-Ȃp
[State -1, Stand Medium Punch]
type = ChangeState
value = 210
triggerall = !var(59)
triggerall = command = "y"  || command = "holdy"
triggerall = (command != "holddown") && (statetype = S)
triggerall = movecontact
trigger1 = (stateno = 200) && time > 5
trigger2 = (stateno = 230) && time > 6
trigger3 = var(36) = 1

;p`
[State -1, Stand Medium Punch]
type = ChangeState
value = 210
triggerall = !var(59)
triggerall = command = "y" 
triggerall = (command != "holddown") && (statetype = S)
trigger1 =  (ctrl)

;------------------------------------------------------------
;Stand Strong Punch
;p`-Ȃp
[State -1, Stand Strong Punch]
type = ChangeState
value = 220
triggerall = !var(59)
triggerall = (command = "z")   || command = "holdz"
triggerall = (command != "holddown") && (statetype = S) 
triggerall = movecontact
trigger1 = (stateno = 200) && time > 5
trigger2 = (stateno = 230) && time > 6
trigger3 = (stateno = 210) && time > 8
trigger4 = var(37) = 1

;p`
[State -1, Stand Strong Punch]
type = ChangeState
value = 220
triggerall = !var(59)
triggerall = (command = "z") && (command != "holddown") && (statetype = S) 
trigger1 = (ctrl)

;------------------------------------------------------------
;LbN-Ȃp
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = !var(59)
triggerall = (command != "holddown") && (statetype = S)
triggerall = command = "a" || command = "holda"
triggerall = movecontact
trigger1 = (stateno = 200) && time > 5
trigger2 = (stateno = 230) && time > 9
trigger3 = var(45) = 1

;Stand Light Kick
;LbN
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = !var(59)
triggerall = (command != "holddown") && (statetype = S)
triggerall = command = "a"
trigger1 = (ctrl)



;------------------------------------------------------------


;Standing Medium Kick
;LbN
[State -1, Standing Medium Kick]
type = ChangeState
value = 240
triggerall = !var(59)
triggerall =  (statetype != A)
triggerall =  (statetype = S)
triggerall = command = "b"
trigger1 =  (ctrl)
trigger2 = (stateno = 200) && time > 5 
trigger2 = movecontact
trigger3 = (stateno = 230) && time > 6 
trigger3 = movecontact
trigger4 = (stateno = 210) && time > 6
trigger4 = movecontact
trigger5 = var(46) = 1
trigger5 = movecontact
trigger5 = command = "b" || command = "holdb"
trigger5 = (command != "holddown")

;------------------------------------------------------------
;Standing Strong Kick
;LbN-Ȃp
[State -1, Standing Strong Kick]
type = ChangeState
value = 250
triggerall = !var(59)
triggerall = command = "c" || command = "holdc"
triggerall = command != "holddown" && command != "holdfwd"&& (statetype = S)
triggerall = movecontact
trigger1 = (stateno = 200) && time > 5
trigger2 = (stateno = 230) && time > 6
trigger3 = (stateno = 210) && time > 8
trigger4 = var(47) = 1

;LbN
[State -1, Standing Strong Kick]
type = ChangeState
value = 250
triggerall = !var(59)
triggerall = command = "c"
triggerall = command != "holddown" && (statetype = S)
trigger1 = ctrl


;------------------------------------------------------------
;Jump Light Punch
;󒆎p`-Ȃ
[State -1, Jump Light Punch]
type = null;ChangeState
value = 600
triggerall = !var(59)
triggerall = (statetype = A)
triggerall =  (command = "x")  || command = "holdx"
triggerall = movecontact
trigger1 = var(35) = 1 || (stateno = 630)
trigger1 = stateno != 620 && stateno != 650

;󒆎p`
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = !var(59)
triggerall = (statetype = A) && (ctrl)
trigger1 =  (command = "x")

;------------------------------------------------------------
;Jump Medium Punch
;󒆒p`-Ȃ
[State -1, Jump Medium Punch]
type = ChangeState
value = 610
triggerall = !var(59)
triggerall = command = "y" || command = "holdy"
triggerall = statetype = A
triggerall = var(7) = 0
triggerall = movecontact
triggerall = time < 15
trigger1 = stateno = 600 || stateno = 630  || stateno = 640
trigger2 = var(36) = 1
trigger2 = stateno != 620 && stateno != 650

;󒆒p`-Ȃ2
[State -1, Jump Medium Punch]
type = ChangeState
value = 610
triggerall = !var(59)
triggerall = statetype = A
triggerall = var(7) = 0
triggerall = movecontact
triggerall = time < 15
trigger1 =  (command = "x")
trigger1 = stateno = 600 || stateno = 630 || stateno = 640
trigger1 =  stateno != 620 && stateno != 650

;󒆒p`
[State -1, Jump Medium Punch]
type = ChangeState
value = 610
triggerall = !var(59)
triggerall = command = "y"
triggerall = statetype = A
triggerall = var(7) = 0
trigger1 = ctrl

;------------------------------------------------------------
;Jump Strong Punch
;󒆋p`-Ȃ
[State -1, Jump Strong Punch]
type = ChangeState
value = 620
triggerall = !var(59)
triggerall = (statetype = A)
triggerall = (command = "z") || command = "holdz"
triggerall = stateno != 1005 || stateno != 1009
triggerall = movecontact
triggerall = time < 15
trigger1 = stateno = 600 || stateno = 630 || stateno = 610
trigger2 = var(37) = 1
trigger2 =  stateno != 620 && stateno != 650

;󒆋p`-Ȃ2
[State -1, Jump Strong Punch]
type = ChangeState
value = 620
triggerall = !var(59)
triggerall = statetype = A
triggerall = movecontact
triggerall = time < 15
trigger1 =  (command = "y")
trigger1 =  (command != "b") || (command != "c")
trigger1 = stateno = 610

;󒆋p`
[State -1, Jump Strong Punch]
type = ChangeState
value = 620
triggerall = !var(59)
triggerall = (statetype = A)
triggerall = (command = "z")
triggerall = stateno != 1005 || stateno != 1009
trigger1 = ctrl

;------------------------------------------------------------
;Jump Light Kick
;󒆎LbN-Ȃ
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = !var(59)
triggerall = statetype = A
triggerall = command = "a" || command = "holda"
triggerall = movecontact
triggerall = time < 15
trigger1 = var(45) = 1
trigger1 =  stateno != 620 && stateno != 650

;󒆎LbN
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = !var(59)
triggerall = ctrl && statetype = A
trigger1 = command = "a"

;------------------------------------------------------------
;Jump Medium Kick
;󒆒LbN-Ȃ
[State -1, Jump Medium Kick]
type = ChangeState
value = 640
triggerall = !var(59)
triggerall = statetype = A 
triggerall = command = "b" || command = "holdb"
triggerall = var(8) = 0
triggerall = movecontact
triggerall = time < 15
trigger1 = stateno = 600 || stateno = 630  || stateno = 610
trigger2 = var(46) = 1
trigger2 =  stateno != 620 && stateno != 650

;󒆒LbN-Ȃ2
[State -1, Jump Medium Kick]
type = ChangeState
value = 640
triggerall = !var(59)
triggerall = statetype = A 
triggerall = var(8) = 0
triggerall = movecontact
triggerall = time < 15
trigger1 =  (command = "a")
trigger1 = stateno = 630  || stateno = 610

;󒆒LbN
[State -1, Jump Medium Kick]
type = ChangeState
value = 640
triggerall = !var(59)
triggerall = statetype = A 
triggerall = command = "b"
triggerall = var(8) = 0
trigger1 = ctrl

;------------------------------------------------------------
;󒆋LbN-Ȃ
[State -1, Jump Strong Kick]
type = ChangeState
value = 650
triggerall = !var(59)
triggerall = command = "c" || command = "holdc"
triggerall = statetype = A 
triggerall = stateno != 1005 || stateno != 1009
triggerall = movecontact
triggerall = time < 15
trigger1 = stateno = 600 || stateno = 630
trigger2 = var(47) = 1

;󒆋LbN-Ȃ2
[State -1, Jump Strong Kick]
type = null;ChangeState
value = 650
triggerall = !var(59)
triggerall = statetype = A
triggerall = movecontact
triggerall = time < 15
trigger1 =  (command = "b")
trigger1 =  (command != "z") || (command != "y")
trigger1 = stateno = 640

;󒆋LbN
[State -1, Jump Strong Kick]
type = ChangeState
value = 650
triggerall = !var(59)
triggerall = command = "c" && statetype = A
triggerall = stateno != 1005 || stateno != 1009
trigger1 = ctrl











;----------Y------------------------------------

[State -1,AI Combo]
type = Null ;ChangeState
value = 3501
triggerall = (ctrl) && (var(59) = 1) && (StateType = S) && pos y = 0
trigger1 = (command = "AICombo")
trigger2 = (command = "AICombo2")
trigger3 = (command = "AICombo3")
trigger4 = (command = "AICombo4")
trigger5 = (command = "AICombo5")
trigger6 = (command = "AICombo6")
trigger7 = (command = "AICombo7")
trigger8 = (command = "AICombo8")
trigger9 = (command = "AICombo9")
trigger10 = (command = "AICombo10")
trigger11 = (P2BodyDist X = [0, 20]) && (P2BodyDist y = [-10, -50]) 
trigger11 =  (random > 400)


;Press Start Graphic
[State -1, GroundCounter]
type = Null ;ChangeState
value = 3500
triggerall = numexplod(9001) = 0
trigger1 = var(59) = 1  && statetype = s && time =0





;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
;----------           ------------------------------------------------------
;----------   A  I   ------------------------------------------------------
;----------         -----------------------------------------------------
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


;------------CӒݒӏ-----------------------------------------------------
;----------AIZbg------------------------------------------------------

[state -1, AItOZbg]
type=VarSet
TriggerAll=!ishelper
TriggerAll=var(59) =0
trigger1 = (command = "CPU2")
trigger2 = (command = "CPU2")
trigger3 = (command = "CPU3")
trigger4 = (command = "CPU4")
trigger5 = (command = "CPU5")
trigger6 = (command = "CPU6")
trigger7 = (command = "Hyper1")
trigger8 = (command = "Hyper2")
trigger9 = (command = "Hyper3")
trigger10 = (command = "Hyper4")
trigger11 = (command = "Hyper5")
trigger12 = (command = "Hyper6")
trigger13 = (command = "Hyper7")
trigger14 = (command = "CPU7")
trigger15 = (command = "CPU8")
trigger16 = (command = "CPU9")
trigger17 = (command = "CPU10")
trigger18 = (command = "CPU11")
trigger19 = (command = "CPU12")
trigger20 = (command = "CPU13")
trigger21 = (command = "CPU14")
trigger22=numhelper(10000)
trigger22=helper(10000),var(59)
trigger23 = Command = "AI22"
trigger24 = Command = "AI23"
trigger25 = Command = "AI24"
trigger26 = Command = "AI25"
trigger27 = Command = "AI26"
trigger28 = Command = "AI27"
trigger29 = Command = "AI28"
trigger30 = Command = "AI29"
trigger31 = Command = "AI30"
Trigger32=command="a"^^command="a2"
Trigger33=command="b"^^command="b2"
Trigger34=command="c"^^command="c2"
Trigger35=command="x"^^command="x2"
Trigger36=command="y"^^command="y2"
Trigger37=command="z"^^command="z2"
Trigger38=command="start"^^command="start2"
Trigger39=command="fwd"^^command="fwd2"
Trigger40=command="back"^^command="back2"
Trigger41=command="up"^^command="up2"
Trigger42=command="down"^^command="down2"
;trigger43= 1;[̃Z~ROƏɂ`hNԂɂȂ܂
IgNoreHitPause=1
;
;--------AIxݒ---------------------------------------------------------
var(59) = 6 ;AIx؂ւ(AI.Lv)   Hard6  5  4@3  2  1  0 Easy
fvar(39) = 10

;x0ŃV}񂪂[
;x1V}ƋY
;x2V}Ɛ키
;x3V}Ɩ̎EDiƂjB̃xȏ͓Ƀ^bOisimulj[hŖ\܂܂
;x4V}ƒnŏIcA[
;x5V}ƈʒn̔ޕ
;x6ŃV}ƂɃJIXfBVs
;x3ȏ͑΂`hOɑgł̂őΐlɂ͕s
;AhoVOK[hgppx̓K[hxˑł


;--------AIK[hxݒ---------------------------------------------------------

[State -1]
type = VarSet
trigger1 = Var(59) >= 1
v = 53      
value = 5   ;AIK[hx@Hard 5 ` 0 Easy



;------------------------------------------------------------------------------
;---R{-ʒuȂ--------------


;1P2PɊւ炸Ahelper(30000)E[Ahelper(30010)[

[State -1,Super Jump];K[hꂽANV
type = null;ChangeState
value = 3600
triggerall = (Statetype != A) && (ctrl) &&  var(59) >= 6
triggerall = EnemyNear,Alive
triggerall =   (EnemyNear,stateno != [5000,5999]) && (EnemyNear,stateno != [670,675]) && (EnemyNear,stateno != [120,155])
triggerall = P2BodyDist X = [-10,70]
trigger1 = numhelper(9920) = 1
trigger1 = helper(9920),stateno = 9921 && helper(9920),movecontact
trigger2 = numhelper(9923) = 1
trigger2 = helper(9923),stateno = 9924 && helper(9920),movecontact
trigger3 = numhelper(9925) = 1
trigger3 = helper(9925),stateno = 9926 && helper(9925),movecontact
trigger4 = NumHelper(1001) >= 1
trigger4 = helper(1001),movecontact

[State -1,Super Jump];K[hꂽANV
type = ChangeState
value = 420
triggerall = (Statetype != A) && (ctrl) &&  var(59) >= 6
triggerall = EnemyNear,Alive
triggerall =   (EnemyNear,stateno != [5000,5999]) && (EnemyNear,stateno != [670,675]) && (EnemyNear,stateno != [120,155])
triggerall = P2BodyDist X = [110,240]
trigger1 = numhelper(9920) = 1
trigger1 = helper(9920),stateno = 9921 && helper(9920),movecontact
trigger2 = numhelper(9923) = 1
trigger2 = helper(9923),stateno = 9924 && helper(9920),movecontact
trigger3 = numhelper(9925) = 1
trigger3 = helper(9925),stateno = 9926 && helper(9925),movecontact
trigger4 = NumHelper(1001) >= 1
trigger4 = helper(1001),movecontact

[State -1, Dash Backward];jXJсA߂΍
type = ChangeState
value = 3200
triggerall = (Statetype != A) && (var(59) >= 1)
trigger1 = backedgedist > 60 || EnemyNear,stateno = 5120
Trigger1 = stateno = 230
Trigger1 = animtime = 0
Trigger1 = !movecontact
trigger1 = BackEdgeBodyDist > 90
Trigger2 = anim = 5 && (var(59) >= 3) && (ctrl)
trigger2 = EnemyNear,moveType != H

[State -1, ʒ[瓦]
type = ChangeState
value = 1006
triggerall = (Statetype != A)  &&  var(59) >= 4
triggerall = EnemyNear,Alive
triggerall =   EnemyNear,stateno = 5120
triggerall = P2BodyDist X = [-90,90]
trigger1 =  (ctrl)
trigger1 = (helper(30000),rootDist x  <= 60) || (helper(30010),rootDist x <= 60)
trigger2 = BackEdgeBodyDist < 90
Trigger2 = stateno = 230
Trigger2 = animtime = 0
Trigger2 = !movecontact

[State -1, ʒ[ŕĈʒu]
type = null;ChangeState
value = 21
triggerall = (Statetype != A) && (ctrl) &&  var(59) >= 6 && (var(30) > 0 || var(32) > 0)
triggerall = EnemyNear,Alive
triggerall =   EnemyNear,stateType = A
triggerall =   EnemyNear,stateno = [5000,5999]
triggerall = P2BodyDist X = [-40,40]
triggerall = EnemyNear,pos y <= -210
triggerall = stateno != 21 ;&& stateno != 100
triggerall = (helper(30000),rootDist x  <= 40) || (helper(30010),rootDist x <= 40)
trigger1 =   FrontEdgeBodyDist < 30

[State -1, ʒ[ŕċ߂Â]
type = ChangeState
value = 21
triggerall = (Statetype != A) && (ctrl) &&  var(59) >= 6 && (var(30) > 0 || var(32) > 0)
triggerall = EnemyNear,Alive
triggerall =   EnemyNear,stateType = A
triggerall =   EnemyNear,stateno = [5000,5999]
triggerall = P2BodyDist X <= 100 && FrontEdgeBodyDist < 150
triggerall = EnemyNear,pos y <= -200
triggerall = stateno != 21 ;&& stateno != 100
triggerall = (helper(30000),rootDist x  >= 70) || (helper(30010),rootDist x >= 70)
trigger1 =  enemynear,BackEdgeBodyDist < 30

[State -1, JIXfBVǂłAċ߂Â]
type = ChangeState
value = 21
triggerall = (Statetype != A) && (ctrl) &&  var(59) >= 6
triggerall = EnemyNear,Alive
triggerall = P2BodyDist X <= 150
triggerall = stateno != 21
trigger1 = EnemyNear,prevstateno = 4521 || EnemyNear,stateno = 4521


[State -1, _]
type = ChangeState
value = 42
triggerall = (Statetype != A) && (ctrl) &&  var(59) >= 4
triggerall = EnemyNear,Alive
triggerall =   EnemyNear,stateno != [5000,5999]
triggerall = stateno = 0
triggerall = EnemyNear,stateno != 4521
triggerall = EnemyNear,prevstateno != 4521
triggerall = (EnemyNear,stateno != [5080,5120])&&EnemyNear,stateno != [674,675]
trigger1 =  time > 10


;Super  Jump;AI
[State -1,Super Jump]
type = ChangeState
value = 42
triggerall = (Statetype != A) && (ctrl) &&  var(59) >= 6
triggerall = EnemyNear,Alive
triggerall =   (EnemyNear,stateno = [5000,5999]) || (EnemyNear,stateno = [670,673])
triggerall = P2BodyDist X = [-10,140]
trigger1 = numhelper(9920) = 1
trigger1 = helper(9920),stateno = 9921 && helper(9920),movehit
trigger1 = EnemyNear,pos y <= -150
trigger2 = numhelper(9923) = 1
trigger2 = helper(9923),stateno = 9924 && helper(9920),movehit
trigger2 = EnemyNear,pos y <= -150
trigger3 = numhelper(9925) = 1
trigger3 = helper(9925),stateno = 9926 && helper(9925),movehit
trigger3 = EnemyNear,pos y <= -150
trigger4 = EnemyNear,vel y <= -6
trigger4 = EnemyNear,pos y <= -90

; Jump;AI
[State -1,Jump]
type = ChangeState
value = 40
triggerall = (Statetype != A) && (ctrl) &&  var(59) >= 6
triggerall = EnemyNear,Alive
triggerall =   (EnemyNear,stateno = [5000,5999]) || (EnemyNear,stateno = [670,673])
triggerall = P2BodyDist X = [-10,120]
trigger1 = numhelper(9920) = 1
trigger1 = helper(9920),stateno = 9921 && helper(9920),movehit
trigger1 = EnemyNear,pos y = [-150,-60]
trigger2 = numhelper(9923) = 1
trigger2 = helper(9923),stateno = 9924 && helper(9920),movehit
trigger2 = EnemyNear,pos y = [-150,-60]
trigger3 = numhelper(9925) = 1
trigger3 = helper(9925),stateno = 9926 && helper(9925),movehit
trigger3 = EnemyNear,pos y = [-150,-60]

; Jump;AI
[State -1, Jump]
type = ChangeState
value = 40
triggerall = (Statetype != A) && (ctrl ||stateno = 100||stateno = 21) &&  var(59) >= 6 && (var(30) = [1,100])
triggerall = EnemyNear,Alive
triggerall =   EnemyNear,stateType = A
;triggerall = ((EnemyNear,pos y = [-170,-140]) && (EnemyNear,vel y =[0,3]))||(EnemyNear,pos y <= -200  &&(EnemyNear,GetHitVar(yaccel) >= 0.5 ||  EnemyNear,GetHitVar(yvel) > -1))
triggerall = (EnemyNear,pos y = [-270,-100])
triggerall =   EnemyNear,stateno = [5000,5999]
triggerall = stateno != 40
triggerall = EnemyNear,stateno != 4521
triggerall = EnemyNear,prevstateno != 4521
triggerall = (EnemyNear,stateno != [5080,5120])&&EnemyNear,stateno != [674,675]
trigger1 = EnemyNear,stateno != 4521 && prevstateno != 4603
trigger1 = (P2BodyDist X >= 100  && stateno = 100) || (P2BodyDist X <= 100 )
trigger1 =  EnemyNear,vel x >-4 && EnemyNear,vel x < 4 && EnemyNear,vel y > -4


[State -1, Jump];JIfBǂł
type = ChangeState
value = 40
triggerall = (Statetype != A) &&  var(59) >= 6
triggerall =   EnemyNear,stateType = A
triggerall =   EnemyNear,moveType = H
triggerall = (EnemyNear,StateNo != [120,159])
;triggerall = stateno = 4650
;triggerall = movehit
trigger1 = anim = 4650 && animtime = 0

[State -1, Dash Forward]
type = ChangeState
value = 100
TriggerAll= var(59) >= 5  || (var(59) = 4 && random <= 700)
triggerall = (Statetype != A) 
triggerall = EnemyNear,Alive
triggerall = (stateno != 100) && (stateno != 101)
triggerall =   EnemyNear,movetype = H
triggerall = ctrl
triggerall = !InGuardDist
triggerall = FrontEdgeBodyDist >= 80
triggerall = (EnemyNear,StateNo != [100,159])
Trigger1 = (P2BodyDist X = [100,350]) || ((P2BodyDist X = [50,100]) && EnemyNear,GetHitVar(xvel) <= -4)
Trigger1 = EnemyNear,StateType != L
Trigger1 = (var(30) > 0 || var(32) > 0)
Trigger2 = (helper(30000),rootDist x  <= 200 && facing = 1) || (helper(30010),rootDist x <= 200 && facing = -1)
Trigger2 = var(30) >40 && (P2BodyDist X = [60,150])
Trigger2 = EnemyNear,pos y > -50
;Trigger2 = numhelper(9920)>=1||numhelper(9923)>=1||numhelper(9925)>=1

;Air Dash Forward
[State -1, Dash Forward Air]
type = ChangeState
value = 651
triggerall = (Statetype = A) && (ctrl)
TriggerAll=var(59)  >= 6
TriggerAll= var(19)  = 0
triggerall = FrontEdgeBodyDist >= 160
triggerall =  EnemyNear,GetHitVar(fall.recovertime) >= 25
triggerall =   EnemyNear,stateno = [5000,5999]
Trigger1 = (P2BodyDist X = [60,350])
Trigger1 = EnemyNear,vel x <-4 || EnemyNear,vel x > 4
trigger1 = (helper(30000),rootDist x  > 150) || (helper(30010),rootDist x  > 150)
Trigger2 = (P2BodyDist X = [130,350]) && (P2BodyDist y >= 0)  
;trigger2 = (helper(30000),P2BodyDist x  = [-40,40]) || (helper(30010),P2BodyDist x = [-40,40])


[State -1, Mystic Stare];ʒ[R{-
type = ChangeState
value = 1000
TriggerAll= var(59)  >= 6 && var(30) < 280
triggerall = (Statetype != A)
triggerall = numhelper(9920) = 0 && numhelper(9923) = 0 && numhelper(9925) = 0
triggerall = NumHelper(1001) = 0
triggerall = (helper(30000),rootDist x  <= 120 && facing = 1) || (helper(30010),rootDist x <= 120 && facing = -1)
TriggerAll= movehit
trigger1 = (stateno = 200) && time = 6 && (P2BodyDist X = [-10, 70])
trigger2 = (stateno = 230) && time = 7 && (P2BodyDist X = [-10, 70])
trigger3 = (stateno = 210) && time = 9 && (P2BodyDist X = [70, 170])
trigger4 = (stateno = 220) && animelemtime(7) = 1
trigger5 = (stateno = 250) && time = 9
trigger6 = (stateno = 400)
trigger6 =  (P2BodyDist X = [-10, 50])
trigger7 = (stateno = 410) || (stateno = 440)
trigger7 = (time = 10) && (P2BodyDist X = [-10, 50])
trigger8 = (stateno = 420) || (stateno = 450)
trigger8 = ( time = 9)

;------؂ւ-----------------------------------------------


[State -1, beam] ;ѓȂǉU}r|,~XeBbNELm
Type = ChangeState
Value = 9180
TriggerAll=var(59) >2
triggerall=power >=2000
TriggerAll=RoundState = 2
TriggerAll=P2StateType != A
triggerall = enemy,time < 10-var(59)
TriggerAll=P2BodyDist X = [160,400]
TriggerAll=P2BodyDist Y = [-10,40]
TriggerAll=Ctrl
TriggerAll=P2MoveType = A
triggerall = var(25) = 0
Triggerall = !inguarddist
Triggerall = Enemy,NumProj > 0 || Enemy,NumHelper > 0 
Trigger1 = random >= 900

[State -1, AirRock];΋E
type = ChangeState
value = 1005
TriggerAll=var(59) >= 4 || (var(59)  = 3 && random <= 300)
TriggerAll=StateType = A
TriggerAll=Ctrl
TriggerAll=EnemyNear,Alive
Triggerall = var(30) = 0
Triggerall = stateno != 42
Triggerall = P2BodyDist Y > 70
Triggerall = EnemyNear,MoveType = A
Triggerall = EnemyNear,vel y<0
triggerall = !InGuardDist
Trigger1 =(P2BodyDist X = [-30,60])
Trigger2 = EnemyNear,vel x>0
Trigger2 =(P2BodyDist X = [-30,80])

[State -1, AirRock];^bOqqq
type = ChangeState
value = 1005
TriggerAll=var(59) >= 4 || (var(59)  = 3 && random <= 300)
TriggerAll=StateType = A
TriggerAll=Ctrl
TriggerAll=EnemyNear,Alive
Triggerall = Pos Y < -90
triggerall = !InGuardDist
Trigger1 =(power < 1000)
trigger1 = TeamMode = simul
trigger1 = P2BodyDist X <= 60
trigger1 = P2BodyDist y >= -20

;Hovering Clone Call
[State -1, Hovering Clone Call]
type = ChangeState
value = 3415
TriggerAll=var(59) >  1
triggerall = (power >= 1000)
triggerall = var(13) = 0
triggerall = EnemyNear,Alive
triggerall = Statetype = A && ctrl 
Triggerall = EnemyNear,MoveType != H
triggerall = P2Statetype = A
TriggerAll=P2BodyDist X = [0,80]
TriggerAll=P2BodyDist y = [-20,140]
TriggerAll=Ctrl
triggerall = var(25) = 0
Triggerall = stateno != 42
Triggerall = var(30) = 0
Triggerall = prevstateno != 42
Trigger1 = EnemyNear,stateType != L
trigger1 = (random <= 200) 
Trigger1 =P2BodyDist X = [0,40]
trigger2 = TeamMode = simul
trigger2 = random < 500
Trigger3 = EnemyNear,pos y < -10
Trigge3 = EnemyNear,vel y<-1
Trigger3 =var(59) >=4 && (random >= 300)
Trigger3 = EnemyNear,MoveType = A

;Roll attack air
[State -1, Roll Attack Air];΁A΋
type = ChangeState
value = 1004
TriggerAll=var(59) >=  4 || (var(59)  = 3 && random <= 300)
Triggerall = var(30) = 0
triggerall = (Statetype = A) && (ctrl) &&  EnemyNear,Alive
triggerall = (EnemyNear,StateNo != [120,159])
Triggerall = EnemyNear,MoveType = A
Triggerall = stateno != 42
Triggerall = vel y>-2
triggerall = pos y <= -100
triggerall = !(var(29) >0 && var(59)  >= 5)
Trigge1 = EnemyNear,vel y<-1
Trigger1 = (P2BodyDist y = [50,120])
Trigger1 = (P2BodyDist X = [0,40]) && (random >= 300)
trigger1 = FrontEdgeBodyDist >= 70

[State -1, Mystic Smash Hyper];E
type = ChangeState
value = 3000
TriggerAll=var(59) >=3
triggerall = var(13) = 0
TriggerAll=Ctrl
triggerall = (Statetype = S) || (Statetype = C) &&  EnemyNear,Alive
triggerall = power >= 1000
triggerall = var(25) = 0
trigger1 = life<lifemax/2
trigger1 = EnemyNear,pos y < -20 || EnemyNear,stateType != A
trigger1 = EnemyNear,life< 50
trigger1 = EnemyNear,MoveType != H
trigger1 = EnemyNear,stateType != L
Trigger1 =(P2BodyDist X >= 20)
Trigger1 =var(59) >=4

;Hovering Clone Call;x3ȏp
[State -1, Hovering Clone Call]
type = ChangeState
value = 3415
TriggerAll=var(59) >=3
triggerall = var(13) = 0
triggerall = EnemyNear,Alive
triggerall = Statetype = A
TriggerAll=Ctrl
triggerall = var(25) = 0
Triggerall = prevstateno != 42
;Triggerall = vel y > -5;vppp
trigger1 = TeamMode = simul
trigger1 = random < 200
trigger1 = (power >= 1000)
trigger1 = (power < 2000)
trigger2 = TeamMode = simul
trigger2 = random < 600
trigger2 = (power >= 2000)
trigger3 = random < 600
trigger3 = (power >= 1000)
Trigger3 = EnemyNear,MoveType = H
Trigger3=P2BodyDist X = [0,30]
Trigger3=P2BodyDist Y = [0,60]
trigger3 = (EnemyNear,StateNo != [120,159])
Trigger3 = var(30) = 0
trigger3 = FrontEdgeBodyDist >= 70
Trigger3 = EnemyNear,pos y < -30
trigger4 = (power >= 1000);~XeBbNElr
Trigger4 = EnemyNear,MoveType = H
Trigger4= (P2BodyDist X = [-30,30]) ||  TeamMode = simul
Trigger4= (P2BodyDist Y = [-20,40]) ||  TeamMode = simul
trigger4= (EnemyNear,StateNo != [120,159])
Trigger4 = var(30) = 0 ||  TeamMode = simul
trigger4 =  life<lifemax/3 ||  TeamMode = simul
trigger4 = FrontEdgeBodyDist >= 100 ||  TeamMode = simul
TriggerAll= var(59) >= 5 || (var(59) = 4 &&  random <= 200)
Trigger4 = EnemyNear,pos y < -30 ||  TeamMode = simul

;Roll attack arch;΋̓
[State -1, Roll Attack Arch]
type = ChangeState
value = 1006
TriggerAll=var(59) >=2
triggerall = Statetype != A
triggerall = ctrl
triggerall = EnemyNear,Alive
triggerall = P2Statetype = A
Triggerall = EnemyNear,vel y>0;(~)
triggerall = !(var(29) >0 && var(59)  >= 5)
trigger1 =  random < 300 
Trigger1 = EnemyNear,stateno = [5000,5999]
Trigger1 =P2BodyDist X <= 30
Trigger1 =var(59) = 2
Trigger1 =(EnemyNear,pos Y = [-70,-5])
trigger1 = BackEdgeBodyDist > 0 || (EnemyNear,pos Y = [-30,-5])
Trigger2 = EnemyNear,MoveType != H
Trigger2 =P2BodyDist X <= 40
Trigger2 =var(59) >= 3
Trigger2 =(EnemyNear,pos Y = [-70,-10])
Trigger2 = var(25) = 0


;Ⴊ݋LbN1
[State -1, C-SK]
type = ChangeState
value = 450
TriggerAll=var(59) >  2
triggerall = Statetype != A
triggerall = ctrl
triggerall = EnemyNear,Alive
Triggerall = EnemyNear,vel y>-1
triggerall = EnemyNear,Statetype = A
triggerall = EnemyNear,moveType != H
triggerall =  random > 990 
Trigger1 = P2BodyDist X = [80,130]
Trigger1 = P2BodyDist Y = [-90,0]
Trigger2 = P2BodyDist X = [0,130]
Trigger2 = P2BodyDist Y = [-90,-50]

;Ⴊ݋LbN1
[State -1, C-SK]
type = ChangeState
value = 450
TriggerAll=var(59) >= 5
triggerall = Statetype != A
triggerall = ctrl
triggerall = EnemyNear,Alive
Triggerall = EnemyNear,vel y>-2
triggerall = EnemyNear,Statetype = A
triggerall = (EnemyNear,StateNo = [120,159])
Trigger1 = P2BodyDist X = [0,130]
Trigger1 = P2BodyDist Y = [-90,0]

[State -1, Chaos Demension Grab -C1];_EǂJIfB
type = ChangeState
value = 4601
TriggerAll=var(59) >= 4
triggerall = var(25) = 1
triggerall = (Statetype = C)  || (Statetype = S) 
triggerall = (P2BodyDist y = [-10, 35])
triggerall = P2BodyDist X = [0, 60]
triggerall = (EnemyNear,stateno = [5080,5120])||(EnemyNear,stateno = [674,675])
Triggerall = !inguarddist
triggerall = Ctrl
trigger1 = 1

[State -1,];_Eǂ
type = ChangeState
value = 230
TriggerAll= var(59) >= 5 || (var(59) = 4 &&  random <= 200)
triggerall = RoundState = 2
triggerall = StateType != A
Triggerall = !inguarddist
triggerall = P2bodydist X = [0,35]
triggerall = EnemyNear,pos Y = [-1,50]
triggerall = Ctrl
;trigger1 = EnemyNear,prevstateno = 4521
trigger1 =  (EnemyNear,stateno = [5080,5120])||(EnemyNear,stateno = [674,675])
trigger1 =  EnemyNear,vel x >-3 && EnemyNear,vel x < 3 && EnemyNear,vel y > -1

[State -1,];_Eǂ
type = ChangeState
value = 240
TriggerAll= var(59) >= 6 || (var(59) = 5 &&  random <= 200)
triggerall = RoundState = 2 && var(30) >= 30
triggerall = StateType != A
Triggerall = !inguarddist
triggerall = P2bodydist X = [0,55]
triggerall = EnemyNear,pos Y = [-20,50]
triggerall = Ctrl
trigger1 = (EnemyNear,stateno = [5080,5120])||(EnemyNear,stateno = [674,675])
triggerall = EnemyNear,prevstateno = 4521

[State -1,];_Eǂ
type = ChangeState
value = 430
TriggerAll= var(59) >= 6 || (var(59) = 5 &&  random <= 200)
triggerall = RoundState = 2 && var(30) >= 30
triggerall = StateType != A
Triggerall = !inguarddist
triggerall = P2bodydist X = [0,40]
triggerall = EnemyNear,pos Y = [-10,30]
triggerall = Ctrl
trigger1 = (EnemyNear,stateno = [5080,5120])||(EnemyNear,stateno = [674,675])

[State -1,];_Eǂ
type = ChangeState
value = 440
TriggerAll= var(59) >= 6 || (var(59) = 5 &&  random <= 200)
triggerall = RoundState = 2 && var(30) >= 30
triggerall = StateType != A
Triggerall = !inguarddist
triggerall = P2bodydist X = [0,95]
triggerall = EnemyNear,pos Y = [-20,20]
triggerall = Ctrl
triggerall = var(25) = 0
triggerall = numhelper(9920) = 0 && numhelper(9923) = 0 && numhelper(9925) = 0
trigger1 = (EnemyNear,stateno = [5080,5120])||(EnemyNear,stateno = [674,675])

[State -1,];_Eǂ2
type = null;ChangeState
value = 240
TriggerAll= var(59) >= 5 || (var(59) = 4 &&  random <= 100)
triggerall = RoundState = 2
triggerall = StateType != A
Triggerall = !inguarddist
triggerall = P2bodydist X = [0,50]
triggerall = P2bodydist Y = [-30,40]
triggerall = Ctrl
triggerall = (EnemyNear,stateno = [5080,5120])||(EnemyNear,stateno = [674,675])
trigger1 = EnemyNear,moveType = H;EnemyNear,vel y != 0



;------s-----------------------------------------------------------------

;------K[hAAhKAgs-------------------------------

[State -1, Taunt];
type = ChangeState
value = 938
triggerall = !EnemyNear,Alive 
triggerall = var(6) = 0 
triggerall = (prevstateno != 938)
trigger1 = ctrl && var(59) >= 1
trigger1 = statetype != A
trigger1 = TeamMode = Single || TeamMode = turns
persistent=0


[State -1,g]
type = SelfState
TriggerAll = CanRecover
TriggerAll = Alive
TriggerAll=Ctrl
triggerall = var(6) = 0 
triggerall=Vel Y > 0
Trigger1 = Pos y>=-15
Trigger1 = Var(59) = 0
Trigger1 = command = "recovery"
Trigger2 = moveType = H
Trigger2 = Pos y<=-15
Trigger2 = P2BodyDist x>= 80
Trigger2= var(59) >  0
Trigger2 = Random = [100,300]
trigger2 = backedgedist > 60
trigger2 = prevstateno != 5200
value = 5200
ctrl = 0


;Ground Counter
[State -1, GroundCounter]
type = ChangeState
value = 900
TriggerAll=var(59) >=2
triggerall = stateno = 150 || stateno = 151
triggerall = (Statetype != A) && (power >= 1000)
triggerall =  (P2BodyDist X < 40)
trigger1 = life<lifemax/4
trigger2 = random <= 300
trigger2 = life<lifemax/2

;Air Counter
[State -1, AirCounter]
type = ChangeState
value = 901
TriggerAll=var(59)  >=2
triggerall = stateno = 154
triggerall = (Statetype = A) && (power >= 1000)
triggerall =  (P2BodyDist X < 40)
trigger1 = life<lifemax/4
trigger2 = random <= 300
trigger2 = life<lifemax/2



;Guard Push (Standing)-AhoVOK[h
[State -1, Guard Push]
type = ChangeState
value = 7000
TriggerAll=var(59) >  0
triggerall = statetype = S
triggerall = stateno = 150 || stateno = 151
trigger1 = Var(53) =4
trigger1 = random <= 300
trigger2 = Var(53) =5

;Guard Push (Crouching)-Ⴊ݃AhoVOK[h
[State -1,C- Guard Push]
type = ChangeState
value = 7005
TriggerAll=var(59) >  0
triggerall = statetype = C
triggerall = stateno = 152 || stateno = 153
trigger1 = Var(53) =4
trigger1 = random <= 300
trigger2 = Var(53) =5

;Guard Push (Air)-󒆃AhoVOK[h
[State -1,C- Guard Push]
type = ChangeState
value = 7006
TriggerAll=var(59) >  0
triggerall = statetype = A
triggerall = stateno = 154 || stateno = 155
trigger1 = Var(53) =4
trigger1 = random <= 300
trigger2 = Var(53) =5

[State -1 GuardCrouch]Gѓ΍
type=ChangeState
value=131
triggerall = (ctrl) || (stateNo = 100) || (stateNo = 20)
triggerall = var(53) > 2   
triggerall = enemy,time > 5-var(53)
triggerall = random < ifelse(var(53)=2,50,ifelse(var(53)=3,180,ifelse(var(53)=4,400,1000)))
triggerall = InGuardDist
TriggerAll=var(59) >= 1
triggerall = (StateType = C) || (StateType = S) 
triggerall = P2Statetype != A
Trigger1=helper(30020),var(2)=5
Trigger2=helper(30020),var(58)=1000|| helper(30020),var(58)=10000||helper(30020),var(58)=100000

[State -1 GuardStand]Gѓ΍
type=ChangeState
value=131
triggerall = (ctrl) || (stateNo = 100) || (stateNo = 20)
triggerall = var(53) > 2   
triggerall = enemy,time > 5-var(53)
triggerall = random < ifelse(var(53)=2,50,ifelse(var(53)=3,180,ifelse(var(53)=4,400,1000)))
triggerall = InGuardDist
TriggerAll=var(59) >= 1
triggerall = (StateType = C) || (StateType = S) 
triggerall = P2Statetype != C
Trigger1=helper(30020),var(2)=5
Trigger2=helper(30020),var(58)=1000|| helper(30020),var(58)=10000||helper(30020),var(58)=100000

[State -1, GuardAir)Gѓ΍
type = changestate
value=132
triggerall = (ctrl) || (stateNo = 50)
triggerall = var(53) > 2   
triggerall = enemy,time > 5-var(53)
triggerall = random < ifelse(var(53)=2,50,ifelse(var(53)=3,180,ifelse(var(53)=4,400,1000)))
triggerall = InGuardDist
TriggerAll=var(59) >= 1
triggerall = (StateType = A) 
Trigger1=helper(30020),var(2)=5
Trigger2=helper(30020),var(58)=1000|| helper(30020),var(58)=10000||helper(30020),var(58)=100000

[State -1 Βngp]
type=ChangeState
value=131
triggerall = var(53) > 1   
triggerall=helper(30000),var(46)||((helper(30000),var(47)<=55-var(59)*2&&random<50)||helper(30000),var(47)<=35-var(59)*2)&&var(59)<=10||((helper(30000),var(47)<=55-var(59)*2&&random<50)||helper(30000),var(47)<=35-var(59)*2)&&var(59)<=10
triggerall=var(59)>0||helper(30020),var(59)=1
TriggerAll=Random <var(59)*100||helper(30020),var(59)=1
TriggerAll=RoundState=2
TriggerAll=playerID(var(57)),Alive
triggerall=P2Dist x > 0
TriggerAll=playerID(var(57)),MoveType!=H||playerID(var(57)),stateno<200
TriggerAll=playerID(var(57)),statetype!=L
triggerall=statetype!=A
triggerall=ctrl||stateno=100||stateno=20
triggerall=(helper(30020),var(58)/1000000)%10&&!((helper(30020),var(58)/1000)%10)&&!((helper(30020),var(58)/10000)%10)	;fpϐ
Triggerall=P2Bodydist x+ playerID(var(57)),facing * facing * playerID(var(57)),vel x*6-(stateno=100)*vel x*4>=100
triggerall = random < ifelse(var(53)=2,50,ifelse(var(53)=3,180,ifelse(var(53)=4,400,1000)))
Trigger1=random<45*helper(30020),fvar(2)

[State -1 Βngp]
type=ChangeState
value=132
triggerall = var(53) > 1   
triggerall=helper(30000),var(46)||((helper(30000),var(47)<=55-var(59)*2&&random<50)||helper(30000),var(47)<=35-var(59)*2)&&var(59)<=10||((helper(30000),var(47)<=55-var(59)*2&&random<50)||helper(30000),var(47)<=35-var(59)*2)&&var(59)<=10
triggerall=var(59)>0||helper(30020),var(59)=1
TriggerAll=Random <var(59)*100||helper(30020),var(59)=1
TriggerAll=RoundState=2
TriggerAll=playerID(var(57)),Alive
triggerall=P2Dist x > 0
TriggerAll=playerID(var(57)),MoveType!=H||playerID(var(57)),stateno<200
TriggerAll=playerID(var(57)),statetype!=L
triggerall=statetype=A
triggerall=ctrl||stateno=50
triggerall=(helper(30020),var(58)/1000000)%10&&!((helper(30020),var(58)/1000)%10)&&!((helper(30020),var(58)/10000)%10)	;fpϐ
Triggerall=P2Bodydist x+ playerID(var(57)),facing * facing * playerID(var(57)),vel x*6-(stateno=100)*vel x*4>=100
triggerall = random < ifelse(var(53)=2,50,ifelse(var(53)=3,180,ifelse(var(53)=4,400,1000)))
Trigger1=random<45*helper(30020),fvar(2)



[State -1, GuardCrouch);NUߑ΍􂵂Ⴊ
type = changestate
triggerall = (stateNo = 5120)
triggerall = var(53) >= 3  
triggerall = enemy,time > 5-var(53)
triggerall = random < ifelse(var(53)=2,50,ifelse(var(53)=3,180,ifelse(var(53)=4,400,1000)))
triggerall = InGuardDist
TriggerAll=var(59) >= 1
triggerall = anim = 5120 && animtime = 0
trigger1 = EnemyNear,movetype = A
trigger1 = EnemyNear,statetype != A
Trigger2=(helper(30020),var(58)=1000|| helper(30020),var(58)=10000||helper(30020),var(58)=100000)
value = 131

[State -1, GuardCrouch);NUߑ΍
type = changestate
triggerall = (stateNo = 5120)
triggerall = var(53) >= 3  
triggerall = enemy,time > 5-var(53)
triggerall = random < ifelse(var(53)=2,50,ifelse(var(53)=3,180,ifelse(var(53)=4,400,1000)))
triggerall = InGuardDist
TriggerAll=var(59) >= 1
triggerall = anim = 5120 && animtime = 0
trigger1 = EnemyNear,movetype = A
trigger1 = EnemyNear,statetype != C
Trigger2=(helper(30020),var(58)=1000|| helper(30020),var(58)=10000||helper(30020),var(58)=100000)
value = 130

[State -1, GuardCrouch)
type = changestate
triggerall = (ctrl) || (stateNo = 100) || (stateNo = 20)
triggerall = var(53) >= 1   
triggerall = enemy,time > 5-var(53)
triggerall = random < ifelse(var(53)=2,50,ifelse(var(53)=3,180,ifelse(var(53)=4,400,1000)))
triggerall = InGuardDist
TriggerAll=var(59) >= 1
triggerall = (StateType = C) || (StateType = S) 
trigger1 = var(53) <= 3
trigger2 = P2Statetype != A  && var(53) >= 3
trigger3 = P2Statetype = C  && var(53) >= 3
value = 131

[State -1, GuardAir)
type = changestate
triggerall = (ctrl) || (stateNo = 50)
triggerall = var(53) >= 1   
triggerall = enemy,time > 5-var(53)
triggerall = random < ifelse(var(53)=2,50,ifelse(var(53)=3,180,ifelse(var(53)=4,400,1000)))
triggerall = InGuardDist
TriggerAll=var(59) >= 1
triggerall = (StateType = A) 
trigger1 = var(53) <= 3
trigger2 = P2Statetype != C  && var(53) >= 3
trigger3 = var(53) = 5;-------------------
Trigger3 = P2BodyDist Y = [0,50]
Trigger3 = EnemyNear,vel y<0
Trigger3 =(P2BodyDist X = [-30,60])
value = 132


[State -1, GuardStand)
type = changestate
triggerall = (ctrl) || (stateNo = 100)
triggerall = var(53) >= 1   
triggerall = enemy,time > 5-var(53)
triggerall = random < ifelse(var(53)=2,50,ifelse(var(53)=3,180,ifelse(var(53)=4,400,1000)))
triggerall = InGuardDist
TriggerAll =var(59) >= 1
triggerall = (StateType = C) || (StateType = S) 
trigger1 = var(53) <= 3
trigger2 = P2Statetype != C  && var(53) >= 3
value = 130





;-----_bV,Wvn----------------------------

;Super  Jump;AI
[State -1,Super Jump]
type = ChangeState
value = 42
triggerall = (Statetype != A) && (ctrl) &&  var(59) >= 5 && var(30) = 0
triggerall = EnemyNear,Alive
Triggerall=!(helper(30020),var(58)=1000|| helper(30020),var(58)=10000||helper(30020),var(58)=100000)
triggerall = EnemyNear,stateno != 4521
triggerall = EnemyNear,prevstateno != 4521
triggerall = (EnemyNear,stateno != [5080,5120])&&EnemyNear,stateno != [674,675]
trigger1 = P2BodyDist X = [0,90]
trigger1 = backedgedist < 50
trigger1 = random <= 300
trigger1 = var(25) = 0
trigger1 =   EnemyNear,moveType != H
Trigger1 = var(58) < 8
trigger2 = P2BodyDist X >= 120
trigger2 = random >= 700
trigger2 =   EnemyNear,moveType = A
trigger2 =  Enemy,NumProj > 0 || Enemy,NumHelper > 0
Trigger2 = var(58) < 8
trigger3 = P2BodyDist X >= 100
trigger3 = random <= 50
trigger3 =   EnemyNear,moveType != H
Trigger3 = var(58) < 8
trigger4 = P2BodyDist X <= 90
trigger4 = (EnemyNear,pos y <= -290 && EnemyNear,vel y > -3) || ((EnemyNear,pos y <= -220) && (EnemyNear,vel y = [ -5,-3]))
trigger4 =   EnemyNear,moveType = H
trigger4 =  EnemyNear,vel x >-3 && EnemyNear,vel x < 3 && EnemyNear,vel y < 1
trigger4 =  EnemyNear,GetHitVar(yaccel) <= 0.5 && EnemyNear,GetHitVar(yvel) <= -2
Trigger5= helper(30020),var(58)=100

[State -1,Super Jump];^bOpqqq
type = ChangeState
value = 42
triggerall = (Statetype != A) && (ctrl) &&  var(59) >= 5
triggerall = EnemyNear,Alive
triggerall = var(25) = 0
Triggerall = EnemyNear,MoveType != H
triggerall = TeamMode = simul
trigger1 = P2BodyDist X <= 90

[State -1,Super Jump];GA⏕
type = ChangeState
value = 42
triggerall = (Statetype != A) &&  var(59) >= 2
triggerall = EnemyNear,Alive
trigger1 = EnemyNear,moveType = H
trigger1 = stateno = 240  && movehit > 8

[State -1, Dash Forward]
type = ChangeState
value = 100
TriggerAll=var(59) >=3
triggerall = (Statetype != A) 
triggerall = EnemyNear,Alive
triggerall = (stateno != 100) && (stateno != 101)
triggerall = P2movetype !=A
triggerall = EnemyNear,MoveType != A
triggerall = ctrl
triggerall = !InGuardDist
Triggerall = P2BodyDist X >= 60
triggerall = FrontEdgeBodyDist >= 50
Trigger1 = P2BodyDist X = [160,300]
Trigger1 = random <= 400
Trigger1 = NumHelper(1001) >= 1  || (EnemyNear,StateNo = [120,159])
trigger1 = TeamMode = Single || TeamMode = turns
trigger2 = NumHelper(1001) >= 1 || EnemyNear,moveType = H
Trigger2 = P2BodyDist X > 250
trigger2 =  TeamMode = Single || TeamMode = turns
Trigger3 = P2BodyDist X = [61,300]
Trigger3 = (var(25) = 1)
Trigger3 = random >= 700
trigger3 = NumHelper(1001) >= 1
trigger4 = (EnemyNear,StateNo = [120,159])
Trigger4 = (var(25) = 1)

;Dash Forward
[State -1, Dash Forward]
type = ChangeState
value = 100
TriggerAll=var(59)  <3
TriggerAll=var(59) > 0
triggerall = (Statetype != A) 
triggerall = EnemyNear,Alive
triggerall = (stateno != 100) && (stateno != 101)
triggerall = P2movetype !=A
triggerall = EnemyNear,MoveType != A
triggerall = ctrl
triggerall = !InGuardDist
Triggerall = P2BodyDist X >= 30
Trigger1 = P2BodyDist X = [60,120]
Trigger1 = (var(25) = 1)
Trigger2 = P2BodyDist X >= 130
trigger2 = var(25) = 0
Trigger2 = random >= 300
trigger2 = NumHelper(1001) >= 1
Trigger3 = P2BodyDist X = [81,200]
Trigger3 = (var(25) = 1)
trigger3 = NumHelper(1001) >= 1
trigger4 = EnemyNear,prevstateno = 4521
trigger4 = p2stateno = 5100

;Dash Forward
[State -1, Dash Forward]
type = ChangeState
value = 100
TriggerAll=var(59)  <3
TriggerAll=var(59)  > 0
triggerall = (Statetype != A) 
triggerall = EnemyNear,Alive
triggerall = (stateno != 100) && (stateno != 101)
triggerall = P2movetype !=A
triggerall = ctrl
Triggerall = P2BodyDist X > 50
Triggerall = !inguarddist
Trigger1 = P2BodyDist X = [60,200]
Trigger1 = EnemyNear,MoveType = H
trigger1 = (EnemyNear,StateNo != [120,159])
Trigger1 = EnemyNear,stateType =S || EnemyNear,stateType =C


;Air Dash Forward
[State -1, Dash Forward Air]
type = ChangeState
value = 651
triggerall = (Statetype = A) && (ctrl)
TriggerAll = EnemyNear,StateType != L
TriggerAll=var(59)  > 0
triggerall = NumHelper(1001) >= 1
TriggerAll= var(19)  = 0
triggerall = FrontEdgeBodyDist >= 70
trigger1 =  (P2BodyDist X = [200, 400]) && (random < 600) 
trigger1 =  (P2BodyDist X = [50, 400]) && (random > 800) 
trigger1 =  (EnemyNear,Pos y = [-250,-50])
trigger1 =   var(30) = 0
trigger2 = var(30) >= 1 && P2BodyDist X > 70 && EnemyNear,MoveType = H
trigger2 = P2BodyDist y = [-10, 40]
Trigger3 = var(59) >=  3
trigger3 = (P2BodyDist x > 60)
trigger3 = stateno = 50 && pos y < -90
trigger3 = EnemyNear,moveType = A
Trigger4 = P2BodyDist X = [81,300]
Trigger4 = EnemyNear,vel x <= -3 
trigger4 = EnemyNear,moveType = H
Trigger4 =var(59)  >= 3
Trigger5 =var(59)  >= 4
Trigger5=!(helper(30020),var(2)=5)
Trigger5=helper(30020),var(58)=100
Trigger5 = pos y < -180

;Dash Backward
[State -1, Dash Backward]
type = ChangeState
value = 3200
triggerall = (Statetype != A) && (ctrl) && (var(59) >= 1)
triggerall = NumHelper(1001) = 0
triggerall = numhelper(9920) = 0 && numhelper(9923)  = 0 && numhelper(9925)  = 0
triggerall = backedgedist > 60
triggerall = var(25) = 0
TriggerAll= !InGuardDist
triggerall = EnemyNear,moveType != H
trigger1 = EnemyNear,StateType = L
trigger1 =  (P2BodyDist X = [0, 90])
Trigger2 =var(59) >= 3
Trigger2 = stateno = 0 || stateno = 20
Trigger2 = time >= 30
trigger2 = random > 600


;Air Dash Forward
[State -1, Dash Forward Air]
type = ChangeState
value = 651
triggerall = (Statetype = A) && (ctrl)
TriggerAll=var(59)  >= 6
TriggerAll= var(19)  = 0
triggerall = FrontEdgeBodyDist >= 70
TriggerAll = EnemyNear,moveType != H
triggerall = var(25) = 0
triggerall =  (P2BodyDist X = [-60, 60])
Trigger1 = EnemyNear,ctrl
trigger1 =  (P2BodyDist y = [-30, 160])

;Dash Backward Air
[State -1, Dash Backward Air]
type = ChangeState
value = 652
TriggerAll=var(59)  >= 3
triggerall = (Statetype = A) && (ctrl)
TriggerAll = EnemyNear,moveType != H
triggerall = var(25) = 0
triggerall =  (P2BodyDist X = [-60, 90]) && (backedgedist > 90)
TriggerAll= var(19)  = 0
trigger1 = random >= 900 
trigger1 = EnemyNear,moveType = A
Trigger2 = EnemyNear,StateType = L
trigger3 = EnemyNear,moveType = A
Trigge3 = EnemyNear,vel y<0
Trigger4 =var(59)  >= 4
Trigger4=helper(30020),var(58)=100
Trigger4 = pos y < -180
Trigger5 = EnemyNear,ctrl
trigger5 =  (P2BodyDist y = [-30, 160])
Trigger5=var(59)  >= 6

; Jump;AI
[State -1, Jump]
type = ChangeState
value = 40
triggerall = (Statetype != A) && (ctrl) &&  var(59) >= 2 &&  var(30) <= 20
triggerall = EnemyNear,Alive
triggerall =   EnemyNear,stateType = A
triggerall = P2BodyDist X = [0,90]
triggerall = EnemyNear,stateno != 4521
triggerall = EnemyNear,prevstateno != 4521
triggerall = (EnemyNear,stateno != [5080,5120])&&EnemyNear,stateno != [674,675]
trigger1 = var(59) < 4
trigger1 = (EnemyNear,StateNo != [120,159])
trigger1 =  EnemyNear,moveType = H 
trigger1 = EnemyNear,pos Y = [-150,-90]
trigger1 = P2BodyDist X = [0,60]
trigger1 = random <= 700 
trigger2 =  EnemyNear,moveType != H 
trigger2 = EnemyNear,pos y <= -70
trigger2 = random >= 700
Trigger2 =  (var(58) < 5 &&  random <= 400)
trigger2 = TeamMode = single || TeamMode = simul
trigger3 =  EnemyNear,moveType != H 
trigger3 = P2BodyDist X = [0,60]
trigger3 = var(59) >= 4
trigger3 = var(25) = 0
Trigger3 = var(58) < 8 &&  random <= 400
trigger3 = TeamMode = single || TeamMode = simul
trigger4 = EnemyNear,pos y <= -70
trigger4 = random >= 700
Trigger4 = ((TeamMode = turns) && (var(58) < 2))
trigger4 =  EnemyNear,moveType != H 
trigger5 = var(59) >= 4
trigger5 = var(25) = 1
trigger5 = EnemyNear,pos y = [-150,-80]
trigger5 = EnemyNear,vel y = [-2,0.5]

[State -1, Jump];ői
type = ChangeState
value = 40
triggerall = (Statetype != A) && (ctrl) &&  var(59) >= 4 && var(30) = 0
triggerall = EnemyNear,Alive
triggerall = var(25) = 0 || (var(26) <= 200 && EnemyNear,life > lifemax/2)
trigger1 = EnemyNear,StateType = C
trigger1 = P2BodyDist X = [0,60]
trigger1 = var(59) >= 4 &&  random <= 400
Trigger1 = ((TeamMode = turns) && (var(58) < 2))
trigger2 = (var(59) >= 5 ) || (var(59) = 4 &&  random <= 200)
trigger2 = EnemyNear,stateType = C
trigger2 = (P2BodyDist X = [0, 70])
;trigger2 = NumHelper(1001) >= 1
trigger2 = EnemyNear,StateNo = [150,155]

;---------------------------------------------------------

[State -1, Roll Attack Air];ői
type = ChangeState
value = 1004
TriggerAll= var(59) >= 5 || (var(59) = 4 &&  random <= 200)
TriggerAll= var(30) = 0
triggerall = var(25) = 0 || (var(26) <= 400 && EnemyNear,life > lifemax/2)
triggerall = (Statetype = A) && (ctrl) &&  EnemyNear,Alive
triggerall = !InGuardDist
triggerall = !(var(29) >0 && var(59)  >= 5)
trigger1 = (EnemyNear,stateType = S &&  random <= 200) || EnemyNear,stateType = C
trigger1 = (EnemyNear,StateNo = [120,159])
trigger1 = (P2BodyDist X = [0, 120])  &&  (P2BodyDist y = [-80, 80])
trigger1 = pos y >-80

[State -1, Ⴊ݋j];󒆃K[h
type = ChangeState
value = 450
TriggerAll= var(59) >= 5 || (var(59) = 4 &&  random <= 200)
TriggerAll= var(30) = 0
triggerall = var(25) = 0 || (var(26) <= 300)
triggerall = (Statetype = S) && (Statetype = C) && (ctrl) &&  EnemyNear,Alive
triggerall = !InGuardDist
trigger1 = EnemyNear,pos y > -2
trigger1 = (EnemyNear,StateNo = [120,159])
trigger1 = (P2BodyDist X = [0, 120])  &&  (P2BodyDist y = [-120, 0])

[State -1, J-SP];Wvo
type = ChangeState
value = 620
TriggerAll= var(59) >= 5 || (var(59) = 4 &&  random <= 200)
triggerall = (Statetype = A) && (ctrl) &&  EnemyNear,Alive
triggerall = !InGuardDist
trigger1 = EnemyNear,moveType != H
trigger1 = (P2BodyDist X = [10, 220])  &&  (P2BodyDist y = [50, 180])
trigger1 =  vel y>0  && pos y < -150

;Jump Medium Kick;AI
[State -1, Wvj]
type = ChangeState
value = 640
TriggerAll=var(59) >= 3  && var(30) = 0
TriggerAll=StateType = A
TriggerAll=EnemyNear,Alive
TriggerAll=P2BodyDist X <= 60
TriggerAll=(P2BodyDist Y = [-30, 60])
Triggerall = ctrl
Triggerall = vel y>0;(~)
trigger1 = var(8) = 0
trigger2 = EnemyNear,StateType = C

[State -1,WvP]
Type = ChangeState
value = 620
TriggerAll=var(59) >  1
TriggerAll = StateType=A
TriggerAll = Ctrl
Trigger1 = P2BodyDist X = [50,70]
Trigger1 =P2BodyDist y = [-30,60]
Trigger1 = vel y>0;(~)

[State -1,d]
type = ChangeState
TriggerAll=var(59) >= 6 
triggerall = RoundState = 2
triggerall = StateType != A
triggerall = EnemyNear,StateType != L
Triggerall = !inguarddist
triggerall = P2bodydist X = [0,80]
triggerall = P2bodydist Y = [0,100]
triggerall = Ctrl 
triggerall = var(25) = 0
trigger1 = EnemyNear,stateType = S || (EnemyNear,stateType = C &&  random <= 300)
trigger1 = (EnemyNear,StateNo = [120,159])
value = 430

[State -1,d2]
type = ChangeState
TriggerAll=var(59) >= 6
triggerall = RoundState = 2
triggerall = StateType != A
triggerall = EnemyNear,StateType != L
Triggerall = !inguarddist
triggerall = P2bodydist X = [80,140]
triggerall = P2bodydist Y = [0,100]
triggerall = Ctrl 
triggerall = var(25) = 0
trigger1 = EnemyNear,stateType = S || (EnemyNear,stateType = C &&  random <= 300)
trigger1 = (EnemyNear,StateNo = [120,159])
value = 440

;Eye Projectile-Air
[State -1, Mystic Stare]
type = ChangeState
value = 1010
TriggerAll=var(59)  >= 2
triggerall = var(6) = 0
triggerall = (Statetype = A)
TriggerAll=Ctrl
triggerall = prevstateno != 1010
triggerall = stateno != 1010
triggerall = numhelper(9920) = 0 && numhelper(9923) = 0 && numhelper(9925) = 0
triggerall = numhelper(9911) = 0 && numhelper(9912) = 0 && numhelper(9913) = 0
triggerall = NumHelper(1001) = 0
triggerall = var(30) = 0
triggerall = pos y <= -70
triggerall = var(25) = 0
Triggerall = vel y>-3
Triggerall=!(helper(30020),var(58)=1000|| helper(30020),var(58)=10000||helper(30020),var(58)=100000)
trigger1 = (P2BodyDist X = [90, 120])
trigger1 = (P2BodyDist y = [0, 80])
trigger1 = random >= 500 
trigger2 = (P2BodyDist X = [120, 180])
trigger2 = P2BodyDist y = [-10,150]
trigger2 = pos y <= -80
trigger2 = random >= 700
trigger3 = (P2BodyDist X = [180, 240])
trigger3 = P2BodyDist y = [-10,250]
trigger3 = pos y <= -90
trigger3 = random >= 800
trigger4 = EnemyNear,MoveType != H
trigger4 = (P2BodyDist X = [0, 30])
trigger4 = P2Statetype = A
trigger4 = var(59) >= 3
Trigger4 = EnemyNear,vel y <-1


;-------ډs----------------------------------------

[State -1, Chaos Demension Grab Standing]
type = ChangeState
value = 4600
TriggerAll=var(59)  >= 2
triggerall = var(25) = 1
triggerall = (Statetype = S)
triggerall = EnemyNear,statetype = S || EnemyNear,statetype = C || EnemyNear,statetype = A
triggerall = (P2BodyDist y = [-15, 35])
triggerall = P2BodyDist X = [0, 50]
triggerall = EnemyNear,StateType != L
Triggerall = !inguarddist
triggerall = Ctrl
trigger1 = EnemyNear,getHitvar(Hitcount) >= 6
Trigger2 = var(26) > 400 || EnemyNear,life < lifemax/2 || life<lifemax/3

[State -1, Chaos Demension Grab -C1]
type = ChangeState
value = 4601
TriggerAll=var(59) >= 1
triggerall = var(25) = 1
triggerall = (Statetype = C)  || (Statetype = S) 
triggerall = EnemyNear,statetype = S || EnemyNear,statetype = C
triggerall = (P2BodyDist y = [-5, 35])
triggerall = P2BodyDist X = [0, 60]
triggerall = EnemyNear,StateType != A
triggerall = EnemyNear,StateType != L
Triggerall = !inguarddist
triggerall = Ctrl
trigger1 = EnemyNear,getHitvar(Hitcount) >= 6
Trigger2 = var(26) > 400 || EnemyNear,life < lifemax/2 || life<lifemax/3

[State -1, Chaos Demension Grab -Air]
type = ChangeState
value = 4602
TriggerAll=var(59)  >= 1
triggerall = var(25) = 1
triggerall = (Statetype = A)
triggerall = EnemyNear,statetype = S || EnemyNear,statetype = A
triggerall = (P2BodyDist y = [20, 20])
triggerall = P2BodyDist X = [0, 70]
triggerall = EnemyNear,StateType != L
Triggerall = !inguarddist
triggerall = Ctrl
trigger1 = EnemyNear,getHitvar(Hitcount) >= 5
Trigger2 = var(26) > 400 || EnemyNear,life < lifemax/2 || life<lifemax/3

[State -1,]
type = ChangeState
TriggerAll=var(59) >  0
triggerall = RoundState = 2
triggerall = StateType != A
triggerall = EnemyNear,StateType != L
Triggerall = !inguarddist
triggerall = P2bodydist X = [0,50]
triggerall = P2bodydist Y = [0,100]
triggerall = Ctrl
trigger1 = EnemyNear,MoveType = H
trigger1 = (EnemyNear,StateNo != [120,159])
value = 400


[State -1,]
type = ChangeState
TriggerAll=var(59) >  0
triggerall = RoundState = 2
triggerall = StateType != A
triggerall = EnemyNear,StateType != L
Triggerall = !inguarddist
triggerall = P2bodydist X = [0,60]
triggerall = P2bodydist Y = [0,100]
triggerall = Ctrl
trigger1 = EnemyNear,MoveType = H
trigger1 = (EnemyNear,StateNo != [120,159])
value = 430

[State -1,]
type = ChangeState
TriggerAll=var(59) >  0 
triggerall = RoundState = 2
triggerall = StateType != A
Triggerall = !inguarddist
triggerall = P2bodydist X = [0,35]
triggerall = P2bodydist Y = [-10,90]
triggerall = Ctrl
trigger1 = EnemyNear,MoveType = H
trigger1 = (EnemyNear,StateNo != [120,159])
trigger1 = EnemyNear,vel y >= 0
value = 230

[State -1,]
type = ChangeState
TriggerAll=var(59) >  0 
triggerall = RoundState = 2
triggerall = StateType != A
triggerall = P2StateType != C
triggerall = EnemyNear,StateType != L
Triggerall = !inguarddist
triggerall = P2bodydist X = [10,40]
triggerall = P2bodydist Y = [0,40]
triggerall = Ctrl
trigger1 = (EnemyNear,StateNo = [5000,5999])
Trigger1 = var(25) = 0
Trigger2 = var(25) = 1
Trigger2 = random < 100
trigger2 = P2BodyDist X = [10,90]
value = 200



[State -1,]
type = ChangeState
TriggerAll=var(59) >  0 
triggerall = RoundState = 2
triggerall = StateType != A
triggerall = EnemyNear,StateType != L
Triggerall = !inguarddist
triggerall = P2bodydist X = [0,55]
triggerall = P2bodydist Y = [-10,30]
triggerall = Ctrl
trigger1 = (EnemyNear,StateNo = [5000,5999])
value = 240


[State -1,]
type = ChangeState
TriggerAll=var(59) >  0
triggerall = RoundState = 2 
triggerall = StateType != A && var(30)
triggerall = EnemyNear,StateType != L
Triggerall = !inguarddist
triggerall = P2bodydist X = [0,100]
triggerall = P2bodydist Y = [-10,30]
triggerall = Ctrl
triggerall = (helper(30000),rootDist x  >= 70) || (helper(30010),rootDist x >= 70)
trigger1 = (EnemyNear,StateNo = [5000,5199]) 
value = 210


[State -1,]
type = ChangeState
TriggerAll=var(59) <= 2 
TriggerAll=var(59) >  0
triggerall = RoundState = 2
triggerall = StateType != A
triggerall = EnemyNear,StateType != L
Triggerall = !inguarddist
triggerall = P2bodydist X = [100,120]
triggerall = P2bodydist Y = [-10,90]
triggerall = Ctrl
trigger1 = EnemyNear,MoveType = H
trigger1 = (EnemyNear,StateNo != [120,159])
Trigger1 = random < 500
value = 220

[State -1,]
type = ChangeState
TriggerAll=var(59) <= 2 
TriggerAll=var(59) >  0
triggerall = RoundState = 2
triggerall = StateType != A
triggerall = EnemyNear,StateType != L
Triggerall = !inguarddist
triggerall = P2bodydist X = [80,160]
triggerall = P2bodydist Y = [-30,60]
triggerall = Ctrl
trigger1 = EnemyNear,MoveType = H
trigger1 = (EnemyNear,StateNo != [120,159])
Trigger1 = EnemyNear,vel x < -2
value = 250

[State -1,]
type = ChangeState
TriggerAll=var(59) >  0
triggerall = RoundState = 2
triggerall = StateType != A
triggerall = EnemyNear,StateType != L
Triggerall = !inguarddist
triggerall = P2bodydist X = [0,110]
triggerall = P2bodydist Y = [0,100]
triggerall = Ctrl 
trigger1 = EnemyNear,MoveType = H
trigger1 = (EnemyNear,StateNo != [120,159])
value = 410

[State -1,]
type = ChangeState
TriggerAll=var(59) >  0 
triggerall = RoundState = 2
triggerall = StateType != A
triggerall = EnemyNear,StateType != L
Triggerall = !inguarddist
triggerall = P2bodydist X = [0,140]
triggerall = P2bodydist Y = [0,100]
triggerall = Ctrl 
trigger1 = EnemyNear,MoveType = H
trigger1 = (EnemyNear,StateNo != [120,159])
value = 440




;----nȂ---------------------------------------------



[State -1, Devitalization];fBoC^[[V
type = ChangeState
value = 3600
TriggerAll= var(59) >=  4
triggerall = (Statetype != A)
triggerall = var(25) =  0 && var(30) = 0
TriggerAll= movehit && random <= 300
TriggerAll=P2BodyDist X = [61,70]
triggerall = EnemyNear,StateType != A
triggerall = EnemyNear,StateNo != [150,155]
trigger1 = (stateno = 200) && time > 5
trigger2 = (stateno = 230) && time > 6
trigger3 = (stateno = 400) || (stateno = 430)
trigger3 = (time > 9) || (movehit && time > 5)


[State -1, Mystic Stare];ŏIS{K[hd-
type = ChangeState
value = 1000
TriggerAll= var(59) >=  5
triggerall = (Statetype != A)
triggerall = numhelper(9920) = 0 && numhelper(9923) = 0 && numhelper(9925) = 0
triggerall = NumHelper(1001) = 0
TriggerAll= moveGuarded
trigger1 = (stateno = 220) && animelemtime(7) > 0
trigger2 = (stateno = 250) && time > 8
trigger3 = (stateno = 420) || (stateno = 450)
trigger3 = (time > 12)

[State -1, Mystic Stare];ŏIS{K[hd
type = ChangeState
value = 1000
TriggerAll= var(59) >=  4
triggerall = (Statetype != A)
triggerall = numhelper(9920) = 0 && numhelper(9923) = 0 && numhelper(9925) = 0
triggerall = NumHelper(1001) = 0
triggerall = var(25) =  1
TriggerAll= moveGuarded
trigger1 = (stateno = 200) && time > 5
trigger2 = (stateno = 230) && time > 6
trigger3 = (stateno = 210) && time > 8
trigger4 = (stateno = 220) && animelemtime(7) > 0
trigger5 = (stateno = 250) && time > 8
trigger6 = (stateno = 400) || (stateno = 430) || (stateno = 410) || (stateno = 440)
trigger6 = (time > 9)
trigger7 = (stateno = 420) || (stateno = 450)
trigger7 = (time > 12) || (movecontact && time > 8)

[State -1,S-Combo-MK]
Type     = ChangeState
TriggerAll= var(59)  >= 6 && var(30) < 280
triggerall = (Statetype != A)
triggerall = numhelper(9920) = 0 && numhelper(9923) = 0 && numhelper(9925) = 0
;triggerall = NumHelper(1001) = 0
triggerall = (helper(30000),rootDist x  <= 120 && facing = 1) || (helper(30010),rootDist x <= 120 && facing = -1)
TriggerAll= movehit
TriggerAll=EnemyNear,Alive
TriggerAll=EnemyNear,MoveType=H
TriggerAll=!InGuardDist
TriggerAll=P2BodyDist X=[0,60]
Trigger1 = (StateNo=230 && time >= 8) || StateNo=210 && time >= 10
trigger1 = var(25) = 0
Trigger2 = (StateNo=230 && time >= 8) || StateNo=210 && time >= 10
trigger2 = var(25) = 1
trigger2 = var(26) < 350
trigger3 = (stateno = 410) || (stateno = 440)
trigger3 = time > 10
trigger3 = var(25) = 0
trigger4 = (stateno = 410) || (stateno = 440)
trigger4 = time > 10
trigger4 = var(25) = 1
trigger4 = var(26) < 350
value = 240



[State -1,S-Combo-MK]
Type     = ChangeState
TriggerAll=var(59) >=  6
TriggerAll=numhelper(9920)>=1||numhelper(9923)>=1||numhelper(9925)>=1||(helper(30000),rootDist x>120&&facing=1)||(helper(30010),rootDist x>120&&facing=-1)
TriggerAll=StateType != A
TriggerAll=EnemyNear,Alive
TriggerAll=EnemyNear,MoveType=H
TriggerAll=!InGuardDist
TriggerAll=P2BodyDist X=[0,60]
TriggerAll=Movehit
Trigger1 = StateNo=230 || StateNo=210
trigger1 = var(25) = 0
Trigger2 = StateNo=230 || StateNo=210
trigger2 = var(25) = 1
trigger2 = var(26) < 350
trigger3 = (stateno = 410) || (stateno = 440)
trigger3 = time > 5
trigger3 = var(25) = 0
trigger4 = (stateno = 410) || (stateno = 440)
trigger4 = time > 5
trigger4 = var(25) = 1
trigger4 = var(26) < 350
value = 240

[State -1,S-Combo-MK]
Type     = ChangeState
TriggerAll=var(59) >=  1 && var(59) <=  5
TriggerAll=StateType != A
TriggerAll=EnemyNear,Alive
TriggerAll=EnemyNear,MoveType=H
TriggerAll=!InGuardDist
TriggerAll=P2BodyDist X=[0,60]
TriggerAll=Movehit
Trigger1 = StateNo=230 || StateNo=210
trigger1 = var(25) = 0
Trigger2 = StateNo=230 || StateNo=210
trigger2 = var(25) = 1
trigger2 = var(26) < 350
trigger3 = (stateno = 410) || (stateno = 440)
trigger3 = time > 5
trigger3 = var(25) = 0
trigger4 = (stateno = 410) || (stateno = 440)
trigger4 = time > 5
trigger4 = var(25) = 1
trigger4 = var(26) < 350
value = 240

[State -1,S-Combo-SP];xT
Type     = ChangeState
TriggerAll=var(59) >=  5 
TriggerAll=StateType != A
TriggerAll=EnemyNear,Alive
TriggerAll=!InGuardDist
TriggerAll= movecontact
TriggerAll=P2BodyDist X = [71,140]
Triggerall = StateNo=210 && time > 8
trigger1 = var(25) = 0
trigger2 = FrontEdgeBodyDist < 150
trigger2 = var(25) = 1
value = 220

[State -1,S-Combo-SK]
Type     = ChangeState
TriggerAll= (var(59) =  3) || (var(59) =  4)
TriggerAll=StateType != A
TriggerAll=EnemyNear,Alive
TriggerAll=EnemyNear,MoveType=H
TriggerAll=!InGuardDist
TriggerAll= movehit
triggerall = TeamMode = Single || TeamMode = turns
TriggerAll= (P2BodyDist X = [61,160]) || EnemyNear,stateType= A
Trigger1 = StateNo=210 && time > 8
value = 250


[State -1,C-Combo-LP]
Type     = ChangeState
TriggerAll=var(59) >  1 
TriggerAll=StateType != A
TriggerAll=EnemyNear,Alive
TriggerAll=EnemyNear,MoveType=H
TriggerAll=!InGuardDist
TriggerAll=P2BodyDist X = [0,65]
TriggerAll=MoveGuarded
trigger1 = stateno = 200 
trigger1 = random <= 100
trigger2 = stateno = 230
trigger2 = random <= 100
trigger3 = (stateno = 430)
trigger3 = (time > 9) || (movehit && time > 5)
value = 400

[State -1,C-Combo-LK]
Type     = ChangeState
TriggerAll=var(59) >  1 
TriggerAll=StateType != A
TriggerAll=EnemyNear,Alive
TriggerAll=EnemyNear,MoveType=H
TriggerAll=!InGuardDist
TriggerAll=P2BodyDist X = [0,80]
TriggerAll=MoveGuarded
trigger1 = stateno = 200 
trigger1 = random <= 100
trigger2 = stateno = 230
trigger2 = random <= 100
trigger3 = (stateno = 400)
trigger3 = (time > 9) || (movehit && time > 5)
value = 430

[State -1, Roll Attack Ground]
type = ChangeState
value = 1003
TriggerAll=var(59)  >= 4 || (var(59)  = 3 && random <= 300)
triggerall = (Statetype != A)  &&  EnemyNear,Alive
triggerall = (EnemyNear,StateNo != [120,159])
triggerall = !InGuardDist
triggerall =  (EnemyNear,stateno = [5000,5999]) && P2BodyDist X = [61, 100]
TriggerAll= movehit
TriggerAll= var(25) = 0 
triggerall =  EnemyNear,GetHitVar(yvel) > -2
triggerall = !(var(29) >0 && var(59)  >= 5)
trigger1 = (stateno = 210) && time > 8
trigger2 = (stateno = 220) && animelemtime(7) > 0
trigger3 = (stateno = 250) && time > 25
trigger4 = (stateno = 400) || (stateno = 430) || (stateno = 410) || (stateno = 440)
trigger4 = (time > 9) || (movehit && time > 5)

[State -1,C-Combo-MK]
Type     = ChangeState
TriggerAll=var(59) >  2 
TriggerAll=StateType != A
TriggerAll=EnemyNear,Alive
TriggerAll=EnemyNear,MoveType=H
TriggerAll=!InGuardDist
TriggerAll=P2BodyDist X = [60,160]
TriggerAll=movecontact
trigger1 = (stateno = 410) || (stateno = 440)
trigger1 = (time > 9) || (movehit && time > 5)
value = 420

[State -1,S-Combo-LK]
Type     = ChangeState
TriggerAll=var(59) >  0 
TriggerAll=StateType != A
TriggerAll=EnemyNear,Alive
TriggerAll=EnemyNear,MoveType=H
TriggerAll=!InGuardDist
TriggerAll=P2BodyDist X=[0,55]
TriggerAll=movehit
Trigger1 = StateNo=200
value = 230

[State -1,S-Combo-MP]
Type     = ChangeState
TriggerAll=var(59) >  0 
TriggerAll=StateType != A
TriggerAll=EnemyNear,Alive
TriggerAll=EnemyNear,MoveType=H
TriggerAll=!InGuardDist
TriggerAll=P2BodyDist X=[0,120]
TriggerAll=movehit
Triggerall = var(25) = 0
Trigger1 = StateNo=200
Trigger2 = StateNo=230
value = 210

[State -1,C-Combo-MP]
Type     = ChangeState
TriggerAll=var(59) >  0 
TriggerAll=StateType != A
TriggerAll=EnemyNear,Alive
TriggerAll=EnemyNear,MoveType=H
TriggerAll=!InGuardDist
TriggerAll=P2BodyDist X = [0,135]
TriggerAll=EnemyNear,pos y=[0,40]
TriggerAll=movehit
trigger1 = (stateno = 400) || (stateno = 430)
trigger1 = (time > 9) || (movehit && time > 5)
value = 410

[State -1,C-Combo-LK]
Type     = ChangeState
TriggerAll=var(59) >= 6 
TriggerAll=StateType != A
TriggerAll=EnemyNear,Alive
TriggerAll=EnemyNear,MoveType=H
TriggerAll=!InGuardDist
TriggerAll=P2BodyDist X = [0,80]
TriggerAll=!movecontact
triggerall = var(25) = 0
trigger1 = (stateno = 210)
trigger1 = (time < 3)
trigger1 = EnemyNear,pos y > -20
trigger1 = var(30)>50 ||  var(32)>50
value = 430

[State -1,C-Combo-MK]
Type     = ChangeState
TriggerAll=var(59) >= 6 
TriggerAll=StateType != A
TriggerAll=EnemyNear,Alive
TriggerAll=EnemyNear,MoveType=H
TriggerAll=!InGuardDist
TriggerAll=P2BodyDist X = [70,160]
TriggerAll=!movecontact
triggerall = var(25) = 0
trigger1 = (stateno = 210)
trigger1 = (time < 3)
trigger1 = EnemyNear,pos y > -50
trigger1 = var(30)>50 ||  var(32)>50
value = 440

[State -1,C-Combo-MK]
Type     = ChangeState
TriggerAll=var(59) >  0 
TriggerAll=StateType != A
TriggerAll=EnemyNear,Alive
TriggerAll=EnemyNear,MoveType=H
TriggerAll=!InGuardDist
TriggerAll=P2BodyDist X = [0,160]
TriggerAll=movehit
trigger1 = (stateno = 400) || (stateno = 430)
trigger1 = (time > 9) || (movehit && time > 5)
value = 440



;^^^^^^󒆖ډAGACu

[State -1,ChaosDemention]
type = ChangeState
TriggerAll=var(59) > 2
triggerall = RoundState = 2
triggerall = StateType = A
triggerall = P2bodydist X = [-10,70]
triggerall = P2bodydist Y = [-30,20]
triggerall = Ctrl ;|| (stateno = 50 && prevstateno != 4016)
triggerall = var(25) = 1
Trigger1 = var(26) > 300 || EnemyNear,life < lifemax/2 || life<lifemax/2
Trigger2 = var(30) >= 80 || var(32) >= 80 || EnemyNear,getHitvar(Hitcount) >= 4
value = 4602

[State -1, beam] ;r|AI- `JŃV!!A~XeBbNELm
type = ChangeState
value = 9180
TriggerAll=var(59) >= 2
triggerall =  (power >= 2000)  &&  EnemyNear,Alive
TriggerAll=EnemyNear,stateno = [5000,5999]
triggerall = Ctrl
Trigger1 = EnemyNear,vel y<0
trigger1 = movehit  && stateno = 620 
trigger1 = P2BodyDist y >= 0
trigger1 = P2BodyDist x >=0 

[State -1,JLP]
type = ChangeState
TriggerAll=var(59) >= 5 &&var(30) >= 1
triggerall = RoundState = 2
triggerall = StateType = A
triggerall = EnemyNear,StateType = A
TriggerAll=(EnemyNear,stateno = [5000,5999])||(EnemyNear,stateno = [670,675])
TriggerAll=(P2BodyDist X = [-30,60])
triggerall = Ctrl
triggerall =   EnemyNear,vel y > -1
Trigger1 = P2BodyDist Y >= 30
Trigger1 = vel y <= -3
value = 1005

[State -1, A-Combo-SP];G
type = ChangeState
value = 620
TriggerAll=var(59) >= 5
TriggerAll=StateType = A
TriggerAll=EnemyNear,Alive
TriggerAll=(P2BodyDist X = [0,100])
TriggerAll=(P2BodyDist Y=[-140, -40])
triggerall = Ctrl
triggerall = (var(25) = 0) && var(30) > 140
triggerall = vel y > -2
Trigger1 = prevStateNo=600
Trigger2 = prevStateNo=610
Trigger3 = StateNo=50

[State -1,JLP]
type = ChangeState
TriggerAll=var(59) >= 5 &&var(30) >= 1
triggerall = RoundState = 2
triggerall = StateType = A
triggerall = EnemyNear,StateType = A
TriggerAll=(EnemyNear,stateno = [5000,5999])||(EnemyNear,stateno = [670,675])
TriggerAll=(P2BodyDist X = [-10,70])
triggerall = Ctrl
triggerall =   EnemyNear,vel y > -2
Trigger1 = P2BodyDist Y >= 30
Trigger1 = vel y > -3
value = 620

[State -1,JLP]
type = ChangeState
TriggerAll=var(59) >= 2
triggerall = RoundState = 2
triggerall = StateType = A
triggerall = EnemyNear,StateType = A
triggerall = P2bodydist X = [-10,15]
triggerall = (P2bodydist Y = [-60-floor(var(30)*0.6),0])
triggerall = Ctrl
trigger1 =   EnemyNear,stateno = [5000,5999]
value = 600

[State -1,JLK]
type = ChangeState
TriggerAll=var(59)  >= 2
triggerall = RoundState = 2
triggerall = StateType = A
triggerall = P2bodydist X = [-10,30]
triggerall = (P2bodydist Y = [-10-floor(var(30)*0.6),20])
triggerall = Ctrl
trigger1 = EnemyNear,stateno = [5000,5999]
value = 630

[State -1,JMK]
type = ChangeState
TriggerAll=var(59) >  0; && var(30) = 0
triggerall = RoundState = 2
triggerall = StateType = A
triggerall = P2bodydist X = [-60,-60]
triggerall = P2bodydist Y = [-30-floor(var(30)*0.6), 40]
triggerall = Ctrl 
;triggerall = var(7) = 0
trigger1 = EnemyNear,stateno = [5000,5999]
value = 640

[State -1,JMP]
type = ChangeState
TriggerAll= var(59) >  0; && var(30) = 0
triggerall = RoundState = 2
triggerall = StateType = A
triggerall = P2bodydist X = [50,80]
triggerall = P2bodydist Y = [-70,20]
triggerall = Ctrl 
;triggerall = var(7) = 0
trigger1 = EnemyNear,stateno = [5000,5999]
value = 610



[State -1,JSP]
type = ChangeState
TriggerAll=var(59)  >= 2
triggerall = RoundState = 2
triggerall = StateType = A
triggerall = P2bodydist X = [0,60]
triggerall = P2bodydist Y = [-50,-50]
triggerall = Ctrl
trigger1 = EnemyNear,stateno = [5000,5999]
trigger2 = numhelper(9920) >= 1 || numhelper(9923) >= 1 || numhelper(9925) >= 1
value = 620


[State -1,JSK]
type = ChangeState
TriggerAll=var(59)  >= 2
triggerall = RoundState = 2
triggerall = StateType = A
triggerall = P2bodydist X = [95,130]
triggerall = P2bodydist Y = [20,80]
triggerall = Ctrl 
triggerall =  EnemyNear,GetHitVar(fall.recovertime) >= 15
trigger1 = EnemyNear,stateno = [5000,5999]
value = 650



;------GACuAȂ-Air Combo ---------------

[State -1,ChaosDemention]
type = ChangeState
value = 4602
TriggerAll=var(59) > 2
TriggerAll=StateType = A
TriggerAll=EnemyNear,Alive
TriggerAll=(P2BodyDist X = [0,75])
;TriggerAll=(P2BodyDist Y=[-30, 35])
TriggerAll=movecontact
triggerall = (var(25) = 1)
Trigger1 = StateNo=600
Trigger1 = (var(26) = [400,550]) || var(30) >= 150 || var(32) >= 150 || EnemyNear,getHitvar(Hitcount) >= 4
Trigger2 = StateNo=630
Trigger2 = (var(26) = [400,550]) || var(30) >= 150 || var(32) >= 150 || EnemyNear,getHitvar(Hitcount) >= 4
Trigger3 = StateNo=640;tR{
Trigger3 = prevStateNo=610 || var(30) >= 80 || var(32) >= 80 || EnemyNear,getHitvar(Hitcount) >= 6
Trigger4 = StateNo=610;tR{
Trigger4 = prevStateNo=640 || var(30) >= 80 || var(32) >= 80 || EnemyNear,getHitvar(Hitcount) >= 6
Trigger5 = StateNo=640;ԂɍȂꍇ
Trigger5 = (var(26) = [400,550]) || var(30) >= 80 || var(32) >= 80 || EnemyNear,getHitvar(Hitcount) >= 4
Trigger6 = StateNo=610;ԂɍȂꍇ
Trigger6 = (var(26) = [400,550]) || var(30) >= 80 || var(32) >= 80 || EnemyNear,getHitvar(Hitcount) >= 4
Trigger7 =  var(26) > 400 || EnemyNear,life < lifemax/2 || life<lifemax/2
Trigger7 = (StateNo= [600,640]) && StateNo !=620

[State -1,ChaosDemention];\
type = ChangeState
value = 4602
TriggerAll=var(59) > 2
TriggerAll=StateType = A
TriggerAll=EnemyNear,Alive
triggerall = (var(25) = 1)
TriggerAll=(P2BodyDist X = [0,75])
TriggerAll=(P2BodyDist Y=[-30, 35])
Trigger1 = StateNo=620 && time < 4

[State -1, laser] ;r|-Ȃ
type = ChangeState
value = 9180
TriggerAll=var(59) >= 6
triggerall =(power >= 2000)
triggerall = StateType = A
triggerall = RoundState = 2
TriggerAll=(P2BodyDist Y=[-90, -10])
triggerall = (var(25) = 0)
triggerall = (helper(30000),rootDist x  >= 280 && facing = 1) || (helper(30010),rootDist x >= 280 && facing = -1)
triggerall = EnemyNear,vel y < -4
trigger1 = movehit
trigger1 = stateno = 620 
trigger2 = prevstateno = 620 
trigger2 = stateno = 50 

[State -1, A-Combo-SP];r[O
type = ChangeState
value = 620
TriggerAll=var(59) >= 6
TriggerAll=StateType = A
TriggerAll=EnemyNear,Alive
triggerall = power >= 4300 || (power >= 2000&&(EnemyNear,life<lifemax*0.3))
TriggerAll=(P2BodyDist X = [0,70])
TriggerAll=(P2BodyDist Y=[-70, 60])
TriggerAll=movecontact
triggerall = var(30) < 100
triggerall = (var(25) = 0)
triggerall = (helper(30000),rootDist x  >= 280 && facing = 1) || (helper(30010),rootDist x >= 280 && facing = -1)
Trigger1 = StateNo=610
Trigger1 = prevStateNo=640
Trigger2 = StateNo=640
Trigger2 = prevStateNo=610

[State -1, AirRock];ƍx
type = ChangeState
value = 1005
TriggerAll= ( var(59) >= 6 ) && var(30) > 80
TriggerAll=StateType = A
TriggerAll=EnemyNear,Alive
TriggerAll=EnemyNear,stateno = [5000,5999]
TriggerAll=(P2BodyDist X = [-30,40])
TriggerAll= P2BodyDist Y >= -20
TriggerAll=movecontact
triggerall = (helper(30000),rootDist x  < 80 && facing = 1) || (helper(30010),rootDist x < 80 && facing = -1)
triggerall = EnemyNear,StateType = A
Trigger1 = StateNo=610
Trigger1 = prevStateNo=640 || P2BodyDist Y >= 30
Trigger2 = StateNo=640
Trigger2 = prevStateNo=610 || P2BodyDist Y >= 30

[State -1, AirRock];x
type = ChangeState
value = 1005
TriggerAll= ( var(59) >= 5 )
TriggerAll=StateType = A
TriggerAll=EnemyNear,Alive
TriggerAll=EnemyNear,stateno = [5000,5999]
TriggerAll=(P2BodyDist X = [-30,40])
TriggerAll= P2BodyDist Y >= -20
TriggerAll=movecontact
Triggerall = var(30) >= 1
triggerall = (helper(30000),rootDist x  > 280 && facing = 1) || (helper(30010),rootDist x > 280 && facing = -1) || var(32) > 80
triggerall = numhelper(9920) >= 1 || numhelper(9923) >= 1 || numhelper(9925) >= 1
triggerall = EnemyNear,StateType = A
Trigger1 = StateNo=610
Trigger1 = prevStateNo=640
Trigger2 = StateNo=640
Trigger2 = prevStateNo=610

[State -1,K];z
type = ChangeState
value = 4015
TriggerAll=var(59) >= 3
TriggerAll=StateType = A
TriggerAll=EnemyNear,Alive
TriggerAll=EnemyNear,StateNo != [150,155]
TriggerAll=(P2BodyDist X = [-10,50])
TriggerAll=(P2BodyDist Y=[-30, 20]);-30,20
Triggerall = var(30) >= 20 || var(32) >= 20 || EnemyNear,life < 140
Triggerall = (var(25) = 0)
triggerall = (helper(30000),rootDist x  > 280 && facing = 1) || (helper(30010),rootDist x > 280 && facing = -1)
triggerall = numhelper(9920) = 0 && numhelper(9923)  = 0 && numhelper(9925)  = 0
Trigger1 = StateNo=610
Trigger1 = prevStateNo=640
Trigger1=movecontact
Trigger2 = StateNo=640
Trigger2 = prevStateNo=610
Trigger2=movecontact
Trigger3 = StateNo=1005
Trigger3= !movecontact
Trigger3= time < 10

[State -1, AirRock]
type = ChangeState
value = 1005
TriggerAll=var(59) >= 2 && var(59) < 6
TriggerAll=StateType = A
TriggerAll=EnemyNear,Alive
TriggerAll=EnemyNear,stateno = [5000,5999]
TriggerAll=(P2BodyDist X = [0,60])
TriggerAll= P2BodyDist Y >= -20
TriggerAll=movecontact
Triggerall = var(30) = [1,50]
triggerall = P2StateType = A
trigger1 = stateno = 640
Trigger2 = StateNo=610

[State -1, A-Combo-MK]
type = ChangeState
value = 640
TriggerAll=var(59) >= 2
TriggerAll=StateType = A
TriggerAll=EnemyNear,Alive
TriggerAll=(P2BodyDist X = [-75,75]);[-55,55]
TriggerAll=(P2BodyDist Y=[-60, 70]);[-30, 50]
TriggerAll=movecontact
triggerall = time < 15
Trigger1 = StateNo=630
Trigger2 = StateNo=600
Trigger3 = StateNo=610
trigger3 = var(8) = 0

[State -1, A-Combo-MP]
type = ChangeState
value = 610
TriggerAll=var(59) >= 2
TriggerAll=StateType = A
TriggerAll=EnemyNear,Alive
TriggerAll=(P2BodyDist X = [0,75])
TriggerAll=(P2BodyDist Y=[-70, 45])
TriggerAll=movecontact
triggerall = time < 15
Trigger1 = StateNo=600
Trigger2 = StateNo=630
Trigger3 = StateNo=640
trigger3 = var(7) = 0

[State -1, A-Combo-SP];JIfB
type = ChangeState
value = 620
TriggerAll=var(59) >= 2
TriggerAll=StateType = A
TriggerAll=EnemyNear,Alive
TriggerAll=(P2BodyDist X = [0,70])
TriggerAll=(P2BodyDist Y=[40, 60])
TriggerAll=movecontact
triggerall = time < 15
triggerall = (var(25) = 1)
triggerall = numhelper(9920) = 0 && numhelper(9923)  = 0 && numhelper(9925)  = 0
Trigger1 = StateNo=610
Trigger1 = prevStateNo=640
Trigger2 = StateNo=640
Trigger2 = prevStateNo=610
Trigger3 = (StateNo= [600,640]) && StateNo != 620 
Trigger3 =(P2BodyDist Y=[-10, -40])


[State -1, A-Combo-SP];JIfB
type = ChangeState
value = 620
TriggerAll=var(59) >= 2
TriggerAll=StateType = A
TriggerAll=EnemyNear,Alive
TriggerAll=(P2BodyDist X = [0,70])
TriggerAll=(P2BodyDist Y=[-70, 60])
TriggerAll=movecontact
triggerall = time < 15
;ptriggerall = numhelper(9920) = 0 && numhelper(9923)  = 0 && numhelper(9925)  = 0
triggerall = FrontEdgeBodyDist <= 200
triggerall = (var(25) = 0)
triggerall = (helper(30000),rootDist x  <= 280 && facing = 1) || (helper(30010),rootDist x <= 280 && facing = -1)
Trigger1 = StateNo=610
Trigger1 = prevStateNo=640
Trigger2 = StateNo=640
Trigger2 = prevStateNo=610
Trigger3 = (StateNo= [600,640]) && StateNo != 620 
Trigger3 =(P2BodyDist Y=[-70, -40])

[State -1, A-Combo-SP];G
type = ChangeState
value = 620
TriggerAll=var(59) >= 5 && var(30) >= 150
;TriggerAll=StateType = A
;TriggerAll=EnemyNear,Alive
TriggerAll=(P2BodyDist X = [-20,120])
TriggerAll=(P2BodyDist Y=[-140, -40])
TriggerAll = time <= 5;movecontact
triggerall = (var(25) = 0)
triggerall = pos y < -200
;triggerall = (helper(30000),rootDist x  > 90 && facing = 1) || (helper(30010),rootDist x > 90 && facing = -1)
Trigger1 = stateno=600
Trigger2 = StateNo=610
Trigger3 = StateNo=630
Trigger4 = StateNo=640

;-------ZU-X[p[R{A----------------------------




;Chaos Demension Grab
[State -1, Chaos Demension Grab Standing]
type = ChangeState
value = 4600
triggerall = var(25) = 1
triggerall = (Statetype = S)
triggerall = EnemyNear,StateType != L
triggerall = (P2BodyDist y = [-15, 35])
triggerall = P2BodyDist X = [0, 65]
triggerall = ctrl
trigger1 = var(59) >=2
Trigger1 = var(26) > 300 || (EnemyNear,life < lifemax/2) || (life<lifemax/2)
trigger2 = var(59) >3
trigger2 = (EnemyNear,StateNo = [120,159])
trigger3 = var(59) =1 && (random < 100)
trigger3 = life<lifemax/4
trigger4 = var(59) >4
trigger4 = EnemyNear,getHitvar(Hitcount) >= 8
trigger5 = var(59) = 3

;Chaos Demension Grab
[State -1, Chaos Demension Grab Crouch punch/Air]
type = ChangeState
value = 4602
triggerall = var(25) = 1
triggerall = (Statetype = A)
triggerall = P2BodyDist y = [10, 25]
triggerall = P2BodyDist X = [0, 80]
triggerall = EnemyNear,StateType != L
triggerall = ctrl
trigger1 = var(59) >=2
Trigger1 = var(26) > 300 || (EnemyNear,life < lifemax/2) || (life<lifemax/2)
trigger2 = var(59) >3
trigger2 = (EnemyNear,StateNo = [120,159])
trigger3 = var(59) =1 && (random < 100)
trigger3 = life<lifemax/4
trigger4 = var(59) >4
trigger4 = EnemyNear,getHitvar(Hitcount) >= 8
trigger5 = var(59) = 3

;Chaos Demension Grab
[State -1, Chaos Demension Grab Crouch kick]
type = ChangeState
value = 4601
triggerall = var(25) = 1
triggerall =  (Statetype = C)
triggerall = (P2BodyDist y = [0, 35])
triggerall = P2BodyDist X = [0, 80]
triggerall = EnemyNear,StateType != L
triggerall = ctrl
trigger1 = var(59) >=2
Trigger1 = var(26) > 300 || (EnemyNear,life < lifemax/2) || (life<lifemax/2)
trigger2 = var(59) >3
trigger2 = (EnemyNear,StateNo = [120,159])
trigger3 = var(59) =1 && (random < 100)
trigger3 = life<lifemax/4
trigger4 = var(59) >4
trigger4 = EnemyNear,getHitvar(Hitcount) >= 8
trigger5 = var(59) = 3

[State -1, Mystic Smash Hyper];xRȏ^bOp
type = ChangeState
value = 3000
TriggerAll=var(59) >=3
triggerall = var(13) = 0
TriggerAll=Ctrl
triggerall = (Statetype = S) || (Statetype = C) &&  EnemyNear,Alive
triggerall = power >= 1000
triggerall = var(25) = 0
trigger1 =  (P2BodyDist X > 50) && (random <= 500)
trigger1 = TeamMode = simul

;Seperation Attack
[State -1, Mystic Smash Hyper];ǂł
type = ChangeState
value = 3000
TriggerAll=var(59)  >= 3
triggerall = var(13) = 0
TriggerAll=Ctrl
triggerall = (Statetype = S)  &&  EnemyNear,Alive
triggerall = power >= 1000
triggerall = var(25) = 0
triggerall = EnemyNear,movetype = H
triggerall = (EnemyNear,StateNo != [120,159])
triggerall = EnemyNear,vel y>=0
trigger1 =  (P2BodyDist X = [0, 50]) 
trigger1 = var(59) >= 5 || (var(59) = 4 &&  random <= 600) ||(var(59) = 3 && random <= 100)
trigger1 =   ((EnemyNear,pos y = [-60, -20]) && EnemyNear,vel y<2) || ((EnemyNear,pos y = [-110, -70]) && EnemyNear,vel y>=2)
trigger1  = (EnemyNear,life < lifemax/9) || var(30) > 80 || var(32) > 120 || power >= 4000
trigger2 =  (P2BodyDist X = [50, 90])
trigger2 = var(59) >= 5 || (var(59) = 4 &&  random <= 600) ||(var(59) = 3 && random <= 100)
trigger2 = ((EnemyNear,pos y = [-100, -60]) && EnemyNear,vel y<2) || ((EnemyNear,pos y = [-140, -90]) && EnemyNear,vel y>=2)
trigger2  = (EnemyNear,life < lifemax/9) || var(30) > 80 || var(32) > 120 || power >= 4000
trigger3 =  (P2BodyDist X  = [-120, -180]) 
trigger3 = (EnemyNear,pos y  = [-170, -120])
trigger3 = var(59) >= 5 || (var(59) = 4 &&  random <= 600) ||(var(59) = 3 && random <= 100)
trigger3  = (EnemyNear,life < lifemax/9) || var(30) > 120 || var(32) > 160 || power >= 4000
trigger4 =  (P2BodyDist X >180)
trigger4 = (EnemyNear,pos y  = [-200, -160])
trigger4 = (EnemyNear,vel y  = [-1, 2])
trigger4 = var(59) >= 5 || (var(59) = 4 &&  random <= 600) ||(var(59) = 3 && random <= 100)
trigger4  = (EnemyNear,life < lifemax/9) || var(30) > 120 || var(32) > 160 || power >= 4000
trigger5 =  (P2BodyDist X >180) ;trigger4⏕
trigger5 = (EnemyNear,pos y  <= -200)
trigger5 = (EnemyNear,vel y  > 2)
trigger5 = var(59) >= 5 || (var(59) = 4 &&  random <= 600) ||(var(59) = 3 && random <= 100)
trigger5  = (EnemyNear,life < lifemax/9) || var(30) > 120 || var(32) > 160 || power >= 4000

;Devitalization
[State -1, Devitalization]
type = ChangeState
value = 3600
TriggerAll=var(59)  >= 4 && random <= 300
triggerall = (Statetype != A) && var(30) = 0
triggerall = p2statetype != L  &&  EnemyNear,Alive
TriggerAll=Ctrl
triggerall = EnemyNear,StateType != A
triggerall = EnemyNear,StateNo != [150,155]
trigger1 = (P2BodyDist X = [16, 60]) 
trigger1 = (P2BodyDist y = [-10, 20])
trigger1 = var(25) = 0

;Energy Drain
[State -1, Energy Drain]
type = ChangeState
value = 4015
TriggerAll=var(59)  >= 3
triggerall = var(14) = 0
triggerall = var(30) = 0
triggerall = p2statetype != L
TriggerAll=Ctrl
triggerall = var(6) = 0
triggerall = EnemyNear,StateNo != [150,155]
triggerall = (P2BodyDist y = [-5, 20])
triggerall = var(25) = 0
trigger1 = life<lifemax/1.3
trigger1 = (P2BodyDist X = [0, 15]) 
trigger2 = TeamMode = simul
trigger2 = (P2BodyDist X = [0, 25]) 

;Energy Drain
[State -1, Energy Drain]
type = ChangeState
value = 4015
TriggerAll=var(59)  < 3
TriggerAll=var(59)  > 0
triggerall = var(14) = 0
triggerall = var(6) = 0
triggerall = p2statetype != L
TriggerAll=Ctrl
triggerall = EnemyNear,StateNo != [150,155]
trigger1 = (P2BodyDist X = [0, 10]) 
trigger1 = (P2BodyDist y = [-10, 20]) && (random > 800)
trigger1 = var(25) = 0

;Throw
[State -1, Throw]
type = ChangeState
value = 3002
TriggerAll=var(59) >  0
triggerall = P2BodyDist y = [-10, 30]
triggerall = (Statetype = S) && p2statetype != L && (ctrl) && (p2statetype != A)
triggerall = EnemyNear,StateNo != [150,155]
trigger1 =  (P2BodyDist X = [0, 10]) && random <= 300
trigger1 = var(25) = 0

[State -1, Chaos Demention Activate];JIXfBVԈڍs
type = ChangeState
value = 4603
TriggerAll=var(59) >  0
triggerall = var(25) = 0
triggerall = (Statetype = S) || (Statetype = C) 
triggerall = var(13) = 0
triggerall = EnemyNear,Alive
triggerall = power >= 3000
Triggerall = !inguarddist
TriggerAll=Ctrl
triggerall  = EnemyNear,life > lifemax/9
;triggerall = NumEnemy = 1 ;@[;Ń^bOł͎gps
trigger1 = var(59) =1
trigger1 =  (P2BodyDist X = [100, 200]) && random <= 300
trigger2 = var(59) >=2
trigger2 =  (P2BodyDist X = [0, 50]) || (EnemyNear,vel x > 2 && (P2BodyDist X = [0, 70]))
trigger2 = EnemyNear,MoveType != H ||  (EnemyNear,StateNo = [120,159])
trigger3 = var(59) >=4
trigger3 =  (P2BodyDist X = [0, 50]) || (EnemyNear,vel x > 2 && (P2BodyDist X = [0, 70]))
trigger3 = EnemyNear,MoveType = H ||  (EnemyNear,StateNo != [120,159])
trigger3 =  (EnemyNear,vel y <= 2 && EnemyNear,pos y = [-100, -30]) || (EnemyNear,vel y > 2 && (EnemyNear,pos y = [200, 100]))
Trigger3 = EnemyNear,StateType != L
trigger4 = var(59) >=2
trigger4  = EnemyNear,life < lifemax/2
trigger4 = EnemyNear,MoveType != H ||  (EnemyNear,StateNo = [120,159])
trigger5 = power >= 5000

[State -1, beam] ;r|AI-~XeBbNELm
type = ChangeState
value = 9180
TriggerAll=var(59) >=3
TriggerAll = Alive
triggerall = ctrl
triggerall =  (power >= 2000)  
triggerall = var(25) = 0
trigger1 = life< 350
trigger1 = EnemyNear,life = [350,60]
trigger1 = (P2BodyDist y = [-10, 10])
trigger1 = P2BodyDist x >= 120 
trigger1 = !var(30)
trigger1 = TeamMode =  Single &&  EnemyNear,Alive
trigger2 = (P2BodyDist y = [-10, 10])
trigger2 = P2BodyDist x >= 70 
trigger2 = TeamMode = simul
trigger2 = random < 500

;Clone Call
[State -1, Clone Call Hyper]
type = ChangeState
value = 3401
TriggerAll=var(59) <= 2
TriggerAll=var(59) >  0
triggerall = power >= 1000
triggerall = var(13) = 0
triggerall = var(25) = 0
TriggerAll=Ctrl
triggerall = statetype != A  &&  EnemyNear,Alive
triggerall = numhelper(9920) > 0 || numhelper(9923)  > 0 || numhelper(9925)  > 0
trigger1 = (EnemyNear,StateNo != [120,159])
trigger1 = (random <= 250) && (P2BodyDist y = [-120, 100]) && p2bodydist x >= 150



;-------ZU-KEZ----------------------------------------------------

;Eye Projectile
[State -1, Mystic Stare]
type = ChangeState
value = 1000
TriggerAll=var(59)  >= 3
triggerall = (Statetype != A) && (ctrl)
triggerall = prevstateno != 1000
triggerall = numhelper(9920) = 0 && numhelper(9923) = 0 && numhelper(9925) = 0
triggerall = NumHelper(1001) = 0
trigger1 = (P2BodyDist X = [60, 180])
trigger1 =  (P2BodyDist y = [-70, 40]) && random <= 500
trigger1 = (EnemyNear,vel y = [-3,4]) && (EnemyNear,vel x = [-4,4]) 
trigger1 = EnemyNear,MoveType != H ||  (EnemyNear,StateNo = [120,159])
trigger2 = EnemyNear,statetype = A
trigger2 = var(59) >= 5 || (var(59) = 4 &&  random <= 600) ||(var(59) = 3 && random <= 100)
trigger2 = EnemyNear,stateno = [5000,5999]
trigger2 =  ((EnemyNear,pos y = [-160, -110]) && (P2BodyDist X = [0, 30]))
trigger2 = EnemyNear,vel y < 2 && EnemyNear,GetHitVar(yvel) <= -2
trigger2 = var(25) = 0
trigger3 = P2BodyDist X <= 180  && random >= 800
trigger3 = !InGuardDist
trigger3 = EnemyNear,vel y> 0
trigger3 =  (P2BodyDist y = [-80, 0]) 
trigger3 = EnemyNear,MoveType != H ||  (EnemyNear,StateNo = [120,159])
trigger4 = P2BodyDist X >=60 && var(25) = 1
trigger4 = !InGuardDist  && random >= 700
trigger4 = EnemyNear,MoveType != H ||  (EnemyNear,StateNo = [120,159])
trigger5 = EnemyNear,stateType = L
trigger5 = P2BodyDist X >=80
trigger6 = TeamMode = simul
trigger6 = P2BodyDist X >=60 && var(25) = 0
Trigger7 =var(59) >= 3
Trigger7 = stateno = 0
Trigger7 = time >= 30
trigger7 = random > 600
trigger7 = EnemyNear,MoveType != H ||  (EnemyNear,StateNo = [120,159])
trigger8 = EnemyNear,statetype = A;trigger2⏕
trigger8 = var(59) >= 5 || (var(59) = 4 &&  random <= 600) ||(var(59) = 3 && random <= 100)
trigger8 = EnemyNear,stateno = [5000,5999]
trigger8 =  ((EnemyNear,pos y = [-220, -180]) && (P2BodyDist X = [90, 120]))|| ((EnemyNear,pos y = [-200, -170]) && (P2BodyDist X = [30, 90]))
trigger8 = EnemyNear,vel y < 2  && EnemyNear,GetHitVar(yvel) <= -2
trigger8 = var(25) = 0

;Eye Projectile
[State -1, Mystic Stare]
type = ChangeState
value = 1000
TriggerAll=var(59)  = 2
triggerall = (Statetype != A) && (ctrl)
triggerall = prevstateno != 1000
triggerall = numhelper(9920) = 0 && numhelper(9923) = 0 && numhelper(9925) = 0
triggerall = NumHelper(1001) = 0
trigger1 = P2BodyDist X >=180  && random <= 200
trigger1 = !InGuardDist
trigger2 = TeamMode = simul
trigger2 = P2BodyDist X >=160 && var(25) = 0  && random <= 300

;Eye Projectile
[State -1, Mystic Stare]
type = ChangeState
value = 1000
TriggerAll=var(59)  = 1
triggerall = (Statetype != A) && (ctrl)
triggerall = prevstateno != 1000
triggerall = numhelper(9920) = 0 && numhelper(9923) = 0 && numhelper(9925) = 0
triggerall = NumHelper(1001) = 0
trigger1 = (P2BodyDist X = [70, 220]) && (random <= 100)
trigger1 =  (P2BodyDist y = [-40, 40])
trigger1 = life<lifemax/2

;Roll attack Ground
[State -1, Roll Attack Ground]
type = ChangeState
value = 1003
TriggerAll=var(59)  >= 3
triggerall = (Statetype != A) && (ctrl) &&  EnemyNear,Alive
triggerall = (EnemyNear,StateNo != [120,159])
triggerall = !InGuardDist
triggerall = !(var(29) >0 && var(59)  >= 5)
trigger1 = prevstateno != 1003 && P2Movetype = H && P2BodyDist X = [110, 300]
trigger1 = (p2statetype = A) && (random > 990)
trigger1 =  EnemyNear,vel x<-2 || EnemyNear,vel x>-2
trigger1 = EnemyNear,pos Y = [-150,-30]
trigger2 = numhelper(9920) >= 1 || numhelper(9923) >= 1 || numhelper(9925) >= 1
trigger2 = EnemyNear,MoveType = H
trigger2 = random >= 900
trigger2 =  (P2BodyDist X = [90, 200]) && EnemyNear,pos y >= -70
Trigger3 = EnemyNear,vel y>0;(~)
trigger3 =  EnemyNear,ctrl 
Trigger3 = EnemyNear,MoveType != H
Trigger3 =P2BodyDist X <= 30
Trigger3 =EnemyNear,pos y >= -70

;Roll attack Ground
[State -1, Roll Attack Ground]
type = ChangeState
value = 1003
TriggerAll=var(59)  < 3
TriggerAll=var(59)  > 0
triggerall = (Statetype != A) && (ctrl) &&  EnemyNear,Alive
triggerall = (EnemyNear,StateNo != [120,159])
triggerall = !InGuardDist
triggerall = (EnemyNear,StateNo != [120,159])
triggerall = !(var(29) >0 && var(59)  >= 5)
trigger1 = prevstateno != 1003 && P2Movetype = H && P2BodyDist X = [0, 180]
trigger1 = (p2statetype != A) && (random > 990)
trigger2 = prevstateno != 1006 && P2BodyDist X >=100
trigger2 = random <= 100 && P2Movetype = A
trigger3 = numhelper(9920) >= 1 || numhelper(9923) >= 1 || numhelper(9925) >= 1
trigger3 = EnemyNear,MoveType = H
trigger3 = EnemyNear,pos Y = [-20,0]
trigger3 = random <= 200

;Roll attack air
[State -1, Roll Attack Air]
type = ChangeState
value = 1004
TriggerAll=var(59) >  0
TriggerAll= var(30) = 0
triggerall = (Statetype = A) && (ctrl) &&  EnemyNear,Alive
triggerall = !InGuardDist
triggerall = !(var(29) >0 && var(59)  >= 5)
trigger1 = (EnemyNear,StateNo != [120,159])
Trigger1 = stateno != 42
Trigger1 = vel y>-3
trigger1 = EnemyNear,MoveType = H
trigger1 = (P2BodyDist X = [0, 150]) && (random > 990) && prevstateno != 1004
trigger1 = EnemyNear,Pos y = [-50,80]

;Roll attack arch
[State -1, Roll Attack Arch];XJ
type = ChangeState
value = 1006
TriggerAll=var(59)  > 3
triggerall = Statetype != A
triggerall = EnemyNear,Alive
triggerall = animtime = 0 
Trigger1 = !movecontact
trigger1 = anim = 4015 || anim = 4019
trigger1 = random > 990
trigger2 = anim = 4030
trigger2 = random > 500
trigger2 = EnemyNear,stateType != L

;Roll attack arch
[State -1, Roll Attack Arch]
type = ChangeState
value = 1006
TriggerAll=var(59)  >= 3
triggerall = Statetype != A
triggerall = ctrl
triggerall = EnemyNear,Alive
triggerall = stateno != 42
triggerall = !InGuardDist
triggerall = var(29) = 0 && var(30) <= 40 && var(32) <= 5
triggerall = EnemyNear,stateno= [5000,5999] 
trigger1 = var(59) >= 5 || (var(59) = 4 &&  random <= 600) ||(var(59) = 3 && random <= 100)
trigger1 = frontedgedist > 60
Trigger1 =((P2BodyDist X = [0,30])&&(EnemyNear,pos Y = [-60,-10]))||((P2BodyDist X = [30,120])&&(EnemyNear,pos Y = [-140,-80]))
trigger1 = EnemyNear,pos Y = [-90,-10]
trigger2 = numhelper(9920) >= 1 || numhelper(9923) >= 1 || numhelper(9925) >= 1
trigger2 =  (P2BodyDist X = [50,150])
trigger2 = EnemyNear,pos Y = [-90,-10]
trigger2 = random >= 700
Trigger3 =P2BodyDist X <= 30
Trigger3 =(EnemyNear,pos Y = [-90,-1])
trigger3 = var(25) = 0
trigger3 = BackEdgeBodyDist > 0
trigger3 = (EnemyNear,GetHitVar(yvel) = [-2,2])

;Roll attack arch
[State -1, Roll Attack Arch]
type = ChangeState
value = 1006
TriggerAll=var(59)  < 3
TriggerAll=var(59)  > 0
triggerall = Statetype != A
triggerall = ctrl
triggerall = EnemyNear,Alive
triggerall = prevstateno != 1006
triggerall = stateno != 42
triggerall = !InGuardDist
triggerall = (EnemyNear,StateNo != [120,159])
triggerall = !(var(29) >0 && var(59)  >= 5)
trigger1 = NumHelper(1001) >= 1 && (random <= 200)
trigger2 = backedgedist < 60
trigger2 = EnemyNear,stateType = L
trigger3 = numhelper(9920) >= 1 || numhelper(9923) >= 1 || numhelper(9925) >= 1
trigger3 = EnemyNear,MoveType = H
trigger3 = EnemyNear,pos Y <= -20
trigger3 = random <= 300

;-----------------------------------------------------


[State -1, AirRock]
type = ChangeState
value = 1005
TriggerAll=var(59)  < 3
TriggerAll=var(59)  > 0
TriggerAll=StateType = A
TriggerAll=Ctrl
TriggerAll=EnemyNear,Alive
Triggerall = var(30) = 0
Triggerall = stateno != 42
Triggerall = P2BodyDist Y > 80
triggerall = !InGuardDist
TriggerAll= P2StateType = A
Trigger1 =(P2BodyDist X = [-30,40])
trigger1 = random <= 500

;Jump Light Punch;AI
;󒆎p`
[State -1, Jump Light Punch]
type = ChangeState
value = 600
TriggerAll=var(59) >  0
TriggerAll=StateType = A
TriggerAll=EnemyNear,Alive
TriggerAll=(P2BodyDist X = [0,20])
TriggerAll=(P2BodyDist Y = [-55, 10])
triggerall = EnemyNear,stateType = A
Triggerall = vel y>-3
Trigger1 = ctrl
trigger1 = random >= 700

;----------------------------------------------------



;Jump Medium Kick;AI
[State -1, Jump Medium Kick]
type = ChangeState
value = 640
TriggerAll=var(59) >  0  && var(30) = 0
TriggerAll=StateType = A
TriggerAll=EnemyNear,Alive
TriggerAll=(P2BodyDist X = [-50,55])
TriggerAll=(P2BodyDist Y = [-20, 50])
Triggerall = vel y>-3
Trigger1 = ctrl
trigger1 = random <= 500
trigger1 = var(8) = 0

;-------------------------------------------------------


;Jump Medium Punch;AI
[State -1, Jump Medium Punch]
type = ChangeState
value = 610
TriggerAll=var(59) >  0  && var(30) = 0
TriggerAll=StateType = A
TriggerAll=EnemyNear,Alive
TriggerAll=(P2BodyDist X = [-10,55])
TriggerAll=(P2BodyDist Y = [-60, 0])
Triggerall = vel y>-3
Trigger1 = ctrl
trigger1 = random <= 500 
trigger1 = var(7) = 0

;-------------------------------------------------------


;Jump Light Kick;AI
[State -1, Jump Light Kick]
type = ChangeState
value = 630
TriggerAll=var(59) >  0  && var(30) = 0
TriggerAll=StateType = A
TriggerAll=EnemyNear,Alive
TriggerAll=(P2BodyDist X = [-10,60])
TriggerAll=(P2BodyDist Y = [10, 30])
Triggerall = vel y>-3
Trigger1 = EnemyNear,getHitvar(Hitcount) <= 6
Trigger1 = ctrl
trigger1 = random >= 700

;--------------------------------------------------------


[State -1, Jump Strong Kick];AI
type = ChangeState
value = 650
TriggerAll=var(59) >=  4
TriggerAll= var(30) = 0
TriggerAll=StateType = A
TriggerAll=EnemyNear,Alive
TriggerAll=EnemyNear,stateno = [5000,5999]
TriggerAll=!InGuardDist
TriggerAll=(P2BodyDist X = [85,110])
TriggerAll=(P2BodyDist Y = [-10, 90])
Triggerall = vel y>-2  && vel x<2.5
triggerall =  EnemyNear,GetHitVar(fall.recovertime) >= 15
Trigger1 = ctrl
trigger1 = random >= 700

[State -1, Jump Strong Kick];AI
type = ChangeState
value = 650
TriggerAll=var(59) <  4
TriggerAll=var(59) >  0  && var(30) = 0
TriggerAll=StateType = A
TriggerAll=EnemyNear,Alive
TriggerAll=EnemyNear,MoveType=H
TriggerAll=!InGuardDist
TriggerAll=(P2BodyDist X = [75,110])
TriggerAll=(P2BodyDist Y = [-10, 100])
Triggerall = vel y>-3 && vel x<2.5
Trigger1 = ctrl
trigger1 = random >= 700

;------------------------------------------------------


;Stand Light Kick;AI
;LbN
[State -1, Stand Light Kick]
type = ChangeState
value = 230
TriggerAll=var(59) >= 1
triggerall = (statetype = S)
triggerall = (ctrl) || (stateno = 100 && var(25) = 0)
triggerall = EnemyNear,Alive  
triggerall =  (P2BodyDist X = [0,35]) && (P2BodyDist Y = [0, 90])  && (var(25) = 0)
triggerall = P2statetype != A
trigger1 = random >= 990
trigger2 = EnemyNear,StateType = L && var(59) > 2

;------------------------------------------------------------


;Standing Medium Kick;AI
;LbN
[State -1, Standing Medium Kick]
type = ChangeState
value = 240
TriggerAll=var(59) = 1 || var(59) = 2
TriggerAll=StateType = S
TriggerAll=statetype != A
TriggerAll=EnemyNear,Alive
TriggerAll=!InGuardDist
triggerall = EnemyNear,StateType != L
triggerall = EnemyNear,StateType != A
TriggerAll=(P2BodyDist X = [0,60])
TriggerAll=(P2BodyDist Y = [0, 70])
TriggerAll= ctrl
triggerall = stateno != 42
triggerall = stateno != 240
triggerall = stateno != 100
triggerall = stateno != 50
triggerall = stateno != 4602
trigger1 = random <= 100


;--------------------------------------------------------



;p`
[State -1, Stand Light Punch];AI
type = ChangeState
value = 200
TriggerAll=var(59)  >= 1
triggerall = (statetype = S)
triggerall = (ctrl) || (stateno = 100 && var(25) = 0)
triggerall = EnemyNear,Alive 
triggerall =  (P2BodyDist X = [10,80]) && P2BodyDist y =[0,40]
triggerall = EnemyNear,StateType != L
triggerall = EnemyNear,StateType != C
trigger1 = random <= 700 && (P2BodyDist X = [10,30])
trigger2 = random >= 990 && (P2BodyDist X = [31,80])
trigger3 = EnemyNear,vel x>0
Trigger3 =EnemyNear,MoveType=H
trigger3 = var(59) >= 3

;--------------------------------------------------------------

;Crouching Medium Punch;AI
;Ⴊݒp`
[State -1, Crouching Medium Punch]
type = ChangeState
value = 410
triggerall = var(25) = 0
TriggerAll=Ctrl
triggerall = (statetype = C) && var(59) >= 1 && EnemyNear,Alive 
triggerall =  (P2BodyDist X = [0,135]) && (P2BodyDist Y = [0, 90]) 
triggerall = EnemyNear,StateType != L
trigger1 = random <= 100
trigger2 = movehit && stateno = 400  || (stateno = 430)
trigger3 = MoveGuarded  && stateno = 200 || stateno = 210 && random >= 300 
Trigger4 = var(59) >= 5
trigger4 = EnemyNear,StateNo = [150,155]
trigger4 = EnemyNear,StateType = S

;----------------------------------------------------------------

;Stand Medium Punch;AI
;p`
[State -1, Stand Medium Punch]
type = ChangeState
value = 210
TriggerAll=var(59)  >= 1
triggerall = (statetype = S)
triggerall = (ctrl) || (stateno = 100 && var(25) = 0)
triggerall = EnemyNear,Alive 
triggerall =  (P2BodyDist X = [40,120]) && (P2BodyDist Y = [-20, 80]) 
triggerall = EnemyNear,StateNo != [5120,5200]
triggerall = EnemyNear,StateNo != [120,155]
Triggerall=!(helper(30020),var(58)=1000|| helper(30020),var(58)=10000||helper(30020),var(58)=100000)
trigger1 = random <= 50 && (P2BodyDist X = [40,69])
trigger2 = random <= 30 && (P2BodyDist X = [70,120])

triggerall = (Statetype != A) && (ctrl) &&  var(59) >= 6
triggerall = EnemyNear,Alive
triggerall =   (EnemyNear,stateno != [5000,5999]) && (EnemyNear,stateno != [670,675]) && (EnemyNear,stateno != [120,155])
triggerall = P2BodyDist X = [-10,70]
trigger1 = numhelper(9920) = 1
trigger1 = helper(9920),stateno = 9921 && helper(9920),movecontact
trigger2 = numhelper(9923) = 1
trigger2 = helper(9923),stateno = 9924 && helper(9920),movecontact
trigger3 = numhelper(9925) = 1
trigger3 = helper(9925),stateno = 9926 && helper(9925),movecontact
trigger4 = NumHelper(1001) >= 1
trigger4 = helper(1001),movecontact

;----------------------------------------------------------------




;Crouching Light Kick;AI
;ႪݎLbN
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
TriggerAll=var(59) >= 1
TriggerAll=StateType = S || statetype = C
TriggerAll=statetype != A
TriggerAll=EnemyNear,Alive
TriggerAll=!InGuardDist
TriggerAll=(P2BodyDist X = [0,80])
TriggerAll=(P2BodyDist Y = [50, 100])
TriggerAll= ctrl
trigger1 = random >= 800
trigger2 = movehit && stateno = 400  && random <= 300 && time>=10
trigger3 = MoveGuarded  && stateno = 200 || stateno = 210 
trigger3 = random >= 900 && AnimElem >= 6
trigger4 = MoveGuarded  && stateno = 230 && random >= 900 && time>=5
trigger5 = NumHelper(1001) >= 1
trigger6 = EnemyNear,StateType = L
trigger6 =  (P2BodyDist X = [0, 30])
Trigger7 = var(59) >= 5
trigger7 = EnemyNear,StateNo = [150,155]
trigger7 = EnemyNear,StateType = S

;--------------------------------------------------------------

;Crouching Strong Kick;AI
;ႪݒLbN
[State -1, Crouching medium Kick]
type = ChangeState
value = 440
triggerall = var(25) = 0
triggerall = (statetype = C) && (ctrl) && var(59) >= 1 && EnemyNear,Alive 
triggerall =  (P2BodyDist X = [0,160]) && (P2BodyDist Y = [0, 100]) 
triggerall = EnemyNear,StateType != L
trigger1 = random <= 300
trigger2 = movehit && stateno = 400  || (stateno = 430)


;-------------------------------------------------------------

;Crouching Light Punch;AI
;Ⴊݎp`
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
TriggerAll=var(59) >= 1
TriggerAll=StateType = S || statetype = C
TriggerAll=statetype != A
TriggerAll=EnemyNear,Alive
TriggerAll=!InGuardDist
triggerall = EnemyNear,StateType != L
TriggerAll=(P2BodyDist X = [0,65])
TriggerAll=(P2BodyDist Y = [0, 90])
TriggerAll= ctrl
trigger1 = random >= 800
trigger2 = MoveGuarded = 1 && stateno = 200 || stateno = 210 && random >= 990 
trigger3 = MoveGuarded = 1 && stateno = 230 && random >= 900 
trigger4 = NumHelper(1001) >= 1
Trigger5 = var(59) >= 5
trigger5 = EnemyNear,StateNo = [150,155]
trigger5 = EnemyNear,StateType = S

;-----------------------------------------------------------------


;Ⴊ݋p`;AI
[State -1, Crouching Strong Punch]
type = ChangeState
value = 420
triggerall = var(25) = 0
TriggerAll=Ctrl
triggerall = (statetype = C) && var(59) >= 1 && EnemyNear,Alive 
triggerall =  (P2BodyDist X = [110,160]) && (P2BodyDist Y = [0, 90]) 
triggerall = EnemyNear,StateType != L
trigger1 = random <= 300
trigger2 = movehit && stateno = 400  || (stateno = 430)



;-----------------------------------------------------------


;Ⴊ݋LbNAI
[State -1, Crouching Strong Kick]
type = ChangeState
value = 450
triggerall = var(25) = 0
triggerall = (statetype = C) && (ctrl) && var(59) >= 1 && EnemyNear,Alive 
triggerall =   (P2BodyDist Y = [-90, 0])  && (var(30) = 0 && var(32) = 0)
triggerall = EnemyNear,StateType != L
trigger1 = random <= 10 && (var(30) = 0 && var(32) = 0)
trigger2 = P2StateType = A && random <= 100
trigger2 =  (P2BodyDist X = [90,120]) && (var(30) > 0 && var(32) > 0)

;------------------------------------------------------------

;Stand Strong Punch;AI
;p`
[State -1, Stand Strong Punch]
type = ChangeState
value = 220
triggerall = (statetype = S) && (ctrl)  && var(59) >= 1 && EnemyNear,Alive 
TriggerAll=var(59)  < 4
triggerall =  (P2BodyDist X = [130,145]) && (P2BodyDist Y = [0, 60]) 
triggerall = EnemyNear,StateType != L
triggerall = EnemyNear,StateType != A
Triggerall = EnemyNear,vel x<2
trigger1 = random <= 150

;--------------------------------------------------------------


;Standing Strong Kick;AI
;LbN
[State -1, Standing Strong Kick]
type = ChangeState
value = 250
TriggerAll=var(59)  >= 1 
TriggerAll=var(59)  < 4
triggerall = (statetype = S)
triggerall = (ctrl)
triggerall = EnemyNear,Alive 
triggerall =  (P2BodyDist X = [130,160]) && (P2BodyDist Y = [-10, 80]) 
TriggerAll = EnemyNear,StateType != L
triggerall = var(25) = 0
triggerall = TeamMode = Single || TeamMode = turns
trigger1 = random <= 50
trigger2 = (P2BodyDist X = [100,150]) && random <= 200 




;------------------------------------------------------------


;͂̕N͍lÕV}SXŃVB߂łƂI݂ȂɎ悤II
