;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;---------------------------------------------------------------------------
; Default Values
[Defaults]
command.time = 25
command.buffer.time = 1

;-| Super Motions |--------------------------------------------------------
;-| commands |-


[Command]
name = "MegaOpticBlast"
command = ~D, DF, F, x+y
time = 30
[Command]
name = "MegaOpticBlast"
command = ~D, DF, F, x+z
time = 30
[Command]
name = "MegaOpticBlast"
command = ~D, DF, F, y+z
time = 30

[Command]
name = "SuperOpticBlast"
command = ~D, DF, F, a+b
time = 30
[Command]
name = "SuperOpticBlast"
command = ~D, DF, F, a+b
time = 30
[Command]
name = "SuperOpticBlast"
command = ~D, DF, F, a+b
time = 30


;-| Special Motions |------------------------------------------------------
;-| commands |-

[Command]
name = "OpticBlastX"
command = ~D, DF, F, x
time = 30
[Command]
name = "OpticBlastY"
command = ~D, DF, F, y
time = 30
[Command]
name = "OpticBlastZ"
command = ~D, DF, F, z
time = 30

[Command]
name = "OpticSweep"
command = F, DF, D, x
time = 30
[Command]
name = "OpticSweep"
command = F, DF, D, y
time = 30
[Command]
name = "OpticSweep"
command = F, DF, D, z
time = 30

[Command]
name = "GeneSpliceX"
command = ~F, D, DF, x
time = 25
[Command]
name = "GeneSpliceY"
command = ~F, D, DF, y
time = 25
[Command]
name = "GeneSpliceZ"
command = ~F, D, DF, z
time = 25

[Command]
name = "GeneSpliceZ"
command = s


[Command]
name = "CycloneKick"
command = ~D, DB, B, a
time = 30
[Command]
name = "CycloneKick"
command = ~D, DB, B, b
time = 30
[Command]
name = "CycloneKick"
command = ~D, DB, B, c
time = 30

[Command]
name = "RushingPunches"
command = F,F,x+a
time = 25


[Command]
name = "RushingSlam"
command = F, F, z+c
time = 45


[Command]
name = "RecoveryRoll"
command = B, DB, D, x
time = 20
[Command]
name = "RecoveryRoll"
command = B, DB, D, y
time = 20
[Command]
name = "RecoveryRoll"
command = B, DB, D, z
time = 20
[Command]
name = "RecoveryRoll2"
command = B, DB, D, a
time = 20
[Command]
name = "RecoveryRoll2"
command = B, DB, D, b
time = 20
[Command]
name = "RecoveryRoll2"
command = B, DB, D, c
time = 20

[Command]
name = "VC1"
command = ~B, DB, D, x
time = 20
[Command]
name = "VC1"
command = ~B, DB, D, y
time = 20
[Command]
name = "VC1"
command = ~B, DB, D, z
time = 20
[Command]
name = "VC1"
command = y+b
time = 2

;-| Double Tap |-----------------------------------------------------------
;-| Eight commands |-

[Command]
name = "FF"       ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"       ;Required (do not remove)
command = B, B
time = 10

[Command]
name = "DU"
command = D, U
time = 10

[Command]
name = "UF"
command = UF
time = 1

[Command]
name = "UB"
command = UB
time = 1

[Command]
name = "DUF"
command = D, UF
time = 10

[Command]
name = "DUB"
command = D, UB
time = 10

[Command]
name = "up"
command = U
time = 1

[Command]
name = "SJ"
command = $D,$U
time = 15

[Command]
name = "SJ"
command = a+b
time = 1



;-| Dir + Button |---------------------------------------------------------
;-| Five commands |-

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "down_y"
command = /$D,y
time = 1

[Command]
name = "down_z"
command = /$D,z
time = 1

;-| 2/3 Button Combination |-----------------------------------------------
;-| Four commands |-

[Command]
name = "recovery" ;Required (do not remove)
command = a+b
time = 1

[Command]
name = "TwoPunch"
command = x+y
time = 1
[Command]
name = "TwoPunch"
command = x+z
time = 1
[Command]
name = "TwoPunch"
command = y+z
time = 1

[command] 
name = "Advguard"
command = x+y
time = 5

[Command]
name = "SJ"
command = a+b
time = 2

;-| Single Button |---------------------------------------------------------
;-| Fourteen commands |-

[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "s"
command = s
time = 1

[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 1

[Command]
name = "hold_c"
command = /c
time = 1

[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1

[Command]
name = "hold_z"
command = /z
time = 1

[Command]
name = "fwd"
command = F
time = 1

[Command]
name = "GemCursor"
command = ~5s
time = 1

;-| Hold Dir |--------------------------------------------------------------
;-| Twelve commands |-

[Command]
name = "holdfwd"  ;Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback" ;Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup"   ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown" ;Required (do not remove)
command = /$D
time = 1

[Command]
name = "holddownfwd"
command = /DF
time = 1

[Command]
name = "holddownback"
command = /DB
time = 1

[Command]
name = "holdupfwd"
command = /UF
time = 1

[Command]
name = "holdupback"
command = /UB
time = 1

[Command]
name = "holdfwd2"
command = /F
time = 1

[Command]
name = "holdback2"
command = /B
time = 1

[Command]
name = "holdup2"
command = /U
time = 1

[Command]
name = "holddown2"
command = /D
time = 1

[Command] 
name = "hold_a" 
command = /$a 
[Command] 
name = "hold_b" 
command = /$b 
[Command] 
name = "hold_x" 
command = /$x 
[Command] 
name = "hold_y" 
command = /$y 
[Command] 
name = "hold_c" 
command = /$c 
[Command] 
name = "hold_z" 
command = /$z

;-| CPU Commands |----------------------------------------------------------
;-| Commands |-

[Command]
name = "cpu1"
command = U, U, U, U
time = 1
[Command]
name = "cpu2"
command = U, U, U, D
time = 1
[Command]
name = "cpu3"
command = U, U, D, D
time = 1
[Command]
name = "cpu4"
command = U, D, D, D
time = 1
[Command]
name = "cpu5"
command = D, D, D, D
time = 1
[Command]
name = "cpu6"
command = D, D, D, U
time = 1
[Command]
name = "cpu7"
command = D, D, U, U
time = 1
[Command]
name = "cpu8"
command = D, U, U, U
time = 1
[Command]
name = "cpu9"
command = U, D, U, U
time = 1
[Command]
name = "cpu10"
command = U, U, D, U
time = 1
[Command]
name = "cpu11"
command = D, U, U, D
time = 1
[Command]
name = "cpu12"
command = U, D, D, U
time = 1
[Command]
name = "cpu13"
command = D, U, D, U
time = 1
[Command]
name = "cpu14"
command = U, D, U, D
time = 1
[Command]
name = "cpu15"
command = F, F, F, F
time = 1
[Command]
name = "cpu16"
command = B, B, B, B
time = 1
[Command]
name = "cpu17"
command = F, B, F, F
time = 1
[Command]
name = "cpu18"
command = F, F, B, F
time = 1
[Command]
name = "cpu19"
command = B, F, F, F
time = 1
[Command]
name = "cpu20"
command = F, F, F, B
time = 1
[Command]
name = "cpu21"
command = F, B, B, F
time = 1
[Command]
name = "cpu22"
command = B, F, F, B
time = 1
[Command]
name = "cpu23"
command = F, B, F, B
time = 1
[Command]
name = "cpu24"
command = B, F, B, F
time = 1
[Command]
name = "cpu25"
command = D, F, D, F
time = 1
[Command]
name = "cpu26"
command = D, B, D, B
time = 1
[Command]
name = "cpu27"
command = D, B, D, F
time = 1
[Command]
name = "cpu28"
command = D, F, D, B
time = 1
[Command]
name = "cpu29"
command = U, F, D, B
time = 1
[Command]
name = "cpu30"
command = U, B, D, F
time = 1
[Command]
name = "cpu31"
command = B, D, F, U
time = 1
[Command]
name = "cpu32"
command = F, D, B, U
time = 1

[Statedef -1]
;R}h------------------------------------------------------------------

;---------------------------------------------------------------------------
; Mega Optic Blast
[State -1]
type = ChangeState
value = 3000
triggerall = !var(59)
triggerall = var(43) = 0
triggerall = power >= 1000
triggerall = command = "MegaOpticBlast"
trigger1 = ctrl
trigger2 = stateno = [200,651]
trigger3 = stateno = [1000,1591]


;---------------------------------------------------------------------------
; Super Optic Blast
[State -1]
type = ChangeState
value = 3040
triggerall = !var(59)
triggerall = var(43) = 0
triggerall = power >= 1000
triggerall = command = "SuperOpticBlast"
trigger1 = ctrl
trigger2 = stateno = [200,651]
trigger3 = stateno = [1000,1591]


;RunBack
[State -1]
type = ChangeState
value = 105
triggerall = !var(59)
triggerall = var(43) = 0
triggerall = (command = "holdback2" && command = "TwoPunch") || (StateType != A && command = "BB")
trigger1 = StateType = S
trigger1 = ctrl
trigger1 = StateNo != [105,106]




;RunFwd
[State -1]
type = ChangeState
value = 100
triggerall = !var(59)
triggerall = var(43) = 0
triggerall = (command = "TwoPunch") || (StateType != A && command = "FF")
trigger1 = StateType = S
trigger1 = StateNo != 100
trigger1 = ctrl
trigger2 = StateNo = 10

;---------------------------------------------------------------------------
; Guard Push (Stand)
[State -1, Guard Push]
type = ChangeState
value = 710
triggerall = !var(59)
triggerall = command = "Advguard"
trigger1 = stateno = [150,151]

;Guard Push (Crouch)
[State -1, Guard Push]
type = ChangeState
value = 711
triggerall = !var(59)
triggerall = command = "Advguard"
trigger1 = stateno = [152,153]

;Guard Push (Air)
[State -1, Guard Push]
type = ChangeState
value = 712
triggerall = !var(59)
triggerall = command = "Advguard"
trigger1 = stateno = 154
trigger2 = stateno = 155

;---------------------------------------------------------------------------
;-------------------------------Specials------------------------------------
;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
; Abp[X
[State -1]
type = ChangeState
value = 1400
triggerall = !var(59)
triggerall = var(43) = 0
triggerall = statetype != A
triggerall = command = "GeneSpliceX"
trigger1 = ctrl
trigger2 = stateno = [200,201]
trigger3 = stateno = 210
trigger4 = stateno = 220
trigger5 = stateno = [230,231]
trigger6 = stateno = 240
trigger7 = stateno = 250
trigger8 = stateno = 251
trigger9 = stateno = 400
trigger10 = stateno = 410
trigger11 = stateno = 420
trigger12 = stateno = 430
trigger13 = stateno = 440
trigger14 = stateno = 450


;---------------------------------------------------------------------------
; Abp[ Y
[State -1]
type = ChangeState
value = 1410
triggerall = !var(59)
triggerall = var(43) = 0
triggerall = statetype != A
triggerall = command = "GeneSpliceY"
trigger1 = ctrl
trigger2 = stateno = [200,201]
trigger3 = stateno = 210
trigger4 = stateno = 220
trigger5 = stateno = [230,231]
trigger6 = stateno = 240
trigger7 = stateno = 250
trigger8 = stateno = 251
trigger9 = stateno = 400
trigger10 = stateno = 410
trigger11 = stateno = 420
trigger12 = stateno = 430
trigger13 = stateno = 440
trigger14 = stateno = 450


;---------------------------------------------------------------------------
; Abp[ Z
[State -1]
type = ChangeState
value = 1420
triggerall = !var(59)
triggerall = var(43) = 0
triggerall = statetype != A
triggerall = command = "GeneSpliceZ"
trigger1 = ctrl
trigger2 = stateno = [200,201]
trigger3 = stateno = 210
trigger4 = stateno = 220
trigger5 = stateno = [230,231]
trigger6 = stateno = 240
trigger7 = stateno = 250
trigger8 = stateno = 251
trigger9 = stateno = 400
trigger10 = stateno = 410
trigger11 = stateno = 420
trigger12 = stateno = 430
trigger13 = stateno = 440
trigger14 = stateno = 450

;---------------------------------------------------------------------------
; sbhp`
[State -1]
type = ChangeState
value = 1540
triggerall = !var(59)
triggerall = var(43) = 0
triggerall = statetype != A
triggerall = command = "RushingPunches"
trigger1 = ctrl
trigger2 = stateno = [200,201]
trigger3 = stateno = 210
trigger4 = stateno = 220
trigger5 = stateno = [230,231]
trigger6 = stateno = 240
trigger7 = stateno = 250
trigger8 = stateno = 251
trigger9 = stateno = 400
trigger10 = stateno = 410
trigger11 = stateno = 420
trigger12 = stateno = 430
trigger13 = stateno = 440
trigger14 = stateno = 450

;---------------------------------------------------------------------------
; Optic Blast X
[State -1]
type = ChangeState
value = 1450
triggerall = !var(59)
triggerall = var(43) = 0
triggerall = statetype != A
triggerall = command = "OpticBlastX"
trigger1 = ctrl
trigger2 = stateno = [200,201]
trigger3 = stateno = 210
trigger4 = stateno = 220
trigger5 = stateno = [230,231]
trigger6 = stateno = 240
trigger7 = stateno = 250
trigger8 = stateno = 251
trigger9 = stateno = 400
trigger10 = stateno = 410
trigger11 = stateno = 420
trigger12 = stateno = 430
trigger13 = stateno = 440
trigger14 = stateno = 450


;---------------------------------------------------------------------------
; Optic Blast Y
[State -1]
type = ChangeState
value = 1460
triggerall = !var(59)
triggerall = var(43) = 0
triggerall = statetype != A
triggerall = command = "OpticBlastY"
trigger1 = ctrl
trigger2 = stateno = [200,201]
trigger3 = stateno = 210
trigger4 = stateno = 220
trigger5 = stateno = [230,231]
trigger6 = stateno = 240
trigger7 = stateno = 250
trigger8 = stateno = 251
trigger9 = stateno = 400
trigger10 = stateno = 410
trigger11 = stateno = 420
trigger12 = stateno = 430
trigger13 = stateno = 440
trigger14 = stateno = 450


;---------------------------------------------------------------------------
; Optic Blast Z
[State -1]
type = ChangeState
value = 1470
triggerall = !var(59)
triggerall = var(43) = 0
triggerall = statetype != A
triggerall = command = "OpticBlastZ"
trigger1 = ctrl
trigger2 = stateno = [200,201]
trigger3 = stateno = 210
trigger4 = stateno = 220
trigger5 = stateno = [230,231]
trigger6 = stateno = 240
trigger7 = stateno = 250
trigger8 = stateno = 251
trigger9 = stateno = 400
trigger10 = stateno = 410
trigger11 = stateno = 420
trigger12 = stateno = 430
trigger13 = stateno = 440
trigger14 = stateno = 450


;---------------------------------------------------------------------------
; r[ X
[State -1]
type = ChangeState
value = 1461
triggerall = !var(59)
triggerall = var(43) = 0
triggerall = statetype = A
triggerall = command = "OpticBlastX" 
triggerall = Pos Y <= -20
trigger1 = ctrl
trigger2 = stateno = 600
trigger3 = stateno = 610 || stateno = 611
trigger4 = stateno = 620 || stateno = 621
trigger5 = stateno = 630 || stateno = 631
trigger6 = stateno = 640 || stateno = 641
trigger7 = stateno = 650 || stateno = 651

;---------------------------------------------------------------------------
; r[ Y
[State -1]
type = ChangeState
value = 1471
triggerall = !var(59)
triggerall = var(43) = 0
triggerall = statetype = A
triggerall = command = "OpticBlastY" 
triggerall = Pos Y <= -20
trigger1 = ctrl
trigger2 = stateno = 600
trigger3 = stateno = 610 || stateno = 611
trigger4 = stateno = 620 || stateno = 621
trigger5 = stateno = 630 || stateno = 631
trigger6 = stateno = 640 || stateno = 641
trigger7 = stateno = 650 || stateno = 651


;---------------------------------------------------------------------------
; r[ Z
[State -1]
type = ChangeState
value = 1471
triggerall = !var(59)
triggerall = var(43) = 0
triggerall = statetype = A
triggerall = command = "OpticBlastZ" 
triggerall = Pos Y <= -20
trigger1 = ctrl
trigger2 = stateno = 600
trigger3 = stateno = 610 || stateno = 611
trigger4 = stateno = 620 || stateno = 621
trigger5 = stateno = 630 || stateno = 631
trigger6 = stateno = 640 || stateno = 641
trigger7 = stateno = 650 || stateno = 651


;---------------------------------------------------------------------------
; XEB[v
[State -1]
type = ChangeState
value = 1480
triggerall = !var(59)
triggerall = var(43) = 0
triggerall = statetype != A
triggerall = command = "OpticSweep"
trigger1 = ctrl
trigger2 = stateno = [200,201]
trigger3 = stateno = 210
trigger4 = stateno = 220
trigger5 = stateno = [230,231]
trigger6 = stateno = 240
trigger7 = stateno = 250
trigger8 = stateno = 251
trigger9 = stateno = 400
trigger10 = stateno = 410
trigger11 = stateno = 420
trigger12 = stateno = 430
trigger13 = stateno = 440
trigger14 = stateno = 450


;---------------------------------------------------------------------------
; TCNLbN
[State -1]
type = ChangeState
value = 1590
triggerall = !var(59)
triggerall = var(43) = 0
triggerall = statetype != A
triggerall = command = "CycloneKick"
trigger1 = ctrl
trigger2 = stateno = [200,201]
trigger3 = stateno = 210
trigger4 = stateno = 220
trigger5 = stateno = [230,231]
trigger6 = stateno = 240
trigger7 = stateno = 250
trigger8 = stateno = 251
trigger9 = stateno = 400
trigger10 = stateno = 410
trigger11 = stateno = 420
trigger12 = stateno = 430
trigger13 = stateno = 440
trigger14 = stateno = 450


;---------------------------------------------------------------------------
; lbNu[J[
[State -1]
type = ChangeState
value = 1600
triggerall = !var(59)
triggerall = var(43) = 0
triggerall = statetype != A
triggerall = command = "RushingSlam"
trigger1 = ctrl
trigger2 = stateno = [200,201]
trigger3 = stateno = 210
trigger4 = stateno = 220
trigger5 = stateno = [230,231]
trigger6 = stateno = 240
trigger7 = stateno = 250
trigger8 = stateno = 251
trigger9 = stateno = 400
trigger10 = stateno = 410
trigger11 = stateno = 420
trigger12 = stateno = 430
trigger13 = stateno = 440
trigger14 = stateno = 450


;---------------------------------------------------------------------------
;--------------------------------Basics-------------------------------------
;---------------------------------------------------------------------------

;
;---------------------------------------------------------------------------
; P
[State -1]
type = ChangeState
value = 800
triggerall = !var(59)
triggerall = StateType = S
triggerall = p2StateType != A
triggerall = p2bodydist X <= 52
;triggerall = p2dist X > 0
triggerall = p2dist Y <= 50
triggerall = p2dist Y > -50
triggerall = StateNo != 100
trigger1 = enemyNear, StateNo != [120,159]
trigger1 = command = "holdfwd2" || command = "holdback2"
trigger1 = command = "z"
trigger1 = ctrl
trigger2 = command = "x" && command = "a"
trigger2 = ctrl

;---------------------------------------------------------------------------
; K
[State -1]
type = ChangeState
value = 830
triggerall = !var(59)
triggerall = StateType = S
triggerall = p2StateType != A
triggerall = command = "holdfwd2" || command = "holdback2"
triggerall = command = "c"
triggerall = p2bodydist X <= 52
;triggerall = p2dist X > 0
triggerall = p2dist Y <= 50
triggerall = p2dist Y > -50
triggerall = StateNo != 100
triggerall = enemyNear, StateNo != [120,159]
trigger1 = ctrl


;---------------------------------------------------------------------------
; j. Fierce Throw Forward
[State -1]
type = ChangeState
value = 920
triggerall = !var(59)
triggerall = StateType = A
triggerall = p2StateType = A
triggerall = command = "holdfwd2" || command = "holdback2"
triggerall = command = "z"
triggerall = p2bodydist X <= 50
triggerall = p2bodydist X >= -5
triggerall = p2bodydist Y <= 60
triggerall = p2bodydist Y > -60
triggerall = enemyNear, StateNo != [120,159]
trigger1 = ctrl


;---------------------------------------------------------------------------

;Super Jump
[State -1]
type = ChangeState
value = 10022
triggerall = !var(59)
triggerall = var(43) = 0
triggerall = statetype!=A
trigger1 = command = "holdup"
trigger1 = stateno = 210 || stateno = 440
trigger1 = movehit = 1
trigger2 = command = "holdupfwd"
trigger2 = stateno = 210 || stateno = 440
trigger2 = movehit = 1
trigger3 = command = "holdupback"
trigger3 = stateno = 210 || stateno = 440
trigger3 = movehit = 1



[State -1]
type = ChangeState
value = 10023
triggerall = !var(59)
triggerall = var(43) = 0
triggerall = statetype!=A
trigger1 = stateno = [200,450]
trigger1 = movecontact
trigger1 = command = "SJ"
trigger2 = ctrl
trigger2 = command = "SJ"



[State -1]
type = ChangeState
value = 10024
triggerall = !var(59)
triggerall = var(44)=1
triggerall = var(41)=1
triggerall = statetype=A 
trigger1 = pos Y < -200
trigger1 = command = "up" 
trigger1 = ctrl
trigger1 = vel Y<0
trigger2 = command = "up" 
trigger2 = ctrl
trigger2 = vel Y>0

[State -1]
type = ChangeState
value = 10026
triggerall = !var(59)
triggerall = var(44)=1
triggerall = var(41)=1
triggerall = statetype=A 
trigger1 = pos Y < -200
trigger1 = command = "UB"
trigger1 = ctrl
trigger1 = vel Y<0
trigger2 = command = "UB"
trigger2 = ctrl
trigger2 = vel Y>0


[State -1]
type = ChangeState
value = 10025
triggerall = !var(59)
triggerall = var(44)=1
triggerall = var(41)=1
triggerall = statetype=A 
trigger1 = pos Y < -200
trigger1 = command = "UF"
trigger1 = ctrl
trigger1 = vel Y<0
trigger2 = command = "UF"
trigger2 = ctrl
trigger2 = vel Y>0

[State -1]
type = ChangeState
value = 10024
triggerall = !var(59)
triggerall = var(44)=1
triggerall = var(41)=0
triggerall = statetype=A 
trigger1 = pos Y < -100
trigger1 = command = "up" 
trigger1 = ctrl
trigger1 = vel Y<0
trigger2 = command = "up" 
trigger2 = ctrl
trigger2 = vel Y>0

[State -1]
type = ChangeState
value = 10026
triggerall = !var(59)
triggerall = var(44)=1
triggerall = var(41)=0
triggerall = statetype=A 
trigger1 = pos Y < -100
trigger1 = command = "UB"
trigger1 = ctrl
trigger1 = vel Y<0
trigger2 = command = "UB"
trigger2 = ctrl
trigger2 = vel Y>0


[State -1]
type = ChangeState
value = 10025
triggerall = !var(59)
triggerall = var(44)=1
triggerall = var(41)=0
triggerall = statetype=A 
trigger1 = pos Y < -100
trigger1 = command = "UF"
trigger1 = ctrl
trigger1 = vel Y<0
trigger2 = command = "UF"
trigger2 = ctrl
trigger2 = vel Y>0



[State -1]
type = ChangeState
value = 10025
triggerall = !var(59)
triggerall = var(44)=1
triggerall = statetype=A
triggerall = command = "UF"
trigger1 = stateno = 600 && time>6
trigger2 = stateno = 610 && time>6
trigger3 = stateno = 611 && time>6
trigger4 = stateno = 620 && time>6
trigger5 = stateno = 630 && time>6
trigger6 = stateno = 631 && time>6
trigger7 = stateno = 640 && time>6
trigger8 = stateno = 650 && time>6

[State -1]
type = ChangeState
value = 10024
triggerall = !var(59)
triggerall = var(44)=1
triggerall = statetype=A
triggerall = command = "up" 
trigger1 = stateno = 600 && time>6
trigger2 = stateno = 610 && time>6
trigger3 = stateno = 611 && time>6
trigger4 = stateno = 620 && time>6
trigger5 = stateno = 630 && time>6
trigger6 = stateno = 631 && time>6
trigger7 = stateno = 640 && time>6
trigger8 = stateno = 650 && time>6

[State -1]
type = ChangeState
value = 10026
triggerall = !var(59)
triggerall = var(44)=1
triggerall = statetype=A
triggerall = command = "UB"
trigger1 = stateno = 600 && time>6
trigger2 = stateno = 610 && time>6
trigger3 = stateno = 611 && time>6
trigger4 = stateno = 620 && time>6
trigger5 = stateno = 630 && time>6
trigger6 = stateno = 631 && time>6
trigger7 = stateno = 640 && time>6
trigger8 = stateno = 650 && time>6

;--|[ Standing ]|--
;---------------------------------------------------------------------------
; s. Jab
[State -1]
type = ChangeState
value = 200
triggerall = !var(59)
triggerall = statetype != A
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = ctrl

;---------------------------------------------------------------------------
; s. Strong
[State -1]
type = ChangeState
value = 210
triggerall = !var(59)
triggerall = statetype != A
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = ctrl
trigger2 = stateno = [200,201]
trigger2 = MoveContact
trigger3 = stateno = [230,231]
trigger3 = MoveContact
trigger4 = stateno = 400
trigger4 = MoveContact
trigger5 = stateno = 430
trigger5 = MoveContact


;---------------------------------------------------------------------------
; s. Fierce
[State -1]
type = ChangeState
value = 220
triggerall = !var(59)
triggerall = statetype != A
triggerall = command = "z"
triggerall = command != "holddown"
trigger1 = ctrl
trigger2 = stateno = [200,201]
trigger2 = MoveContact
trigger3 = stateno = 210
trigger3 = MoveGuarded
trigger4 = stateno = [230,231]
trigger4 = MoveContact
trigger5 = stateno = 240
trigger5 = MoveContact
trigger6 = stateno = 400
trigger6 = MoveContact
trigger7 = stateno = 410
trigger7 = MoveContact
trigger8 = stateno = 430
trigger8 = MoveContact
trigger9 = stateno = 440
trigger9 = MoveContact


;---------------------------------------------------------------------------
; s. Short
[State -1]
type = ChangeState
value = 230
triggerall = !var(59)
triggerall = statetype != A
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = ctrl
trigger2 = stateno = [200,201]
trigger2 = MoveContact
trigger3 = stateno = 400
trigger3 = MoveContact

;---------------------------------------------------------------------------
; s. Forward
[State -1]
type = ChangeState
value = 240
triggerall = !var(59)
triggerall = statetype != A
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = ctrl
trigger2 = stateno = [200,201]
trigger2 = MoveContact
trigger3 = stateno = 210
trigger3 = MoveGuarded
trigger4 = stateno = [230,231]
trigger4 = MoveContact
trigger5 = stateno = 400
trigger5 = MoveContact
trigger6 = stateno = 410
trigger6 = MoveContact
trigger7 = stateno = 430
trigger7 = MoveContact


;---------------------------------------------------------------------------
; s. Roundhouse
[State -1]
type = ChangeState
value = 250
triggerall = !var(59)
triggerall = statetype != A
triggerall = command = "c"
triggerall = command != "holddown"
trigger1 = ctrl
trigger2 = stateno = [200,201]
trigger2 = MoveContact
trigger3 = stateno = 210
trigger3 = MoveGuarded
trigger4 = stateno = 220
trigger4 = MoveContact
trigger5 = stateno = [230,231]
trigger5 = MoveContact
trigger6 = stateno = 240
trigger6 = MoveContact
trigger7 = stateno = 400
trigger7 = MoveContact
trigger8 = stateno = 410
trigger8 = MoveContact
trigger9 = stateno = 420
trigger9 = MoveContact
trigger10 = stateno = 430
trigger10 = MoveContact
trigger11 = stateno = 440
trigger11 = MoveContact

;--|[ Crouching ]|--
;---------------------------------------------------------------------------
; c. Jab
[State -1]
type = ChangeState
value = 400
triggerall = !var(59)
triggerall = statetype != A
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = ctrl


;---------------------------------------------------------------------------
; c. Strong
[State -1]
type = ChangeState
value = 410
triggerall = !var(59)
triggerall = statetype != A
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = ctrl
trigger2 = stateno = [200,201]
trigger2 = MoveContact
trigger3 = stateno = [230,231]
trigger3 = MoveContact
trigger4 = stateno = 400
trigger4 = MoveContact
trigger5 = stateno = 430
trigger5 = MoveContact


;---------------------------------------------------------------------------
; c. Fierce
[State -1]
type = ChangeState
value = 420
triggerall = !var(59)
triggerall = statetype != A
triggerall = command = "z"
triggerall = command = "holddown"
trigger1 = ctrl
trigger2 = stateno = [200,201]
trigger2 = MoveContact
trigger3 = stateno = 210
trigger3 = MoveGuarded
trigger4 = stateno = [230,231]
trigger4 = MoveContact
trigger5 = stateno = 240
trigger5 = MoveContact
trigger6 = stateno = 400
trigger6 = MoveContact
trigger7 = stateno = 410
trigger7 = MoveContact
trigger8 = stateno = 430
trigger8 = MoveContact
trigger9 = stateno = 440
trigger9 = MoveGuarded


;---------------------------------------------------------------------------
; c. Short
[State -1]
triggerall = !var(59)
type = ChangeState
value = 430
triggerall = statetype != A
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = ctrl
trigger2 = stateno = [200,201]
trigger2 = MoveContact
trigger3 = stateno = 400
trigger3 = MoveContact


;---------------------------------------------------------------------------
; c. Forward
[State -1]
type = ChangeState
value = 440
triggerall = !var(59)
triggerall = statetype != A
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = ctrl
trigger2 = stateno = [200,201]
trigger2 = MoveContact
trigger3 = stateno = 210
trigger3 = MoveGuarded
trigger4 = stateno = [230,231]
trigger4 = MoveContact
trigger5 = stateno = 400
trigger5 = MoveContact
trigger6 = stateno = 410
trigger6 = MoveContact
trigger7 = stateno = 430
trigger7 = MoveContact


;---------------------------------------------------------------------------
; c. Roundhouse
[State -1]
type = ChangeState
value = 450
triggerall = !var(59)
triggerall = statetype != A
triggerall = command = "c"
triggerall = command = "holddown"
trigger1 = ctrl
trigger2 = stateno = [200,201]
trigger2 = MoveContact
trigger3 = stateno = 210
trigger3 = MoveGuarded
trigger4 = stateno = 220
trigger4 = MoveContact
trigger5 = stateno = [230,231]
trigger5 = MoveContact
trigger6 = stateno = 240
trigger6 = MoveContact
trigger7 = stateno = 400
trigger7 = MoveContact
trigger8 = stateno = 410
trigger8 = MoveContact
trigger9 = stateno = 420
trigger9 = MoveContact
trigger10 = stateno = 430
trigger10 = MoveContact
trigger11 = stateno = 440
trigger11 = MoveGuarded

;--|[ Jumping ]|--
;---------------------------------------------------------------------------
; j. Jab
[State -1]
type = ChangeState
value = 600
triggerall = !var(59)
triggerall = statetype = A
triggerall = command = "x"
trigger1 = ctrl


;---------------------------------------------------------------------------
; j. Strong Special
[State -1]
type = ChangeState
value = 611
triggerall = statetype = A
triggerall = command = "down_y"
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = MoveContact
trigger3 = stateno = 630 || stateno = 631
trigger3 = MoveContact


;---------------------------------------------------------------------------
; j. Strong
[State -1]
type = ChangeState
value = 610
triggerall = !var(59)
triggerall = statetype = A
triggerall = command = "y"
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = MoveContact
trigger3 = stateno = 630 || stateno = 631
trigger3 = MoveContact


;---------------------------------------------------------------------------
; j. Fierce Special
[State -1]
type = ChangeState
value = 621
triggerall = !var(59)
triggerall = statetype = A
triggerall = command = "down_z"
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = MoveContact
trigger3 = stateno = 610 || stateno = 611
trigger3 = MoveContact
trigger4 = stateno = 630 || stateno = 631
trigger4 = MoveContact
trigger5 = stateno = 640 || stateno = 641
trigger5 = MoveContact


;---------------------------------------------------------------------------
; j. Fierce
[State -1]
type = ChangeState
value = 620
triggerall = !var(59)
triggerall = statetype = A
triggerall = command = "z"
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = MoveContact
trigger3 = stateno = 610 || stateno = 611
trigger3 = MoveContact
trigger4 = stateno = 630 || stateno = 631
trigger4 = MoveContact
trigger5 = stateno = 640 || stateno = 641
trigger5 = MoveContact

;---------------------------------------------------------------------------
; j. Short Special
[State -1]
type = ChangeState
value = 631
triggerall = !var(59)
triggerall = statetype = A
triggerall = command = "down_a"
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = MoveContact


;---------------------------------------------------------------------------
; j. Short
[State -1]
type = ChangeState
value = 630
triggerall = !var(59)
triggerall = statetype = A
triggerall = command = "a"
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = MoveContact


;---------------------------------------------------------------------------
; j. Forward Special
[State -1]
type = ChangeState
value = 641
triggerall = !var(59)
triggerall = statetype = A
triggerall = command = "down_b"
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = MoveContact
trigger3 = stateno = 610 || stateno = 611
trigger3 = MoveContact
trigger4 = stateno = 630 || stateno = 631
trigger4 = MoveContact


;---------------------------------------------------------------------------
; j. Forward
[State -1]
type = ChangeState
value = 640
triggerall = !var(59)
triggerall = statetype = A
triggerall = command = "b"
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = MoveContact
trigger3 = stateno = 610 || stateno = 611
trigger3 = MoveContact
trigger4 = stateno = 630 || stateno = 631
trigger4 = MoveContact


;---------------------------------------------------------------------------
; j. Roundhouse Special
[State -1]
type = ChangeState
value = 651
triggerall = !var(59)
triggerall = statetype = A
triggerall = command = "down_c"
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = MoveContact
trigger3 = stateno = 610 || stateno = 611
trigger3 = MoveContact
trigger4 = stateno = 620 || stateno = 621
trigger4 = MoveContact
trigger5 = stateno = 630 || stateno = 631
trigger5 = MoveContact
trigger6 = stateno = 640 || stateno = 641
trigger6 = MoveContact


;---------------------------------------------------------------------------
; j. Roundhouse
[State -1]
triggerall = !var(59)
type = ChangeState
value = 650
triggerall = statetype = A
triggerall = command = "c"
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = MoveContact
trigger3 = stateno = 610 || stateno = 611
trigger3 = MoveContact
trigger4 = stateno = 620 || stateno = 621
trigger4 = MoveContact
trigger5 = stateno = 630 || stateno = 631
trigger5 = MoveContact
trigger6 = stateno = 640 || stateno = 641
trigger6 = MoveContact




;---------------------------------------------------------------------------
;Taunt
[State -1]
type = ChangeState
value = 195
triggerall = !var(59)
triggerall = command = "s"
triggerall = StateType != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;_E
----------------------------------------------------------------------------------------
; Recovery Roll
[State -1, Falling]
type = VarSet
triggerall = !var(59)
triggerall = alive
triggerall = (StateNo = 5035) || (StateNo = 5050) || (StateNo = 5071)
triggerall = Stateno != 5040
trigger1 = (Command = "RecoveryRoll")
var(57) = 1

[State -1, Rolling]
type = ChangeState
value = 705
triggerall = !var(59)
triggerall = alive
triggerall = Var(57) = 1 
triggerall = (StateNo = 5035) || (StateNo = 5050) || (StateNo = 5071)
trigger1 = (Pos Y >= 0) && (Vel Y > 0)

; Recovery Roll
[State -1, Falling]
type = VarSet
triggerall = !var(59)
triggerall = alive
triggerall = (StateNo = 5035) || (StateNo = 5050) || (StateNo = 5071)
triggerall = Stateno != 5040
trigger1 = (Command = "RecoveryRoll2")
var(57) = 2

[State -1, Rolling]
type = ChangeState
value = 706
triggerall = !var(59)
triggerall = alive
triggerall = Var(57) = 2
triggerall = (StateNo = 5035) || (StateNo = 5050) || (StateNo = 5071)
trigger1 = (Pos Y >= 0) && (Vel Y > 0)

;---------------------------------------------------------------------------
[State -1, Rolling]
type       = ChangeState
triggerall = var(59)=0
triggerall = stateno=5100||stateno=5110||stateno=5120
trigger1   = command="RecoveryRoll"
value      = 705

[State -1, Rolling]
type       = ChangeState
triggerall = var(59)=0
triggerall = stateno=5100||stateno=5110||stateno=5120
trigger1   = command="RecoveryRoll2"
value      = 706


; JE^[
[State -1]
type = ChangeState
value = 2222
triggerall = power > 1000
triggerall = command = "VC1"
trigger1 = stateno = [150,153]
