; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
;

;-| AI Activation Commands |-----------------------------------------------
; From BBH
[Command]
name = "CPU0"
command = U,U,D,D,B,F,B,F,s,s
time = 0

[Command]
name = "CPU1"
command = U,U,D,D,B,F,B,F,a,a
time = 0

[Command]
name = "CPU2"
command = U,U,D,D,B,F,B,F,b,b
time = 0

[Command]
name = "CPU3"
command = U,U,D,D,B,F,B,F,c,c
time = 0

[Command]
name = "CPU4"
command = U,U,D,D,B,F,B,F,x,x
time = 0

[Command]
name = "CPU5"
command = U,U,D,D,B,F,B,F,y,y
time = 0

[Command]
name = "CPU6"
command = U,U,D,D,B,F,B,F,z,z
time = 0

[Command]
name = "CPU7"
command = U,U,D,D,B,F,B,F,a,b
time = 0

[Command]
name = "CPU8"
command = U,U,D,D,B,F,B,F,b,c
time = 0

[Command]
name = "CPU9"
command = U,U,D,D,B,F,B,F,a,c
time = 0

[Command]
name = "CPU10"
command = U,U,D,D,B,F,B,F,x,y
time = 0

[Command]
name = "CPU11"
command = U,U,D,D,B,F,B,F,y,z
time = 0

[Command]
name = "CPU12"
command = U,U,D,D,B,F,B,F,x,z
time = 0

[Command]
name = "CPU13"
command = U,U,D,D,B,F,B,F,a,x
time = 0

[Command]
name = "CPU14"
command = U,U,D,D,B,F,B,F,a,y
time = 0

[Command]
name = "CPU15"
command = U,U,D,D,B,F,B,F,a,z
time = 0

[Command]
name = "CPU16"
command = U,U,D,D,B,F,B,F,b,x
time = 0

[Command]
name = "CPU17"
command = U,U,D,D,B,F,B,F,b,y
time = 0

[Command]
name = "CPU18"
command = U,U,D,D,B,F,B,F,b,z
time = 0

[Command]
name = "CPU19"
command = U,U,D,D,B,F,B,F,c,x
time = 0

[Command]
name = "CPU20"
command = U,U,D,D,B,F,B,F,c,y
time = 0

[Command]
name = "CPU21"
command = U,U,D,D,B,F,B,F,c,z
time = 0

[Command]
name = "CPU22"
command = U,U,D,D,B,F,B,F,x,a
time = 0

[Command]
name = "CPU23"
command = U,U,D,D,B,F,B,F,x,b
time = 0

[Command]
name = "CPU24"
command = U,U,D,D,B,F,B,F,x,c
time = 0

[Command]
name = "CPU25"
command = U,U,D,D,B,F,B,F,y,a
time = 0

[Command]
name = "CPU26"
command = U,U,D,D,B,F,B,F,y,b
time = 0

[Command]
name = "CPU27"
command = U,U,D,D,B,F,B,F,y,c
time = 0

[Command]
name = "CPU28"
command = U,U,D,D,B,F,B,F,z,a
time = 0

[Command]
name = "CPU29"
command = U,U,D,D,B,F,B,F,z,b
time = 0

[Command]
name = "CPU30"
command = U,U,D,D,B,F,B,F,z,c
time = 0

[Command]
name = "CPU31"
command = U,U,D,D,B,F,B,F,s,s,s
time = 0

;-| Super Motions |--------------------------------------------------------
;g
[Command]
name = "g"
command = ~D, DF, F, x+y

[Command]
name = ""
command = ~D, DF, F, a+b


;-| Special Motions |------------------------------------------------------

[Command]
name = "ςg̏p"
command = ~F, DF, D,DB,B, z
time = 20

[Command]
name = "ςg̏p"
command = ~F, DF, D,DB,B, y
time = 20

[Command]
name = "ςg̏p"
command = ~F, DF, D,DB,B, x
time = 20

[Command]
name = "˂"
command = ~F, D, DF, z

[Command]
name = "˂"
command = ~F, D, DF, y

[Command]
name = "˂"
command = ~F, D, DF, x

[Command]
name = "K藠z"
command = ~D, DF, F, z

[Command]
name = "K藠y"
command = ~D, DF, F, y

[Command]
name = "K藠x"
command = ~D, DF, F, x


[Command]
name = "藠"
command = ~D, DF, F, z

[Command]
name = "藠"
command = ~D, DF, F, y

[Command]
name = "藠"
command = ~D, DF, F, x

[Command]
name = "X[N{"
command = ~D, DF, F, a
time = 25

[Command]
name = "X[N{"
command = ~D, DF, F, b
time = 25

[Command]
name = "X[N{"
command = ~D, DF, F, c
time = 25

[Command]
name = "͉̂B̏pEV"
command = ~B, D, DB, z

[Command]
name = "͉̂B̏pEV"
command = ~B, D, DB, y

[Command]
name = "͉̂B̏pEV"
command = ~B, D, DB, x


[Command]
name = "͉̂B̏pEn"
command = ~D, DB, B, z

[Command]
name = "͉̂B̏pEn"
command = ~D, DB, B, y

[Command]
name = "͉̂B̏pEn"
command = ~D, DB, B, x

[Command]
name = "R"
command = ~D, DB, B, a
time = 20

[Command]
name = "R"
command = ~D, DB, B, b
time = 20

[Command]
name = "R"
command = ~D, DB, B, c
time = 20

[Command]
name = "yق̏p"
command = ~D, D, z

[Command]
name = "yق̏p"
command = ~D, D, y

[Command]
name = "yق̏p"
command = ~D, D, x


[Command]
name = "Warpa"
command = ~B, D, DB, B, a

[Command]
name = "Warpb"
command = ~B, D, DB, B, b

[Command]
name = "Warpc"
command = ~B, D, DB, B, c

[Command]
name = "Warpx"
command = ~B, D, DB, B, x

[Command]
name = "Warpy"
command = ~B, D, DB, B, y

[Command]
name = "Warpz"
command = ~B, D, DB, B, z


[Command]
name = "SuperJump"
command = $D, $U

[Command]
name = "SuperJump"
command = a+b
time = 2


[Command]
name = "RecoveryRoll"
command = ~B, DB, D, x
time = 20
[Command]
name = "RecoveryRoll"
command = ~B, DB, D, y
time = 20
[Command]
name = "RecoveryRoll"
command = ~B, DB, D, z
time = 20
[Command]
name = "RecoveryRoll2"
command = ~B, DB, D, a
time = 20
[Command]
name = "RecoveryRoll2"
command = ~B, DB, D, b
time = 20
[Command]
name = "RecoveryRoll2"
command = ~B, DB, D, c
time = 20

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

[Command]
name = "2p"
command = x+y
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "ςȂx"
command = /$x
time = 1

[Command]
name = "ςȂy"
command = /$y
time = 1

[Command]
name = "ςȂa"
command = /$a
time = 1

[Command]
name = "ςȂb"
command = /$b
time = 1

[Command]
name = "ςȂz"
command = /$z
time = 1

[Command]
name = "ςȂc"
command = /$c
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "down_c"
command = D+c
time = 2

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;[Command]
;name = "F"
;command = f
;time = 1



;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;---------------------------------------------------------------------------
;͕̂Sg̏p
[State -1, ]
type = ChangeState
value = 2000
triggerall = var(34) = 0
triggerall = command = "g"
triggerall = Power >= 1000
triggerall = StateType = S || StateType = C 
trigger1 = ctrl
trigger2 = StateNo = [200,250]
trigger3 = StateNo = [400,450]
trigger4 = ctrl
trigger5 = stateno = [1000,1100]

;---------------------------------------------------------------------------
;΂T
[State -1, ]
type = ChangeState
value = 3000
triggerall = var(34) = 0
triggerall = command = ""
triggerall = Power >= 1000
triggerall = StateType = S || StateType = C || StateType = A
trigger1 = ctrl
trigger2 = StateNo = [200,250]
trigger3 = StateNo = [400,450]
trigger4 = StateNo = [600,655]
trigger5 = ctrl
trigger6 = stateno = [1000,1500]
trigger7 = stateno = 1919



;===========================================================================

;---------------------------------------------------------------------------
;"͉̂B̏pES"
; Warp LP
[State -1, Warp LP]
type = ChangeState
value = 2300
triggerall = command = "Warpx"
triggerall = StateType = S || StateType = C
trigger1 = ctrl
trigger2 = StateNo = [200,250]
trigger3 = StateNo = [400,450]

;---------------------------------------------------------------------------
; Warp MP
[State -1, Warp MP]
type = ChangeState
value = 2301
triggerall = command = "Warpy"
triggerall = StateType = S || StateType = C
trigger1 = ctrl
trigger2 = StateNo = [200,250]
trigger3 = StateNo = [400,450]

;---------------------------------------------------------------------------
; Warp HP
[State -1, Warp HP]
type = ChangeState
value = 2302
triggerall = command = "Warpz"
triggerall = StateType = S || StateType = C
trigger1 = ctrl
trigger2 = StateNo = [200,250]
trigger3 = StateNo = [400,450]

;---------------------------------------------------------------------------
; Warp LK
[State -1, Warp LK]
type = ChangeState
value = 2303
triggerall = command = "Warpa"
triggerall = StateType = S || StateType = C
trigger1 = ctrl
trigger2 = StateNo = [200,250]
trigger3 = StateNo = [400,450]

;---------------------------------------------------------------------------
; Warp MK
[State -1, Warp MK]
type = ChangeState
value = 2304
triggerall = command = "Warpb"
triggerall = StateType = S || StateType = C
trigger1 = ctrl
trigger2 = StateNo = [200,250]
trigger3 = StateNo = [400,450]

;---------------------------------------------------------------------------
; Warp HK
[State -1, Warp HK]
type = ChangeState
value = 2305
triggerall = command = "Warpc"
triggerall = StateType = S || StateType = C
trigger1 = ctrl
trigger2 = StateNo = [200,250]
trigger3 = StateNo = [400,450]

;---------------------------------------------------------------------------


;---------------------------------------------------------------------------
;эjƂ̏p
[State -1, ]
type = ChangeState
value = 1800
triggerall = var(34) != 1
triggerall = command = "ςg̏p"
triggerall = statetype = A
trigger1 = ctrl
trigger2 = StateNo = [600,670]

;---------------------------------------------------------------------------

;эjƂ̏p
[State -1, ]
type = ChangeState
value = 1801
triggerall = var(34) != 1
triggerall = command = "ςg̏p"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = StateNo = [200,270]
trigger3 = StateNo = [400,470]

;---------------------------------------------------------------------------

;TTȑp
[State -1, Fast Kung Fu Knee]
type = ChangeState
value = 1500
triggerall = command = "͉̂B̏pEn"
triggerall = statetype = A
triggerall = stateno != 1500
triggerall = stateno != 1505
trigger1 = ctrl
trigger2 = StateNo = [600,650]

;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
;ꖳ
[State -1, Fast Kung Fu Knee]
type = ChangeState
value = 1400
triggerall = var(34) != 1
triggerall = command = "藠"
triggerall = statetype = A
trigger1 = ctrl
trigger2 = StateNo = [600,650]

;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
;R
[State -1, Fast Kung Fu Knee]
type = ChangeState
value = 1300
triggerall = var(34) != 1
triggerall = command = "R"
triggerall = statetype = A
trigger1 = ctrl
trigger2 = StateNo = [600,655]

;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
;ςg̏p
;[State -1, Fast Kung Fu Knee]
;type = ChangeState
;value = 1700
;triggerall = command = "ςg̏p"
;triggerall = statetype != A
;trigger1 = ctrl
;trigger2 = StateNo = [200,250]
;trigger3 = StateNo = [400,450]

;---------------------------------------------------------------------------
;͉̂B̏pEV
;[State -1, Fast Kung Fu Knee]
;type = ChangeState
;value = 1220
;triggerall = command = "͉̂B̏pEV"
;triggerall = statetype != A
;trigger1 = ctrl
;trigger2 = StateNo = [200,250]
;trigger3 = StateNo = [400,450]

;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
;͉̂B̏pEn
;[State -1, Fast Kung Fu Knee]
;type = ChangeState
;value = 1200
;triggerall = command = "͉̂B̏pEn"
;triggerall = statetype != A
;trigger1 = ctrl
;trigger2 = StateNo = [200,250]
;trigger3 = StateNo = [400,450]

;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
;˂
[State -1, Fast Kung Fu Knee]
type = ChangeState
value = 1100
triggerall = var(34) != 1
triggerall = command = "˂"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = StateNo = [200,250]
trigger3 = StateNo = [400,450]

;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
;K藠
[State -1, Fast Kung Fu Knee]
type = ChangeState
value = 1000
triggerall = var(34) != 1
triggerall = command = "K藠x"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = StateNo = [200,250]
trigger3 = StateNo = [400,450]

;---------------------------------------------------------------------------
;K藠
[State -1, Fast Kung Fu Knee]
type = ChangeState
value = 1010
triggerall var(34) != 1
triggerall = command = "K藠y"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = StateNo = [200,250]
trigger3 = StateNo = [400,450]
;---------------------------------------------------------------------------
;K藠
[State -1, Fast Kung Fu Knee]
type = ChangeState
value = 1020
triggerall var(34) != 1
triggerall = command = "K藠z"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = StateNo = [200,250]
trigger3 = StateNo = [400,450]
;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
;藠
;[State -1, Fast Kung Fu Knee]
;type = ChangeState
;value = 1000
;triggerall = command = "藠"
;triggerall = statetype != A
;trigger1 = ctrl
;trigger2 = StateNo = [200,250]
;trigger3 = StateNo = [400,450]

;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
;X[N{
[State -1, Fast Kung Fu Knee]
type = ChangeState
value = 1919
triggerall = var(34) != 1
triggerall = command = "X[N{"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = StateNo = [200,250]
trigger3 = StateNo = [400,450]


;---------------------------------------------------------------------------
;yق̏p
[State -1, Fast Kung Fu Knee]
type = ChangeState
value = 1600
triggerall = command = "yق̏p"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = StateNo = [200,250]
trigger3 = StateNo = [400,450]





;===========================================================================


;---------------------------------------------------------------------------
; Push Block (Stand)
[State -1]
type = ChangeState
value = 1230
triggerall = (command = "x" && command = "y") || (command = "y" && command = "z") || (command = "x" && command = "y" && command = "z")
trigger1 = stateno = [150,151]

;Push Block (crouching)
[State -1]
type = ChangeState
value = 1240
triggerall = (command = "x" && command = "y") || (command = "y" && command = "z") || (command = "x" && command = "y" && command = "z")
trigger1 = stateno = [152,153]

;Push Block (aerial)
[State -1]
type = ChangeState
value = 1250
triggerall = (command = "x" && command = "y") || (command = "y" && command = "z") || (command = "x" && command = "y" && command = "z")
trigger1 = stateno = 154
trigger2 = stateno = 155
trigger2 = Time <= 10

;---------------------------------------------------------------------------
;Run Back
[State -1, Run Back]
type = ChangeState
value = 105
triggerall = StateNo != 105
triggerall = statetype = S
triggerall = ctrl 
trigger1 = command = "BB"
trigger2 = command = "holdback"
trigger2 = (command = "x" && command = "y") || (command = "y" && command = "z") || (command = "x" && command = "y" && command = "z")

;---------------------------------------------------------------------------
;Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
triggerall = var(34) != 1
triggerall = StateNo != [100,102]
;triggerall = statetype = S||stateno=10
triggerall = ctrl
trigger1 = command = "FF"
trigger1 = statetype = S
trigger2 = command = "x" && command = "y"
trigger2 = statetype = S || stateno=10
trigger3 = command = "y" && command = "z"
trigger3 = statetype = S || stateno=10
trigger4 = command = "x" && command = "y" && command = "z"
trigger4 = statetype = S || stateno=10

;---------------------------------------------------------------------------
;Air Dash
;_bV
[State -1, Air Dash]
type = ChangeState
value = 101
triggerall = command = "FF" || command = "2p"
trigger1 = statetype = A
trigger1 = ctrl
trigger1 = (stateno != 101 && time >= 3)
;trigger2 = (prevstateno = 55 && time >= 22)
;trigger3 = anim = 42 && time <= 8
;trigger3 = command = "holdfwd"

;---------------------------------------------------------------------------

; Super Jump
[State -1, Superjump]
type = ChangeState
value = 660
triggerall =  command = "SuperJump"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 420) && movehit 
trigger3 = (stateno = 220) && movehit 
trigger4 = (stateno = 450) && movehit
trigger5 = (stateno = 440) && movehit 

;---------------------------------------------------------------------------
; Air Throw 󒆓
[State -1, Air Throw]
type = ChangeState
value = 802
triggerall = command = "y" || command = "z"
triggerall = statetype = A
triggerall = ctrl
triggerall = stateno != 100
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X < 3
trigger1 = (p2statetype = A) 
trigger1 = p2movetype != H
trigger2 = command = "holdback"
trigger2 = p2bodydist X < 5
trigger2 = (p2statetype = A)
trigger2 = p2movetype != H

;---------------------------------------------------------------------------
; 
[State -1, ]
type = ChangeState
value = 800
triggerall = command = "y" || command = "z"
triggerall = statetype = S
triggerall = ctrl
triggerall = stateno != 100
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X < 3
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
trigger2 = command = "holdback"
trigger2 = p2bodydist X < 5
trigger2 = (p2statetype = S) || (p2statetype = C)
trigger2 = p2movetype != H

;---------------------------------------------------------------------------
; 
[State -1, ]
type = ChangeState
value = 801
triggerall = command = "b" || command = "c"
triggerall = statetype = S
triggerall = ctrl
triggerall = stateno != 100
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X < 3
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
trigger2 = command = "holdback"
trigger2 = p2bodydist X < 5
trigger2 = (p2statetype = S) || (p2statetype = C)
trigger2 = p2movetype != H

;===========================================================================
;---------------------------------------------------------------------------
;Stand Light Punch
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Stand Medium Punch
[State -1, Stand Medium Punch]
type = ChangeState
value = 210
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = StateNo = 200
trigger2 = MoveContact
trigger3 = StateNo = 230
trigger3 = MoveContact
trigger4 = StateNo = 400
trigger4 = MoveContact
trigger5 = StateNo = 430
trigger5 = MoveContact
trigger6 = StateNo = 435
trigger6 = MoveContact

;---------------------------------------------------------------------------
; Stand Hard Punch
[State -1, Stand Hard Punch]
type = ChangeState
value = 220
triggerall = command = "z"
triggerall = command != "holddown"
trigger1 = StateType = S
trigger1 = ctrl
trigger2 = StateNo = 200
trigger2 = MoveContact
trigger3 = StateNo = 210
trigger3 = MoveContact
trigger4 = StateNo = 230
trigger4 = MoveContact
trigger5 = StateNo = 240
trigger5 = MoveContact
trigger6 = StateNo = 400
trigger6 = MoveContact
trigger7 = StateNo = 410
trigger7 = MoveContact
trigger8 = StateNo = 430
trigger8 = MoveCOntact
trigger9 = StateNo = 440
trigger9 = MoveContact
trigger10 = StateNo = 435
trigger10 = MoveContact 

;---------------------------------------------------------------------------
;Stand Light Kick
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = StateNo = 200
trigger2 = MoveContact
trigger3 = StateNo = 400
trigger3 = MoveContact

;---------------------------------------------------------------------------
;Standing Medium Kick
[State -1, Standing Medium Kick]
type = ChangeState
value = 240
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = StateNo = 200
trigger2 = MoveContact
trigger3 = StateNo = 210
trigger3 = MoveContact
trigger4 = StateNo = 230
trigger4 = MoveContact
trigger5 = StateNo = 400
trigger5 = MoveContact
trigger6 = StateNo = 410
trigger6 = MoveContact
trigger7 = StateNo = 430
trigger7 = MoveContact
trigger8 = StateNo = 435
trigger8 = MoveContact 

;---------------------------------------------------------------------------
; Standing Hard Kick
[State -1, Standing Hard Kick]
type = ChangeState
value = 250
triggerall = command = "c"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = StateNo = 200
trigger2 = MoveContact
trigger3 = StateNo = 210
trigger3 = MoveContact
trigger4 = StateNo = 230
trigger4 = MoveContact
trigger5 = StateNo = 240
trigger5 = MoveContact
trigger6 = StateNo = 400
trigger6 = MoveContact
trigger7 = StateNo = 410
trigger7 = MoveContact
trigger8 = StateNo = 430
trigger8 = MoveCOntact
trigger9 = StateNo = 440
trigger9 = MoveContact 
trigger10 = StateNo = 435
trigger10 = MoveContact 
trigger11 = StateNo = 220
trigger11 = MoveContact
trigger12 = StateNo = 420
trigger12 = MoveContact  

; Launcher followup jump
[State -1, Launcher followup]
type = ChangeState
value = 255
triggerall = var(34) != 1
triggerall = command = "holdup" 
trigger1 = StateNo = 250
trigger1 = Movehit 
trigger2 = StateNo = 440
trigger2 = Movehit
;---------------------------------------------------------------------------
;Taunt
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Light Punch
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Medium Punch
[State -1, Crouching Medium Punch]
type = ChangeState
value = 410
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = StateNo = 200
trigger2 = MoveContact
trigger3 = StateNo = 230
trigger3 = MoveContact
trigger4 = StateNo = 400
trigger4 = MoveContact
trigger5 = StateNo = 430
trigger5 = MoveContact
trigger6 = StateNo = 435
trigger6 = MoveContact 

;---------------------------------------------------------------------------
; Crouching Hard Punch
[State -1, Crouching Hard Punch]
type = ChangeState
value = 420
triggerall = command = "z"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = StateNo = 200
trigger2 = MoveContact
trigger3 = StateNo = 210
trigger3 = MoveContact
trigger4 = StateNo = 230
trigger4 = MoveContact
trigger5 = StateNo = 240
trigger5 = MoveContact
trigger6 = StateNo = 400
trigger6 = MoveContact
trigger7 = StateNo = 410
trigger7 = MoveContact
trigger8 = StateNo = 430
trigger8 = MoveCOntact
trigger9 = StateNo = 440
trigger9 = MoveContact
trigger10 = StateNo = 435
trigger10 = MoveContact 

;---------------------------------------------------------------------------
;Crouching Light Kick@XCfBO
[State -1, Crouching Light Kick]
type = ChangeState
value = 435
triggerall = command = "a" && command = "holddown" && command = "holdfwd"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = StateNo = 200
trigger2 = MoveContact
trigger3 = StateNo = 400
trigger3 = MoveContact

;---------------------------------------------------------------------------
;Crouching Light Kick
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = StateNo = 200
trigger2 = MoveContact
trigger3 = StateNo = 400
trigger3 = MoveContact

;---------------------------------------------------------------------------


;---------------------------------------------------------------------------

;Crouching Medium Kick
[State -1, Crouching Medium Kick]
type = ChangeState
value = 440
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = StateNo = 200
trigger2 = MoveContact
trigger3 = StateNo = 210
trigger3 = MoveContact
trigger4 = StateNo = 230
trigger4 = MoveContact
trigger5 = StateNo = 400
trigger5 = MoveContact
trigger6 = StateNo = 410
trigger6 = MoveContact
trigger7 = StateNo = 430
trigger7 = MoveContact
trigger8 = StateNo = 435
trigger8 = MoveContact
 

;---------------------------------------------------------------------------
; Crouching Hard Kick
[State -1, Crouching Hard Kick]
type = ChangeState
value = 450
triggerall = command = "c"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = StateNo = 200
trigger2 = MoveContact
trigger3 = StateNo = 210
trigger3 = MoveContact
trigger4 = StateNo = 230
trigger4 = MoveContact
trigger5 = StateNo = 240
trigger5 = MoveContact
trigger6 = StateNo = 400
trigger6 = MoveContact
trigger7 = StateNo = 410
trigger7 = MoveContact
trigger8 = StateNo = 430
trigger8 = MoveCOntact
trigger9 = StateNo = 440
trigger9 = MoveContact
trigger10 = StateNo = 435
trigger10 = MoveContact 

;---------------------------------------------------------------------------
;Jump Light Punch
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Jump Medium Punch
[State -1, Jump Medium Punch]
type = ChangeState
value = 610
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = MoveContact
trigger3 = StateNo = 630
trigger3 = MoveContact


;---------------------------------------------------------------------------
; Jump Hard Punch
[State -1, Jump Hard Punch]
type = ChangeState
value = 620
triggerall = command = "z"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = StateNo = 600
trigger2 = MoveContact
trigger3 = StateNo = 610
trigger3 = MoveContact
trigger4 = StateNo = 630
trigger4 = MoveContact
trigger5 = StateNo = 640
trigger5 = MoveContact

;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = StateNo = 600
trigger2 = MoveContact

;---------------------------------------------------------------------------
;Jump Medium Kick
[State -1, Jump Medium Kick]
type = ChangeState
value = 640
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = StateNo = 600
trigger2 = MoveContact
trigger3 = StateNo = 610
trigger3 = MoveContact
trigger4 = StateNo = 630
trigger4 = MoveContact

;---------------------------------------------------------------------------


; Jump Hard Kick
[State -1, Jump Hard Kick]
type = ChangeState
value = 655
triggerall = command = "down_c"
trigger1 = ctrl
trigger1 = StateType = A
trigger2 = StateNo = 600
trigger2 = MoveContact
trigger3 = StateNo = 610
trigger3 = MoveContact
trigger4 = StateNo = 630
trigger4 = MoveContact
trigger5 = StateNo = 640
trigger5 = MoveContact
trigger6 = StateNo = 620
trigger6 = MoveContact



; Jump Hard Kick
[State -1, Jump Hard Kick]
type = ChangeState
value = 650
triggerall = command = "c"
trigger1 = StateType = A
trigger1 = ctrl
trigger2 = StateNo = 600
trigger2 = MoveContact
trigger3 = StateNo = 610
trigger3 = MoveContact
trigger4 = StateNo = 630
trigger4 = MoveContact
trigger5 = StateNo = 640
trigger5 = MoveContact
trigger6 = StateNo = 620
trigger6 = MoveContact


;---------------------------------------------------------------------------
;_E
----------------------------------------------------------------------------------------
; Recovery Roll
[State -1, Falling]
type = VarSet
triggerall = !var(59)
triggerall = alive
triggerall = (StateNo = 5035) || (StateNo = 5050) || (StateNo = 5071)
triggerall = Stateno != 5040
trigger1 = (Command = "RecoveryRoll")
var(57) = 1

[State -1, Rolling]
type = ChangeState
value = 690
triggerall = !var(59)
triggerall = Var(57) = 1 
triggerall = (StateNo = 5035) || (StateNo = 5050) || (StateNo = 5071)
trigger1 = (Pos Y >= 0) && (Vel Y > 0)

; Recovery Roll
[State -1, Falling]
type = VarSet
triggerall = !var(59)
triggerall = alive
triggerall = (StateNo = 5035) || (StateNo = 5050) || (StateNo = 5071)
triggerall = Stateno != 5040
trigger1 = (Command = "RecoveryRoll2")
var(57) = 2

[State -1, Rolling]
type = ChangeState
value = 710
triggerall = !var(59)
triggerall = Var(57) = 2
triggerall = (StateNo = 5035) || (StateNo = 5050) || (StateNo = 5071)
trigger1 = (Pos Y >= 0) && (Vel Y > 0)

;---------------------------------------------------------------------------
[State -1, Rolling]
type       = ChangeState
triggerall = var(59)=0
triggerall = stateno=5100||stateno=5110||stateno=5120
trigger1   = command="RecoveryRoll"
value      = 690

[State -1, Rolling]
type       = ChangeState
triggerall = var(59)=0
triggerall = stateno=5100||stateno=5110||stateno=5120
trigger1   = command="RecoveryRoll2"
value      = 710




