; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below. 
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10



;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 30

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1


;-| TCo[EX |--------------------------------------------------------


;t@CiDED
[Command]
name = "Final DD"
command = ~D, DF, F,D, DF, F, x

[Command]
name = "Final DD"
command = ~D, DF, F,D, DF, F, y




;-| R}hZ |------------------------------------------------------




;hLm
[Command]
name = "QCF_x"
command = ~D, DF, F, x



;nCp[DEDiA1j
[Command]
name = "QCB_x"
command = ~F,B,F, x

;nCp[DEDiA2j
[Command]
name = "QCB_y"
command = ~F,B,F, y

;D3{
[Command]
name = "QCF_y"
command = ~D, DF, F, z

;D3{i߁j
[Command]
name = "Land Mine Ex near"
command = ~D, DB, B, z

;TCNX^v
[Command]
name = "QCF_z"
command=~D, DB, B, a
time=15

; _bVUiA1j
[Command]
name = "FFx"
command = F, F, x

;_bVUiA2j
[Command]
name = "FFy"
command = F, F, y

GXgsO
[Command]
name = "Oiuchi"
command = $D,y

GMKNbV
[Command]
name = "Giga Crush"
command = x+y

Gp[`[W
[Command]
name = "Recharge Power"
command = x+y


[Command]
name = "Special Reversal"
command = /B,c


;[Command]
;name = "Super Jump"
;command = D,$U

;----||---------------------------------------


;iA1j
[Command]
name = "Stand Throw"  ;while standing
command = /F,x

[Command]
name = "Stand Throw"  ;while standing
command = /B,x

;iA2j
[Command]
name = "Toss"
command = /F,y

[Command]
name = "Toss"
command = /B,y

[Command]
name = "Arm Twist"
command = ~B,F,z




;----|ʏ|---------------------------------------


;-| u[Xg |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1


;-| {^ |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| z[h |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

[Command]
name = "holdx"
command = /x
time = 1


[Command]
name = "holdy"
command = /y
time = 1

[Command]
name = "holdz"
command = /z
time = 1

[Command]
name = "holda"
command = /a
time = 1

[Command]
name = "holdb"
command = /b
time = 1

[Command]
name = "holdc"
command = /c
time = 1

[Command]
name = "holds"
command = /s
time = 1

;--------------

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]


;---------------------------------------------------------------------------





;---------------------------------------------------------------------------

[State -1,t@CiDED]
type = ChangeState
value = 3000
triggerall = !var(59)
triggerall = command = "Final DD"
triggerall = power >= 1000
triggerall = statetype != A
trigger1 = ctrl
trigger2 = var(51)
trigger3 = stateno = 200 && time >= 8 || stateno = 210 && time >= 7 || stateno = 300 && time >= 8
trigger4 = stateno = 310 && time >= 10|| stateno = 400 && time >= 13|| stateno = 630 && time >= 9
trigger5 = stateno = stateno =2300 && time >= 21|| stateno =2301 && time >= 20 
trigger6 = stateno = stateno = 140 || stateno = 141 ||  stateno = 150 || stateno = 151 
trigger7 = stateno = 100 || stateno = 105 



;---------------------------------------------------------------------------
[State -1, ʏR{P]
type = ChangeState
value = 1000
triggerall = !var(59)
trigger1 = command = "x"
trigger1 = Stateno = 200
trigger1 = MoveContact
;trigger1 = Time >= 10

;------------------------------------------------------------------------------
[State -1, ʏR{Q]
type = ChangeState
value = 1001
triggerall = !var(59)
trigger1 = command = "y"
trigger1 = Stateno = 1000
trigger1 = MoveContact
trigger1 = Time >= 8
trigger2 = command = "y"
trigger2 = Stateno = 200
trigger2 = MoveContact
trigger2 = Time >= 8


;---------------------------------------------------------------------------
[State -1, MKNbV]
type = ChangeState
value = 1230
triggerall = !var(59)
triggerall = command = "Giga Crush"
triggerall = power >= 1000
triggerall = StateType != A
trigger1 = ctrl 
trigger2 = var(51) = 1
trigger3 = stateno = 100 || stateno = 105

;---------------------------------------------------------------------------
[State -1, hLm]
type = ChangeState
value = 1240
triggerall = !var(59)
triggerall = command = "QCF_x"
triggerall = StateType != A
triggerall = NumHelper(2300) = 0
trigger1 = ctrl
trigger2 = var(51) = 1
trigger3 = stateno = 200 && time >= 8 || stateno = 210 && time >= 7 || stateno = 300 && time >= 8
trigger4 = stateno = 310 && time >= 10|| stateno = 400 && time >= 13|| stateno = 630 && time >= 9
trigger5 = stateno = stateno =2300 && time >= 21|| stateno =2301 && time >= 20
trigger6 = stateno = 100 || stateno = 105 

;---------------------------------------------------------------------------
[State -1, nCp[DEDiA1j]
type = ChangeState
value = 1250
triggerall = !var(59)
triggerall = command = "QCB_x"
triggerall = StateType != A
trigger1 = ctrl
trigger2 = var(51) = 1
trigger3 = stateno = 200 && time >= 8 || stateno = 210 && time >= 7 || stateno = 300 && time >= 8
trigger4 = stateno = 310 && time >= 10|| stateno = 400 && time >= 13|| stateno = 630 && time >= 9
trigger5 = stateno = stateno =2300 && time >= 21|| stateno =2301 && time >= 20 
trigger6 = stateno = 100 || stateno = 105


[State -1, nCp[DEDiA2j]
type = ChangeState
value = 1255
triggerall = !var(59)
triggerall = command = "QCB_y"
triggerall = StateType != A
trigger1 = ctrl
trigger2 = var(51) = 1
trigger3 = stateno = 200 && time >= 8 || stateno = 210 && time >= 7 || stateno = 300 && time >= 8
trigger4 = stateno = 310 && time >= 10|| stateno = 400 && time >= 13|| stateno = 630 && time >= 9
trigger5 = stateno = stateno =2300 && time >= 21|| stateno =2301 && time >= 20
trigger6 = stateno = 100 || stateno = 105 

;---------------------------------------------------------------------------
[State -1, D3{]
type = ChangeState
value = 1260
triggerall = !var(59)
triggerall = command = "QCF_y"
triggerall = StateType != A
triggerall = NumHelper(1263) = 0
triggerall = NumHelper(2300) = 0
trigger1 = ctrl
trigger2 = var(51) = 1
trigger3 = stateno = 200 && time >= 8 || stateno = 210 && time >= 7 || stateno = 300 && time >= 8
trigger4 = stateno = 310 && time >= 10|| stateno = 400 && time >= 13|| stateno = 630 && time >= 9
trigger5 = stateno =2300 && time >= 21|| stateno =2301 && time >= 20 
trigger6 = stateno = 100 || stateno = 105

;---------------------------------------------------------------------------
[State -1, D3{i߁j]
type = ChangeState
value = 1261
triggerall = !var(59)
triggerall = command = "Land Mine Ex near"
triggerall = StateType != A
triggerall = NumHelper(1263) = 0
triggerall = NumHelper(2300) = 0
trigger1 = ctrl
trigger2 = var(51) = 1
trigger3 = stateno = 200 && time >= 8 || stateno = 210 && time >= 7 || stateno = 300 && time >= 8
trigger4 = stateno = 310 && time >= 10|| stateno = 400 && time >= 13|| stateno = 630 && time >= 9
trigger5 = stateno =2300 && time >= 21|| stateno =2301 && time >= 20 
trigger6 = stateno = 100 || stateno = 105

;---------------------------------------------------------------------------

[State -1, n]
type = ChangeState
value = 2300
triggerall = !var(59)
triggerall = statetype = S
triggerall = NumHelper(2300) = 0
triggerall = NumHelper(1263) = 0
triggerall = command = "z"
trigger1 = ctrl
trigger2 = stateno = 200 && time >= 8 || stateno = 210 && time >= 7 || stateno = 300 && time >= 8
trigger3 = stateno = 310 && time >= 10|| stateno = 400 && time >= 13|| stateno = 630 && time >= 9
trigger4 = stateno =2300 && time >= 21|| stateno =2301 && time >= 20
trigger5 = stateno = 100 || stateno = 105 


[State -1, ni߁j]
type = ChangeState
value = 2301
triggerall = !var(59)
triggerall = statetype = C
triggerall = command = "z"
triggerall = NumHelper(2300) = 0
triggerall = NumHelper(1263) = 0
trigger1 = ctrl
trigger2 = stateno = 200 && time >= 8 || stateno = 210 && time >= 7 || stateno = 300 && time >= 8
trigger3 = stateno = 310 && time >= 10|| stateno = 400 && time >= 13|| stateno = 630 && time >= 9
trigger4 = stateno =2300 && time >= 21|| stateno =2301 && time >= 20 
trigger5 = stateno = 100 || stateno = 105


[State -1, ni󒆁j]
type = ChangeState
value = 2302
triggerall = !var(59)
triggerall = command = "z"
triggerall = NumHelper(2300) = 0
triggerall = NumHelper(1263) = 0
triggerall = statetype = A
trigger1 = ctrl
trigger2 = stateno = 200 && time >= 8 || stateno = 210 && time >= 7 || stateno = 300 && time >= 8
trigger3 = stateno = 310 && time >= 10|| stateno = 400 && time >= 13|| stateno = 630 && time >= 9
trigger4 = stateno =2300 && time >= 21|| stateno =2301 && time >= 20 
trigger5 = stateno = 100 || stateno = 105


;===========================================================================
;---------------------------------------------------------------------------


[State -1,Release b]
type = VarSet
trigger1 = command = "holdb"
triggerall = Stateno = 100 ||  Stateno = 105 || Stateno = 50 || Stateno = 54
var(55) = 0

[State -1,Release b]
type = VarSet
trigger1 = command != "holdb"
triggerall = Stateno != 100 ||  Stateno != 105 || Stateno != 50 || Stateno != 54
var(55) = 55

;u[Xg
[State -1, Run Fwd]
type = ChangeState
value = 100
triggerall = !var(59)
triggerall = var(55) = 55
triggerall = Stateno != 100
triggerall = statetype = S
triggerall = command != "holddown"
triggerall = command != "holdup"
triggerall = ctrl
trigger1 = command = "FF"
trigger2 = command != "holdback"
trigger2 = command = "holdb"

;---------------------------------------------------------------------------
;obNu[Xg
[State -1, Run Back]
type = ChangeState
value = 105
triggerall = !var(59)
triggerall = var(55) = 55
triggerall = Stateno != 105
triggerall = statetype = S
triggerall = command != "holddown"
triggerall = command != "holdup"
triggerall = ctrl
trigger1 = command = "BB"
trigger2 = command = "holdback"
trigger2 = command = "holdb"
trigger3 = Stateno = 150 && time >= 2 || Stateno = 151 && time >= 2
trigger3 = command = "BB"|| command = "holdback" && command = "holdb"


;---------------------------------------------------------------------------

[State -1, 󒆃u[Xg]
type = ChangeState
value = 54
triggerall = var(54) < 3
triggerall = Stateno = 54
triggerall = statetype = A
triggerall = ctrl
trigger1 = command = "b"

[State -1]
type = varadd
trigger1 = stateno = 54
trigger1 = Time = 1
var(54) = 1



;---------------------------------------------------------------------------

[State -1,iA1j]
type = ChangeState
value = 800
triggerall = !var(59)
triggerall = command = "Stand Throw"
triggerall = p2BodyDist X <=7
triggerall = ctrl
triggerall = stateno != 100
triggerall = P2Statetype != L
trigger1 = statetype = S
;---------------------------------------------------------------------------

[State -1, iA2j]
type = ChangeState
value = 830
triggerall = !var(59)
triggerall = command = "Toss"
triggerall = p2BodyDist X <=7
triggerall = P2Statetype != L
triggerall = ctrl
trigger1 = stateno != 100
trigger1 = statetype = S

;---------------------------------------------------------------------------
[State -1, Arm Twist]
type = null;ChangeState
value = 860
triggerall = !var(59)
triggerall = command = "start"
triggerall = ctrl
triggerall = stateno != 100
trigger1 = statetype = S



;===========================================================================
;---------------------------------------------------------------------------

[State -1, A1]
type = ChangeState
value = 200
triggerall = !var(59)
triggerall = command = "x"
triggerall = stateno != 100
triggerall = ctrl
trigger1 = statetype = S

;---------------------------------------------------------------------------
[State -1, rȂ]
type = null;ChangeState
value = 207
triggerall = !var(59)
triggerall = command = "c"
triggerall = stateno != 100
triggerall = ctrl
trigger1 = statetype = S

;---------------------------------------------------------------------------
[State -1, A2]
type = ChangeState
value = 210
triggerall = !var(59)
triggerall = command = "y"
triggerall = command != "holdfwd"
triggerall = stateno != 100
triggerall = ctrl
trigger1 = statetype = S


;---------------------------------------------------------------------------
[State -1,  _bVA1]
type = ChangeState
value = 300
triggerall = !var(59)
triggerall = ctrl
triggerall = statetype = S
trigger1 = command = "FFx"
trigger2 = command = "x"
trigger2 = stateno = 100

;---------------------------------------------------------------------------
[State -1, _bVA2]
type = ChangeState
value = 310
triggerall = !var(59)
triggerall = ctrl
triggerall = statetype = S
trigger1 = command = "FFy"
trigger2 = command = "y"
trigger2 = stateno = 100
;---------------------------------------------------------------------------
[State -1, ]
type = null;ChangeState
value = 195
triggerall = !var(59)
triggerall = !Var(59)
triggerall = command = "start"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------

[State -1, ႪA1]
type = ChangeState
value = 400
triggerall = !var(59)
triggerall = command = "x"
triggerall = ctrl
trigger1 = statetype = C

;---------------------------------------------------------------------------
[State -1, ႪA2]
type = ChangeState
value = 430
triggerall = !var(59)
triggerall = command = "y"
triggerall = ctrl
trigger1 = statetype = C


;---------------------------------------------------------------------------
[State -1, A1]
type = ChangeState
value = 630
triggerall = !var(59)
triggerall = command = "x"
triggerall = ctrl
trigger1 = statetype = A


;---------------------------------------------------------------------------
[State -1, A2]
type = ChangeState
value = 640
triggerall = !var(59)
triggerall = command = "y"
triggerall = command != "holddown"
triggerall = ctrl
trigger1 = statetype = A


;---------------------------------------------------------------------------
[State -1, XgsO]
type = ChangeState
value = 650
triggerall = !var(59)
triggerall = command = "Oiuchi"
triggerall = ctrl
trigger1 = statetype = A


;---------------------------------------------------------------------------
[State -1,TCNX^v]
type = ChangeState
value = 670
triggerall = !var(59)
triggerall = ctrl
triggerall = command = "QCF_z"
trigger1 = statetype != A

;---------------------------------------------------------------------------
[State -1, Nオ]
type = ChangeState
value = 701
triggerall = !var(59)
triggerall = stateno = 5120
trigger1 = command = "b"
trigger1 = Time = 1


;---------------------------------------------------------------------------
[State -1, p[`[W]
type = ChangeState
value = 1220
triggerall = !var(59)
triggerall = command = "holdy"
triggerall = command = "holdx"
triggerall = power < 1000
trigger1 = ctrl 
trigger1 = stateno != 1220
trigger1 = StateType = S
trigger2 = stateno = 200 && time >= 8 || stateno = 210 && time >= 7 || stateno = 300 && time >= 8
trigger3 = stateno = 310 && time >= 10|| stateno = 400 && time >= 13
trigger4 = stateno =2300 && time >= 21|| stateno =2301 && time >= 20 


