;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;---------------------------------------------------------------------------
; Default Values
[Defaults]
command.time = 25
command.buffer.time = 1

;-| Super Motions |--------------------------------------------------------
;-| commands |-

[Command]
name = "PU"
command = F, D, DF, a+b
time = 25

[Command]
name = "HC"
command = D, DF, F, x+y
time = 25
[Command]
name = "HC"
command = D, DF, F, x+z
time = 25
[Command]
name = "HC"
command = D, DF, F, y+z
time = 25


;-| Special Motions |------------------------------------------------------
;-| commands |-

[Command]
name = "jpx"
command = B, D, F, x
time = 35
[Command]
name = "jpy"
command = B, D, F, y
time = 35
[Command]
name = "jpz"
command = B, D, F, z
time = 35

[Command]
name = "qx"
command = D, DB, B, x
time = 25
[Command]
name = "qy"
command = D, DB, B, y
time = 25
[Command]
name = "qz"
command = D, DB, B, z
time = 25

[Command]
name = "bpa"
command = B, D, F, a
time = 30
[Command]
name = "bpb"
command = B, D, F, b
time = 30
[Command]
name = "bpc"
command = B, D, F, c
time = 30



[Command]
name = "ns"
command = F, D, B, a
time = 35
[Command]
name = "ns"
command = F, D, B, b
time = 35
[Command]
name = "ns"
command = F, D, B, c
time = 35

[Command]
name = "RecoveryRoll"
command = B, DB, D, x
time = 25
[Command]
name = "RecoveryRoll"
command = B, DB, D, y
time = 25
[Command]
name = "RecoveryRoll"
command = B, DB, D, z
time = 25
[Command]
name = "RecoveryRoll2"
command = B, DB, D, a
time = 25
[Command]
name = "RecoveryRoll2"
command = B, DB, D, b
time = 25
[Command]
name = "RecoveryRoll2"
command = B, DB, D, c
time = 25

[Command]
name = "VC1"
command = B, DB, D, x
time = 25
[Command]
name = "VC1"
command = B, DB, D, y
time = 25
[Command]
name = "VC1"
command = B, DB, D, z
time = 25

[Command]
name = "VC1"
command = y+b
time = 1


[Command]
name = "FFF"     ;Required (do not remove)
command = F, F, F
time = 30

[Command]
name = "BBB"     ;Required (do not remove)
command = B, B, B
time = 30

;-| Double Tap |-----------------------------------------------------------
;-| Eight commands |-

[Command]
name = "FF"       ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"       ;Required (do not remove)
command = B, B
time = 10

[Command]
name = "DU"
command = D, U
time = 10

[Command]
name = "UF"
command = UF
time = 1

[Command]
name = "UB"
command = UB
time = 1

[Command]
name = "DUF"
command = D, UF
time = 10

[Command]
name = "DUB"
command = D, UB
time = 10

[Command]
name = "up"
command = U
time = 1

[Command]
name = "SJ"
command = $D,$U
time = 15

[Command]
name = "SJ"
command = a+b
time = 1



;-| Dir + Button |---------------------------------------------------------
;-| Five commands |-

[Command]
name = "up_c"
command = /$U,c
time = 1

[Command]
name = "up_b"
command = /$U,b
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "down_y"
command = /$D,y
time = 1

[Command]
name = "down_z"
command = /$D,z
time = 1

;-| 2/3 Button Combination |-----------------------------------------------
;-| Four commands |-

[Command]
name = "recovery" ;Required (do not remove)
command = a+b
time = 1

[Command]
name = "TwoPunch"
command = x+y
time = 1
[Command]
name = "TwoPunch"
command = x+z
time = 1
[Command]
name = "TwoPunch"
command = y+z
time = 1

[command] 
name = "Advguard"
command = x+y
time = 5

[Command]
name = "SJ"
command = a+b
time = 2

;-| Single Button |---------------------------------------------------------
;-| Fourteen commands |-

[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "s"
command = s
time = 1

[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 1

[Command]
name = "hold_c"
command = /c
time = 1

[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1

[Command]
name = "hold_z"
command = /z
time = 1

[Command]
name = "fwd"
command = F
time = 1


;-| Hold Dir |--------------------------------------------------------------
;-| Twelve commands |-

[Command]
name = "holdfwd"  ;Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback" ;Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup"   ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown" ;Required (do not remove)
command = /$D
time = 1

[Command]
name = "holddownfwd"
command = /DF
time = 1

[Command]
name = "holddownback"
command = /DB
time = 1

[Command]
name = "holdupfwd"
command = /UF
time = 1

[Command]
name = "holdupback"
command = /UB
time = 1

[Command]
name = "holdfwd2"
command = /F
time = 1

[Command]
name = "holdback2"
command = /B
time = 1

[Command]
name = "holdup2"
command = /U
time = 1

[Command]
name = "holddown2"
command = /D
time = 1

[Command] 
name = "hold_a" 
command = /$a 
[Command] 
name = "hold_b" 
command = /$b 
[Command] 
name = "hold_x" 
command = /$x 
[Command] 
name = "hold_y" 
command = /$y 
[Command] 
name = "hold_c" 
command = /$c 
[Command] 
name = "hold_z" 
command = /$z

[command]
name="fwd"
command=F
time=1
[command]
name="back"
command=B
time=1
[command]
name="up"
command=U
time=1
[command]
name="down"
command=D
time=1

[command]
name="start"
command=s
time=1

;-| CPU Commands |----------------------------------------------------------
;-| Commands |-

[Command]
name = "AI0"
command = a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a
time = 0
[Command]
name = "AI1"
command = b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b
time = 0
[Command]
name = "AI2"
command = c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c
time = 0
[Command]
name = "AI3"
command = x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
time = 0
[Command]
name = "AI4"
command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y
time = 0
[Command]
name = "AI5"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI6"
command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
time = 0
[Command]
name = "AI7"
command = F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F
time = 0
[Command]
name = "AI8"
command = D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D
time = 0
[Command]
name = "AI9"
command = B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B
time = 0
[Command]
name = "AI10"
command = U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U
time = 0
[Command]
name = "AI11"
command = a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a
time = 0
[Command]
name = "AI12"
command = c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c
time = 0
[Command]
name = "AI13"
command = x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
time = 0
[Command]
name = "AI14"
command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y
time = 0
[Command]
name = "AI15"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI16"
command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
time = 0
[Command]
name = "AI17"
command = a,B,c,x,y,z,s,B,D,F,U,a,b,c,x,y,z,s,s
time = 0
[Command]
name = "AI18"
command = a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a
time = 0
[Command]
name = "AI19"
command = b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b
time = 0
[Command]
name = "AI20"
command = c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c
time = 0
[Command]
name = "AI21"
command = x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
time = 0
[Command]
name = "AI22"
command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y
time = 0
[Command]
name = "AI23"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI24"
command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
time = 0
[Command]
name = "AI25"
command = F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F
time = 0
[Command]
name = "AI26"
command = D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D
time = 0
[Command]
name = "AI27"
command = B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B
time = 0
[Command]
name = "AI28"
command = U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U
time = 0
[Command]
name = "AI29"
command = a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a
time = 0
[Command]
name = "AI30"
command = c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c
time = 0
[Command]
name = "AI31"
command = x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
time = 0
[Command]
name = "AI32"
command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y
time = 0
[Command]
name = "AI33"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI34"
command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
time = 0
[Command]
name = "AI35"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI36"
command = z,z,z,z,z,z,a,a,a,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI37"
command = z,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,z,z,z
time = 0
[Command]
name = "AI38"
command = z,z,z,z,z,a,a,a,z,z,z,z,z,a,a,a,z,z,z
time = 0
[Command]
name = "AI39"
command = z,z,z,z,z,a,a,a,z,z,z,z,z,z,a,a,z,z,z
time = 0
[Command]
name = "AI40"
command = z,z,z,z,a,a,a,z,z,z,z,a,z,z,a,a,z,z,z
time = 0
[Command]
name = "AI41"
command = z,z,z,a,z,z,z,z,z,z,z,z,z,a,a,z,z,z,z
time = 0
[Command]
name = "AI42"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI43"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,a,a,z
time = 0
[Command]
name = "AI44"
command = z,z,a,a,a,a,z,z,z,z,z,z,z,z,z,a,a,a,z
time = 0
[Command]
name = "AI45"
command = z,z,z,z,z,z,a,a,z,z,z,z,z,a,a,a,a,z,z
time = 0
[Command]
name = "AI46"
command = z,z,z,z,z,z,z,z,a,a,a,a,a,a,z,z,z,z,z
time = 0
[Command]
name = "AI47"
command = z,z,z,a,a,a,a,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI48"
command = z,z,z,z,z,a,a,a,z,z,z,a,a,a,z,z,a,z,a
time = 0
[Command]
name = "AI49"
command = z,z,z,z,a,a,a,z,z,z,z,z,a,a,a,z,z,z,z
time = 0
[Command]
name = "AI50"
command = z,z,z,a,a,z,z,z,z,z,z,z,z,z,a,a,z,z,z
time = 0

[Statedef -1]
;R}h------------------------------------------------------------------

;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
; p[Abv
[State -1]
type = ChangeState
value = 1300
triggerall = var(59)<=0
triggerall = var(43) = 0
triggerall = command = "PU"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = stateno = [200,450]


; wbhNbV
[State -1]
type = ChangeState
value = 3000
triggerall = var(59)<=0
triggerall = var(43) = 0
triggerall = power >= 1000
triggerall = command = "HC"
triggerall = statetype !=A
trigger1 = ctrl
trigger1 = var(47) = 0
trigger2 = stateno = [200,450]
trigger2 = var(47) = 0
trigger3 = stateno = [1000,1400]
trigger3 = var(47) = 0
trigger4 = stateno = [200,450]
trigger4 = movecontact
trigger4 = var(47) = 1
trigger5 = stateno = [1000,1400]
trigger5 = movecontact
trigger5 = var(47) = 1
trigger6 = stateno = [2222,2223]


;RunBack
[State -1]
type = ChangeState
value = 105
triggerall = var(59)<=0
triggerall = var(43) = 0
triggerall = (command = "holdback2" && command = "TwoPunch") || (StateType != A && command = "BB")
trigger1 = StateType = S
trigger1 = ctrl
trigger1 = StateNo != [105,106]




;RunFwd
[State -1]
type = ChangeState
value = 100
triggerall = var(59)<=0
triggerall = var(43) = 0
triggerall = var(47) = 0
triggerall = (command = "TwoPunch") || (StateType != A && command = "FF")
trigger1 = StateType = S
trigger1 = StateNo != [100,101]
trigger1 = ctrl
trigger2 = StateNo = 10



;---------------------------------------------------------------------------
; Guard Push (Stand)
[State -1, Guard Push]
type = ChangeState
value = 7610
triggerall = var(59)<=0
triggerall = command = "Advguard"
trigger1 = stateno = [150,151]

;Guard Push (Crouch)
[State -1, Guard Push]
type = ChangeState
value = 7615
triggerall = var(59)<=0
triggerall = command = "Advguard"
trigger1 = stateno = [152,153]

;Guard Push (Air)
[State -1, Guard Push]
type = ChangeState
value = 7620
triggerall = var(59)<=0
triggerall = command = "Advguard"
trigger1 = stateno = 154
trigger2 = stateno = 155

;---------------------------------------------------------------------------
;-------------------------------Specials------------------------------------
;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
; NGCNX
[State -1]
type = ChangeState
value = 1000
triggerall = var(59)<=0
triggerall = var(43) = 0
triggerall = statetype != A
triggerall = command = "qx"
trigger1 = ctrl
trigger2 = stateno = [200,450]

;---------------------------------------------------------------------------
; NGCN Y
[State -1]
type = ChangeState
value = 1001
triggerall = var(59)<=0
triggerall = var(43) = 0
triggerall = statetype != A
triggerall = command = "qy"
trigger1 = ctrl
trigger2 = stateno = [200,450]

;---------------------------------------------------------------------------
; Abp[ Z
[State -1]
type = ChangeState
value = 1002
triggerall = var(59)<=0
triggerall = var(43) = 0
triggerall = statetype != A
triggerall = command = "qz"
trigger1 = ctrl
trigger2 = stateno = [200,450]


;---------------------------------------------------------------------------
; p`@X
[State -1]
type = ChangeState
value = 1200
triggerall = var(59)<=0
triggerall = var(43) = 0
triggerall = statetype != A
triggerall = command = "jpx"
trigger1 = ctrl
trigger1 = var(47) = 0
trigger2 = stateno = [200,450]

;---------------------------------------------------------------------------
; p` Y
[State -1]
type = ChangeState
value = 1201
triggerall = var(59)<=0
triggerall = var(43) = 0
triggerall = statetype != A
triggerall = command = "jpy"
trigger1 = ctrl
trigger1 = var(47) = 0
trigger2 = stateno = [200,450]



;---------------------------------------------------------------------------
; p` Z
[State -1]
type = ChangeState
value = 1202
triggerall = var(59)<=0
triggerall = var(43) = 0
triggerall = statetype != A
triggerall = command = "jpz"
trigger1 = ctrl
trigger1 = var(47) = 0
trigger2 = stateno = [200,450]

;---------------------------------------------------------------------------
; vX
[State -1]
type = ChangeState
value = 1100
triggerall = var(59)<=0
triggerall = var(43) = 0
triggerall = statetype != A
triggerall = command = "bpa"
trigger1 = ctrl
trigger2 = stateno = [200,450]

;---------------------------------------------------------------------------
; vX
[State -1]
type = ChangeState
value = 1101
triggerall = var(59)<=0
triggerall = var(43) = 0
triggerall = statetype != A
triggerall = command = "bpb"
trigger1 = ctrl
trigger2 = stateno = [200,450]

;---------------------------------------------------------------------------
;vX 
[State -1]
type = ChangeState
value = 1102
triggerall = var(59)<=0
triggerall = var(43) = 0
triggerall = statetype != A
triggerall = command = "bpc"
trigger1 = ctrl
trigger2 = stateno = [200,450]

;---------------------------------------------------------------------------
; lCX
[State -1]
type = ChangeState
value = 1400
triggerall = var(59)<=0
triggerall = var(43) = 0
triggerall = statetype != A
triggerall = command = "ns"
trigger1 = ctrl
trigger2 = stateno = [200,450]


;---------------------------------------------------------------------------
;--------------------------------Basics-------------------------------------
;---------------------------------------------------------------------------

;
;---------------------------------------------------------------------------
; P
[State -1]
type = ChangeState
value = 800
triggerall = var(59)<=0
triggerall = StateType = S
triggerall = p2StateType != A
triggerall = p2bodydist X <= 70
triggerall = StateNo != [100,107]
triggerall = enemyNear, movetype !=H
trigger1 = enemyNear, StateNo != [120,159]
trigger1 = command = "holdfwd2" || command = "holdback2"
trigger1 = command = "z" || command = "y"
trigger1 = ctrl
trigger2 = command = "x" && command = "a"
trigger2 = ctrl

;---------------------------------------------------------------------------
; K
[State -1]
type = ChangeState
value = 860
triggerall = var(59)<=0
triggerall = StateType = S
triggerall = p2StateType != A
triggerall = command = "holdfwd2" || command = "holdback2"
triggerall = command = "c"
triggerall = p2bodydist X <= 70
;triggerall = p2dist X > 0
triggerall = p2dist Y <= 50
triggerall = p2dist Y > -50
triggerall = StateNo != 100
triggerall = enemyNear, StateNo != [120,159]
trigger1 = ctrl


;---------------------------------------------------------------------------
; j. Fierce Throw Forward
[State -1]
type = ChangeState
value = 830
triggerall = var(59)<=0
triggerall = StateType = A
triggerall = p2StateType = A
triggerall = command = "holdfwd2" || command = "holdback2"
triggerall = command = "z" || command = "y"
triggerall = p2bodydist X <= 60
triggerall = p2bodydist Y <= 60
triggerall = p2bodydist Y > -60
triggerall = enemyNear, StateNo != [120,159]
triggerall = enemyNear, movetype =H
trigger1 = ctrl


;---------------------------------------------------------------------------

;Super Jump
[State -1]
type = ChangeState
value = 10022
triggerall = var(59)<=0
triggerall = var(43) = 0
triggerall = statetype!=A
trigger1 = command = "holdup"
trigger1 = stateno = 420 || stateno = 221
trigger1 = movehit = 1
trigger2 = command = "holdupfwd"
trigger2 = stateno = 420 || stateno = 221
trigger2 = movehit = 1
trigger3 = command = "holdupback"
trigger3 = stateno = 420 || stateno = 221 
trigger3 = movehit = 1



[State -1]
type = ChangeState
value = 10023
triggerall = var(59)<=0
triggerall = var(43) = 0
triggerall = statetype!=A
trigger1 = stateno = [200,450]
trigger1 = movehit
trigger1 = command = "SJ"
trigger2 = ctrl
trigger2 = command = "SJ"


;--|[ Standing ]|--
;---------------------------------------------------------------------------
; LP
[State -1]
type = ChangeState
value = 200
triggerall = var(59)<=0
triggerall = statetype != A
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = ctrl

; LPs
[State -1]
type = ChangeState
value = 201
triggerall = var(59)<=0
triggerall = statetype != A
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = stateno = 200 && time>11
trigger2 = stateno = 200 && movecontact

;---------------------------------------------------------------------------
; MP
[State -1]
type = ChangeState
value = 210
triggerall = var(59)<=0
triggerall = statetype != A
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = MoveContact
trigger3 = stateno = 230
trigger3 = MoveContact
trigger4 = stateno = 400
trigger4 = MoveContact
trigger5 = stateno = 430
trigger5 = MoveContact

;---------------------------------------------------------------------------
; HPs
[State -1]
type = ChangeState
value = 221
triggerall = var(59)<=0
triggerall = statetype != A
triggerall = command = "z" && command = "holdfwd"
triggerall = command != "holddown"
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = MoveContact
trigger3 = stateno = 230
trigger3 = MoveContact
trigger4 = stateno = 400
trigger4 = MoveContact
trigger5 = stateno = 430
trigger5 = MoveContact

;---------------------------------------------------------------------------
; HP
[State -1]
type = ChangeState
value = 220
triggerall = var(59)<=0
triggerall = statetype != A
triggerall = command = "z"
triggerall = command != "holddown"
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = MoveContact
trigger3 = stateno = 230
trigger3 = MoveContact
trigger4 = stateno = 400
trigger4 = MoveContact
trigger5 = stateno = 430
trigger5 = MoveContact


;---------------------------------------------------------------------------
; LK
[State -1]
type = ChangeState
value = 230
triggerall = var(59)<=0
triggerall = statetype != A
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = ctrl



;---------------------------------------------------------------------------
; MK
[State -1]
type = ChangeState
value = 240
triggerall = var(59)<=0
triggerall = statetype != A
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = MoveContact
trigger3 = stateno = 230
trigger3 = MoveContact
trigger4 = stateno = 400
trigger4 = MoveContact
trigger5 = stateno = 430
trigger5 = MoveContact


;---------------------------------------------------------------------------
; HK
[State -1]
type = ChangeState
value = 250
triggerall = var(59)<=0
triggerall = statetype != A
triggerall = command = "c"
triggerall = command != "holddown"
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = MoveContact
trigger3 = stateno = 230
trigger3 = MoveContact
trigger4 = stateno = 400
trigger4 = MoveContact
trigger5 = stateno = 430
trigger5 = MoveContact

;--|[ Crouching ]|--
;---------------------------------------------------------------------------
; CLP
[State -1]
type = ChangeState
value = 400
triggerall = var(59)<=0
triggerall = statetype != A
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = ctrl


;---------------------------------------------------------------------------
; CMP
[State -1]
type = ChangeState
value = 410
triggerall = var(59)<=0
triggerall = statetype != A
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = MoveContact
trigger3 = stateno = 230
trigger3 = MoveContact
trigger4 = stateno = 400
trigger4 = MoveContact
trigger5 = stateno = 430
trigger5 = MoveContact


;---------------------------------------------------------------------------
; CHP
[State -1]
type = ChangeState
value = 420
triggerall = var(59)<=0
triggerall = statetype != A
triggerall = command = "z"
triggerall = command = "holddown"
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = MoveContact
trigger3 = stateno = 230
trigger3 = MoveContact
trigger4 = stateno = 400
trigger4 = MoveContact
trigger5 = stateno = 430
trigger5 = MoveContact


;---------------------------------------------------------------------------
; CLK
[State -1]
triggerall = var(59)<=0
type = ChangeState
value = 430
triggerall = statetype != A
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = ctrl


;---------------------------------------------------------------------------
; CMK
[State -1]
type = ChangeState
value = 440
triggerall = var(59)<=0
triggerall = statetype != A
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = MoveContact
trigger3 = stateno = 230
trigger3 = MoveContact
trigger4 = stateno = 400
trigger4 = MoveContact
trigger5 = stateno = 430
trigger5 = MoveContact


;---------------------------------------------------------------------------
; CHK
[State -1]
type = ChangeState
value = 450
triggerall = var(59)<=0
triggerall = statetype != A
triggerall = command = "c"
triggerall = command = "holddown"
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = MoveContact
trigger3 = stateno = 230
trigger3 = MoveContact
trigger4 = stateno = 400
trigger4 = MoveContact
trigger5 = stateno = 430
trigger5 = MoveContact

;--|[ Jumping ]|--
;---------------------------------------------------------------------------
; JLP
[State -1]
type = ChangeState
value = 600
triggerall = var(59)<=0
triggerall = statetype = A
triggerall = command = "x"
trigger1 = ctrl


;---------------------------------------------------------------------------
; JMP
[State -1]
type = ChangeState
value = 610
triggerall = var(59)<=0
triggerall = statetype = A
triggerall = command = "y"
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = MoveContact
trigger3 = stateno = 630
trigger3 = MoveContact




;---------------------------------------------------------------------------
; JHP
[State -1]
type = ChangeState
value = 620
triggerall = var(59)<=0
triggerall = statetype = A
triggerall = command = "z"
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = MoveContact
trigger3 = stateno = 610 
trigger3 = MoveContact
trigger3 = var(41)=1
trigger4 = stateno = 630 
trigger4 = MoveContact
trigger5 = stateno = 640
trigger5 = MoveContact
trigger5 = var(41)=1


;---------------------------------------------------------------------------
; JLK
[State -1]
type = ChangeState
value = 630
triggerall = var(59)<=0
triggerall = statetype = A
triggerall = command = "a"
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = MoveContact
trigger2 = var(41)=1



;---------------------------------------------------------------------------
; JMK
[State -1]
type = ChangeState
value = 640
triggerall = var(59)<=0
triggerall = statetype = A
triggerall = command = "b"
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = MoveContact
trigger3 = stateno = 610 
trigger3 = MoveContact
trigger3 = var(41)=1
trigger4 = stateno = 630 
trigger4 = MoveContact



;---------------------------------------------------------------------------
; JHK
[State -1]
triggerall = var(59)<=0
type = ChangeState
value = 650
triggerall = statetype = A
triggerall = command = "c"
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = MoveContact
trigger3 = stateno = 610 
trigger3 = MoveContact
trigger3 = var(41)=1
trigger4 = stateno = 620 
trigger4 = MoveContact
trigger4 = var(41)=1
trigger5 = stateno = 630 
trigger5 = MoveContact
trigger6 = stateno = 640
trigger6 = MoveContact
trigger6 = var(41)=1




;---------------------------------------------------------------------------
;Taunt
[State -1]
type = ChangeState
value = 195
triggerall = var(59)<=0
triggerall = command = "s"
triggerall = StateType != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;_E
----------------------------------------------------------------------------------------
; Recovery Roll
[State -1, Falling]
type = VarSet
triggerall = var(59)<=0
triggerall = alive
triggerall = (StateNo = 5035) || (StateNo = 5050) || (StateNo = 5071)
triggerall = Stateno != 5040
trigger1 = (Command = "RecoveryRoll")
var(57) = 1

[State -1, Rolling]
type = ChangeState
value = 705
triggerall = var(59)<=0
triggerall = Var(57) = 1 
triggerall = (StateNo = 5035) || (StateNo = 5050) || (StateNo = 5071)
trigger1 = (Pos Y >= 0) && (Vel Y > 0)

; Recovery Roll
[State -1, Falling]
type = VarSet
triggerall = var(59)<=0
triggerall = alive
triggerall = (StateNo = 5035) || (StateNo = 5050) || (StateNo = 5071)
triggerall = Stateno != 5040
trigger1 = (Command = "RecoveryRoll2")
var(57) = 2

[State -1, Rolling]
type = ChangeState
value = 706
triggerall = var(59)<=0
triggerall = Var(57) = 2
triggerall = (StateNo = 5035) || (StateNo = 5050) || (StateNo = 5071)
trigger1 = (Pos Y >= 0) && (Vel Y > 0)

;---------------------------------------------------------------------------
[State -1, Rolling]
type       = ChangeState
triggerall = var(59)<=0
triggerall = stateno=5100||stateno=5110||stateno=5120
trigger1   = command="RecoveryRoll"
value      = 705

[State -1, Rolling]
type       = ChangeState
triggerall = var(59)<=0
triggerall = stateno=5100||stateno=5110||stateno=5120
trigger1   = command="RecoveryRoll2"
value      = 706


; JE^[
[State -1]
type = ChangeState
value = 2222
triggerall = var(59)<=0
triggerall = power > 1000
triggerall = command = "VC1"
trigger1 = stateno = [150,153]
