;===========================================================================
; {s
;===========================================================================
;common1.cns㏑CĂ܂B



;---------------------------------------------------------------------------
; Common state file for M.U.G.E.N beta 2002.04.14
;
; System variables usage
; ----------------------
; Var Name    Type   Purpose
; --------    ----   -------
; sysvar(0)   Temp   Set by state 5081 (HITL_SLIDE) to 1 to prevent
;                    showing ground hit frame in state 5110 (HIT_LIEDOWN).
;                    Used by guarding states.
; sysvar(1)   Temp   Used by state 40 (Jump Start) amd 45 (Air Jump Start)
;                    to keep track of which way to jump.
;                    Used by state 5100 and 5110 to remember downward
;                    velocity of player just before hitting the ground.
;                    Used in state 5080 for storing the anim # to display.

; The following states have special handling within MUGEN, and should be
; overridden with caution:
; Jump Start (40): airjumping bookkeeping at time = 0
; All guard states (120-155): guard handling throughout state
; Hit_trip, shaking (5070): defence increases at time = 0
; Hit_bounce (5100): defence increases at time = 0, player becomes
;                    invincible if within 10 ticks of getting up
; Hit_liedown (5110): player changes to get-up state (5120) when ready
; Hit_getup (5120): player's defence is restored to normal at time = 0
; Hitfall_recover (5200): player's defence is restored at time = 0
; Hitfall_airrecover (5210): player's defence is restored at time = 0

;---------------------------------------------------------------------------



;---------------------------------------------------------------------------
; Stand
;==================================================
; [{] ʏ헧
;--------------------------------------------------
[Statedef 0]
Type     = S
Physics  = S
SprPriority = 0

;I
[State 0, CtrlSet]
Type       = CtrlSet
TriggerAll = (RoundState = 3)
Trigger1   = (Ctrl = 0)
Value      = 1

[State 0, CtrlSet]	;d
Type       = CtrlSet
TriggerAll = 0
TriggerAll = (Var(59) = 0) && (RoundState = 2 && Ctrl)	;AItO
Trigger1   = (Ctrl = 0)
Trigger1   = fvar(8) = 0
Value      = 1

[State 0, ChangeAnim]
Type     = ChangeAnim
Trigger1 = Anim != 0 && Anim != 5
Trigger2 = Anim = 5 && AnimTime = 0		;Turn Anim over
Value    = 0


;-------------------------------------------------- x
[State 0, VelSet]
Type     = VelSet
Trigger1 = Time = 0
Y        = 0

[State 0, VelSet]		;Stop moving if low velocity or 4 ticks pass
Type     = VelSet
Trigger1 = Abs(Vel X) < 2
Trigger2 = Time = 4
X        = 0


;-------------------------------------------------- Xe[gύX
[State 0, ChangeState]		;Are you dead?
Type     = ChangeState
Trigger1 = !Alive
Value    = 5050
Ctrl     = 0




;**************************************************
[State 0, ChangeState]		;󒆕Vh~
Type       = ChangeState
Trigger1   = Pos Y < 0
Value      = 51

[State 0, DestroySelf]		;gpwp[폜
Type     = DestroySelf
Trigger1 = IsHelper





;---------------------------------------------------------------------------
; Stand to Crouch
[Statedef 10]
Type    = C
Physics = C
Anim    = 10

[State 10, VelMul]
Type     = VelMul
Trigger1 = Time = 0
X        = .75

[State 10, ChangeState]
Type     = ChangeState
Trigger1 = AnimTime = 0
Value    = 11



;---------------------------------------------------------------------------
; Crouching
[Statedef 11]
Type     = C
Physics  = C
Anim     = 11
SprPriority = 0

[State 11, ChangeAnim]		;Change from turning Animation
Type       = ChangeAnim
Trigger1   = (Anim = 6) && (AnimTime = 0)
Value      = 11




;---------------------------------------------------------------------------
; Crouch to Stand
[Statedef 12]
Type     = S
Physics  = S
Anim     = 12

[State 12, 1]
Type     = ChangeState
Trigger1 = AnimTime = 0
Value    = 0



;---------------------------------------------------------------------------
; Walk
[Statedef 20]
Type    = S
Physics = S
SprPriority = 0

[State 20, ChangeState]
Type       = ChangeState
TriggerAll = (Var(59) >= 1) && (RoundState = 2)	;AItO
Trigger1   = (Time = 0)
Value      = 0
Ctrl       = 1

[State 20, VelSet]
Type       = VelSet
Trigger1   = ((Command = "holdfwd") || (Command = "holdback"))
X          = IfElse(Command="holdfwd", Const(Velocity.Walk.Fwd.X), Const(Velocity.Walk.Back.X))


[State 20, ChangeAnim]
Type       = ChangeAnim
TriggerAll = Vel X > 0
Trigger1   = Anim != 20 && Anim != 5
Trigger2   = Anim = 5 && AnimTime = 0
Value      = 20

[State 20, ChangeAnim]
Type       = ChangeAnim
TriggerAll = Vel X < 0
Trigger1   = Anim != 21 && Anim != 5
Trigger2   = Anim = 5 && AnimTime = 0
Value      = 21


;---------------------------------------------------------------------------
; WalkiOijiAIpj
[Statedef 21]
Type    = S
Physics = S
SprPriority = 0

[State 21, VelSet]
Type       = VelSet
TriggerAll = (Var(59) >= 1) && (RoundState = 2)	;AItO
;TriggerAll = enemynear,statetype != L
;TriggerAll = ctrl && stateno != 20 && stateno != 21 && stateno != 22
Trigger1   = P2BodyDist X > 60
X          = const(velocity.walk.fwd.x)

[State 21, ChangeAnim]
Type       = ChangeAnim
TriggerAll = Vel X > 0
Trigger1   = Anim != 20 && Anim != 5
Trigger2   = Anim = 5 && AnimTime = 0
Value      = 20

[State 21, ChangeState]
Type       = ChangeState
TriggerAll = (Var(59) != 0)	;AItO
Trigger1   = (RoundState != 2)
Value      = 0

[State 21, 5]
type = ChangeState
trigger1 = vel X = 0
Trigger2 = P2BodyDist X <= 40
value = 0
ctrl = 1 
;---------------------------------------------------------------------------
; WalkiށjiAIpj
[Statedef 22]
Type    = S
Physics = S
SprPriority = 0

[State 22, VelSet]
Type       = VelSet
TriggerAll = (Var(59) >= 1) && (RoundState = 2)	;AItO
Trigger1   = P2BodyDist X <= 80
;Trigger1   = ctrl && stateno != 20 && stateno != 21 && stateno != 22
X          = const(velocity.walk.back.x)

[State 22, ChangeAnim]
Type       = ChangeAnim
TriggerAll = Vel X < 0
Trigger1   = Anim != 21 && Anim != 5
Trigger2   = Anim = 5 && AnimTime = 0
Value      = 21

[State 22, 5]
type = ChangeState
TriggerAll = (Var(59) >= 1) && (RoundState = 2)	;AItO
Trigger1   = InGuardDist
Trigger2   = BackEdgeBodyDist < 30
Trigger3   = vel X = 0 
Trigger4   = Time >= 40
value = 0
ctrl = 1

[State 22, ChangeState]
Type       = ChangeState
TriggerAll = (Var(59) != 0)	;AItO
Trigger1   = (RoundState != 2)
Value      = 0

;---------------------------------------------------------------------------
; Jump Start
[Statedef 40]
Type    = S
Physics = S
;Anim = 40
Ctrl = 0
SprPriority = 1

[State 40, ChangeState]
Type       = ChangeState
TriggerAll = (Var(59) >= 1) && (RoundState = 2)	;AItO
Trigger1   = (Time = 0)
Value      = 0
Ctrl       = 1

[State 40, PlaySnd]
Type     = PlaySnd
TriggerAll = var(33) = 1
Trigger1 = Time = 0
Trigger1 = random <= 400
Value    = S4000, 1
channel  = 2 

[State 40, 1]
Type = VarSet
Trigger1 = Time = 0
sysvar(1) = 0


[State 40, 2]
Type       = VarSet
Trigger1   = Command = "holdfwd"
sysvar(1)  = 1

[State 40, 3]
Type       = VarSet
Trigger1   = Command = "holdback"
sysvar(1)  = -1


[State 40, 4]
Type = VelSet
Trigger1 = AnimTime = 0
x = ifelse(sysvar(1)=0, const(velocity.jump.neu.x), ifelse(sysvar(1)=1, const(velocity.jump.fwd.x), const(velocity.jump.back.x)))
y = const(velocity.jump.y)

[State 40, 5]
Type = VelSet
Trigger1 = AnimTime = 0
Trigger1 = prevstateno = 100 ;RUN_FWD
Trigger1 = sysvar(1) = 1
x = const(velocity.runjump.fwd.x)

[State 40, 6]
Type = ChangeState
Trigger1 = AnimTime = 0
Value = 50
Ctrl = 1


;---------------------------------------------------------------------------
; Jump StartiAIpj
[Statedef 41]
Type    = S
Physics = S
;Anim = 40
Ctrl = 0
SprPriority = 1

[State 20, 4]
type = ChangeAnim
trigger1 = time = 0
value = 40 

[State 41, PlaySnd]
Type     = PlaySnd
Trigger1 = Time = 0
Trigger1 = random <= 400
Value    = S4000, 1
channel  = 2 

[State 41, 2]
Type       = VarSet
TriggerAll = Var(59) = 1 && RoundState = 2
Trigger1   = P2bodydist X = [40,180]
Trigger1   = P2statetype != L
Trigger1   = 0
sysvar(1)  = 1

[State 41, 3]
Type       = VarSet
TriggerAll = Var(59) = 1 && RoundState = 2
Trigger1   = Var(50) = 1 || Var(50) = 2
Trigger1   = P2bodydist X >= 180
trigger1   = power >= 2000 && Var(40) >= 2000
Trigger1   = 0
sysvar(1)  = -1 

[State 41, 1]
Type = VarSet
Trigger1 = Time = 0
trigger1 = var(59) = 0 
sysvar(1) = 0


[State 41, 4]
Type = VelSet
Trigger1 = AnimTime = 0
x = ifelse(sysvar(1)=0, const(velocity.jump.neu.x), ifelse(sysvar(1)=1, const(velocity.jump.fwd.x), const(velocity.jump.back.x)))
y = const(velocity.jump.y)

[State 41, 5]
Type = VelSet
Trigger1 = AnimTime = 0
Trigger1 = prevstateno = 100 ;RUN_FWD
Trigger1 = sysvar(1) = 1
x = const(velocity.runjump.fwd.x)

[State 41, 6]
Type = ChangeState
Trigger1 = AnimTime = 0
Value = 50
Ctrl = 1
;---------------------------------------------------------------------------
;OWv
[Statedef 42]
Type    = S
Physics = S
Anim = 40
Ctrl = 0
SprPriority = 1

[State 42, PlaySnd]
Type     = PlaySnd
Trigger1 = Time = 0
Trigger1 = random <= 400
Value    = S4000, 1
channel  = 2 

[State 42, 2]
Type       = VarSet
TriggerAll = Var(59) = 1 && RoundState = 2
Trigger1   = Time = 0
Trigger1   = 1
sysvar(1)  = 1

[State 42, 4]
Type = VelSet
Trigger1 = AnimTime = 0
x = ifelse(sysvar(1)=0, const(velocity.jump.neu.x), ifelse(sysvar(1)=1, const(velocity.jump.fwd.x), const(velocity.jump.back.x)))
y = const(velocity.jump.y)

[State 42, 5]
Type = VelSet
Trigger1 = AnimTime = 0
Trigger1 = prevstateno = 100 ;RUN_FWD
Trigger1 = sysvar(1) = 1
x = const(velocity.runjump.fwd.x)

[State 42, 6]
Type = ChangeState
Trigger1 = AnimTime = 0
Value = 50
Ctrl = 1
;---------------------------------------------------------------------------
; AirJump Start
[Statedef 45]
Type    = A
Physics = N
Ctrl    = 0
VelSet  = 0,0

[State 45, 1]
Type     = ChangeAnim
Trigger1 = SelfAnimExist(44)
Value    = 44

[State 45, 2]
Type     = ChangeAnim
Trigger1 = !SelfAnimExist(44)
Value    = 41

[State 45, 3]
Type      = VarSet
Trigger1  = Time = 0
sysvar(1) = 0

[State 45, 4]
Type      = VarSet
Trigger1  = ((Command = "holdfwd") || (Command = "holdback"))
sysvar(1) = IfElse(Command="holdfwd",1,-1)

[State 45, 6]
Type     = VelSet
Trigger1 = Time = 0
X        = IfElse(sysvar(1)=0, Const(Velocity.AirJump.Neu.X),IfElse(sysvar(1)=1, Const(Velocity.AirJump.Fwd.X), Const(Velocity.AirJump.Back.X)))
Y        = Const(Velocity.AirJump.Y)

[State 45, 7]
Type     = ChangeState
Trigger1 = Time = 2
Value    = 50
Ctrl     = 1


;==================================================
; [{] Wvi㏸j
;--------------------------------------------------
[Statedef 50]
Type    = A
Physics = A
Ctrl    = 0

[State 50, AngleDraw]
Type     = AngleDraw
Trigger1 = 1
Value    = 0

[State 50, VarSet]
Type      = VarSet
Trigger1  = Time = 0
sysvar(1) = 0

[State 50, CtrlSet]
Type     = CtrlSet
Trigger1 = Pos Y <= -10 && Time >= 5
Value    = 1

[State 50, CtrlSet]
Type     = CtrlSet
Trigger1 = Pos Y > -10
Value    = 0

[State 50, ChangeAnim]
Type     = ChangeAnim
Trigger1 = Time = 0
Value    = ifelse((vel x)=0, 41, ifelse((vel x)>0, 42, 43))

[State 50, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Vel y > -2
Trigger1   = SelfAnimExist(Anim + 3)
Persistent = 0
Value      = Anim + 3


;==================================================
; [{] Wvi~j
;--------------------------------------------------
[Statedef 51]
Type    = A
Physics = A
Anim    = 45
Facep2  = 0


[State 51, CtrlSet]	;d
Type       = CtrlSet
Trigger1   = (Ctrl = 0)
Trigger1   = fvar(8) = 0
Value      = 1

[State 51, AssertSpecial]
Type     = AssertSpecial
Trigger1 = 1
Flag     = NoAutoTurn
IgnoreHitPause = 1

[State 51, AngleDraw]
Type     = AngleDraw
Trigger1 = 1
Value    = 0

[State 51, CtrlSet]
Type     = CtrlSet
Trigger1 = Pos Y > -10
Value    = 0


;==================================================
; [{] Wvinj
;--------------------------------------------------
[Statedef 52]
Type    = S
Physics = S
Ctrl    = 0
Anim    = 47


[State 52, AngleDraw]
Type     = AngleDraw
Trigger1 = 1
Value    = 0

[State 52, PlaySnd]
Type     = PlaySnd
Trigger1 = Time = 0
Value    = S115, 0

[State 52, VelSet]
Type     = VelSet
Trigger1 = Time = 0
Y        = 0

[State 52, PosSet]
Type     = PosSet
Trigger1 = Time = 0
Y        = 0


[State 52, VarSet]
Type       = VarSet
TriggerAll = AnimTime = 0
Trigger1   = (RoundState = 2 && Ctrl)
fvar(8)    = IfElse((PrevStateNo=[110,119]), 5, 2)


[State 52, ChangeState]
Type       = ChangeState
TriggerAll = (Command="holddown")
;Trigger1   = (PrevStateNo=2040)
Trigger1   = (PrevStateNo=2240)
Value      = 10
Ctrl       = 1

[State 52, ChangeState]		;Cg
Type       = ChangeState
TriggerAll = 0
TriggerAll = AnimTime = 0
Trigger1   = (RoundState = [0,1]) || !(RoundState = 2 && Ctrl)
Value      = 0
Ctrl       = 0

[State 52, ChangeState]		;ʏ펞
Type       = ChangeState
Trigger1   = AnimTime = 0
Value      = 0
Ctrl       = 1	;1


;==================================================
; [{] Wvi~Es\j
;--------------------------------------------------
[Statedef 53]
Type    = A
Physics = A
Anim    = 45
Ctrl    = 0
Facep2  = 0

[State 53, AssertSpecial]
Type     = AssertSpecial
Trigger1 = 1
Flag     = NoAutoTurn
IgnoreHitPause = 1

[State 53, AngleDraw]
Type     = AngleDraw
Trigger1 = 1
Value    = 0





;==================================================
; [{] nCWvij
;--------------------------------------------------
[Statedef 55]
Type        = S
Physics     = S
Anim        = 40
Ctrl        = 0
SprPriority = 1


[State 55, PlaySnd]
Type     = PlaySnd
Trigger1 = AnimElem = 2
Value    = S115, 3

[State 55, Helper]	;nCWvGtFNg
Type       = Helper
Trigger1   = AnimTime = 0
Persistent = 0
OwnPal     = 1
PosType    = P1
Pos        = 0, 0
Name       = " "
ID         = 6055
StateNo    = 6055

[State 55, VarSet]
Type      = VarSet
Trigger1  = Time = 0
sysvar(1) = 0

[State 55, VarSet]
Type       = VarSet
TriggerAll = (Var(59) <= 0) && (RoundState = 2)	;AItO
TriggerAll = SysVar(1) = 0
Trigger1   = Command = "holdfwd"
Trigger1   = Command != "holdback"
sysvar(1)  = 1

[State 55, VarSet]
Type       = VarSet
TriggerAll = (Var(59) <= 0) && (RoundState = 2)	;AItO
TriggerAll = SysVar(1) = 0
Trigger1   = Command != "holdfwd"
Trigger1   = Command = "holdback"
sysvar(1)  = -1

[State 55, VarSet]
Type       = VarSet
TriggerAll = (Var(59) >= 1) && (RoundState = 2)	;AItO
TriggerAll = SysVar(1) = 0
Trigger1   = 1
sysvar(1)  = 1

[State 55, VelSet]
Type     = VelSet
Trigger1 = AnimTime = 0
x        = IfElse((sysVar(1)=1), 5, (IfElse((sysVar(1)=-1), -5, 0)))
y        = IfElse(sysVar(1)=0, -11, -7.5)

[State 55, ChangeState]
Type     = ChangeState
Trigger1 = AnimTime = 0
Value    = 56
Ctrl     = 1


;==================================================
; [{] nCWvi㏸j
;--------------------------------------------------
[Statedef 56]
Type    = A
Physics = A

[State 56, VarSet]
Type      = VarSet
Trigger1  = Time = 0
sysvar(1) = 0

[State 56, AssertSpecial]
Type     = AssertSpecial
Trigger1 = 1
flag     = NoAirGuard

[State 56, ChangeAnim]
Type     = ChangeAnim
Trigger1 = Time = 0
Value    = IfElse((Vel X)=0, 41, IfElse((Vel X)>0, 42, 43))

[State 56, AfterImage]
Type        = AfterImage
Trigger1    = Time = 0
Trigger1    = Var(49) = 0 || Var(49) = 10
Trigger1    = NumHelper(4995) = 0
Time        = 40
length      = 8
palBright   = 0, 0, 0
palContrast = 0, 0, 128
palAdd      = -30, -30, -30
palMul      = 1, 1, 1
Trans       = Add
TimeGap     = 1
frameGap    = 3

[State 56, CtrlSet]
Type     = CtrlSet
Trigger1 = Pos Y <= -10 && Time >= 4
Value    = 1

[State 56, CtrlSet]
Type     = CtrlSet
Trigger1 = Pos Y > -10
Value    = 0




;==================================================
; [{] _bViJnj
;--------------------------------------------------
[Statedef 100]
Type        = S
MoveType    = I
Physics     = S
PowerAdd    = 0
Ctrl        = 0
VelSet      = 0, 0
Anim        = 100
SprPriority = 1

[State 100, PlaySnd]
Type     = PlaySnd
Trigger1 = AnimElem = 3
Value    = S115, 1

[State 100, VelSet]
Type     = VelSet
Trigger1 = 1
x        = 0.05*Time*Time * IfElse(NumHelper(4903)>0, 1.1, 1)


[State 100, Explod]		;GtFNg
Type        = Explod
TriggerAll  = Var(0) = 0	;yʉtO
Trigger1    = Time = 2
Anim        = 6322
ID          = 63220
Facing      = 1
PosType     = P1
Pos         = -5,-15
vel         = 0,0
OwnPal      = 1
Scale       = 0.5, 0.5
SprPriority = 20

[State 100, Helper]		;_bVGtFNgio[XgOj
Type       = Helper
Trigger1   = AnimTime = 0
Persistent = 0
OwnPal     = 1
Facing     = 1
PosType    = P1
Pos        = -27, -48
Name       = " "
ID         = 6100
StateNo    = 6100

[State 100, PosAdd]	;ʒuړ
Type       = PosAdd
Trigger1   = AnimElem = 1
x          = 5

[State 100, PosAdd]	;ʒuړ
Type       = PosAdd
Trigger1   = AnimElem = 2
x          = 6

[State 100, PosAdd]	;ʒuړ
Type       = PosAdd
Trigger1   = AnimElem = 3
x          = 6

[State 100, PosAdd]	;ʒuړ
Type       = PosAdd
Trigger1   = AnimTime = 0
x          = 8


[State 100, ChangeState]
Type     = ChangeState
Trigger1 = AnimTime = 0
Value    = 101



;==================================================
; [{] _bVi_bVj
;--------------------------------------------------
[Statedef 101]
Type        = A
MoveType    = I
Physics     = N
VelSet      = 0, 0
Anim        = 101
SprPriority = 1
Ctrl        = 0

[State 101, VelSet]
Type     = VelSet
Trigger1 = 1
x        = const(velocity.run.fwd.x) * IfElse(NumHelper(4903)>0, 1.1, 1)

[State 101, AssertSpecial]		;Prevent run from canceling into walk
Type     = AssertSpecial
Trigger1 = 1
flag     = NoWalk

[State 101, AssertSpecial]		;Prevent from turning
Type     = AssertSpecial
Trigger1 = 1
flag     = NoAutoTurn

[State 101, AfterImage]
Type        = AfterImage
Trigger1    = Time = 0
Trigger1    = Var(49) = 0 || Var(49) = 10
Trigger1    = NumHelper(4995) = 0
Time        = 70
length      = 8
palBright   = 0, 0, 0
palContrast = 0, 0, 128
palAdd      = -30, -30, -30
palMul      = 1, 1, 1
Trans       = Add
TimeGap     = 1
frameGap    = 3

[State 101, Explod]		;_bVGtFNgiCj
Type        = Explod
Trigger1    = Time%8 = 0
Anim        = 6301
ID          = 6101
Facing      = 1
PosType     = P1
Pos         = -20,-73+Random%73
vel         = -4,0
OwnPal      = 1
Scale       = 1, 1
SprPriority = 100

;--------------------R}hs
[State 101, VarSet]
Type       = VarSet
TriggerAll = Var(40) >= 1000
TriggerAll = Var(10) != 1300
Trigger1   = (Command = "hold_b" && Command = "c") || (Command = "b" && Command = "hold_c" )
Trigger1   = Command != "holddown"
var(10)    = 1340

[State 101, VarSet]
Type       = VarSet
TriggerAll = Var(10) != 1340
Trigger1   = Command = "a" || Command = "b" || Command = "c"
Trigger1   = Command = "holdfwd"
Trigger1   = Command != "holddown"
var(10)    = 1300

[State 101, ChangeState]
Type     = ChangeState
TriggerAll = Time >= 10
Trigger1 = var(59) = 1
Trigger1 = P2BodyDist X < 70
Trigger2 = var(59) = 0
Trigger2 = Command != "holdfwd"
trigger3 = Time >= 90 
Value    = 102
;==================================================
; [{] _bViIj
;--------------------------------------------------
[Statedef 102]
Type        = S
MoveType    = I
Physics     = S
VelSet      = 0, 0
Anim        = 102
SprPriority = 1
Ctrl        = 0

;-------------------------------------------------- ϐ
[State 102, VarSet]	;s͕ϐZbg
Type     = VarSet
Trigger1 = Time = 0
var(10)  = 0


[State 102, PlaySnd]
Type     = PlaySnd
Trigger1 = AnimTime = 0
Value    = S115, 0

[State 102, ChangeState]
Type     = ChangeState
Trigger1 = AnimTime = 0
Value    = 0
Ctrl     = 1

[State 102, ChangeState]
Type     = ChangeState
Trigger1 = (Var(59) = 0)	;AItO
Trigger1 = Command = "holdback"
Trigger1 = InGuardDist
Trigger2 = Var(59) >= 1
Trigger2 = P2bodydist X < 80
Trigger2 = InGuardDist
Value    = 120


;==================================================
; [{] 󒆃_bV
;--------------------------------------------------
[Statedef 103]
Type        = A
MoveType    = I
Physics     = N
VelSet      = 0, 0
Anim        = 103
SprPriority = 1
Ctrl        = 0

[State 103, VarAdd]	;ĉ񐔂̕ϐ
Type     = VarAdd
Trigger1 = Time = 8
V        = 45
Value    = -1

[State 103, PlaySnd]
Type     = PlaySnd
Trigger1 = AnimElem = 3
Value    = S115, 1

[State 103, VelSet]
Type     = VelSet
Trigger1 = Time = [0,9]
x        = 0.04*Time*Time * IfElse(NumHelper(4903)>0, 1.1, 1)

[State 103, Helper]		;_bVGtFNgio[XgOj
Type       = Helper
Trigger1   = Time = 10
Persistent = 0
OwnPal     = 1
Facing     = 1
PosType    = P1
Pos        = -27, -48
Name       = " "
ID         = 6100
StateNo    = 6100

[State 103, VelSet]
Type     = VelSet
Trigger1 = Time = [0, 5]
x        = 0
y        = 0.2

[State 103, VelSet]
Type     = VelSet
Trigger1 = Time = [6, 7]
x        = const(velocity.run.fwd.x)*0.6

[State 103, VelSet]
Type     = VelSet
Trigger1 = Time = [8, 10]
x        = const(velocity.run.fwd.x)*1.1 * IfElse(NumHelper(4903)>0, 1.1, 1)

[State 103, VelSet]
Type     = VelSet
Trigger1 = Time = [11, 15]
x        = const(velocity.run.fwd.x)*1.3 * IfElse(NumHelper(4903)>0, 1.1, 1)

[State 103, VelSet]
Type     = VelSet
Trigger1 = Time = [16, 20]
x        = const(velocity.run.fwd.x)*0.9 * IfElse(NumHelper(4903)>0, 1.1, 1)

[State 103, VelSet]
Type     = VelSet
Trigger1 = Time = [21, 22]
x        = const(velocity.run.fwd.x)*0.7 * IfElse(NumHelper(4903)>0, 1.1, 1)

[State 103, VelSet]
Type     = VelSet
Trigger1 = Time = [26, 25]
x        = const(velocity.run.fwd.x)*0.5 * IfElse(NumHelper(4903)>0, 1.1, 1)

[State 103, AssertSpecial]		;Prevent run from canceling into walk
Type     = AssertSpecial
Trigger1 = Time = [10, 22]
flag     = NoWalk

[State 103, AssertSpecial]		;Prevent from turning
Type     = AssertSpecial
Trigger1 = Time = [10, 22]
flag     = NoAutoTurn

[State 103, AfterImage]
Type        = AfterImage
Trigger1    = Time = 10
Trigger1    = Var(49) = 0 || Var(49) = 10
Trigger1    = NumHelper(4995) = 0
Time        = 70
length      = 8
palBright   = 0, 0, 0
palContrast = 0, 0, 128
palAdd      = -30, -30, -30
palMul      = 1, 1, 1
Trans       = Add
TimeGap     = 1
frameGap    = 3

[State 103, Explod]		;_bVGtFNgiCj
Type        = Explod
Trigger1    = Time%8 = 0
Trigger1    = Time = [10, 22]
Anim        = 6301
ID          = 6101
Facing      = 1
PosType     = P1
Pos         = -20,-73+Random%73
vel         = -4,0
OwnPal      = 1
Scale       = 1, 1
SprPriority = 100

[State 103, PosAdd]	;ʒuړ
Type       = PosAdd
Trigger1   = AnimElem = 1
x          = 8

[State 103, PosAdd]	;ʒuړ
Type       = PosAdd
Trigger1   = AnimElem = 2
x          = 8

[State 103, PosAdd]	;ʒuړ
Type       = PosAdd
Trigger1   = AnimElem = 3
x          = 9


[State 103, ChangeState]
Type     = ChangeState
Trigger1 = AnimTime = 0
Value    = 51
Ctrl     = 1




;==================================================
; [{] obNXebviJnj
;--------------------------------------------------
[Statedef 105]
Type        = S
MoveType    = I
Physics     = S
PowerAdd    = 0
Ctrl        = 0
VelSet      = 0, 0
Anim        = 105
SprPriority = 1

[State 105, PlaySnd]
Type     = PlaySnd
Trigger1 = AnimElem = 1
Value    = S115, 1

[State 105, PlaySnd]
Type     = PlaySnd
Trigger1 = AnimElem = 1
Trigger1 = random <= 300
Value    = S4000, 3
channel  = 2 

[State 105, AssertSpecial]		;Prevent run from canceling into walk
Type     = AssertSpecial
Trigger1 = 1
flag     = NoWalk

[State 105, AssertSpecial]		;Prevent from turning
Type     = AssertSpecial
Trigger1 = 1
flag     = NoAutoTurn

[State 105, Helper]		;obNXebvGtFNgio[XgOj
Type       = Helper
Trigger1   = AnimTime = 0
Persistent = 0
OwnPal     = 1
Facing     = -1
PosType    = P1
Pos        = 35, -48
Name       = " "
ID         = 6105
StateNo    = 6105

[State 105, ChangeState]
Type     = ChangeState
Trigger1 = AnimTime = 0
Value    = 106


;==================================================
; [{] obNXebviXebvj
;--------------------------------------------------
[Statedef 106]
Type        = A
MoveType    = I
Physics     = N
VelSet      = 0, 0
Anim        = 106
SprPriority = 0

[State 106, VelSet]
Type     = VelSet
Trigger1 = Time <=4
x        = const(velocity.run.back.x)
y        = const(velocity.run.back.y)

[State 106, VelSet]
Type     = VelSet
Trigger1 = Time >4 && Time<=5
x        = const(velocity.run.back.x)

[State 106, VelSet]
Type     = VelSet
Trigger1 = Time >5
x        = const(velocity.run.back.x)
y        = -const(velocity.run.back.y)

[State 106, NotHitBy]
Type     = NotHitBy
Trigger1 = 1
Value    = SCA, AA, AP, AT
Time     = 4

[State 106, AfterImage]
Type        = AfterImage
Trigger1    = Time = 0
Trigger1    = Var(49) = 0 || Var(49) = 10
Trigger1    = NumHelper(4995) = 0
Time        = 70
length      = 8
palBright   = 0, 0, 0
palContrast = 0, 0, 128
palAdd      = -30, -30, -30
palMul      = 1, 1, 1
Trans       = Add
TimeGap     = 1
frameGap    = 3

[State 106, Explod]		;obNXebvGtFNgiCj
Type        = Explod
Trigger1    = Time%8 = 0
Anim        = 6301
ID          = 6106
Facing      = -1
PosType     = P1
Pos         = 20,73-Random%73
vel         = 4,0
OwnPal      = 1
Scale       = 1, 1
SprPriority = 100

[State 106, ChangeState]
Type     = ChangeState
Trigger1 = Pos Y >= 0
Trigger1 = Vel Y > 0
Value    = 107


;==================================================
; [{] obNXebvinj
;--------------------------------------------------
[Statedef 107]
Type        = S
MoveType    = I
Physics     = S
VelSet      = 0, 0
Anim        = 107
SprPriority = 1

[State 107, PosSet]
Type     = PosSet
Trigger1 = Time = 0
y        = 0

[State 107, PlaySnd]
Type     = PlaySnd
Trigger1 = AnimTime = 0
Value    = S115, 0

[State 107, MakeDust]		;͕Kv낤cB
Type     = MakeDust
Trigger1 = Time = 2
Pos      = -5, -2
spacing  = 1

[State 107, ChangeState]
Type     = ChangeState
Trigger1 = AnimTime = 0
Value    = 0
Ctrl     = 1

[State 107, ChangeState]
Type     = ChangeState
Trigger1 = (Var(59) = 0)	;AItO
Trigger1 = Command = "holdback"
Trigger1 = InGuardDist
Trigger2 = Var(59) >= 1
Trigger2 = InGuardDist
Value    = 120





;==================================================
; [{] 󒆃obN_bV
;--------------------------------------------------
[Statedef 108]
Type        = A
MoveType    = I
Physics     = N
PowerAdd    = 0
Ctrl        = 0
VelSet      = 0, 0
Anim        = 108
SprPriority = 1

[State 108, PlaySnd]
Type     = PlaySnd
Trigger1 = AnimElem = 1
Value    = S115, 1

[State 108, AssertSpecial]		;Prevent run from canceling into walk
Type     = AssertSpecial
Trigger1 = 1
flag     = NoWalk

[State 108, AssertSpecial]		;Prevent from turning
Type     = AssertSpecial
Trigger1 = 1
flag     = NoAutoTurn

[State 108, VarAdd]	;ĉ񐔂̕ϐ
Type     = VarAdd
Trigger1 = Time = 3
V        = 45
Value    = -1

[State 108, Helper]		;obNXebvGtFNgio[XgOj
Type       = Helper
Trigger1   = Time  = 3
Persistent = 0
OwnPal     = 1
Facing     = -1
PosType    = P1
Pos        = 35, -58
Name       = " "
ID         = 6105
StateNo    = 6105


[State 108, VelSet]
Type     = VelSet
Trigger1 = Time = [1, 3]
x        = const(velocity.run.back.x)*0.8
y        = const(velocity.run.back.y)*1.8

[State 108, VelSet]
Type     = VelSet
Trigger1 = Time = [4, 6]
x        = const(velocity.run.back.x)*1.1
y        = const(velocity.run.back.y)*1.5

[State 108, VelSet]
Type     = VelSet
Trigger1 = Time = 7
x        = const(velocity.run.back.x)*0.8

[State 108, VelSet]
Type     = VelSet
Trigger1    = Time = [8, 9]
x        = const(velocity.run.back.x)*0.6
y        = -const(velocity.run.back.y)*0.2

[State 108, NotHitBy]
Type     = NotHitBy
Trigger1 = Time = [3, 6]
Value    = SCA, AA, AP, AT
Time     = 4

[State 108, AfterImage]
Type        = AfterImage
Trigger1    = Time = 3
Trigger1    = Var(49) = 0 || Var(49) = 10
Trigger1    = NumHelper(4995) = 0
Time        = 70
length      = 8
palBright   = 0, 0, 0
palContrast = 0, 0, 128
palAdd      = -30, -30, -30
palMul      = 1, 1, 1
Trans       = Add
TimeGap     = 1
frameGap    = 3

[State 108, Explod]		;obNXebvGtFNgiCj
Type        = Explod
Trigger1    = Time%8 = 0
Trigger1    = Time = [3, 9]
Anim        = 6301
ID          = 6106
Facing      = -1
PosType     = P1
Pos         = 20,63-Random%73
vel         = 4,0
OwnPal      = 1
Scale       = 1, 1
SprPriority = 100




[State 108, ChangeState]
Type     = ChangeState
Trigger1 = AnimTime = 0
Value    = 51
Ctrl     = 1


;==================================================
; [{] 
;--------------------------------------------------
[Statedef 110]
Type    = A
Physics = N
Anim    = 110
Ctrl    = 0
VelSet  = 0,0



[State 110, ChangeAnim]	;ăAj[V̐ݒ
Type     = ChangeAnim
Trigger1 = (Anim = 110) && (AnimTime = 0)
Value    = 112



[State 110, VarAdd]	;͉񕜐
Type     = VarAdd
Trigger1 = Time = 0
V        = 43
Value    = 10


[State 110, VarAdd]	;ĉ񐔂̕ϐ
Type     = VarAdd
Trigger1 = Time = 0
V        = 45
Value    = -1


[State 110, VarSet]
Type     = VarSet
Trigger1 = Time = 0
fvar(4)  = 0

[State 110, VarSet]
Type     = VarSet
Trigger1 = Time = 0
fvar(5)  = 0


[State 110, VarSet]	;ݒϐF񐫔\iQl@ߋ肳2AVq1xڈj
Type     = VarSet
Trigger1 = 1
fvar(6)  = 0.35

[State 110, Varset]	;ݒϐFđx
Type     = VarSet
Trigger1 = Time = 7
fvar(7)  = 15 * IfElse(NumHelper(4903)>0, 1.1, 1)

[State 110, VarAdd]
Type     = VarAdd
Trigger1 = Time = [7,17]
fvar(7)  = -1



[State 110, VarSet]	;ݒϐFđx
Type     = VarSet
Trigger1 = Time > 17
fvar(7)  = 5

[State 110, VarAdd]		;͏EďI
Type     = VarAdd
Trigger1 = Time > 15
V        = 40
Value    = IfElse(var(40)>50,-50,0)




[State 110, PlaySnd]	;ĉ̐ݒ
Type     = PlaySnd
Trigger1 = Time = 9
Value    = s115, 1
Channel  = 6


[State 110, AfterImage]			;ăGtFNg
Type        = AfterImage
Trigger1    = Time = 7
Trigger1    = Var(49) = 0 || Var(49) = 10
Trigger1    = NumHelper(4995) = 0
Time        = 40
length      = 8
palBright   = 0, 0, 0
palContrast = 0, 0, 128
palAdd      = -30, -30, -30
palMul      = 1, 1, 1
Trans       = Add
TimeGap     = 1
frameGap    = 3

[State 110, Helper]		;ăGtFNg
Type       = Helper
Trigger1   = TimeMod = 6, 0
Trigger1   = Time > 10
StateNo    = 6110
ID         = 6110
OwnPal     = 1
Facing     = -1
Pos        = Floor(45*Cos(fvar(5)*(Pi/180.0))), Floor(-50-45*Sin(fvar(5)*(Pi/180.0)))
PosType    = P1
keyctrl    = 0
;IfElse((fvar(5) > 90 || fvar(5) < -90),(fvar(5)-180),fvar(5))


[State 110, Turn]
Type       = Turn
TriggerAll = P2Dist X < 0
Trigger1   = (Var(59) <= 0)	;AItO
Trigger1   = Time > 21
Trigger1   = Command != "hold_x"
Trigger2   = Var(40) <= 50

;[State 110, Turn]
;Type       = Turn
;TriggerAll = (Var(59) >= 1) && (RoundState = 2)	;AItO
;Trigger1   = !InGuardDist
;Trigger1   = EnemyNear,MoveType != A
;Trigger1   = P2BodyDist X <= 80


[State 110, ChangeState]
Type     = ChangeState
Trigger1 = (Var(59) <= 0)	;AItO
Trigger1 = Time > 21
Trigger1 = Command != "hold_x"
Trigger2 = Var(40) <= 50
Value    = 51
Ctrl     = 1

[State 110, ChangeState]
Type       = ChangeState
TriggerAll = (Var(59) >= 1) && (RoundState = 2)	;AItO
;Trigger1 = (p2BodyDist X < (10+Random%(15-Var(59))) && ((Abs(Pos X - EnemyNear,Pos X) > 40))) || ((Abs(Pos X - EnemyNear,Pos X) > 50) && (EnemyNear,Vel X <= 0) && (EnemyNear,MoveType != A) && (EnemyNear,HitDefAttr != ,AA,AP,AT))
Trigger1   = !InGuardDist
Trigger1   = EnemyNear,MoveType != A
Trigger1   = P2BodyDist X <= 100
Value      = 51
Ctrl       = 1


[State 110, ChangeState]
Type     = ChangeState
Trigger1 = Pos Y >= 0 && Vel Y > 0
Value    = 51
Ctrl     = 0





;**************************************************
;@@LqQlFi] ߋiNKl쐬j̔
;**************************************************

;**************************************************
;	
;**************************************************
[State 110, VarSet]
Type     = VarSet
Trigger1 = (Var(59) <= 0)	;AItO
Trigger1 = (Command = "holdfwd") || (Command = "holdback")
fvar(4)  = (Command="holdup")*IfElse(Command="holdfwd",45,IfElse(fvar(5)>=0,135,-225))+(Command="holddown")*IfElse(Command="holdfwd",-45,IfElse(fvar(5)<=0,-135,225))

[State 110, VarSet]
Type     = VarSet
TriggerAll = (Var(59) >= 1) && (RoundState = 2)	;AItO
Trigger1 = 1
fvar(4)  = 0

[State 110, VarSet]
Type     = VarSet
Trigger1 = (Var(59) <= 0)	;AItO
Trigger1 = ((Command != "holdfwd") && (Command != "holdback")) && ((Command = "holdup") || (Command = "holddown"))
fvar(4)  = (Command="holdup")*IfElse((fvar(5)!=[-90,90]),-270,90)-(Command="holddown")*IfElse((fvar(5)!=[-90,90]),-270,90)

[State 110, VarSet]
Type     = VarSet
Trigger1 = (Var(59) <= 0)	;AItO
Trigger1 = (Command = "holdback") && ((Command != "holdup") && (Command != "holddown"))
fvar(4)  = IfElse(fvar(5)>0,180,-180)

[State 110, VarSet]
Type     = VarSet
Trigger1 = Time = 0
fvar(5)  = fvar(4)

[State 110, VarSet]
Type       = VarSet
TriggerAll = Time > 12
TriggerAll = (Var(59) <= 0)	;AItO
Trigger1   = (fvar(5) = 180) && (Command = "holddown")
Trigger2   = (fvar(5) = -180) && (Command = "holdup")
fvar(5)    = IfElse(fvar(5)>=180,-180,180)

[State 110, VarSet]	;񐫔\ϐfvar(6)ɂpx␳
Type     = VarAdd
Trigger1 = Time > 12
fvar(5)  = IfElse(fvar(4)>fvar(5),IfElse(fvar(4)-fvar(5)<(fvar(6)),fvar(4)-fvar(5),(fvar(6))),IfElse(fvar(4)-fvar(5)>-(fvar(6)),fvar(4)-fvar(5),-(fvar(6))))

[State 110, VarAdd]
Type     = VarAdd
Trigger1 = fvar(5) > 180 || fvar(5) < -180
fvar(5)  = IfElse(fvar(5)>=180,-360,360)


[State 110, VelSet]		;ړx
Type     = VelSet
Trigger1 = Time = 0
x        = 0
y        = 0

[State 110, VelSet]		;ړx
Type     = VelSet
Trigger1 = (Time > 12)
x        = (fvar(7))*Cos(fvar(5)*(Pi/180.0))
y        = -(fvar(7))*Sin(fvar(5)*(Pi/180.0))

[State 110, VelMul]		;␳i}^̏ꍇj
Type     = VelMul
Trigger1 = (Time > 12 && Time < 22)
x        = 0.8
y        = 0.8

[State 110, VelSet]		;ړx
Type     = VelSet
Trigger1 = (Time > 12)
Trigger1 = (ScreenPos Y < (Const(size.height) - (Vel Y))) && (Vel Y <= 0)
y        = IfElse(ScreenPos Y < 0, 0, IfElse(Const(size.height)-ScreenPos Y <= 0,Const(size.height)-ScreenPos Y,0))		;ʊOȂ炻ȏɍsȂ


[State 110, VarSet]		;pϐ
Type     = VarSet
Trigger1 = Time = 6
V        = 7
Value    = IfElse((fvar(5) > 90 || fvar(5) < -90), -1,1)


[State 110, AngleDraw]	;Aj[VƃZbgŐݒBĕɌX鏈
Type     = AngleDraw
Trigger1 = Time > 5
Trigger1 = Pos Y < 0
Value    = IfElse(Var(7) = -1, fvar(5)-(180), fvar(5))
Scale    = Var(7) , 1


[State 110, StateTypeSet]
Type     = StateTypeSet
Trigger1 = Pos Y < 0
Physics  = A

[State 110, CtrlSet]
Type     = CtrlSet
Trigger1 = Pos Y < 0 && Time > 21
Value    = 1





;---------------------------------------------------------------------------
; GUARD (start)
[Statedef 120]
Type = U    ;Leave State Type unchanged
Physics = U ;Leave Physics unchanged
SprPriority = 0


[State 120, ChangeState]
Type       = ChangeState
TriggerAll = (Var(59) >= 1) && (RoundState = 2)	;AItO
TriggerAll = NumHelper(4900) > 0 && NumHelper(4901) > 0
TriggerAll = EnemyNear,HitDefAttr = ,AP
Trigger1   = (Time = 0)
Value      = 0
Ctrl       = 1

[State 120, 1]
Type = ChangeAnim
Trigger1 = Time = 0
Value = 120 + (StateType = C) + (StateType = A)*2

[State 120, 2]
Type = StateTypeSet
Trigger1 = Time = 0 && StateType = S
Physics = S

[State 120, 3]
Type = StateTypeSet
Trigger1 = Time = 0 && StateType = C
Physics = C

[State 120, 4]
Type = StateTypeSet
Trigger1 = Time = 0 && StateType = A
Physics = A

[State 120, Hi to Lo]
Type = StateTypeSet
TriggerAll = StateType = S
TriggerAll = StateType != A
Trigger1 = (var(59) = 0)
Trigger1 = StateType = S && Command = "holddown"
Trigger2 = (var(59) = 1)
Trigger2 = (enemynear,statetype = S && enemynear,time <= 14) || (enemynear,statetype = C) || (enemynear,hitdefattr = S,AA && enemynear,time <= 14) || (enemynear,hitdefattr = C,AA)
Trigger2 = !(NumHelper(4900) != 0 && NumHelper(4901) != 0 && enemynear,hitdefattr = SCA,AP)
StateType = C
Physics = C

[State 120, Lo to Hi]
Type = StateTypeSet
TriggerAll = StateType = C
TriggerAll = StateType != A
Trigger1 = (var(59) = 0)
Trigger1 = StateType = C && Command != "holddown"
Trigger2 = (var(59) = 1)
Trigger2 = (enemynear,statetype = A) || (enemynear,statetype = S && enemynear,time >= 15) || (enemynear,hitdefattr = A,AA) || (enemynear,hitdefattr = S,AA && enemynear,time >= 15)
Trigger2 = !(NumHelper(4900) != 0 && NumHelper(4901) != 0 && enemynear,hitdefattr = SCA,AP)
StateType = S
Physics = S

[State 120, 5]
Type = ChangeState
Trigger1 = AnimTime = 0
Value = 130 + (StateType = C) + (StateType = A)*2

[State 120, Stop Guarding]
Type       = ChangeState
Trigger1   = (var(59) = 0)
Trigger1   = Command != "holdback"
Trigger2   = !InGuardDist
Value      = 140

[State 120, Explod]		;oAGtFNg
Type        = Explod
TriggerAll  = Var(0) = [0,1]	;yʉtO
TriggerAll  = NumExplod(64800) = 0
Trigger1    = 1
Anim        = 6480
ID          = 64800
Facing      = 1
PosType     = P1
Pos         = 20,-50
vel         = 0,0
OwnPal      = 1
Scale       = 0.2, 0.5
SprPriority = 1
BindTime    = -1


;---------------------------------------------------------------------------
; STAND GUARD (guarding)
[Statedef 130]
Type    = S
Physics = S

[State 130, PowerAdd]
Type       = PowerAdd
Trigger1   = Time = 1
Value      = 10
Persistent = 0
IgnoreHitPause = 1

[State 130, 1]
Type = ChangeAnim
Trigger1 = Anim != 130
Value = 130

[State 130, VarSet]	;K[hԂZbg
Type       = VarSet
Trigger1   = 1
fvar(31)   = 2

[State 130, Hi to Lo]
Type = ChangeState
Trigger1   = (var(59) = 0)
Trigger1 = Command = "holddown"
Value = 131

[State 130, Stop Guarding]
Type       = ChangeState
Trigger1   = (var(59) = 0)
Trigger1   = Command != "holdback"
Trigger2   = !InGuardDist
Value      = 140

[State 130, Explod]		;oAGtFNg
Type        = Explod
TriggerAll  = Var(0) = [0,1]	;yʉtO
TriggerAll  = NumExplod(64800) = 0
Trigger1    = 1
Anim        = 6480
ID          = 64800
Facing      = 1
PosType     = P1
Pos         = 20,-50
vel         = 0,0
OwnPal      = 1
Scale       = 0.2, 0.5
SprPriority = 1
BindTime    = -1

;---------------------------------------------------------------------------
; CROUCH GUARD (guarding)
[Statedef 131]
Type    = C
Physics = C

[State 131, PowerAdd]
Type       = PowerAdd
Trigger1   = Time = 1
Value      = 10
Persistent = 0
IgnoreHitPause = 1

[State 131, 1]
Type = ChangeAnim
Trigger1 = Anim != 131
Value = 131


[State 131, VarSet]	;K[hԂZbg
Type       = VarSet
Trigger1   = 1
fvar(31)   = 3


[State 131, Lo to Hi]
Type       = ChangeState
Trigger1   = (var(59) = 0)
Trigger1   = Command != "holddown"
Value      = 130

[State 131, Stop Guarding]
Type       = ChangeState
Trigger1   = (var(59) = 0)
Trigger1   = Command != "holdback"
Trigger2   = !InGuardDist
Value      = 140

[State 131, Explod]		;oAGtFNg
Type        = Explod
TriggerAll  = Var(0) = [0,1]	;yʉtO
TriggerAll  = NumExplod(64800) = 0
Trigger1    = 1
Anim        = 6480
ID          = 64800
Facing      = 1
PosType     = P1
Pos         = 20,-50
vel         = 0,0
OwnPal      = 1
Scale       = 0.2, 0.5
SprPriority = 1
BindTime    = -1

;---------------------------------------------------------------------------
; AIR GUARD (guarding)
[Statedef 132]
Type    = A
Physics = N

[State 132, PowerAdd]
Type       = PowerAdd
Trigger1   = Time = 1
Value      = 10
Persistent = 0
IgnoreHitPause = 1


[State 132, 1]
Type = ChangeAnim
Trigger1 = Anim != 132
Value = 132

[State 132, 2]
Type = VelAdd
Trigger1 = 1
y = Const(movement.yaccel)

[State 132, 3]
Type = VarSet
Trigger1 = 1
sysvar(0) = (Pos y >= 0) && (vel y > 0)

[State 132, 4]
Type = VelSet
Trigger1 = sysvar(0)
y = 0

[State 132, 5]
Type = PosSet
Trigger1 = sysvar(0)
y = 0

[State 132, 6]
Type       = ChangeState
Trigger1   = sysvar(0)
Trigger1   = (Command = "holdback") || (var(59) >= 1)
Trigger1   = InGuardDist
Value      = 130



[State 132, 7]
Type = ChangeState
Trigger1 = sysvar(0)
Value = 52

[State 132, Stop Guarding]
Type       = ChangeState
Trigger1   = (var(59) = 0)
Trigger1   = Command != "holdback"
Trigger2   = !InGuardDist
Value      = 140


[State 132, Explod]		;oAGtFNg
Type        = Explod
TriggerAll  = Var(0) = [0,1]	;yʉtO
TriggerAll  = NumExplod(64800) = 0
Trigger1    = 1
Anim        = 6480
ID          = 64800
Facing      = 1
PosType     = P1
Pos         = 20,-50
vel         = 0,0
OwnPal      = 1
Scale       = 0.2, 0.5
SprPriority = 1
BindTime    = -1


;---------------------------------------------------------------------------
; GUARD (end)
[Statedef 140]
Type = U    ;Leave state Type unchanged
Physics = U ;Leave Physics unchanged
Ctrl = 1

[State 140, 1]
Type = ChangeAnim
Trigger1 = Time = 0
Value = 140 + (StateType = C) + (StateType = A)*2

[State 140, 2]
Type = StateTypeSet
Trigger1 = Time = 0 && StateType = S
Physics = S

[State 140, 3]
Type = StateTypeSet
Trigger1 = Time = 0 && StateType = C
Physics = C

[State 140, 4]
Type = StateTypeSet
Trigger1 = Time = 0 && StateType = A
Physics = A

[State 140, Hi to Lo]
Type       = StateTypeSet
Trigger1   = (var(59) = 0)
Trigger1   = StateType = S && Command = "holddown"
StateType  = C
Physics    = C

[State 140, Lo to Hi]
Type       = StateTypeSet
Trigger1   = (var(59) = 0)
Trigger1   = StateType = C && Command != "holddown"
StateType  = S
Physics    = S

;[State 140, 5] ;Implemented within engine
;Type = ChangeState
;Trigger1 = AnimTime = 0
;Value = (StateType = C)*11 + (StateType = A)*51




;---------------------------------------------------------------------------
; SGUARDHIT (shaking)
[Statedef 150]
Type    = S
MoveType= H
Physics = N
VelSet = 0,0


;-------------------------------------------------- ϐ
[State 150, VarSet]	;s͕ϐZbg
Type     = VarSet
Trigger1 = Time = 0
var(10)  = 0

[State 150, VarAdd]	;͏
Type     = VarAdd
Trigger1 = Time = 0
var(40)  = -100

[State 150, VarSet]	;͉񕜐
Type     = VarSet
Trigger1 = Time = 0
var(43)  = 10




;-------------------------------------------------- {[_[NbV
[State 150, Helper]
Type       = Helper
;TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
StateNo    = 6025
ID         = 6025
Name       = "BorderCrush"
Pos        = 0, Const(Size.Mid.Pos.Y)
PosType    = P1
Ownpal     = 1
IgnoreHitPause = 1

;-------------------------------------------------- {[_[NbV
;[State 150, PlaySnd]
;Type       = PlaySnd
;TriggerAll = (Time = 0)
;Trigger1   = NumHelper(8000)>0
;Trigger1   = Helper(8000),var(7) > 0
;Value      = s51,0
;Channel    = 5
;IgnoreHitPause = 1

;-------------------------------------------------- {[_[NbV
[State 150, ChangeState]
Type       = ChangeState
;TriggerAll = (Time = 0)
Trigger1   = Helper(8000),var(7) > 0
Value      = 5003

;--------------------------------------------------

[State 150, 1]
Type = ChangeAnim
Trigger1 = 1
Value = 150

[State 150, 2]
Type = ChangeState
Trigger1 = HitShakeOver
Value = 151 + 2*(command = "holddown" && var(59) = 0)


[State 150, Hi to Lo]
Type       = StateTypeSet
Trigger1   = (var(59) = 0)
Trigger1   = StateType = S && Command = "holddown"
StateType  = C
Physics    = C

[State 150, Lo to Hi]
Type       = StateTypeSet
Trigger1   = (var(59) = 0)
Trigger1   = StateType = C && Command != "holddown"
StateType  = S
Physics    = S

[State 150, 3]
Type = ForceFeedback
Trigger1 = Time = 0
waveform = square
Time = 3


[State 150, Explod]		;oAGtFNg
Type        = Explod
TriggerAll  = Var(0) = [0,1]	;yʉtO
TriggerAll  = NumExplod(64800) = 0
Trigger1    = 1
Anim        = 6480
ID          = 64800
Facing      = 1
PosType     = P1
Pos         = 19,-50
vel         = 0,0
OwnPal      = 1
Scale       = 0.2, 0.5
SprPriority = 1
BindTime    = -1

;---------------------------------------------------------------------------
; SGUARDHIT2 (knocked back)
[Statedef 151]
Type    = S
MoveType= H
Physics = S
Anim = 150

[State 151, 1]
Type = HitVelSet
Trigger1 = Time = 0
x = 1

[State 151, 2]
Type = VelSet
Trigger1 = Time = GetHitVar(slideTime)
Trigger2 = HitOver
x = 0

[State 151, 3]
Type = CtrlSet
Trigger1 = Time = GetHitVar(ctrlTime)
Value = 1

[State 151, Hi to Lo]
Type       = StateTypeSet
Trigger1   = (var(59) = 0)
Trigger1   = StateType = S && Command = "holddown"
StateType  = C
Physics    = C

[State 151, Lo to Hi]
Type       = StateTypeSet
Trigger1   = (var(59) = 0)
Trigger1   = StateType = C && Command != "holddown"
StateType  = S
Physics    = S

[State 151, 4]
Type       = ChangeState
Trigger1   = HitOver
Value      = 130
Ctrl       = 1



;---------------------------------------------------------------------------
; CGUARDHIT (shaking)
[Statedef 152]
Type    = C
MoveType= H
Physics = N
VelSet = 0,0

;-------------------------------------------------- ϐ
[State 152, VarSet]	;s͕ϐZbg
Type     = VarSet
Trigger1 = Time = 0
var(10)  = 0

[State 152, VarAdd]	;͏
Type     = VarAdd
Trigger1 = Time = 0
var(40)  = -100

[State 152, VarSet]	;͉񕜐
Type     = VarSet
Trigger1 = Time = 0
var(43)  = 10


;-------------------------------------------------- {[_[NbV
[State 152, Helper]
Type       = Helper
;TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
StateNo    = 6025
ID         = 6025
Name       = "BorderCrush"
Pos        = 0, Const(Size.Mid.Pos.Y)
PosType    = P1
Ownpal     = 1
IgnoreHitPause = 1

;-------------------------------------------------- {[_[NbV
;[State 152, PlaySnd]
;Type       = PlaySnd
;TriggerAll = (Time = 0)
;Trigger1   = NumHelper(8000)>0
;Trigger1   = Helper(8000),var(7) > 0
;Value      = s51,0
;Channel    = 5
;IgnoreHitPause = 1


;-------------------------------------------------- {[_[NbV
[State 152, ChangeState]
Type       = ChangeState
;TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
Value      = 5003




;--------------------------------------------------
[State 152, 1]
Type = ChangeAnim
Trigger1 = 1
Value = 151

[State 152, 3]
Type       = ChangeState
Trigger1   = HitShakeOver
Value = 151 + 2*(command = "holddown" && var(59) = 0)


[State 152, Hi to Lo]
Type       = StateTypeSet
Trigger1   = (var(59) = 0)
Trigger1   = StateType = S && Command = "holddown"
StateType  = C
Physics    = C

[State 152, Lo to Hi]
Type       = StateTypeSet
Trigger1   = (var(59) = 0)
Trigger1   = StateType = C && Command != "holddown"
StateType  = S
Physics    = S

[State 152, 4]
Type = ForceFeedback
Trigger1 = Time = 0
waveform = square
Time = 4

[State 152, Explod]		;oAGtFNg
Type        = Explod
TriggerAll  = Var(0) = [0,1]	;yʉtO
TriggerAll  = NumExplod(64800) = 0
Trigger1    = 1
Anim        = 6480
ID          = 64800
Facing      = 1
PosType     = P1
Pos         = 19,-50
vel         = 0,0
OwnPal      = 1
Scale       = 0.2, 0.5
SprPriority = 1
BindTime    = -1



;---------------------------------------------------------------------------
; CGUARDHIT2 (knocked back)
[Statedef 153]
Type    = C
MoveType= H
Physics = C
Anim = 151

[State 153, 1]
Type = HitVelSet
Trigger1 = Time = 0
x = 1

[State 153, 2]
Type = VelSet
Trigger1 = Time = GetHitVar(slideTime)
Trigger2 = HitOver
x = 0

[State 153, 3]
Type = CtrlSet
Trigger1 = Time = GetHitVar(ctrlTime)
Value = 1

[State 153, Hi to Lo]
Type       = StateTypeSet
Trigger1   = (var(59) = 0)
Trigger1   = StateType = S && Command = "holddown"
StateType  = C
Physics    = C

[State 153, Lo to Hi]
Type       = StateTypeSet
Trigger1   = (var(59) = 0)
Trigger1   = StateType = C && Command != "holddown"
StateType  = S
Physics    = S

[State 153, 4]
Type = ChangeState
Trigger1 = HitOver
Value = 131
Ctrl = 1



;---------------------------------------------------------------------------
; AGUARDHIT (shaking)
[Statedef 154]
Type    = A
MoveType= H
Physics = N
VelSet = 0,0

;-------------------------------------------------- ϐ
[State 154, VarSet]	;s͕ϐZbg
Type     = VarSet
Trigger1 = Time = 0
var(10)  = 0

[State 154, VarAdd]	;͏
Type     = VarAdd
Trigger1 = Time = 0
var(40)  = -100

[State 154, VarSet]	;͉񕜐
Type     = VarSet
Trigger1 = Time = 0
var(43)  = 10

;-------------------------------------------------- {[_[NbV
[State 154, Helper]
Type       = Helper
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
StateNo    = 6025
ID         = 6025
Name       = "BorderCrush"
Pos        = 0, Const(Size.Mid.Pos.Y)
PosType    = P1
Ownpal     = 1
IgnoreHitPause = 1

;-------------------------------------------------- {[_[NbV
;[State 154, PlaySnd]
;Type       = PlaySnd
;TriggerAll = (Time = 0)
;Trigger1   = NumHelper(8000)>0
;Trigger1   = Helper(8000),var(7) > 0
;Value      = s51,0
;Channel    = 5
;IgnoreHitPause = 1

;-------------------------------------------------- {[_[NbV
[State 154, ChangeState]
Type       = ChangeState
;TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
Value      = 5020



;--------------------------------------------------
[State 154, 1]
Type = ChangeAnim
Trigger1 = 1
Value = 152

[State 154, 2]
Type = ChangeState
Trigger1 = HitShakeOver
Value = 155 ;AGUARDHIT2

[State 154, 3]
Type = ForceFeedback
Trigger1 = Time = 0
waveform = square
Time = 4


[State 154, Explod]		;oAGtFNg
Type        = Explod
TriggerAll  = Var(0) = [0,1]	;yʉtO
TriggerAll  = NumExplod(64800) = 0
Trigger1    = 1
Anim        = 6480
ID          = 64800
Facing      = 1
PosType     = P1
Pos         = 19,-50
vel         = 0,0
OwnPal      = 1
Scale       = 0.2, 0.5
SprPriority = 1
BindTime    = -1


;---------------------------------------------------------------------------
; AGUARDHIT2 (knocked away)
[Statedef 155]
Type     = A
MoveType = H
Physics  = N
Anim     = 152

[State 155, 1]
Type     = HitVelSet
Trigger1 = Time = 0
x        = 1
y        = 1

[State 155, 2]
Type     = VelAdd
Trigger1 = 1
y        = Const(movement.yaccel)

[State 155, 3]
Type     = CtrlSet
Trigger1 = Time = GetHitVar(ctrlTime)
Value    = 1

[State 155, 4]
Type      = VarSet
Trigger1  = 1
sysvar(0) = (Pos y >= 0) && (vel y > 0)

[State 155, 5]
Type     = VelSet
Trigger1 = sysvar(0)
y        = 0

[State 155, 6]
Type       = PosSet
Trigger1   = sysvar(0)
y          = 0

[State 155, 6]
Type       = ChangeState
Trigger1   = sysvar(0)
Trigger1   = (Command = "holdback") || (var(59) >= 1)
Trigger1   = InGuardDist
Value      = 130




[State 155, 7]
Type       = ChangeState
Trigger1   = sysvar(0)
Value      = 52




;===========================================================================
; {iJnяI̍sj
;===========================================================================

;==================================================
; [{] ^CI[o[iskj
;--------------------------------------------------
[Statedef 170]
Type   = S
Ctrl   = 0
Anim   = 170
VelSet = 0,0

[State 170, 1]
Type     = NotHitBy
Trigger1 = 1
Value    = SCA, AA, AP, AT
Time     = 1

[State 170, PlaySnd]
Type = PlaySnd
Trigger1 = Time = 5
Trigger1 = life != 0
Value    = s5000, 5

[State 170, PlaySnd]
type = AssertSpecial
Trigger1 = Time = [0,180]
flag = RoundNotOver

;==================================================
; [{] ^CI[o[ij
;--------------------------------------------------
[Statedef 175]
Type   = S
Ctrl   = 0
VelSet = 0,0

[State 175, 1] ; If no Anim, use go to lose state.
Type     = ChangeState
Trigger1 = Time = 0
Trigger1 = !SelfAnimExist(175)
Value    = 170

[State 175, 2]
Type     = ChangeAnim
Trigger1 = Time = 0
Value    = 175

[State 175, 3]
Type     = NotHitBy
Trigger1 = 1
Value    = SCA, AA, AP, AT
Time     = 1

[State 175, PlaySnd]
Type = PlaySnd
Trigger1 = Time = 5
Trigger1 = life != 0
Value    = s5000, 5

[State 175, PlaySnd]
type = AssertSpecial
Trigger1 = Time = [0,180]
flag = RoundNotOver

;==================================================
; [{] |[Yij common1.cnsɂ͖ǁARXe[g
;--------------------------------------------------
[Statedef 180]
Type = S
Ctrl = 0

[State 180, ChangeState]
Type     = ChangeState
Trigger1 = Time = 0
Value    = 181 + Random%2
;Value    = 182

;==================================================
; [{] |[YîPF΂ށj
;--------------------------------------------------
[Statedef 181]
Type   = S
Ctrl   = 0
Anim   = 181
VelSet = 0, 0

[State 181, PlaySnd]
Type       = PlaySnd
Trigger1   = Time = 1
Value      = s3000, 1
channel    = 3

[State 181, NotHitBy]
Type     = NotHitBy
Trigger1 = 1
Value    = SCA, AA, AP, AT
Time     = 1

[State 181, 1]
type = AssertSpecial
Trigger1 = Time = [0,240]
flag = RoundNotOver 

;==================================================
; [{] |[YîQFc܂Ƃj
;--------------------------------------------------
[Statedef 182]
Type       = S
Physics    = S
Ctrl       = 0
Anim       = 20
VelSet     = 0, 0
SprPriority = 0

[State 182, NotHitBy]
Type       = NotHitBy
Trigger1   = 1
Value    = SCA, AA, AP, AT
Time       = 1


[State 182, VarSet]
Type       = VarSet
TriggerAll = (Anim != 182)
Trigger1   = (Time = 0)
var(8)     = Floor(IfElse(FrontEdgeBodyDist >= BackEdgeBodyDist, Const(Velocity.Walk.Fwd.X), Const(Velocity.Walk.Back.X))*0.9)
Persistent = 0

[State 182, VelSet]
Type       = VelSet
TriggerAll = (Anim != 182)
Trigger1   = 1
X          = Var(8)


[State 182, VelSet]
Type       = VelSet
TriggerAll = (Anim = 182)
Trigger1   = AnimElem = 1
x          = 0
y          = 0

[State 182, VelSet]
Type       = VelSet
TriggerAll = (Anim = 182)
Trigger1   = AnimElem = 2
x          = 2
y          = 0

[State 182, PlaySnd]
Type       = PlaySnd
TriggerAll = (Anim = [20,21])
Trigger1   = AnimElem = 1
Value      = s3000, 2
channel    = 3

[State 182, PlaySnd]
Type       = PlaySnd
TriggerAll = (Anim = 182)
Trigger1   = AnimElem = 1
Value      = s1200, 0

[State 182, PlaySnd]
Type       = PlaySnd
TriggerAll = (Anim = 182)
Trigger1   = AnimElem = 2
Value      = s1520, 1

[State 182, PlaySnd]
Type       = PlaySnd
TriggerAll = (Anim = 182)
Trigger1   = AnimElem = 5
Value      = s110, 2

[State 182, StopSnd]
Type       = StopSnd
TriggerAll = Anim = 182
Trigger1   = AnimElem = 3
;Value      = s4444, 0
channel    = 3




[State 182, ChangeAnim]
Type       = ChangeAnim
TriggerAll = (Anim != 182)
TriggerAll = Vel X > 0
Trigger1   = Anim != 20 && Anim != 5
Trigger2   = Anim = 5 && AnimTime = 0
Value      = 20

[State 182, ChangeAnim]
Type       = ChangeAnim
TriggerAll = (Anim != 182)
TriggerAll = Vel X < 0
Trigger1   = Anim != 21 && Anim != 5
Trigger2   = Anim = 5 && AnimTime = 0
Value      = 21

[State 182, ChangeAnim]
Type       = ChangeAnim
TriggerAll = (Anim = [20,21])
TriggerAll = (Anim != 182)
TriggerAll = (Time%5 = 0)
Trigger1   = (Time > 5)
Trigger1   = (Random < 900)
Trigger1   = (var(8) >= 0) && (fvar(9) - Pos X = [-20,20])
Trigger2   = (Time > 50)
Trigger2   = (Random < 20)
Value      = 182

[State 182, Turn]
Type       = Turn
TriggerAll = (Anim = 182)
Trigger1   = var(8)<0
Persistent = 0


[State 182, ScreenBound]
Type       = ScreenBound
Trigger1   = 1
Value      = 0

[State 182, 1]
type = AssertSpecial
Trigger1 = Time = [0,240]
flag = RoundNotOver
;==================================================
; [{] Cg
;--------------------------------------------------
[Statedef 190]		;PREINTRO
Type   = S
Ctrl   = 0
VelSet = 0,0

[State 190, 1]
Type     = NotHitBy
Trigger1 = 1
Value    = SCA, AA, AP, AT
Time     = 1

[State 190, 1]
Type     = ChangeAnim
Trigger1 = SelfAnimExist(190)
Value    = 190

[State 190, 2]		;Go straight to intro.
Type     = ChangeState
Trigger1 = Time = 0
Trigger1 = P2name = "koakuma"
Value    = 192

[State 190, 2]		;Go straight to intro.
Type     = ChangeState
Trigger1 = Time = 0
Trigger1 = P2name != "koakuma"
Value    = 191 + Random%2
;Value    = 192

;==================================================
; [{] CgîPF{ԂjJnO̓oꉉoANV
;--------------------------------------------------
[Statedef 191]
Type   = S
Ctrl   = 0
Anim   = 190
Velset = 0,0

[State 191, ChangeAnim]	;ogʂɐ؂ւuԂ̃tF[hC̎AAjŒ
Type     = ChangeAnim
Trigger1 = RoundState = 0
Value    = 190

[State 191, AssertSpecial]
Type     = AssertSpecial
Trigger1 = 1
Flag     = Intro

[State 191, NotHitBy]
Type     = NotHitBy
Trigger1 = 1
Value    = SCA, AA, AP, AT
Time     = 1

[State 191, PlaySnd]	;ԂȎ䎌
Type     = PlaySnd
Trigger1 = time = 6
Trigger1 = P2name != "koakuma"; && P2name != "Patchouli"
Value    = s2000, 1+random%3
channel  = 3

[State 191, PlaySnd]	;simul
Type     = PlaySnd
Trigger1 = time = 6
Trigger1 = P2name != "koakuma"; && P2name != "Patchouli"
Trigger1 = TeamMode = simul
Value    = s2000, 7+random%2
channel  = 3

[State 191, PlaySnd]	;turns
Type     = PlaySnd
Trigger1 = time = 6
Trigger1 = P2name != "koakuma"; && P2name != "Patchouli"
Trigger1 = TeamMode = turns
Value    = s2000, 8
channel  = 3

[State 191, PlaySnd]	;ԂuԂ̑䎌
Type     = PlaySnd
Trigger1 = AnimElem = 9
Value    = s5000, 1
channel  = 3

[State 191, PlaySnd]	;ԂuԂ̉
Type     = PlaySnd
Trigger1 = AnimElem = 9
Value    = F5, 2
Volume   = -40

[State 191, PlaySnd]	;Ԃ̉
Type     = PlaySnd
Trigger1 = AnimElemTime(9) = 3
Value    = F5, 3
Volume   = -80


[State 191, Explod]	;ŗ{
Type       = Explod
Trigger1   = RoundState != 0
Trigger1   = AnimElem = 3
Anim       = 191
PosType    = p1
Pos        = 260, -110
Velocity   = -4.8, -7
Accel      = 0, .30
RemoveTime = 51
Persistent = 0

[State 191, Explod]	;ԂĖ{
Type       = Explod
Trigger1   = AnimElemTime(9) = 1
Anim       = 192
PosType    = p1
Pos        = 40, -85
Velocity   = 1, -4
Accel      = 0, .32
RemoveTime = 35


[State 191, ChangeState]	;Aj[VI΁uʏ헧ṽXe[gɕύX
Type     = ChangeState
Trigger1 = AnimTime = 0
Value    = 0


;==================================================
; [{] CgîQF{oj
;--------------------------------------------------
[Statedef 192]
Type    = A
Physics = N
Ctrl   = 0
Anim   = 99999
Velset = 0,0

[State 192, ChangeAnim]	;ogʂɐ؂ւuԂ̃tF[hC̎AAjŒ
Type     = ChangeAnim
Trigger1 = RoundState = [0,1]
Value    = 99999

[State 192, AssertSpecial]
Type     = AssertSpecial
Trigger1 = 1
Flag     = Intro

[State 192, NotHitBy]
Type     = NotHitBy
Trigger1 = 1
Value    = SCA, AA, AP, AT
Time     = 1

[State 192, PlaySnd]	;uԂ̉
Type       = PlaySnd
Trigger1   = Time = 66
Value      = S115, 0
Volume     = -100

[State 192, PlaySnd]	;other
Type     = PlaySnd
Trigger1 = time = 70
Trigger1 = P2name = "koakuma"; || P2name = "Patchouli"
Value    = s2000, 9
channel  = 3

[State 192, PlaySnd]	;single
Type     = PlaySnd
Trigger1 = time = 70
Trigger1 = P2name != "koakuma"; && P2name != "Patchouli"
Trigger1 = TeamMode = Single
Value    = s2000, 1+random%4
channel  = 3

[State 192, PlaySnd]	;simul
Type     = PlaySnd
Trigger1 = time = 70
Trigger1 = P2name != "koakuma"; && P2name != "Patchouli"
Trigger1 = TeamMode = simul
Value    = s2000, 7+random%2
channel  = 3

[State 192, PlaySnd]	;turns
Type     = PlaySnd
Trigger1 = time = 70
Trigger1 = P2name != "koakuma"; && P2name != "Patchouli"
Trigger1 = TeamMode = turns
Value    = s2000, 8
channel  = 3

[State 192, PlaySnd]
Type       = PlaySnd
Trigger1   = Time = 80
Value      = S1300, 0
Volume     = -80


[State 192, Explod]	;ė{
Type       = Explod
;Trigger1   = RoundState != 0
Trigger1   = Time = 30
Anim       = 211
PosType    = p1
Pos        = -10, -230
Velocity   = 0, 7
Accel      = 0, 0
RemoveTime = 34
Persistent = 0

[State 192, Explod]	;n{
Type       = Explod
;Trigger1   = RoundState != 0
Trigger1   = Time = 64
Anim       = 212
PosType    = p1
Pos        = -10, -12
Velocity   = 0, 1
Accel      = 0, 0
RemoveTime = 2
Persistent = 0

[State 192, Explod]	;nʂ̖{
Type       = Explod
;Trigger1   = RoundState != 0
Trigger1   = Time = 66
Anim       = 213
PosType    = p1
Pos        = -10, -10
Velocity   = 0, 0
Accel      = 0, 0
RemoveTime = 53
Persistent = 0


[State 192, Explod]		;
Type        = Explod
Trigger1    = Time = [0,160]
Trigger1    = Time = 90
Anim        = 6743
Facing      = 1
PosType     = P1
Pos         = 0,0
vel         = 0,0
OwnPal      = 1
Scale       = 1.5, 100
SprPriority = -10
SuperMove   = 0
IgnoreHitPause = 0
removeOnGetHit = 1

;̖w
[State 192, Helper]
Type       = Helper
Trigger1   = Time = 80
Persistent = 0
OwnPal     = 1
Facing     = 1
PosType    = P1
Pos        = -7, 0
Name       = " "
ID         = 6750
StateNo    = 6750
SuperMoveTime = 0
PauseMoveTime = 0
IgnoreHitPause = 1

;g
[State 192, Helper]
Type       = Helper
Trigger1   = Time = 0
Persistent = 0
OwnPal     = 1
Facing     = 1
PosType    = P1
Pos        = 0, 0
Name       = " "
ID         = 193
StateNo    = 193
SuperMoveTime = 0
PauseMoveTime = 0
IgnoreHitPause = 1

[State 192, ChangeState]	;Aj[VI΁uʏ헧ṽXe[gɕύX
Type     = ChangeState
Trigger1 = Time>0
Trigger1 = NumHelper(193)>0
Trigger1 = Helper(193),AnimTime=0 && Helper(193),Anim=47
Trigger2 = Time > 500
Value    = 0




;==================================================
; [g] CgîQF{oj
;--------------------------------------------------
[Statedef 193]
Type    = A
Physics = N
Ctrl   = 0
Anim   = 99999
Velset = 0,0

[State 193, ChangeAnim]	;ogʂɐ؂ւuԂ̃tF[hC̎AAjŒ
Type     = ChangeAnim
Trigger1 = RoundState = 0
Value    = 99999

[State 193, ChangeAnim]
Type     = ChangeAnim
Trigger1 = RoundState != 0
Trigger1 = Time >= 100 && Anim = 99999
Value    = 210

[State 193, ChangeAnim]
Type     = ChangeAnim
Trigger1 = Time >= 100 && Anim = 210
Trigger1 = Pos Y = 0
Value    = 47



[State 193, AssertSpecial]
Type     = AssertSpecial
Trigger1 = 1
Flag     = Intro

[State 193, NotHitBy]
Type     = NotHitBy
Trigger1 = 1
Value    = SCA, AA, AP, AT
Time     = 1

[State 193, VelSet]
Type     = VelSet
Trigger1 = Time = 80
x        = 0
y        = -1.5

[State 193, VelSet]
Type     = VelSet
Trigger1 = Time = 100
x        = 0
y        = -1

[State 193, VelAdd]
Type     = VelAdd
Trigger1 = Time = [101,120]
x        = 0
y        = 0.04

[State 193, VelAdd]
Type     = VelAdd
Trigger1 = Time > 120
Trigger1 = Pos Y < 0
x        = 0
y        = 0.07

[State 193, VelSet]
Type     = VelSet
Trigger1 = Time > 120
Trigger1 = Pos Y >= 0
x        = 0
y        = 0

[State 193, PosSet]
Type     = PosSet
Trigger1 = Time > 120
Trigger1 = Pos Y >= 0
y        = 0


;----------ŏ
[State 193, DestroySelf]
Type     = DestroySelf
Trigger1 = AnimTime=0 && Anim=47




;===========================================================================
; {ij
;===========================================================================
;==================================================
; [{] 
;--------------------------------------------------
[Statedef 195]
Type        = S
MoveType    = I
Physics     = S
Ctrl        = 0
Anim        = 195
VelSet      = 0, 0
SprPriority = 2



[State 195, ChangeState]
Type       = ChangeState
TriggerAll = (Var(59) = 0)
Trigger1   = Time >= 20
Trigger1   = Command != "hold_start"
Value      = 196


[State 195, ChangeState]
Type       = ChangeState
TriggerAll = (var(59) >= 1)
Trigger1   = InGuardDist
Trigger2   = EnemyNear,MoveType != H
Trigger2   = P2BodyDist X = [-100,100]
Trigger2   = P2BodyDist Y >= -160-EnemyNear,vel y*8
Trigger3   = (Time >= 90)
Trigger4   = (RoundState != 2)
Trigger5   = P2Life<=0
Trigger6   = !EnemyNear,Alive
Value      = 196

[State 195, ChangeState]
Type       = ChangeState
TriggerAll = (Var(59) != 0)	;AItO
Trigger1   = (RoundState != 2)
Value      = 196


;==================================================
; [{] iIj
;--------------------------------------------------
[Statedef 196]
Type        = S
MoveType    = I
Physics     = S
Ctrl        = 0
Anim        = 196
VelSet      = 0, 0
SprPriority = 2

[State 196, ChangeState]
Type     = ChangeState
Trigger1 = AnimTime = 0
Value    = 0
Ctrl     = 1



;==================================================
; [{] 쌂
;--------------------------------------------------
[StateDef 700]
Type     = S
MoveType = A
Physics  = S
Anim     = 700
Ctrl     = 0
Juggle   = 10000


[State 700, NotHitBy]
Type     = NotHitBy
Trigger1 = Time = [0, 1]
Value    = SCA, AA, AP, AT
Time     = 1

[State 700, NotHitBy]
Type     = NotHitBy
Trigger1 = Time = [2, 5]
Value    = , AA, AP
Time     = 1

[State 700, NotHitBy]
Type     = NotHitBy
Trigger1 = Time <= 6
Value    = SCA, AA, AP, AT
Time     = 1

[State 700, VarSet]	;s͕ϐZbg
Type     = VarSet
Trigger1 = Time = 0
V        = 10
Value    = 0


[State 700, VarAdd]
Type     = VarAdd
Trigger1 = Time = 17 && Var(44) > 0
V        = 44
Value    = -1

[State 700, PowerAdd]
Type       = PowerAdd
Trigger1   = MoveHit = 1
Value      = 1000
ID         = 70000
Persistent = 0
IgnoreHitPause = 1

[State 700, PlaySnd]
Type     = PlaySnd
Trigger1 = Time = 15
Trigger1 = roundstate != 3
Value    = s4000, 13
channel  = 2

[State 700, PlaySnd]
Type     = PlaySnd
Trigger1 = Time = 17
Value    = s201, 1


[State 700, Helper]	;GtFNĝP
Type     = Helper
Trigger1 = Time = 17
OwnPal   = 1
PosType  = P1
Pos      = 0, -58
Name     = " "
ID       = 6405
StateNo  = 6405
IgnoreHitPause = 1

[State 700, Helper]	;GtFNĝQ̂P
Type     = Helper
Trigger1 = Time = 17
OwnPal   = 1
PosType  = P1
Pos      = 0, -58
Name     = " "
ID       = 6406
StateNo  = 6406
IgnoreHitPause = 1

[State 700, Helper]	;GtFNĝQ̂Q
Type     = Helper
Trigger1 = Time = 17
OwnPal   = 1
PosType  = P1
Pos      = 0, -58
Name     = " "
ID       = 6406
StateNo  = 6406
IgnoreHitPause = 1



[State 700, HitDef]
Type             = HitDef
Trigger1         = Time = 17
Attr             = S, SA
Damage           = 0, 0
GuardFlag        = 
HitFlag          = MAF
AnimType         = Hard
AffectTeam       = E
Priority         = 6, Hit
PauseTime        = 0, 0
GetPower         = 0, 0
GivePower        = 4, 3

SparkNo          = s6100
Guard.SparkNo    = s6200	;6210
SparkXY          = -15, 5
;HitSound         = -1
HitSound         = -1
;GuardSound       = -1
GuardSound       = s110, 0
Ground.Type      = High
Air.Type         = High
Ground.SlideTime = 16
Guard.SlideTime  = 16

Ground.HitTime    = 16
Guard.HitTime     = 16
Air.HitTime       = 16
Guard.CtrlTime    = 16
AirGuard.CtrlTime = 20
Guard.Dist        = 0	;K[hs
Ground.Velocity   = -12, -8
Guard.Velocity    = -15
Air.Velocity      = -12, -6
AirGuard.Velocity = -6, -6

Guard.Kill = 0	;K[hLs
;yaccel   = 0
Fall     = 1
Air.Fall = 1
Fall.Recover = 0	;Jo[s
;Fall.RecoverTime =  7 + Ceil(0.02*Enemy,GetHitVar(HitCount))
Ground.CornerPush.VelOff   = 0
Air.CornerPush.VelOff      = 0
Guard.CornerPush.VelOff    = 0
AirGuard.CornerPush.VelOff = 0

ID         = 70000



[State 700, ChangeState]
Type     = ChangeState
Trigger1 = AnimTime = 0
Value    = 0
Ctrl     = 1








;==================================================
; [{] E
;--------------------------------------------------
[Statedef 720]
Type     = U
MoveType = I
Physics  = N
Ctrl     = 0


[State 720, NotHitBy]
Type     = NotHitBy
Trigger1 = Time = 0
Value    = SCA, AA, AP, AT
Time     = 35

[State 720, VarSet]
Type       = VarSet
Trigger1   = Time = 0
fvar(20)   = StateNo*1000 + 35

[State 720, VarSet]	;s͕ϐZbg
Type     = VarSet
Trigger1 = Time = 0
V        = 10
Value    = 0


[State 720, VarAdd]
Type       = VarAdd
Trigger1   = Time = 0
var(40)    = -6000
Persistent = 1
IgnoreHitPause = 1

[State 720, VarAdd]
Type       = VarAdd
Trigger1   = 0
Trigger1   = Time = 0
var(41)    = -1
Persistent = 1
IgnoreHitPause = 1


[State 720, VarSet]
Type       = VarSet
TriggerAll = (Var(59) = 0)
Trigger1   = Time = 0
var(8)     = (Command="holdfwd") + (Command="holdback")*2

[State 720, VarSet]
Type       = VarSet
TriggerAll = (Var(59) >= 1) && (RoundState = 2)	;AItO
Trigger1   = Time = 0
var(8)     = IfElse(FrontEdgeBodyDist<=40 && Random>200, 2, IfElse(BackEdgeBodyDist<=40 && Random>200, 1, 0))


[State 720, PlaySnd]
Type     = PlaySnd
Trigger1 = Time = 0
Value    = s202, 3


[State 720, Helper]
Type        = Helper
Trigger1    = Time = 0
StateNo     = 6220
ID          = 62200
Name        = ""
Pos         = 0,-45
PosType     = P1
ownpal      = 1
size.XScale = .5
size.YScale = .5
Persistent     = 1
IgnoreHitPause = 1


[State 720, ChangeState]
Type       = ChangeState
TriggerAll = (Var(59) = 0)
Trigger1   = Time = 0
Value      = IfElse(StateType=A, IfElse(var(8)=1,103,108), IfElse((Command="holddown"),55,IfElse(var(8)=1,100,105)))

[State 720, ChangeState]
Type       = ChangeState
TriggerAll = (Var(59) >= 1) && (RoundState = 2)	;AItO
Trigger1   = Time = 0
Value      = IfElse(StateType=A, IfElse(var(8)=1,103,108), IfElse((BackEdgeBodyDist<=40) || Random <50,55,IfElse(var(8)=1,100,105)))








;===========================================================================
; {i_[W_Ej
;===========================================================================

;---------------------------------------------------------------------------
; HITG_SHAKE
[Statedef 5000]
Type     = S
MoveType = H
Physics  = N
VelSet   = 0,0

[State 5000, NotHitBy]
Type       = NotHitBy
;TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
Value      = ,AA, AP, AT
Time       = 1


[State 5000, PowerAdd]
Type       = PowerAdd
Trigger1   = Time = 1
Trigger1   = (MoveType = H) && (FVar(39)>0)
Value      = 5 + Floor(GetHitvar(damage) * FVar(39)*0.003) - IfElse((Var(49) = [10,19]), 5, 0)
Persistent = 0
IgnoreHitPause = 1

[State 5000, 1]
Type = PlaySnd
Trigger1 = Time = 1
Trigger1 = life != 0
Trigger1 = random <= 100
Value    = s5000, 1
channel  = 2

[State 5000, 1]
Type = PlaySnd
Trigger1 = Time = 1
Trigger1 = life != 0
Trigger1 = random = [101,300]
Value    = s5000, 1
channel  = 2

[State 5000, 1] ;Anim for HIT_LIGHT to HIT_HARD
Type     = ChangeAnim
Trigger1 = Time = 0
Trigger1 = GetHitVar(AnimType) != [3,5]
Value    = IfElse((GetHitVar(GroundType) = 1),5000,5010) + GetHitVar(AnimType)

[State 5000, 2] ;Anim for HIT_BACK
Type     = ChangeAnim
Trigger1 = Time = 0
Trigger1 = GetHitVar(AnimType) = [3,5]
Value    = 5030

[State 5000, 3] ;Anim for HIT_UP/HIT_DIAGUP (only if it exists)
Type     = ChangeAnim
Trigger1 = Time = 0
Trigger1 = (GetHitVar(AnimType) = [4,5]) && (SelfAnimExist(5047 + GetHitVar(AnimType)))
Value    = 5047 + GetHitVar(AnimType) ;5051 - 4 + Type

[State 5000, 4] ;Freeze Anim
Type     = ChangeAnim
Trigger1 = Time > 0
Value    = Anim

[State 5000, 5] ;State Type gets set to aerial if getting hit up
Type       = StateTypeSet
Trigger1   = Time = 0
Trigger1   = GetHitVar(YVel) != 0 || GetHitVar(Fall)
Trigger2   = Pos Y != 0
StateType  = A


[State 5000, 6]
Type     = ChangeState
Trigger1 = HitShakeOver
Trigger1 = GetHitVar(YVel) = 0 && !GetHitVar(Fall)
Value    = 5001 ;HITG_SLIDE

[State 5000, 7]
Type     = ChangeState
Trigger1 = HitShakeOver
Value    = 5030

[State 5000, FFB Light]
Type       = ForceFeedback
Trigger1   = Anim = 5000
Trigger2   = Anim = 5010
Persistent = 0
Time       = 6
waveform   = square

[State 5000, FFB Medium]
Type       = ForceFeedback
Trigger1   = Anim = 5001
Trigger2   = Anim = 5011
Persistent = 0
Time       = 8
waveform   = sinesquare
Ampl       = 110,-1,-.3

[State 5000, FFB Hard]
Type       = ForceFeedback
Trigger1   = Anim = 5012
Trigger2   = Anim = 5002
Trigger3   = Anim = 5030
Persistent = 0
Time       = 15
waveform   = sinesquare
Ampl       = 140

;---------------------------------------------------------------------------
; HITG_SLIDE
[Statedef 5001]
Type     = S
MoveType = H
Physics  = S

[State 5001, NotHitBy]
Type       = NotHitBy
;TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
Value      = ,AA, AP, AT
Time       = 1

[State 5001, 1]
Type     = HitVelSet
Trigger1 = Time = 0
X        = 1

[State 5001, 2]
Type     = ChangeAnim
Trigger1 = AnimTime = 0
Value    = 5005 + GetHitVar(AnimType) + (GetHitVar(groundType)=2)*10

[State 5001, 3] ;Stop sliding back
Type     = VelMul
Trigger1 = Time >= GetHitVar(SlideTime)
X        = .6

[State 5001, 4]
Type     = VelSet
Trigger1 = HitOver
X        = 0

[State 5001, 5]
Type     = DefenceMulSet
Trigger1 = HitOver
Value    = 1

[State 5001, 6]
Type     = ChangeState
Trigger1 = HitOver
Value    = 0
Ctrl     = 1



;---------------------------------------------------------------------------
; HITG2_SHAKE
[Statedef 5003]
Type     = S
MoveType = H
Physics  = N
VelSet   = 0,0
Anim     = 5003

[State 5003, NotHitBy]
Type       = NotHitBy
;TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
Value      = ,AA, AP, AT
Time       = 1


[State 5003, PowerAdd]
Type       = PowerAdd
Trigger1   = Time = 1
Trigger1   = (MoveType = H) && (FVar(39)>0)
Value      = 5 + Floor(GetHitvar(damage) * FVar(39)*0.003) - IfElse((Var(49) = [10,19]), 5, 0)
Persistent = 0
IgnoreHitPause = 1

[State 5003, 4] ;Freeze Anim
Type     = ChangeAnim
Trigger1 = Time > 0
Value    = Anim

[State 5003, 5] ;State Type gets set to aerial if getting hit up
Type       = StateTypeSet
Trigger1   = Time = 0
Trigger1   =  Pos Y = 0
;Trigger1   = GetHitVar(YVel) != 0 || GetHitVar(Fall)
Trigger2   = Pos Y != 0
StateType  = A


[State 5003, 6]
Type     = ChangeState
Trigger1 = HitShakeOver
;Trigger1 = GetHitVar(YVel) = 0 && !GetHitVar(Fall)
Trigger1 =  Pos Y = 0
Value    = 5004 ;HITG2_SLIDE

[State 5003, 7]
Type     = ChangeState
Trigger1 = HitShakeOver
Value    = 5030

[State 5003, FFB Hard]
Type       = ForceFeedback
Trigger1   = Anim = 5003
Persistent = 0
Time       = 15
waveform   = sinesquare
Ampl       = 140

;---------------------------------------------------------------------------
; HITG2_SLIDE
[Statedef 5004]
Type     = S
MoveType = H
Physics  = S
Anim     = 5008

[State 5004, NotHitBy]
Type       = NotHitBy
;TriggerAll = (Time = 0)
TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
Value      = ,AA, AP, AT
Time       = 1

[State 5004, 1]
Type     = HitVelSet
Trigger1 = Time = 0
X        = 1

[State 5004, 3] ;Stop sliding back
Type     = VelMul
Trigger1 = Time >= 2
X        = .6

[State 5004, 4]
Type     = VelSet
;Trigger1 = HitOver
Trigger1 = Time >= 24
X        = 0

[State 5004, 5]
Type     = DefenceMulSet
;Trigger1 = HitOver
Trigger1 = Time >= 24
Value    = 1

[State 5004, 6]
Type     = ChangeState
;Trigger1 = HitOver
Trigger1 = Time >= 24
Value    = 0
Ctrl     = 1



;---------------------------------------------------------------------------
; HITC_SHAKE
[Statedef 5010]
Type     = C
MoveType = H
Physics  = N
VelSet   = 0,0

[State 5010, NotHitBy]
Type       = NotHitBy
;TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
Value      = ,AA, AP, AT
Time       = 1

[State 5010, PowerAdd]
Type       = PowerAdd
Trigger1   = Time = 1
Trigger1   = (MoveType = H) && (FVar(39)>0)
Value      = 5 + Floor(GetHitvar(damage) * FVar(39)*0.003) - IfElse((Var(49) = [10,19]), 5, 0)
Persistent = 0
IgnoreHitPause = 1

[State 5010, 1]
Type = PlaySnd
Trigger1 = Time = 1
Trigger1 = life != 0
Trigger1 = random <= 100
Value    = s5000, 2
channel  = 2

[State 5010, 1]
Type = PlaySnd
Trigger1 = Time = 1
Trigger1 = life != 0
Trigger1 = random = [101,300]
Value    = s5000, 2
channel  = 2

[State 5010, 1] ;Anim for HIT_LIGHT to HIT_HARD
Type     = ChangeAnim
Trigger1 = Time = 0
Trigger1 = GetHitVar(AnimType) != [3,5]
Value    = 5020 + GetHitVar(AnimType)

[State 5010, 2] ;Anim for HIT_BACK
Type     = ChangeAnim
Trigger1 = Time = 0
Trigger1 = GetHitVar(AnimType) = [3,5]
Value    = 5030

[State 5010, 3] ;Anim for HIT_UP/HIT_DIAGUP (only if it exists)
Type     = ChangeAnim
Trigger1 = Time = 0
Trigger1 = (GetHitVar(AnimType) = [4,5]) && (SelfAnimExist(5047 + GetHitVar(AnimType)))
Value    = 5047 + GetHitVar(AnimType) ;5051 - 4 + Type

[State 5010, 4] ;Freeze Anim
Type     = ChangeAnim
Trigger1 = Time > 0
Value    = Anim

[State 5010, 5] ;State Type gets set to aerial if getting hit up
Type       = StateTypeSet
TriggerAll = Time = 0
Trigger1   = GetHitVar(YVel) != 0 || GetHitVar(Fall)
Trigger2   = Pos Y != 0
StateType  = A


[State 5010, 6]
Type     = ChangeState
Trigger1 = HitShakeOver
Trigger1 = GetHitVar(YVel) = 0 && !GetHitVar(Fall)
Value    = 5011 ;HITC_SLIDE

[State 5010, 7]
Type     = ChangeState
Trigger1 = HitShakeOver
Value    = 5030

[State 5010, FFB Light]
Type       = ForceFeedback
Trigger1   = Anim = 5020
Persistent = 0
Time       = 6
waveform   = square

[State 5010, FFB Medium]
Type       = ForceFeedback
Trigger1   = Anim = 5021
Persistent = 0
Time       = 8
waveform   = sinesquare
Ampl       = 110,-1,-.3

[State 5010, FFB Hard]
Type       = ForceFeedback
Trigger1   = Anim = 5022
Persistent = 0
Time       = 15
waveform   = sinesquare
Ampl       = 140


;---------------------------------------------------------------------------
; HITC_SLIDE
[Statedef 5011]
Type     = C
MoveType = H
Physics  = C

[State 5011, NotHitBy]
Type       = NotHitBy
;TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
Value      = ,AA, AP, AT
Time       = 1

[State 5011, 1]
Type     = HitVelSet
Trigger1 = Time = 0
X        = 1

[State 5011, 2]
Type     = ChangeAnim
Trigger1 = AnimTime = 0
Value    = 5025 + GetHitVar(AnimType)

[State 5011, 3] ;Stop sliding back
Type     = VelMul
Trigger1 = Time >= GetHitVar(SlideTime)
X        = .6

[State 5011, 4]
Type     = VelSet
Trigger1 = HitOver
X        = 0

[State 5011, 5]
Type     = DefenceMulSet
Trigger1 = HitOver
Value    = 1

[State 5011, 6]
Type     = ChangeState
Trigger1 = HitOver
Value    = 11
Ctrl     = 1

;---------------------------------------------------------------------------
; HITA_SHAKE
[Statedef 5020]
Type     = A
MoveType = H
Physics  = N
VelSet   = 0,0

[State 5020, NotHitBy]
Type       = NotHitBy
;TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
Value      = ,AA, AP, AT
Time       = 1

[State 5020, PowerAdd]
Type       = PowerAdd
Trigger1   = Time = 1
Trigger1   = (MoveType = H) && (FVar(39)>0)
Value      = 5 + Floor(GetHitvar(damage) * FVar(39)*0.003) - IfElse((Var(49) = [10,19]), 5, 0)
Persistent = 0
IgnoreHitPause = 1

[State 5020, 1]
Type = PlaySnd
Trigger1 = Time = 1
Trigger1 = life != 0
Trigger1 = random <= 300
Value    = s5000, 2
channel  = 2

[State 5020, 1] ;Anim for HIT_LIGHT to HIT_HARD
Type     = ChangeAnim
Trigger1 = Time = 0
Trigger1 = GetHitVar(AnimType) != [3,5]
Value    = IfElse((GetHitVar(AirType) = 1),5000,5010) + GetHitVar(AnimType)

[State 5020, 2] ;Anim for HIT_BACK
Type     = ChangeAnim
Trigger1 = Time = 0
Trigger1 = GetHitVar(AnimType) = [3,5]
Value    = 5030

[State 5020, 3] ;Anim for HIT_UP/HIT_DIAGUP (only if it exists)
Type     = ChangeAnim
Trigger1 = Time = 0
Trigger1 = (GetHitVar(AnimType) = [4,5]) && (SelfAnimExist(5047 + GetHitVar(AnimType)))
Value    = 5047 + GetHitVar(AnimType) ;5051 - 4 + Type

[State 5020, 4] ;Freeze Anim
Type     = ChangeAnim
Trigger1 = Time > 0
Value    = Anim


[State 5020, 5]
Type     = ChangeState
Trigger1 = HitShakeOver
Value    = 5030

[State 5020, FFB Light]
Type       = ForceFeedback
Trigger1   = Anim = 5000
Trigger2   = Anim = 5010
Persistent = 0
Time       = 6
waveform   = square

[State 5020, FFB Medium]
Type       = ForceFeedback
Trigger1   = Anim = 5001
Trigger2   = Anim = 5011
Persistent = 0
Time       = 8
waveform   = sinesquare
Ampl       = 110,-1,-.3

[State 5020, FFB Hard]
Type       = ForceFeedback
Trigger1   = Anim = 5012
Trigger2   = Anim = 5002
Trigger3   = Anim = 5030
Trigger4   = Anim = [5051,5059]
Persistent = 0
Time       = 15
waveform   = sinesquare
Ampl       = 140


;---------------------------------------------------------------------------
; HITA_UP (initial going up)
[Statedef 5030]
Type     = A
MoveType = H
Physics  = N
Ctrl     = 0

[State 5030, NotHitBy]
Type       = NotHitBy
;TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
Value      = ,AA, AP, AT
Time       = 1

[State 5030, PowerAdd]
Type       = PowerAdd
Trigger1   = Time = 1
Trigger1   = (MoveType = H) && (FVar(39)>0)
Value      = 5 + Floor(GetHitvar(damage) * FVar(39)*0.003) - IfElse((Var(49) = [10,19]), 5, 0)
Persistent = 0
IgnoreHitPause = 1

[State 5030, 1]
Type = PlaySnd
Trigger1 = Time = 1
Trigger1 = life != 0
Trigger1 = random <= 300
Value    = s5000, 4
channel  = 2

[State 5030, 1]
Type     = VelAdd	;Gravity
Trigger1 = 1
Y        = GetHitVar(YAccel)

[State 5030, 2]
Type     = HitVelSet
Trigger1 = Time = 0
X        = 1
Y        = 1

[State 5030, 3]
Type       = ChangeState
TriggerAll = !HitFall
Trigger1   = HitOver
Trigger2   = Vel Y > 0    ;Hit ground
Trigger2   = Pos Y >= 10  ;.
Value      = 5040 ;HITA_RECOV

[State 5030, 4]
Type       = ChangeState
TriggerAll = HitFall
Trigger1   = HitOver
Trigger2   = Vel Y > 0    ;Hit ground
Trigger2   = Pos Y >= 10  ;.
Value      = 5050 ;HITA_FALL

[State 5030, 5]
Type     = ChangeState
Trigger1 = AnimTime = 0
Value    = 5035 ;HITA_UP (transition)


;---------------------------------------------------------------------------
; HITA_UP_T (transition)
[Statedef 5035]
Type     = A
MoveType = H
Physics  = N

[State 5035, NotHitBy]
Type       = NotHitBy
;TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
Value      = ,AA, AP, AT
Time       = 1

[State 5035, 1]
Type     = ChangeAnim
Trigger1 = Time = 0
Trigger1 = SelfAnimExist(5035)
Trigger1 = Anim != [5051,5059]	;Not if in hit up Anim
Trigger1 = Anim != 5090					;Not if hit off ground Anim
Value    = 5035

[State 5035, 2]
Type     = VelAdd
Trigger1 = 1
Y        = GetHitVar(YAccel)

[State 5035, 3]
Type       = ChangeState
TriggerAll = !HitFall
Trigger1   = HitOver			;Hit is over
Trigger2   = AnimTime = 0	;Animation over
Trigger3   = Vel Y > 0		;Hit ground
Trigger3   = Pos Y >= 10	;.
Trigger4   = Time = 0			;No transition Anim
Trigger4   = Anim != 5035	;.
Value      = 5040					;HITA_RECOV

[State 5035, 4]
Type = ChangeState
TriggerAll = HitFall
Trigger1 = HitOver  ;Hit is over
Trigger2 = AnimTime = 0 ;Anim is over
Trigger3 = Vel Y > 0    ;Hit ground
Trigger3 = Pos Y >= 10  ;.
Trigger4 = Time = 0     ;No transition Anim
Trigger4 = Anim != 5035 ;.
Value = 5050 ;HITA_FALL


;---------------------------------------------------------------------------
; HITA_RECOV (recovering in air, not falling)
[Statedef 5040]
Type     = A
MoveType = H
Physics  = N

[State 5040, NotHitBy]
Type       = NotHitBy
;TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
Value      = ,AA, AP, AT
Time       = 1

[State 5040, 1]
Type     = ChangeState
Trigger1 = !Alive
Value    = 5050

[State 5040, 2]
Type     = ChangeAnim
Trigger1 = AnimTime = 0
Trigger1 = Anim != 5040
Trigger2 = Time = 0
Trigger2 = Anim != 5035
Value    = 5040

[State 5040, 3]
Type     = CtrlSet
Trigger1 = HitOver
Value    = 1

[State 5040, 4]
Type     = StateTypeSet
Trigger1 = HitOver
MoveType = I

[State 5040, 5]
Type     = VelAdd
Trigger1 = 1
Y        = GetHitVar(YAccel)

[State 5040, 6]
Type     = ChangeState
Trigger1 = Vel Y > 0
Trigger1 = Pos Y >= 0
Value    = 52 ;JUMPLAND


;---------------------------------------------------------------------------
; HITA_FALL (knocked up, falling)
[Statedef 5050]
Type    = A
MoveType= H
Physics = N

[State 5050, NotHitBy]
Type       = NotHitBy
;TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
Value      = ,AA, AP, AT
Time       = 1

[State 5050, 1] ;Change Anim when done with transition
Type = ChangeAnim
Trigger1 = AnimTime = 0
Trigger1 = Anim = 5035
Trigger2 = Time = 0     ;If no transition Anim
Trigger2 = Anim != 5035
Trigger2 = (Anim != [5051, 5059]) && (Anim != [5061, 5069])
Trigger2 = Anim != 5090 ;Not if hit off ground Anim
Value = 5050

[State 5050, 2] ;Coming down Anim
Type = ChangeAnim
Trigger1 = Anim = [5050,5059]
Trigger1 = Vel Y >= ifelse(Anim = 5050, 1, -2)
Trigger1 = SelfAnimExist(Anim+10)
Value = Anim+10
Persistent = 0

[State 5050, 3] ;Gravity
Type = VelAdd
Trigger1 = 1
y = GetHitVar(yaccel)

[State 5050, 4] ;Recover near ground
Type = ChangeState
TriggerAll = Vel Y > 0
TriggerAll = Pos Y >= -20
TriggerAll = alive
TriggerAll = CanRecover
Trigger1 = Command = "recovery"
Value = 5200 ;HITFALL_RECOVER

[State 5050, 5]; Recover in mid air
Type = ChangeState
TriggerAll = Vel Y > -1
TriggerAll = alive
TriggerAll = CanRecover
Trigger1 = Command = "recovery"
Value = 5210 ;HITFALL_AIRRECOVER

[State 5050, 6]
Type = ChangeState
Trigger1 = Vel Y > 0
Trigger1 = Pos Y >= ifelse((Anim = [5051,5059]) || (Anim = [5061,5069]), 0, 25)
Value = 5100 ;HIT_BOUNCE

;---------------------------------------------------------------------------
; HIT_TRIP (shaking)
[Statedef 5070]
Type    = A
MoveType= H
Physics = N
VelSet = 0,0

[State 5070, NotHitBy]
Type       = NotHitBy
;TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
Value      = ,AA, AP, AT
Time       = 1

[State 5070, PowerAdd]
Type       = PowerAdd
Trigger1   = Time = 1
Trigger1   = (MoveType = H) && (FVar(39)>0)
Value      = 5 + Floor(GetHitvar(damage) * FVar(39)*0.003) - IfElse((Var(49) = [10,19]), 5, 0)
Persistent = 0
IgnoreHitPause = 1

[State 5070, 1]
Type = PlaySnd
Trigger1 = Time = 1
Trigger1 = life != 0
Trigger1 = random <= 300
Value    = s5000, 4
channel  = 2

[State 5070, 1]
Type = ChangeAnim 
Trigger1 = 1
Value = 5070

[State 5070, 2]
Type = ChangeState
Trigger1 = HitShakeOver
Value = 5071

[State 5070, 3]
Type = ForceFeedback
Trigger1 = Time = 0
Time = 12
waveform = sinesquare
ampl = 140


;---------------------------------------------------------------------------
; HIT_TRIP2 (Fall through air)
[Statedef 5071]
Type     = A
MoveType = H
Physics  = N

[State 5071, NotHitBy]
Type       = NotHitBy
;TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
Value      = ,AA, AP, AT
Time       = 1

[State 5071, 1]
Type     = HitVelSet
Trigger1 = Time = 0
X        = 1
Y        = 1

[State 5071, 2] ;Acceleration
Type     = VelAdd
Trigger1 = 1
Y        = GetHitVar(YAccel)

[State 5071, 3] ;Hit ground
Trigger1 = Vel Y > 0
Trigger1 = Pos Y >= 15
Type     = ChangeState
Value    = 5100


;---------------------------------------------------------------------------
; HITL_SHAKE
[Statedef 5080]
Type    = L
MoveType= H
Physics = N
VelSet = 0,0

[State 5080, NotHitBy]
Type       = NotHitBy
;TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
Value      = ,AA, AP, AT
Time       = 1

[State 5080, PowerAdd]
Type       = PowerAdd
Trigger1   = Time = 1
Trigger1   = (MoveType = H) && (FVar(39)>0)
Value      = 5 + Floor(GetHitvar(damage) * FVar(39)*0.003) - IfElse((Var(49) = [10,19]), 5, 0)
Persistent = 0
IgnoreHitPause = 1

[State 5080, 1]
Type = PlaySnd
Trigger1 = Time = 1
Trigger1 = life != 0
Trigger1 = random <= 300
Value    = s5000, 4
channel  = 2

[State 5080, 1] ;Set default Anim
Type = VarSet
Trigger1 = Time = 0
sysvar(2) = ifelse (GetHitVar(yvel) = 0, 5080, 5090)

[State 5080, 2]
Type = VarAdd
Trigger1 = Time = 0
Trigger1 = (Anim = [5081,5089]) || (Anim = [5111,5119])
Trigger1 = SelfAnimExist(sysvar(2) + (Anim % 10))
sysvar(2) = Anim % 10

[State 5080, 3] ;If 5090 doesn't exist, default to 5030
Type = VarSet
Trigger1 = Time = 0
Trigger1 = sysvar(2) = 5090
Trigger1 = !SelfAnimExist(5090)
sysvar(2) = 5030

[State 5080, 3] ;Freeze
Type = ChangeAnim
Trigger1 = 1
Value = sysvar(2)

[State 5080, 4]
Type = ChangeState
Trigger1 = HitShakeOver
Trigger1 = GetHitVar(yvel) = 0
Value = 5081 ;HITL_SLIDE

[State 5080, 5]
Type = ChangeState
Trigger1 = HitShakeOver
Trigger1 = GetHitVar(yvel) != 0
Value = 5030 ;HITA_UP

;---------------------------------------------------------------------------
; HITL_SLIDE
[Statedef 5081]
Type    = L
MoveType= H
Physics = C

[State 5081, NotHitBy]
Type       = NotHitBy
;TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
Value      = ,AA, AP, AT
Time       = 1

[State 5081, 1]
Type = HitVelSet
Trigger1 = Time = 0
x = 1

[State 5081, 2]
Type = VelSet
Trigger1 = HitOver
x = 0

[State 5081, 3] ;Don't show hit ground frame
Type = VarSet
Trigger1 = Time = 0
sysvar(0) = 1

[State 5081, 4]
Type = ChangeState
Trigger1 = HitOver
Value = 5110 ;HIT_LIEDOWN

;---------------------------------------------------------------------------
; HIT_BOUNCE (hit ground)
[Statedef 5100]
Type    = L
MoveType= H
Physics = N

[State 5100, NotHitBy]
Type       = NotHitBy
;TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
Value      = ,AA, AP, AT
Time       = 1

[State 5100, 1]
Type = PlaySnd
Trigger1 = Time = 1
Trigger1 = life != 0
Trigger1 = random <= 300
Value    = s5000, 3
channel  = 2

[State 5100, 1]
Type = VelSet
Trigger1 = Time = 0
Trigger1 = GetHitVar(Fall.yvel) = 0
Trigger1 = vel x > 1
x = 1

[State 5100, EnvShake]
Type = FallEnvShake
Trigger1 = Time = 0

[State 5100, Var] ;Save Fall velocity
Type = VarSet
Trigger1 = Time = 0
sysvar(1) = floor(vel y)

[State 5100, 2] ;Hit ground Anim (normal)
Type = ChangeAnim
TriggerAll = Time = 0
Trigger1 = (Anim != [5051,5059]) && (Anim != [5061,5069])
Trigger2 = !SelfAnimExist(5100 + (Anim % 10))
Value = 5100

[State 5100, 3] ;Hit ground Anim (for hit up)
Type = ChangeAnim
Trigger1 = Time = 0
Trigger1 = (Anim = [5051,5059]) || (Anim = [5061,5069])
Trigger1 = SelfAnimExist(5100 + (Anim % 10))
Value = 5100 + (Anim % 10)

[State 5100, 4]
Type = PosSet
Trigger1 = Time = 0
y = 0

[State 5100, 5]
Type = VelSet
Trigger1 = Time = 0
y = 0

[State 5100, 6] ;Reduce speed
Type = VelMul
Trigger1 = Time = 0
x = 0.75

[State 5100, 7]
Type = ChangeState
Trigger1 = Time = 0
Trigger1 = GetHitVar(Fall.yvel) = 0
Value = 5110 ;HIT_LIEDOWN

[State 5100, 8]
Type = GameMakeAnim
Trigger1 = Time = 1
Value = 60 + (sysvar(1) > 5) ;+ (sysvar(1) > 14)
Pos = 0, 0
under = 0	;sysvar(1) <= 14

[State 5100, 9]
Type = HitFallDamage
Trigger1 = Time = 3

[State 5100, 10]
Type = PlaySnd
Trigger1 = Time = 1
;Value = F7, (sysvar(1) > 5) + (sysvar(1) > 14)
Value    = 110, 2

[State 5100, 11]
Type = PosFreeze
Trigger1 = 1

[State 5100, 12]
Type = ChangeState
Trigger1 = AnimTime = 0
Value = 5101

[State 5100, 13]
Type = ForceFeedback
Trigger1 = Time = 0
waveform = sinesquare
ampl = 128,-3,-.2,.005
Time = 20

;---------------------------------------------------------------------------
; HIT_BOUNCE (bounce into air)
[Statedef 5101]
Type    = L
MoveType= H
Physics = N

[State 5101, NotHitBy]
Type       = NotHitBy
;TriggerAll = (Time = 0)
Trigger1   = NumHelper(8000)>0
Trigger1   = Helper(8000),var(7) > 0
Value      = ,AA, AP, AT
Time       = 1

[State 5101, 1] ;Coming hit ground Anim (normal)
Type = ChangeAnim
TriggerAll = Time = 0
Trigger1 = Anim != [5101,5109]
Trigger2 = !SelfAnimExist(5160 + (Anim % 10))
Value = 5160

[State 5101, 2] ;Coming hit ground Anim (for hit up)
Type = ChangeAnim
TriggerAll = Time = 0
Trigger1 = Anim = [5101,5109]
Trigger1 = SelfAnimExist(5160 + (Anim % 10))
Value = 5160 + (Anim % 10)

[State 5101, 3]
Type = HitFallVel
Trigger1 = Time = 0

[State 5101, 4]
Type = PosSet
Trigger1 = Time = 0
y = 20

[State 5101, 5] ;Acceleration
Type = VelAdd
Trigger1 = 1
y = .4

[State 5101, 6] ;Hit ground
Trigger1 = Vel Y > 0
Trigger1 = Pos Y >= 12
Type = ChangeState
Value = 5110





;---------------------------------------------------------------------------
; HIT_LIEDOWN
;==================================================
; [{] _E
;--------------------------------------------------
[Statedef 5110]
Type     = L
MoveType = H
Physics  = N

;-------------------------------------------------- G
[State 5110, NotHitBy]
Type     = NotHitBy
Trigger1 = Time > 30
Value    = SCA, AA, AP, AT
Time     = 1

[State 5110, 1]
Type = PlaySnd
Trigger1 = Time = 1
Trigger1 = life != 0
Trigger1 = random <= 100
Value    = s5001, 1
channel  = 3
;-------------------------------------------------- ϐ
[State 5110, VarSet]
Type       = VarSet
TriggerAll = (Var(59) = 0)	;AItO
Trigger1   = 1
var(10)    = IfElse(Command="holdfwd",5125,IfElse(Command="holdback",5126,5120))


[State 5110, VarSet]
Type       = VarSet
TriggerAll = (Var(59) >= 1) && (RoundState = 2)	;AItO
TriggerAll = (Var(10) != 5120) && (Var(10) != 5125) && (Var(10) != 5126)
Trigger1   = (Random < 800)
Trigger1   = (P2BodyDist X > 60+Var(59)*8)
Trigger2   = (Random < 500+Var(59)*40)
Trigger2   = (BackEdgeBodyDist < 50+Var(59)*2)
var(10)    = 5125

[State 5110, VarSet]
Type       = VarSet
TriggerAll = (Var(59) >= 1) && (RoundState = 2)	;AItO
TriggerAll = (Var(10) != 5120) && (Var(10) != 5125) && (Var(10) != 5126)
Trigger1   = (Random < 800)
Trigger1   = (P2BodyDist X < 60+Var(59)*8)
Trigger2   = (Random < 500+Var(59)*40)
Trigger2   = (FrontEdgeBodyDist < 50+Var(59)*2)
var(10)    = 5126

[State 5110, VarSet]
Type       = VarSet
TriggerAll = (Var(59) >= 1) && (RoundState = 2)	;AItO
TriggerAll = (Var(10) != 5120) && (Var(10) != 5125) && (Var(10) != 5126)
Trigger1   = 1
var(10)    = 5120

;-------------------------------------------------- h
[State 5110, EnvShake]
Type     = FallEnvShake
Trigger1 = Time = 0

;-------------------------------------------------- AjύX
[State 5110, ChangeAnim]		;For hit up/up-diag Type (from State 5081)
Type       = ChangeAnim
Persistent = 0
Trigger1   = SelfAnimExist(5110 + (Anim % 10))
Trigger1   = Anim = [5081,5089]
Value      = 5110 + (Anim % 10)

[State 5110, ChangeAnim]		;Hit ground Anim (normal)
Type       = ChangeAnim
TriggerAll = Time = 0
TriggerAll = Anim != [5110,5119] ;Not already changed Anim
Trigger1   = Anim != [5161,5169]
Trigger2   = !SelfAnimExist(5170 + (Anim % 10))
Value      = 5170

[State 5110, ChangeAnim]		;Hit ground Anim (for hit up)
Type       = ChangeAnim
TriggerAll = Time = 0
TriggerAll = Anim != [5110,5119] ;Not already changed Anim
Trigger1   = Anim = [5161,5169]
;Trigger1   = SelfAnimExist(5170 + (Anim % 10))
Value      = 5170 + (Anim % 10)


;-------------------------------------------------- 
[State 5110, 6]
Type     = PlaySnd
Trigger1 = Time = 0
Trigger1 = !SysVar(0)
;Value    = F7, (sysvar(1) > 5) + (sysvar(1) > 14)
Value    = 110, 2

;-------------------------------------------------- ̑
[State 5110, 7]
Type     = GameMakeAnim
Trigger1 = 0
Trigger1 = Time = 0
Trigger1 = !SysVar(0)
Value    = 60 + (sysvar(1) > 5) ;+ (sysvar(1) > 14)
Pos      = 0, 0
Under    = 0	;sysvar(1) <= 14


;-------------------------------------------------- ̑
[State 5110, HitFallDamage]
Type     = HitFallDamage
Trigger1 = Time = 0

[State 5110, PosSet]
Type     = PosSet
Trigger1 = Time = 0
Y        = 0

[State 5110, VarSet]		;Get Fall velocity
Type      = VarSet
Trigger1  = Time = 0
Trigger1  = GetHitVar(Fall.YVel) != 0
sysvar(1) = Floor(Vel Y)

[State 5110, VelSet]
Type     = VelSet
Trigger1 = Time = 0
Y        = 0


;-------------------------------------------------- AjύX
[State 5110, ChangeAnim]	;For hit up Type
Type       = ChangeAnim
Persistent = 0
TriggerAll = Anim = [5171,5179]
TriggerAll = SelfAnimExist(5110 + (Anim % 10))
Trigger1   = AnimTime = 0
Trigger2   = SysVar(0)		;SysVar(0) = 1 avoids hit ground Anim
Value      = 5110 + (Anim % 10)

[State 5110, ChangeAnim]	;For normal
Type       = ChangeAnim
Persistent = 0
TriggerAll = Anim != [5111,5119]
Trigger1   = AnimTime = 0
Trigger2   = SysVar(0)		;SysVar(0) = 1 avoids hit ground frame
Value      = 5110

;-------------------------------------------------- Xe[gύX
[State 5110, ChangeState]		;If just died
Type       = ChangeState
TriggerAll = !Alive
Trigger1   = AnimTime = 0
Trigger2   = SysVar(0)		;SysVar(0) = 1 avoids hit ground frame
Trigger3   = Anim = [5110,5119]
Value      = 5150

;-------------------------------------------------- ̑
[State 5110, VarSet]
Type      = VarSet
Trigger1  = SysVar(0)
Trigger1  = Time = 0
sysvar(0) = 0

[State 5110, VelMul]		;Friction
Type     = VelMul
Trigger1 = 1
X        = 0.85


;-------------------------------------------------- ̑
[State 5110, ForceFeedback]
Type     = ForceFeedback
Trigger1 = Alive
Trigger1 = Time = 0
Time     = 8
Ampl     = 240
waveform = sine

[State 5110, ForceFeedback]
Type     = ForceFeedback
Trigger1 = !Alive
Trigger1 = Time = 0
Ampl     = 200, 7, -.467
Time     = 30
waveform = sine


;**************************************************
[State 5110, DestroySelf]		;gpwp[폜
Type     = DestroySelf
Trigger1 = IsHelper



;==================================================
; [{] Nオ
;--------------------------------------------------
[Statedef 5120]
Type     = L
MoveType = I
Physics  = N

[State 5120, ChangeAnim]		;Get up Anim (Normal)
Type       = ChangeAnim
TriggerAll = Time = 0
Trigger1   = (Anim != [5111,5119]) ;&& (Anim != [5171,5179])
Trigger2   = !SelfAnimExist(5120 + (Anim % 10))
Value      = 5120

[State 5120, ChangeAnim]		;Get up Anim (For Hit Up/Diag-Up)
Type       = ChangeAnim
TriggerAll = Time = 0
Trigger1   = (Anim = [5111,5119]) ;|| (Anim = [5171,5179])
Trigger1   = SelfAnimExist(5120 + (Anim % 10))
Value      = 5120 ;+ (Anim % 10)

[State 5120, ChangeAnim]
Type     = ChangeAnim
Trigger1 = (var(10) != 5120) && (Time = 0)
Value    = IfElse(var(10)=5125, 5125, 5126)


;-------------------------------------------------- x
[State 5120, VelSet]
Type     = VelSet
Trigger1 = (Time = 0)
X        = 0

[State 5120, VelAdd]
Type     = VelAdd
TriggerAll = (var(10) = [5125,5126])
Trigger1 = (Time = [0,17])
X        = IfElse(var(10)=5125, 0.4, -0.4)

[State 5120, VelAdd]
Type       = VelAdd
TriggerAll = (var(10) = [5125,5126])
Trigger1   = (Time = [18,33])
X          = IfElse(var(10)=5125, -0.4, 0.4)

[State 5120, VelSet]
Type       = VelSet
TriggerAll = (var(10) = [5125,5126])
Trigger1   = (Time = 34)
X          = 0

;-------------------------------------------------- G
[State 5120, NotHitBy]
Type     = NotHitBy
Trigger1 = 1
Value    = SCA
Time     = 1

[State 5120, NotHitBy]		;Can't be thrown right after getting up
Type       = NotHitBy
Trigger1   = NumHelper(4900)>0 && NumHelper(4901)>0
Trigger1   = AnimTime = 0
Value      = , AP, AT
Time       = 12

[State 5120, NotHitBy]		;Can't be thrown right after getting up
Type       = NotHitBy
Trigger1   = NumHelper(4900)=0 || NumHelper(4901)=0
Trigger1   = AnimTime = 0
Value      = , AT
Time       = 12

[State 5120, NotHitBy]		;Can't be hit right after getting up (short Time)
Type     = NotHitBy
Trigger1 = AnimTime = 0
Value2   = SCA
Time     = 6

[State 5120, VarSet]	;O΍pGԊǗ
Type       = VarSet
Trigger1   = AnimTime = 0
fvar(20)   = StateNo*1000 + 12

;-------------------------------------------------- ̑
[State 5120, PlayerPush]
Type     = PlayerPush
Trigger1 = (var(10) = [5125,5126])
Value    = 0

[State 5120, HitFallSet]
Type     = HitFallSet
Trigger1 = AnimTime = 0
Value    = 1


;-------------------------------------------------- Xe[gύX
[State 5120, ChangeState]
Type     = ChangeState
Trigger1 = (Anim = 5120) && (AnimTime = 0)
Trigger2 = (Anim = 5125) && (AnimTime = 0)
Trigger3 = (Anim = 5126) && (AnimTime = 0)
Value    = 0
Ctrl     = 1


;**************************************************
[State 5120, DestroySelf]		;gpwp[폜
Type     = DestroySelf
Trigger1 = IsHelper




;---------------------------------------------------------------------------
; HIT_LIEDEAD
[Statedef 5150]
Type    = L
MoveType= H
Physics = N
SprPriority = -3

[State 5150, 1] ;Normal Anim
Type = ChangeAnim
TriggerAll = Time = 0
TriggerAll = SelfAnimExist(5140)
Trigger1 = (Anim != [5111,5119]) && (Anim != [5171,5179])
Trigger2 = !SelfAnimExist(5140 + (Anim % 10))
Value = 5140

[State 5150, 3] ;Hit up Type Anim
Type = ChangeAnim
Trigger1 = Time = 0
Trigger1 = (Anim = [5111,5119]) || (Anim = [5171,5179])
Trigger1 = SelfAnimExist(5140 + (Anim % 10))
Value = 5140 + (Anim % 10)

[State 5150, 4] ;Match over Anim
Type = ChangeAnim
Persistent = 0
;Trigger1 = Time = 0
Trigger1 = MatchOver = 1
Trigger1 = Anim = [5140,5149]
Trigger1 = SelfAnimExist(Anim+10)
Value = Anim+10

[State 5150, 5] ;Switch to 5110 if liedead Anim does not exist
Type = ChangeAnim
Trigger1 = Time = 0
Trigger1 = Anim != [5140,5159]
Trigger1 = Anim != [5110,5119]
Value = 5110

[State 5150, 6] ;Friction
Type = VelMul
Trigger1 = 1
x = 0.85

[State 5150, 7] ;Friction
Type = VelSet
Trigger1 = Vel x < .05
Persistent = 0
x = 0

[State 5150, 8]
Type = NotHitBy
Trigger1 = 1
Value = SCA
Time = 1

;---------------------------------------------------------------------------
; HIT_FALLRECOVER (still falling)
[Statedef 5200]
Type     = A
MoveType = H
Physics  = N

[State 5200, 1] ;Change Anim if done with transition
Type = ChangeAnim
Trigger1 = Anim = 5035
Trigger1 = AnimTime = 0
Value = 5050

[State 5200, 2]
Type = VelAdd
Trigger1 = 1
y = GetHitVar(yaccel)

[State 5200, 3]
Type = SelfState
Trigger1 = Vel Y > 0
Trigger1 = Pos Y >= 10
Value = 5201

;[State 5200, ChangeState]
;Type     = ChangeState
;Trigger1 = 1
;Value    = 5210


||||||||||||||||||||||||||||||||||||||||||
; HIT_FALLRECOVER (on the ground)
[Statedef 5201]
Type     = A
MoveType = H
Physics  = A
Anim     = 5200

[State 5201, 1]		;Turn if not Facing opponent
Type     = Turn
Trigger1 = Time = 0
Trigger1 = P2Dist X < -5


;-------------------------------------------------- x
[State 5201, VelSet]]
Type     = VelSet
Trigger1 = Time = 0
X        = IfElse(Command = "holdback", -1.15, 1.15)
Y        = -3.5


[State 5201, 3]
Type     = PosSet
Trigger1 = Time = 0
Y        = 0

[State 5201, 4]
Type     = NotHitBy
Trigger1 = 1
Value    = SCA
Time     = 1

[State 5201, 5]		;Blink white
Type     = PalFX
Trigger1 = Time = 0
Time     = 3
Add      = 128,128,128	;256,256,256

[State 5201, 6]
Type     = GameMakeAnim
Trigger1 = Time = 1
Value    = 60
Pos      = 0, 0
Under    = 1

;-------------------------------------------------- ʉ
[State 5201, PlaySnd]
Type     = PlaySnd
Trigger1 = Time = 0
Value    = s115, 1

;-------------------------------------------------- 
[State 5201, Helper]		;gGtFNg
Type       = Helper
TriggerAll = Var(0) = [0,1]	;yʉtO
Trigger1   = Time = 0
OwnPal     = 1
Facing     = -1
PosType    = P1
Pos        = 0, -50
Name       = "Effect"
ID         = 62400
StateNo    = 6240
Persistent = 1
IgnoreHitPause = 1

;---------------------------------------------------------------------------
; HIT_AIRFALLRECOVER
[Statedef 5210]
Type    = A
MoveType= I
Physics = N
Anim = 5210
Ctrl = 0

[State 5210, 1] ;Blink white
Type = PalFX
Trigger1 = Time = 0
Time = 3
add = 128,128,128 ;256,256,256

[State 5210, 1]
Type = PosFreeze
Trigger1 = Time = 0
Value = 4

[State 5210, 2] ;Turn if not Facing opponent
Type = Turn
Trigger1 = Time = 0
Trigger1 = p2dist X < -20

[State 5210, 1] 
Type     = VelMul
Trigger1 = Time = 0
X        = .8
Y        = .8



;-------------------------------------------------- x
[State 5210, VelSet]]
Type       = VelSet
TriggerAll = (Var(59) = 0)	;AItO
Trigger1   = Time = 0
X          = IfElse(Command = "holdback", -4, 4)
Y          = -4

[State 5210, VelSet]]
Type       = VelSet
TriggerAll = (Var(59) >= 1) && (RoundState = 2)	;AItO
Trigger1   = Time = 0
X          = IfElse((Random<800) && (P2BodyDist X < 60+Var(59)*2), -4, 4)
Y          = -4



[State 5210, 3]
Type = NotHitBy
Trigger1 = Time = 0
Value = SCA
Time = 15

[State 5210, VarSet]
Type       = VarSet
Trigger1   = Time = 0
fvar(20)   = StateNo*1000 + 15

[State 5210, 4]
Type = CtrlSet
Trigger1 = Time = 20
Value = 1

[State 5210, 5]
Type = VelAdd;Gravity
Trigger1 = Time >= 4
y = .35

;-------------------------------------------------- ʉ
[State 5210, PlaySnd]
Type     = PlaySnd
Trigger1 = Time = 0
Value    = s115, 1

;-------------------------------------------------- 
[State 5210, Helper]		;gGtFNg
Type       = Helper
TriggerAll = Var(0) = [0,1]	;yʉtO
Trigger1   = Time = 0
OwnPal     = 1
Facing     = -1
PosType    = P1
Pos        = 0, -50
Name       = "Effect"
ID         = 62400
StateNo    = 6240
Persistent = 1
IgnoreHitPause = 1

;-------------------------------------------------- Xe[gύX
[State 5210, 5] ;Land on ground
Type = ChangeState
Trigger1 = Vel Y > 0
Trigger1 = Pos Y >= 0
Value = 52 ;JUMP_LAND
Ctrl = 1


;---------------------------------------------------------------------------
; Continue?
[Statedef 5500]
Type   = S
Anim   = 5300
Ctrl   = 0
VelSet = 0,0

[State 5500, 1]
Type     = ChangeAnim
Trigger1 = Time = 0
Trigger1 = SelfAnimExist(5500)
Value    = 5500


;---------------------------------------------------------------------------
; Initialize (at the start of the round)
[Statedef 5900]
Type = S

[State 5900, 1] ;Clear all int variables
Type = VarRangeSet
Trigger1 = roundsexisted = 0
Value = 0

[State 5900, 2] ;Clear all float variables
Type = VarRangeSet
Trigger1 = roundsexisted = 0
fValue = 0

[State 5900, 3] ;Intro for round 1
Type = ChangeState
Trigger1 = roundno = 1
Value = 190













;===========================================================================
; 萧Xe[g
;===========================================================================
;==================================================
; [] ǃoEh@
;--------------------------------------------------
[Statedef 12000]
Type       = A
MoveType   = H
Physics    = N
Ctrl       = 0
SprPriority = -1


;--------------------------------------------------
[State 12000, Turn]
Type       = Turn
Trigger1   = P2Dist X < 0


;-------------------------------------------------- x
[State 12000, VelSet]
Type       = VelSet
Trigger1   = !HitShakeOver
X          = 0
Y          = 0

[State 12000, VelSet]
Type       = VelSet
Trigger1   = HitShakeOver
X          = GetHitVar(XVel)*Facing
Y          = GetHitVar(YVel)
Persistent = 0

[State 12000, VelAdd]
Type       = VelAdd
Trigger1   = HitShakeOver
Y          = GetHitVar(YAccel)


;-------------------------------------------------- AjύX
[State 12000, ChangeAnim]
Type       = ChangeAnim
Trigger1   = !HitShakeOver
Trigger1   = Time > 0
Value      = Anim
Elem       = AnimElemNo(0)

[State 12000, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time = 0
Trigger1   = SelfAnimExist(5035)
Value      = 5035

[State 12000, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time = 0
Trigger1   = !SelfAnimExist(5035)
Value      = 5030

[State 12000, ChangeAnim]
Type       = ChangeAnim
Trigger1   = AnimTime = 0
Trigger1   = Anim = [5030,5035]
Value      = 5050


;--------------------------------------------------
[State 12000, ScreenBound]	;XN[
Type       = ScreenBound
Trigger1   = 1
Value      = 0
MoveCamera = 1,1


;-------------------------------------------------- Xe[gύX
[State 12000, ChangeState]
Type       = ChangeState
Trigger1   = HitShakeOver
Trigger1   = FrontEdgeBodyDist < 0 || BackEdgeBodyDist < 0
Value      = 12001

;-------------------------------------------------- Xe[gɖ߂
[State 12000, SelfState]
Type       = SelfState
Trigger1   = Pos Y >= 0 && Vel Y > 0
Value      = 5100





;==================================================
; [] ǃoEhA
;--------------------------------------------------
[Statedef 12001]
Type       = A
MoveType   = H
Physics    = N
Ctrl       = 0
SprPriority = -1


;-------------------------------------------------- AjύX
[State 12001, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time < 4
Trigger1   = SelfAnimExist(5035)
Value      = 5035

[State 12001, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time < 4
Trigger1   = !SelfAnimExist(5035)
Value      = 5030

[State 12001, ChangeAnim]
Type       = ChangeAnim
Trigger1   = AnimTime = 0
Trigger1   = Anim = [5030,5035]
Value      = 5050


;-------------------------------------------------- 
[State 12001, PosFreeze]
Type       = PosFreeze
Trigger1   = Time < 4

[State 12001, Turn]
Type       = Turn
Trigger1   = Time = 4


;-------------------------------------------------- x
[State 12001, VelSet]
Type       = VelSet
Trigger1   = Time = 0
X          = 2.5
Y          = -2

[State 12001, VelAdd]
Type       = VelAdd
Trigger1   = Time > 4
Y          = GetHitVar(YAccel)

;-------------------------------------------------- 
[State 12001, EnvShake]
Type       = EnvShake
Trigger1   = Time = 0
Time       = 15
Ampl       = 5
Freq       = 100
Phase      = 100

;-------------------------------------------------- Xe[gɖ߂
[State 12001, SelfState]
Type       = SelfState
TriggerAll = Pos Y >= -20 && Vel Y > 0
TriggerAll = Alive
TriggerAll = CanRecover
Trigger1   = Command = "recovery"
Value      = 5200

[State 12001, SelfState]
Type       = SelfState
TriggerAll = Vel Y > -1
TriggerAll = Alive
TriggerAll = CanRecover
Trigger1   = Command = "recovery"
Value      = 5210

;-------------------------------------------------- Xe[gɖ߂
[State 12001, SelfState]
Type       = SelfState
Trigger1   = Pos Y >= 0 && Vel Y > 0
Value      = 5100





;==================================================
; [] ǉ]oEh@
;--------------------------------------------------
[Statedef 12002]
Type       = A
MoveType   = H
Physics    = N
Ctrl       = 0
SprPriority = -1

;-------------------------------------------------- x
[State 12002, VelSet]
Type       = VelSet
Trigger1   = !HitShakeOver
X          = 0
Y          = 0

[State 12002, VelSet]
Type       = VelSet
Trigger1   = HitShakeOver
X          = GetHitVar(XVel)*Facing
Y          = GetHitVar(YVel)
Persistent = 0

[State 12002, VelAdd]
Type       = VelAdd
Trigger1   = HitShakeOver
Y          = GetHitVar(YAccel)

;-------------------------------------------------- AjύX
[State 12002, ChangeAnim]
Type       = ChangeAnim
Trigger1   = !HitShakeOver
Trigger1   = Time > 0
Value      = Anim
Elem       = AnimElemNo(0)

[State 12002, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time = 0
Trigger1   = SelfAnimExist(5035)
Value      = 5035

[State 12002, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time = 0
Trigger1   = !SelfAnimExist(5035)
Value      = 5030

[State 12002, ChangeAnim]
Type       = ChangeAnim
Trigger1   = AnimTime = 0
Trigger1   = Anim = [5030,5035]
Value      = 5050

;-------------------------------------------------- 
[State 12002, ScreenBound]	;XN[
Type       = ScreenBound
Trigger1   = 1
Value      = 0
MoveCamera = 1,1

;-------------------------------------------------- Xe[gύX
[State 12002, ChangeState]
Type       = ChangeState
Trigger1   = HitShakeOver
Trigger1   = FrontEdgeBodyDist < 0 || BackEdgeBodyDist < 0
Value      = 12003

;-------------------------------------------------- Xe[gɖ߂
[State 12002, SelfState]
Type       = SelfState
Trigger1   = Pos Y >= 0 && Vel Y > 0
Value      = 5100





;==================================================
; [] ǉ]oEhA
;--------------------------------------------------
[Statedef 12003]
Type     = A
MoveType = H
Physics  = N
Ctrl     = 0
SprPriority = -1

;-------------------------------------------------- AjύX
[State 12003, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time < 4
Trigger1   = SelfAnimExist(5035)
Value      = 5035

[State 12003, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time < 4
Trigger1   = !(SelfAnimExist(5035))
Value      = 5030

[State 12003, ChangeAnim2]
Type       = ChangeAnim2
Trigger1   = Time > 3
Value      = 12001

;-------------------------------------------------- 
[State 12003, PosFreeze]	;ʒuŒ
Type       = PosFreeze
Trigger1   = Time < 4

[State 12003, Turn]
Type       = Turn
Trigger1   = Time = 4

[State 12003, AngleDraw]
Type       = AngleDraw
Trigger1   = (Time > 3) && (Pos Y < 0)
Value      = Time*30

;-------------------------------------------------- x
[State 12003, VelSet]
Type       = VelSet
Trigger1   = Time = 0
X          = 2
Y          = -4

[State 12003, VelAdd]
Type       = VelAdd
Trigger1   = Time > 4
Y          = GetHitVar(YAccel)*.5

;-------------------------------------------------- 
[State 12003, EnvShake]	;ʐU
Type       = EnvShake
Trigger1   = Time = 0
Time       = 15
Ampl       = 5
Freq       = 100
Phase      = 100

[State 12003, OffSet]		;炵ĕ\
Type       = OffSet
Trigger1   = (Time > 3) && (Pos Y < 0)
Y          = Const(Size.Mid.Pos.Y)

;-------------------------------------------------- Xe[gɖ߂igj
[State 12003, SelfState]
Type       = SelfState
TriggerAll = Pos Y >= -20 && Vel Y > 0
TriggerAll = Alive
TriggerAll = CanRecover
Trigger1   = Command = "recovery"
Value      = 5200

[State 12003, SelfState]
Type       = SelfState
TriggerAll = Vel Y > -1
TriggerAll = Alive
TriggerAll = CanRecover
Trigger1   = Command = "recovery"
Value      = 5210

;-------------------------------------------------- Xe[gɖ߂
[State 12003, SelfState]
Type       = SelfState
Trigger1   = Pos Y >= 0 && Vel Y > 0
Value      = 5100





;==================================================
; [] oEh@
;--------------------------------------------------
[Statedef 12005]
Type       = A
MoveType   = H
Physics    = N
Ctrl       = 0
SprPriority = -1

[State 12005, VarSet]
Type       = VarSet
Trigger1   = (Time = 0)
sysvar(1)  = Floor(Pos Y)

;-------------------------------------------------- x
[State 12005, VelSet]
Type       = VelSet
Trigger1   = !HitShakeOver
X          = 0
Y          = 0

[State 12005, VelSet]
Type       = VelSet
Trigger1   = HitShakeOver
X          = GetHitVar(XVel)*Facing
Y          = GetHitVar(YVel)
Persistent = 0

[State 12005, VelAdd]
Type       = VelAdd
Trigger1   = HitShakeOver
Y          = GetHitVar(YAccel)

;-------------------------------------------------- AjύX
[State 12005, ChangeAnim]
Type       = ChangeAnim
Trigger1   = !HitShakeOver
Trigger1   = Time > 0
Value      = Anim
Elem       = AnimElemNo(0)

[State 12005, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time = 0
Trigger1   = SelfAnimExist(5035)
Value      = 5035

[State 12005, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time = 0
Trigger1   = !SelfAnimExist(5035)
Value      = 5030

[State 12005, ChangeAnim]
Type       = ChangeAnim
Trigger1   = AnimTime = 0
Trigger1   = Anim = [5030,5035]
Value      = 5050

;-------------------------------------------------- Xe[gύX
[State 12005, ChangeState]
Type       = ChangeState
Trigger1   = HitShakeOver
Trigger1   = Pos Y > 25
Value      = 12006





;==================================================
; [] oEhA
;--------------------------------------------------
[Statedef 12006]
Type       = A
MoveType   = H
Physics    = N
Ctrl       = 0
SprPriority = -1

;-------------------------------------------------- AjύX
[State 12006, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time < 4
Value      = 5100

[State 12006, ChangeAnim2]
Type       = ChangeAnim2
Trigger1   = Time > 3
Value      = 12001

;-------------------------------------------------- 
[State 12006, PosSet]			;ʒu
Type       = PosSet
Trigger1   = Time = 0
Y          = -1

[State 12006, PosFreeze]	;ʒuŒ
Type       = PosFreeze
Trigger1   = Time < 4

[State 12006, AngleDraw]
Type       = AngleDraw
Trigger1   = (Time > 3) && (Pos Y < 0)
Value      = Time*30

;-------------------------------------------------- x
[State 12006, VelSet]
Type       = VelSet
Trigger1   = Time = 0
X          = (Vel X)*.5
Y          = -3+(sysvar(1)/200.)

[State 12006, VelAdd]
Type       = VelAdd
Trigger1   = Time > 4
Y          = GetHitVar(YAccel)*.3

;-------------------------------------------------- 
[State 12006, EnvShake]	;ʐU
Type       = EnvShake
Trigger1   = Time = 0
Time       = 15
Ampl       = 5
Freq       = 100
Phase      = 100

[State 12006, OffSet]		;炵ĕ\
Type       = OffSet
Trigger1   = (Time > 3) && (Pos Y < 0)
Y          = Const(Size.Mid.Pos.Y)

;-------------------------------------------------- Xe[gɖ߂igj
[State 12006, SelfState]
Type       = SelfState
TriggerAll = Pos Y >= -20 && Vel Y > 0
TriggerAll = Alive
TriggerAll = CanRecover
Trigger1   = Command = "recovery"
Value      = 5200

[State 12006, SelfState]
Type       = SelfState
TriggerAll = Vel Y > -1
TriggerAll = Alive
TriggerAll = CanRecover
Trigger1   = Command = "recovery"
Value      = 5210

;-------------------------------------------------- Xe[gɖ߂
[State 12006, SelfState]
Type       = SelfState
Trigger1   = Pos Y >= 0 && Vel Y > 0
Value      = 5100





;==================================================
; [] ]
;--------------------------------------------------
[Statedef 12007]
Type       = A
MoveType   = H
Physics    = N
Ctrl       = 0
SprPriority = -1

;-------------------------------------------------- AjύX
[State 12007, ChangeAnim]
Type       = ChangeAnim
Trigger1   = !HitShakeOver ||Time = 0
Trigger1   = SelfAnimExist(5035)
Value      = 5035

[State 12007, ChangeAnim]
Type       = ChangeAnim
Trigger1   = !HitShakeOver ||Time = 0
Trigger1   = !SelfAnimExist(5035)
Value      = 5030

[State 12007, ChangeAnim2]
Type       = ChangeAnim2
Trigger1   = (HitShakeOver) && (Anim = [5030,5035])
Value      = 12001

;-------------------------------------------------- x
[State 12007, VelSet]
Type       = VelSet
Trigger1   = !HitShakeOver
X          = 0
Y          = 0

[State 12007, HitVelSet]
Type       = HitVelSet
Trigger1   = HitShakeOver
X          = 1
Y          = 1
Persistent = 0

[State 12007, VelAdd]
Type       = VelAdd
Trigger1   = HitShakeOver
Y          = GetHitVar(YAccel)

;-------------------------------------------------- 
[State 12007, AngleDraw]
Type       = AngleDraw
Trigger1   = (HitShakeOver) && (Pos Y <= 0)
Value      = Time*30

[State 12007, OffSet]	;炵ĕ\
Type       = OffSet
Trigger1   = (HitShakeOver) && (Pos Y <= 0)
Y          = Const(Size.Mid.Pos.Y)

;-------------------------------------------------- Xe[gɖ߂igj
[State 12007, SelfState]
Type       = SelfState
TriggerAll = Pos Y >= -20 && Vel Y > 0
TriggerAll = Alive
TriggerAll = CanRecover
Trigger1   = Command = "recovery"
Value      = 5200

[State 12007, SelfState]
Type       = SelfState
TriggerAll = Vel Y > -1
TriggerAll = Alive
TriggerAll = CanRecover
Trigger1   = Command = "recovery"
Value      = 5210

;-------------------------------------------------- Xe[gɖ߂
[State 12007, SelfState]
Type       = SelfState
Trigger1   = Pos Y > 0 && Vel Y > 0
Value      = 5100





;==================================================
; [] {[_[NbV
;--------------------------------------------------
[Statedef 12020]
Type       = S
MoveType   = H
Physics    = S
VelSet     = 0,0

;-------------------------------------------------- Xe[gɖ߂
[State 12020, SelfState]
Type       = SelfState
Trigger1   = !Alive
Trigger2   = Pos Y != 0
Value      = 5000

;-------------------------------------------------- 
[State 12020, VarSet]
Type       = VarSet
Trigger1   = (Time = 0)
sysvar(1)  = GetHitVar(HitShakeTime)

;-------------------------------------------------- 
[State 12020, VarSet]
Type       = VarSet
TriggerAll = Time = 2
TriggerAll = AuthorName = "Kurogane"
TriggerAll = var(50) != 101
Trigger1   = Name = "Reimu_Hakurei"
Trigger2   = Name = "Yukari_Yakumo"
Trigger3   = Name = "Yuyuko_Saigyouji"
Trigger4   = Name = "Youmu_Konpaku"
Trigger5   = Name = "Patchouli_Knowledge"
fvar(5)    = 0

[State 12020, VarAdd]
Type       = VarAdd
TriggerAll = Time = 2
TriggerAll = AuthorName = "Kurogane"
TriggerAll = fvar(35) != 101
Trigger1   = Name = "Iku_Nagae"
fvar(37)   = -1000

[State 12020, VarSet]
Type       = VarSet
TriggerAll = Time = 2
TriggerAll = AuthorName = "Aotsuki"
Trigger1   = Name = "Suika_Ibuki"
Trigger2   = Name = "Sakuya_Izayoi"
Trigger3   = Name = "Aya_Syameimaru"
Trigger4   = Name = "Hong_Meirin"
fvar(4)    = 0

[State 12020, VarSet]
Type       = VarSet
TriggerAll = Time = 2
TriggerAll = AuthorName = "Nachel"
TriggerAll = var(41) = 0
Trigger1   = Name = "Remilia_Scarlet"
Trigger2   = Name = "Reimu_Hakurei"
var(40)    = 0

[State 12020, VarSet]
Type       = VarSet
TriggerAll = Time = 2
TriggerAll = AuthorName = "Toma"
Trigger1   = Name = "Patchouli"
Trigger2   = Name = "Marisa Kirisame"
fvar(15)   = 0

[State 12020, VarSet]
Type       = VarSet
TriggerAll = Time = 2
TriggerAll = AuthorName = "rouge noir"
TriggerAll = var(22) = 0
Trigger1   = Name = "youmu_konpaku"
var(20)    = 0

[State 12020, VarSet]
Type       = VarSet
TriggerAll = Time = 2
TriggerAll = AuthorName = "SUI"
TriggerAll = var(3) = 0
Trigger1   = Name = "Alice_Margatroid"
var(1)     = 0

[State 12020, VarSet]
Type       = VarSet
TriggerAll = Time = 2
TriggerAll = AuthorName = "ibukah"
Trigger1   = Name = "Ibuki_Suika"
fvar(15)   = 0

[State 12020, VarSet]
Type       = VarSet
TriggerAll = Time = 2
TriggerAll = AuthorName = "Souki"
Trigger1   = Name = "Alice Margatroid"
Trigger2   = Name = "Yuyuko Saigyouji"
var(55)    = 0

[State 12020, VarSet]
Type       = VarSet
TriggerAll = Time = 2
TriggerAll = AuthorName = "Ina"
TriggerAll = var(20) = 0
Trigger1   = Name = "Ibuki_Suika"
fvar(0)    = 0

[State 12020, VarSet]
Type       = VarSet
TriggerAll = Time = 2
TriggerAll = AuthorName = "Daiya (Diamond)"
TriggerAll = var(11) = 0
Trigger1   = Name = "Yakumo Yukari"
var(10)    = -2

[State 12020, VarSet]
Type       = VarSet
TriggerAll = Time = 2
TriggerAll = AuthorName = "Daiya(Diamond)"
TriggerAll = var(5) = 0
Trigger1   = Name = "Yuyuko Saigyouji & Youmu Konpaku"
var(1)     = 1000

[State 12020, VarSet]
Type       = VarSet
TriggerAll = Time = 2
TriggerAll = AuthorName = "kuri"
Trigger1   = Name = "Yuyu"
var(4)     = 0

[State 12020, VarSet]
Type       = VarSet
TriggerAll = Time = 2
TriggerAll = AuthorName = "Shiroto"
Trigger1   = Name = "Yukari Yakumo"
fvar(10)   = 0

[State 12020, VarSet]
Type       = VarSet
TriggerAll = Time = 2
TriggerAll = AuthorName = "nukenashi"
TriggerAll = fvar(2) = 0
Trigger1   = Name = "Sakuya Izayoi"
Trigger2   = Name = "Aya Syameimaru"
fvar(1)    = 0

[State 12020, VarSet]
Type       = VarSet
TriggerAll = Time = 2
TriggerAll = AuthorName = "nukenashi"
TriggerAll = fvar(2) = 0
Trigger1   = Name = "Sakuya Izayoi"
Trigger2   = Name = "Aya Syameimaru"
fvar(2)    = 1

;-------------------------------------------------- 
[State 12020, VelSet]
Type       = VelSet
Trigger1   = HitShakeOver
X          = -8
Persistent = 0

[State 12020, HitFallSet]	;FalltO
Type       = HitFallSet
Trigger1   = Time = 0
Value      = IfElse(Alive,0,1)

[State 12020, OffSet]	;ʂ炷
Type       = OffSet
TriggerAll = Anim != [5910,5911]
TriggerAll = Anim != [12100,12221]
Trigger1   = HitShakeOver
Trigger1   = Time < 56+sysvar(1)
X          = 1
Persistent = 2

;-------------------------------------------------- AjύX
;[State 12020, ChangeAnim2]
;Type       = ChangeAnim2
;TriggerAll = AuthorName = "Kurogane" && Name = "Reimu_Hakurei"
;Trigger1   = Time = 0
;Trigger2   = !HitShakeOver
;Value      = 12100

[State 12020, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "Toma" && Name = "Marisa Kirisame"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12110

[State 12020, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "Aotsuki" && Name = "Sakuya_Izayoi"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12120

[State 12020, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "GATT" && Name = "Sakuya Izayoi"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12122

[State 12020, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "nukenashi" && Name = "Sakuya Izayoi"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12122

[State 12020, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "SUI" && Name = "Alice_Margatroid"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12130

[State 12020, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "Souki" && Name = "Alice Margatroid"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12132

[State 12020, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "Toma" && Name = "Patchouli"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12140

[State 12020, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "rouge noir" && Name = "youmu_konpaku"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12150

[State 12020, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "kuri" && Name = "remilia"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12160

[State 12020, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "Souki" && Name = "Yuyuko Saigyouji"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12170

[State 12020, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = Time = 0
TriggerAll = !HitShakeOver
Trigger1   = AuthorName = "kuri" && Name = "yuyu"
Trigger2   = AuthorName = "Daiya(Diamond)" && Name = "Yuyuko Saigyouji & Youmu Konpaku"
Value      = 12172

[State 12020, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "Daiya (Diamond)" && Name = "Yakumo Yukari"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12180

[State 12020, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "Aotsuki" && Name = "Suika_Ibuki"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12190

[State 12020, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "ibukah" && Name = "Ibuki_Suika"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12192

[State 12020, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "Daiya(Diamond)" && Name = "Hong Meirin"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12200

[State 12020, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "Aotsuki" && Name = "Aya_Syameimaru"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12210

[State 12020, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "nukenashi" && Name = "Aya Syameimaru"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12212

[State 12020, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = Anim = [12100,12221]
Trigger1   = Time = 55+sysvar(1)
Value      = Anim+1


;-------------------------------------------------- AjύX
[State 12020, ChangeAnim]
Type       = ChangeAnim
TriggerAll = Anim != [12100,12221]
TriggerAll = SelfAnimExist(5910)
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 5910

[State 12020, ChangeAnim]
Type     = ChangeAnim
Trigger1 = Anim = 5910
Trigger1 = SelfAnimExist(5911)
Trigger1 = Time = 55+sysvar(1)
Value    = 5911

[State 12020, ChangeAnim]
Type       = ChangeAnim
TriggerAll = Anim != [12100,12221]
Trigger1   = !SelfAnimExist(5910)
Value      = IfElse((GetHitVar(GroundType)=[0,1]),5002,5012)


;-------------------------------------------------- Xe[gɖ߂
[State 12020, SelfState]
Type       = SelfState
Trigger1   = Time = 60+sysvar(1)
Value      = 0
Ctrl       = 1




;==================================================
; [] ]
;--------------------------------------------------
[Statedef 12025]
Type       = S
MoveType   = H
Physics    = N
VelSet     = 0,0
SprPriority = 0

[State 12025, SelfState]
Type       = SelfState
Trigger1   = !Alive
Trigger2   = Pos Y != 0
Value      = 5000

;-------------------------------------------------- ϐ
[State 12025, VarSet]
Type       = VarSet
Trigger1   = (Time = 0)
sysvar(1)  = GetHitVar(HitShakeTime)

;-------------------------------------------------- x
[State 12025, VelSet]
Type       = VelSet
Trigger1   = !HitShakeOver
X          = 0

[State 12025, VelSet]
Type       = VelSet
Trigger1   = HitShakeOver
X          = GetHitVar(XVel)*Facing
Persistent = 0

[State 12025, VelSet]
Type       = VelSet
Trigger1   = HitShakeOver
Trigger1   = BackEdgeBodyDist < 1
X          = (Vel X)*-1
Persistent = 0

;-------------------------------------------------- 
[State 12025, Turn]
Type       = Turn
Trigger1   = BackEdgeBodyDist < 1

[State 12025, HitFallSet]
Type       = HitFallSet
Trigger1   = Time = 0
Value      = IfElse(Alive,0,1)

[State 12025, OffSet]
Type       = OffSet
TriggerAll = (Anim != 5003)
TriggerAll = (Anim != [5975,5976])
TriggerAll = Anim != [12300,12439]
Trigger1   = HitShakeOver
Trigger1   = Time < 34+sysvar(1)
X          = 1
Persistent = 2

[State 12025, StateTypeSet]
Type     = StateTypeSet
Trigger1 = Time = 3+sysvar(1)
Physics  = S

;-------------------------------------------------- AjύX
;[State 12025, ChangeAnim2]
;Type       = ChangeAnim2
;TriggerAll = AuthorName = "Kurogane" && Name = "Reimu_Hakurei"
;Trigger1   = Time = 0
;Trigger2   = !HitShakeOver
;Value      = 12300

[State 12025, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "Toma" && Name = "Marisa Kirisame"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12310

[State 12025, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "Aotsuki" && Name = "Sakuya_Izayoi"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12320

[State 12025, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "nukenashi" && Name = "Sakuya Izayoi"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12321

[State 12025, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "GATT" && Name = "Sakuya Izayoi"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12330

[State 12025, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "SUI" && Name = "Alice_Margatroid"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12340

[State 12025, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "Souki" && Name = "Alice Margatroid"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12341

[State 12025, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "mikage" && Name = "Alice Margatroid"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12342

[State 12025, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "Toma" && Name = "Patchouli"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12350

[State 12025, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "rouge noir" && Name = "youmu_konpaku"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12360

;[State 12025, ChangeAnim2]
;Type       = ChangeAnim2
;TriggerAll = AuthorName = "Kurogane" && Name = "Youmu_Konpaku"
;Trigger1   = Time = 0
;Trigger2   = !HitShakeOver
;Value      = 12370

[State 12025, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "kuri" && Name = "remilia"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12380

[State 12025, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "Souki" && Name = "Yuyuko Saigyouji"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12390

;[State 12025, ChangeAnim2]
;Type       = ChangeAnim2
;TriggerAll = AuthorName = "Daiya (Diamond)" && Name = "Yakumo Yukari"
;Trigger1   = Time = 0
;Trigger2   = !HitShakeOver
;Value      = 12400

[State 12025, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "Aotsuki" && Name = "Suika_Ibuki"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12410

[State 12025, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "ibukah" && Name = "Ibuki_Suika"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12411

[State 12025, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "ina" && Name = "Ibuki_Suika"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12412

[State 12025, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "mikage" && Name = "Suika Ibuki"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12413

;[State 12025, ChangeAnim2]
;Type       = ChangeAnim2
;TriggerAll = AuthorName = "Daiya(Diamond)" && Name = "Hong Meirin"
;Trigger1   = Time = 0
;Trigger2   = !HitShakeOver
;Value      = 12420

[State 12025, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "Aotsuki" && Name = "Aya_Syameimaru"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12430

[State 12025, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "mikage" && Name = "Aya Syameimaru"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12431

[State 12025, ChangeAnim2]
Type       = ChangeAnim2
TriggerAll = AuthorName = "nukenashi" && Name = "Aya Syameimaru"
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 12432

;-------------------------------------------------- AjύX
[State 12025, ChangeAnim]
Type       = ChangeAnim
TriggerAll = Anim != [12300,12439]
TriggerAll = SelfAnimExist(5975)
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 5975

[State 12025, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time = 24+sysvar(1) && Anim = 5975
Trigger1   = SelfAnimExist(5976)
Value      = 5976

[State 12025, ChangeAnim]
Type       = ChangeAnim
TriggerAll = (Anim != [12300,12439]) && (Anim != [5975,5976])
TriggerAll = SelfAnimExist(5003)
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 5003

[State 12025, ChangeAnim]
Type       = ChangeAnim
TriggerAll = (Anim != [12300,12439]) && (Anim != [5975,5976]) && (Anim != 5003)
Trigger1   = Time < 24+sysvar(1)
Trigger1   = !SelfAnimExist(5975)
Value      = IfElse((GetHitVar(GroundType)=[0,1]),5002,5012)

[State 12025, ChangeAnim]
Type       = ChangeAnim
Trigger1   = (Time = 24+sysvar(1)) && (Anim = [5002,5012])
Trigger1   = SelfAnimExist(Anim+5)
Value      = Anim+5

;-------------------------------------------------- Xe[gɖ߂
[State 12025, SelfState]
Type       = SelfState
Trigger1   = (Anim != [12300,12439]) && (Time = 34+sysvar(1))
Trigger2   = (Anim = [12300,12439]) && (AnimTime = 0)
Value      = 0
Ctrl       = 1




;==================================================
; [] LimitOveriǃoEh@j
;--------------------------------------------------
[Statedef 12100]
Type       = A
MoveType   = H
Physics    = N
Ctrl       = 0
SprPriority = -1

[State 12100, Turn]
Type       = Turn
Trigger1   = P2Dist X < 0


;-------------------------------------------------- x
[State 12100, VelSet]
Type       = VelSet
Trigger1   = !HitShakeOver
X          = 0
Y          = 0

[State 12100, VelSet]
Type       = VelSet
Trigger1   = HitShakeOver
X          = GetHitVar(XVel)*Facing
Y          = GetHitVar(YVel)
Persistent = 0

[State 12100, VelAdd]
Type       = VelAdd
Trigger1   = HitShakeOver
Y          = GetHitVar(YAccel)

;-------------------------------------------------- AjύX
[State 12100, ChangeAnim]
Type       = ChangeAnim
Trigger1   = !HitShakeOver
Trigger1   = Time > 0
Value      = Anim
Elem       = AnimElemNo(0)

[State 12100, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time = 0
Trigger1   = SelfAnimExist(5035)
Value      = 5035

[State 12100, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time = 0
Trigger1   = !SelfAnimExist(5035)
Value      = 5030

[State 12100, ChangeAnim]
Type       = ChangeAnim
Trigger1   = AnimTime = 0
Trigger1   = Anim = [5030,5035]
Value      = 5050

;-------------------------------------------------- 
[State 12100, ScreenBound]	;XN[
Type = ScreenBound
Trigger1 = 1
Value = 0
MoveCamera = 1,1

[State 12100, NotHitBy]
Type       = NotHitBy
Trigger1   = 1
Value      = SCA

;-------------------------------------------------- Xe[gύX
[State 12100, ChangeState]
Type       = ChangeState
Trigger1   = HitShakeOver
Trigger1   = FrontEdgeBodyDist < 0 || BackEdgeBodyDist < 0
Value      = 12101

;-------------------------------------------------- Xe[gɖ߂
[State 12100, SelfState]
Type       = SelfState
Trigger1   = Pos Y >= 0 && Vel Y > 0
Value      = 5100





;==================================================
; [] LimitOveriǃoEhAj
;--------------------------------------------------
[Statedef 12101]
Type       = A
MoveType   = H
Physics    = N
Ctrl       = 0
SprPriority = -1

;-------------------------------------------------- AjύX
[State 12101, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time < 4
Trigger1   = SelfAnimExist(5035)
Value      = 5035

[State 12101, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time < 4
Trigger1   = !SelfAnimExist(5035)
Value      = 5030

[State 12101, ChangeAnim]
Type       = ChangeAnim
Trigger1   = AnimTime = 0
Trigger1   = Anim = [5030,5035]
Value      = 5050

;-------------------------------------------------- 
[State 12101, PosFreeze]
Type       = PosFreeze
Trigger1   = Time < 4

[State 12101, Turn]
Type       = Turn
Trigger1   = Time = 4

;-------------------------------------------------- x
[State 12101, VelSet]
Type       = VelSet
Trigger1   = Time = 0
X          = 2.5
Y          = -2

[State 12101, VelAdd]
Type       = VelAdd
Trigger1   = Time > 4
Y          = GetHitVar(YAccel)

;-------------------------------------------------- 
[State 12101, EnvShake]	;ʐU
Type       = EnvShake
Trigger1   = Time = 0
Time       = 15
Ampl       = 5
Freq       = 100
Phase      = 100

[State 12101, NotHitBy]
Type       = NotHitBy
Trigger1   = 1
Value      = SCA

;-------------------------------------------------- Xe[gɖ߂
[State 12101, SelfState]
Type       = SelfState
Trigger1   = Pos Y >= 0 && Vel Y > 0
Value      = 5100





;==================================================
; [] LimitOveriǉ]oEh@j
;--------------------------------------------------
[Statedef 12102]
Type       = A
MoveType   = H
Physics    = N
Ctrl       = 0
SprPriority = -1

;-------------------------------------------------- x
[State 12102, VelSet]
Type       = VelSet
Trigger1   = !HitShakeOver
X          = 0
Y          = 0

[State 12102, VelSet]
Type       = VelSet
Trigger1   = HitShakeOver
X          = GetHitVar(XVel)*Facing
Y          = GetHitVar(YVel)
Persistent = 0

[State 12002, VelAdd]
Type       = VelAdd
Trigger1   = HitShakeOver
Y          = GetHitVar(YAccel)

;-------------------------------------------------- AjύX
[State 12102, ChangeAnim]
Type       = ChangeAnim
Trigger1   = !HitShakeOver
Trigger1   = Time > 0
Value      = Anim
Elem       = AnimElemNo(0)

[State 12102, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time = 0
Trigger1   = SelfAnimExist(5035)
Value      = 5035

[State 12102, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time = 0
Trigger1   = !SelfAnimExist(5035)
Value      = 5030

[State 12102, ChangeAnim]
Type       = ChangeAnim
Trigger1   = AnimTime = 0
Trigger1   = Anim = [5030,5035]
Value      = 5050

;-------------------------------------------------- 
[State 12102, ScreenBound]	;XN[
Type       = ScreenBound
Trigger1   = 1
Value      = 0
MoveCamera = 1,1

[State 12102, NotHitBy]
Type       = NotHitBy
Trigger1   = 1
Value      = SCA

;-------------------------------------------------- Xe[gύX
[State 12102, ChangeState]
Type       = ChangeState
Trigger1   = HitShakeOver
Trigger1   = FrontEdgeBodyDist < 0 || BackEdgeBodyDist < 0
Value      = 12103

;-------------------------------------------------- Xe[gɖ߂
[State 12102, Xe[gɖ߂]
Type = SelfState
Trigger1 = Pos Y >= 0 && Vel Y > 0
Value = 5100





;==================================================
; [] LimitOveriǉ]oEhAj
;--------------------------------------------------
[Statedef 12103]
Type       = A
MoveType   = H
Physics    = N
Ctrl       = 0
SprPriority = -1

;-------------------------------------------------- AjύX
[State 12103, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time < 4
Trigger1   = SelfAnimExist(5035)
Value      = 5035

[State 12103, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time < 4
Trigger1   = !SelfAnimExist(5035)
Value      = 5030

[State 12103, ChangeAnim2]
Type       = ChangeAnim2
Trigger1   = Time > 3
Value      = 12001

;-------------------------------------------------- 
[State 12103, PosFreeze]	;ʒuŒ
Type       = PosFreeze
Trigger1   = Time < 4

[State 12103, Turn]
Type       = Turn
Trigger1   = Time = 4

[State 12103, AngleDraw]
Type       = AngleDraw
Trigger1   = (Time > 3) && (Pos Y < 0)
Value      = Time*30

;-------------------------------------------------- x
[State 12103, VelSet]
Type       = VelSet
Trigger1   = Time = 0
X          = 2
Y          = -4

[State 12103, VelAdd]
Type       = VelAdd
Trigger1   = Time > 4
Y          = GetHitVar(YAccel)*.5

;-------------------------------------------------- 
[State 12103, EnvShake]
Type       = EnvShake
Trigger1   = Time = 0
Time       = 15
Ampl       = 5
Freq       = 100
Phase      = 100

[State 12103, OffSet]	;炵ĕ\
Type       = OffSet
Trigger1   = (Time > 3) && (Pos Y < 0)
Y          = Const(Size.Mid.Pos.Y)

[State 12103, NotHitBy]
Type       = NotHitBy
Trigger1   = 1
Value      = SCA

;-------------------------------------------------- Xe[gɖ߂
[State 12103, SelfState]
Type       = SelfState
Trigger1   = Pos Y >= 0 && Vel Y > 0
Value      = 5100





;==================================================
; [] LimitOverioEh@j
;--------------------------------------------------
[Statedef 12105]
Type       = A
MoveType   = H
Physics    = N
Ctrl       = 0
SprPriority = -1

[State 12105, VarSet]
Type       = VarSet
Trigger1   = (Time = 0)
sysvar(1)  = Floor(Pos Y)

;-------------------------------------------------- AjύX
[State 12105, VelSet]
Type       = VelSet
Trigger1   = !HitShakeOver
X          = 0
Y          = 0

[State 12105, VelSet]
Type       = VelSet
Trigger1   = HitShakeOver
X          = GetHitVar(XVel)*Facing
Y          = GetHitVar(YVel)
Persistent = 0

[State 12105, VelAdd]
Type       = VelAdd
Trigger1   = HitShakeOver
Y          = GetHitVar(YAccel)

;-------------------------------------------------- AjύX
[State 12105, ChangeAnim]
Type       = ChangeAnim
Trigger1   = !HitShakeOver
Trigger1   = Time > 0
Value      = Anim
Elem       = AnimElemNo(0)

[State 12105, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time = 0
Trigger1   = SelfAnimExist(5035)
Value      = 5035

[State 12105, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time = 0
Trigger1   = !SelfAnimExist(5035)
Value      = 5030

[State 12105, ChangeAnim]
Type       = ChangeAnim
Trigger1   = AnimTime = 0
Trigger1   = Anim = [5030,5035]
Value      = 5050

;-------------------------------------------------- 
[State 12105, NotHitBy]
Type       = NotHitBy
Trigger1   = 1
Value      = SCA

;-------------------------------------------------- Xe[gύX
[State 12105, ChangeState]
Type       = ChangeState
Trigger1   = HitShakeOver
Trigger1   = Pos Y > 25
Value      = 12106





;==================================================
; [] LimitOverioEhAj
;--------------------------------------------------
[Statedef 12106]
Type       = A
MoveType   = H
Physics    = N
Ctrl       = 0
SprPriority = -1

;-------------------------------------------------- AjύX
[State 12106, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time < 4
Value      = 5100

[State 12106, ChangeAnim2]
Type       = ChangeAnim2
Trigger1   = Time > 3
Value      = 12001

;-------------------------------------------------- 
[State 12106, PosSet]			;ʒu
Type       = PosSet
Trigger1   = Time = 0
Y          = -1

[State 12106, PosFreeze]	;ʒuŒ
Type       = PosFreeze
Trigger1   = Time < 4

[State 12106, AngleDraw]
Type       = AngleDraw
Trigger1   = (Time > 3) && (Pos Y < 0)
Value      = Time*30

;-------------------------------------------------- x
[State 12106, VelSet]
Type       = VelSet
Trigger1   = Time = 0
X          = (Vel X)*.5
Y          = -3+(sysvar(1)/200.)

[State 12106, VelAdd]
Type       = VelAdd
Trigger1   = Time > 4
Y          = GetHitVar(YAccel)*.3

;-------------------------------------------------- 
[State 12106, EnvShake]	;ʐU
Type       = EnvShake
Trigger1   = Time = 0
Time       = 15
Ampl       = 5
Freq       = 100
Phase      = 100

[State 12106, OffSet]		;炵ĕ\
Type       = OffSet
Trigger1   = (Time > 3) && (Pos Y < 0)
Y          = Const(Size.Mid.Pos.Y)

[State 12106, NotHitBy]
Type       = NotHitBy
Trigger1   = 1
Value      = SCA

;-------------------------------------------------- Xe[gɖ߂
[State 12106, SelfState]
Type       = SelfState
Trigger1   = Pos Y >= 0 && Vel Y > 0
Value      = 5100





;==================================================
; [] LimitOveri]сj
;--------------------------------------------------
[Statedef 12107]
Type     = A
MoveType = H
Physics  = N
Ctrl     = 0
SprPriority = -1

;-------------------------------------------------- AjύX
[State 12107, ChangeAnim]
Type       = ChangeAnim
Trigger1   = !HitShakeOver ||Time = 0
Trigger1   = SelfAnimExist(5035)
Value      = 5035

[State 12107, ChangeAnim]
Type       = ChangeAnim
Trigger1   = !HitShakeOver ||Time = 0
Trigger1   = !SelfAnimExist(5035)
Value      = 5030

[State 12107, ChangeAnim2]	;Aj
Type       = ChangeAnim2
Trigger1   = (HitShakeOver) && (Anim = [5030,5035])
Value      = 12001

;-------------------------------------------------- x
[State 12107, VelSet]
Type       = VelSet
Trigger1   = !HitShakeOver
X          = 0
Y          = 0

[State 12107, HitVelSet]
Type       = HitVelSet
Trigger1   = HitShakeOver
X          = 1
Y          = 1
Persistent = 0

[State 12107, VelAdd]
Type       = VelAdd
Trigger1   = HitShakeOver
Y          = GetHitVar(YAccel)

;-------------------------------------------------- 
[State 12107, AngleDraw]
Type       = AngleDraw
Trigger1   = (HitShakeOver) && (Pos Y <= 0)
Value      = Time*30

[State 12107, OffSet]
Type       = OffSet
Trigger1   = (HitShakeOver) && (Pos Y <= 0)
Y          = Const(Size.Mid.Pos.Y)

[State 12107, NotHitBy]
Type       = NotHitBy
Trigger1   = 1
Value      = SCA

;-------------------------------------------------- Xe[gɖ߂
[State 12107, SelfState]
Type       = SelfState
Trigger1   = Pos Y > 0 && Vel Y > 0
Value      = 5100





;==================================================
; [] LimitOveri󒆂j
;--------------------------------------------------
[Statedef 12130]
Type       = A
MoveType   = H
Physics    = N
Ctrl       = 0

;-------------------------------------------------- AjύX
[State 12130, ChangeAnim]
Type       = ChangeAnim
Trigger1   = Time = 0
Trigger2   = !HitShakeOver
Value      = 5030

[State 12130, ChangeAnim]
Type       = ChangeAnim
Trigger1   = SelfAnimExist(5035)
Trigger1   = ((HitShakeOver) && (Anim = 5030) && (AnimTime = 0))
Value      = 5035

[State 12130, ChangeAnim]
Type       = ChangeAnim
TriggerAll = HitShakeOver
Trigger1   = (Anim = 5035) && (AnimTime = 0)
Trigger2   = ((Anim != 5035) && (Anim != [5050,5059]))
Value      = 5050
Persistent = 0

[State 12130, ChangeAnim]
Type       = ChangeAnim
TriggerAll = HitShakeOver
Trigger1   = Anim = [5050,5059]
Trigger1   = Vel Y >= IfElse(Anim=5050,1,-2)
Trigger1   = SelfAnimExist(Anim+10)
Value      = Anim+10
Persistent = 0

;-------------------------------------------------- x
[State 12130, HitFallSet]
Type       = HitFallSet
Trigger1   = Time = 0
Value      = 1

[State 12130, VelSet]
Type       = VelSet
Trigger1   = !HitShakeOver
X          = 0
Y          = 0

[State 12130, VelAdd]
Type       = VelAdd
Trigger1   = HitShakeOver
Y          = GetHitVar(YAccel)

[State 12130, HitVelSet]	;
Type       = HitVelSet
Trigger1   = HitShakeOver
X          = 1
Y          = 1
Persistent = 0

;-------------------------------------------------- 
[State 12130, NotHitBy]
Type       = NotHitBy
Trigger1   = 1
Value      = SCA

;-------------------------------------------------- Xe[gɖ߂
[State 12130, SelfState]
Type       = SelfState
TriggerAll = HitShakeOver
Trigger1   = Vel Y > 0
Trigger1   = Pos Y >= IfElse((Anim=[5051,5059])||(Anim=[5061,5069]),0,25)
Value      = 5100





;===========================================================================
;===========================================================================
